/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.base.zbnimport.log;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.base.zbnimport.ZbnDataHandler;

public class ZbnLogEntry
implements Cloneable {
    private String origin;
    private long houseHoldData;
    private long resolvedHHData;
    private String resolvedZbn = "";
    private long state;
    private long extendedState;
    private String ID = "";
    private Hashtable<String, String> peripherals = null;
    private float entgelt = 0.0f;

    ZbnLogEntry(String orgData, String itemID) {
        this.origin = orgData;
        this.ID = itemID;
        this.state = 0L;
        this.extendedState = 0L;
        this.houseHoldData = 0L;
        this.resolvedHHData = 0L;
    }

    public boolean equals(ZbnLogEntry toCompare) {
        return this.hashCode() == toCompare.hashCode();
    }

    public int getResolvedZbnCnt() {
        StringTokenizer t = new StringTokenizer(this.resolvedZbn, "\t");
        return t.countTokens();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void reassignOrigin(String src) {
        this.origin = src;
    }

    private void removeZbn(String zbn) {
        int pos = this.resolvedZbn.indexOf(zbn);
        this.resolvedZbn = String.valueOf(this.resolvedZbn.substring(0, pos)) + this.resolvedZbn.substring(pos + zbn.length());
    }

    public void setPeripheralData(String orgZbn, String data) {
        if (this.peripherals == null) {
            this.peripherals = new Hashtable();
        }
        this.peripherals.put(orgZbn, data);
    }

    public String getPeripheral(String zbn) {
        return this.peripherals != null ? this.peripherals.get(zbn) : "";
    }

    public void delPeripherals(String zbn) {
        if (this.peripherals == null) {
            return;
        }
        this.peripherals.remove(zbn);
    }

    public String getPeripheralData() {
        String result = "";
        if (this.peripherals == null) {
            return "";
        }
        Enumeration<String> data = this.peripherals.elements();
        while (data.hasMoreElements()) {
            result = String.valueOf(result) + data.nextElement() + "\t";
        }
        return result;
    }

    public void delPeripheralData() {
        if (this.peripherals != null) {
            this.peripherals.clear();
        }
        this.houseHoldData = 0L;
    }

    public void setHouseHoldData(String data) {
        try {
            this.houseHoldData += Long.parseLong(data.trim());
        }
        catch (NumberFormatException nfEx) {
            nfEx.printStackTrace();
        }
    }

    public void setHouseHoldsAndEntgelt(String hh, String bucks) {
        try {
            this.houseHoldData += Long.parseLong(hh.trim());
            this.entgelt = Float.parseFloat(bucks);
        }
        catch (NumberFormatException nfEx) {
            nfEx.printStackTrace();
        }
    }

    public float getEntgelt() {
        return this.entgelt;
    }

    public long getRawHouseHoldData() {
        return this.houseHoldData == 0L ? this.resolvedHHData : this.houseHoldData;
    }

    public String getHouseHoldData() {
        String result = PSEnvironment.formatLongToGermanLocale(this.houseHoldData);
        return result.equals("0") ? "" : result;
    }

    public void resetHouseHoldData(boolean withEntgelt) {
        this.houseHoldData = 0L;
        this.resolvedHHData = 0L;
        if (this.resolvedZbn.length() > 0) {
            StringTokenizer t = new StringTokenizer(this.resolvedZbn, "\t");
            int i = 0;
            while (i < this.getResolvedZbnCnt()) {
                String actZbn = t.nextToken();
                if (((i < 8 ? this.state : this.extendedState) & 2L << (i < 8 ? i : i - 8) * 4) == 0L) {
                    ZbnDataHandler.getInstance(false).addPeripheral();
                    PSO.cc.SendMessage(322, String.valueOf(withEntgelt ? "1|" : "0|") + actZbn + "|" + actZbn + (this.peripherals == null ? "" : "\t" + this.peripherals.get(actZbn)));
                }
                ++i;
            }
        }
    }

    public void setResolvedZbn(String data) {
        this.resolvedZbn = data;
    }

    public String getResolvedZbn() {
        return this.resolvedZbn;
    }

    public long getState() {
        return this.state;
    }

    public void setState(long value) {
        this.state = value;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getID() {
        return this.ID;
    }

    public boolean containsResolvedZbn(String zbn) {
        if (this.resolvedZbn != null) {
            StringTokenizer t = new StringTokenizer(this.resolvedZbn, "\t");
            while (t.hasMoreTokens()) {
                if (!t.nextToken().equals(zbn)) continue;
                return true;
            }
        }
        return false;
    }

    public int getZbnPosition(String zbn) {
        if (this.resolvedZbn != null) {
            int pos = 0;
            StringTokenizer t = new StringTokenizer(this.resolvedZbn, "\t");
            while (t.hasMoreTokens()) {
                if (t.nextToken().equals(zbn)) {
                    return pos;
                }
                ++pos;
            }
        }
        return 0;
    }

    public boolean containsPeripheralZbn(String zbn) {
        if (this.peripherals != null) {
            Enumeration<String> entries = this.peripherals.elements();
            while (entries.hasMoreElements()) {
                StringTokenizer t = new StringTokenizer(entries.nextElement(), "\t");
                while (t.hasMoreTokens()) {
                    if (!t.nextToken().equals(zbn)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public long getResolvedHHData() {
        return this.resolvedHHData;
    }

    public void setResolvedHHData(long data) {
        this.resolvedHHData = data;
    }

    ZbnLogEntry cloneObject() {
        try {
            return (ZbnLogEntry)super.clone();
        }
        catch (CloneNotSupportedException cnsEx) {
            cnsEx.printStackTrace();
            return null;
        }
    }

    public void discard() {
        if (this.peripherals != null) {
            this.peripherals.clear();
            this.peripherals = null;
        }
    }

    public long getExtendedState() {
        return this.extendedState;
    }

    public void setExtendedState(long extendedState) {
        this.extendedState = extendedState;
    }
}

