/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.base.zbnimport;

import java.util.ResourceBundle;
import prospektservice.PSEnvironment;
import prospektservice.PSUser;

public class ZbnUtility {
    private static ZbnUtility instance = null;
    private static int importMillisecDuration = 1500;
    private long approximateDuration = 0L;
    private String separator = ";";
    private ResourceBundle localProperty = ResourceBundle.getBundle("properties.DlgFilialImport", PSUser.getLanguage());

    private ZbnUtility() {
    }

    public static ZbnUtility getInstance() {
        if (instance == null) {
            instance = new ZbnUtility();
        }
        return instance;
    }

    private boolean streetShouldNotBeAltered(String street) {
        boolean doNotChange = true;
        if (street.trim().length() == 0 || street.toLowerCase().startsWith("klgv") || street.toLowerCase().endsWith("weg")) {
            doNotChange = true;
        }
        if (street.toUpperCase().startsWith("B ") && PSEnvironment.isNumeric(street.substring(2))) {
            doNotChange = true;
        }
        if (street.length() >= "stra\u00dfe".length() && street.toLowerCase().substring(0, "stra\u00dfe".length()).equals("stra\u00dfe") && PSEnvironment.isNumeric(street.substring("stra\u00dfe".length()).trim())) {
            doNotChange = true;
        }
        return doNotChange;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String checkStreetSpelling(String street) {
        int length = street.length();
        String tmp = "";
        if (this.streetShouldNotBeAltered(street)) {
            return street;
        }
        char[] strFilter = street.toCharArray();
        int i = 0;
        boolean valid = true;
        while (i < strFilter.length) {
            int j = 0;
            while (j < "0123456789/,".length()) {
                if (strFilter[i] == "0123456789/,".charAt(j) && i > 2) {
                    if (j >= 10) {
                        valid = false;
                    } else {
                        int num = street.indexOf("des ");
                        if (num < 0 || i >= strFilter.length - 4) {
                            valid = false;
                        }
                    }
                }
                ++j;
            }
            if (!valid) break;
            tmp = String.valueOf(tmp) + strFilter[i];
            ++i;
        }
        if (tmp.lastIndexOf("-") == tmp.length() - 1 && tmp.lastIndexOf("-") != -1) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        if ((tmp = (street = tmp.trim()).toLowerCase()).indexOf("str.") == length - 4) {
            return street;
        }
        int pos = tmp.indexOf("strasse");
        if (pos == -1) {
            pos = tmp.indexOf("stra\u00dfe");
            if (pos == -1) {
                pos = tmp.lastIndexOf("str");
                if (pos != tmp.length() - 3) return street;
                return String.valueOf(street.substring(0, pos + 3)) + ".";
            }
            if (pos != tmp.length() - "stra\u00dfe".length()) return street;
            return String.valueOf(street.substring(0, pos + 3)) + ".";
        }
        if (pos != tmp.length() - "strasse".length()) return street;
        return String.valueOf(street.substring(0, pos + 3)) + ".";
    }

    public long getApproximateDuration() {
        if (this.approximateDuration == 0L) {
            this.approximateDuration = importMillisecDuration;
        }
        return this.approximateDuration;
    }

    public String setApproximateDuration(long vollDuration) {
        String strVollDuration = "";
        this.approximateDuration = vollDuration;
        if ((vollDuration /= 1000L) > 60L) {
            long hourDur = vollDuration / 3600L;
            long minDur = (vollDuration - hourDur * 3600L) / 60L;
            long secDur = vollDuration - hourDur * 3600L - minDur * 60L;
            if (hourDur > 0L) {
                String lblHour = this.localProperty.getString("lblHour");
                if (hourDur == 1L) {
                    lblHour = lblHour.substring(0, lblHour.length() - 1);
                }
                strVollDuration = "  " + hourDur + " " + lblHour;
            }
            if (minDur > 0L) {
                String lblMinute = this.localProperty.getString("lblMinute");
                if (minDur == 1L) {
                    lblMinute = lblMinute.substring(0, lblMinute.length() - 1);
                }
                strVollDuration = String.valueOf(strVollDuration) + "  " + minDur + " " + lblMinute;
            }
            if (secDur > 0L) {
                String lblSecond = this.localProperty.getString("lblSecond");
                if (secDur == 1L) {
                    lblSecond = lblSecond.substring(0, lblSecond.length() - 1);
                }
                strVollDuration = String.valueOf(strVollDuration) + "  " + secDur + " " + lblSecond;
            }
        } else {
            strVollDuration = vollDuration == 0L ? String.valueOf(strVollDuration) + "  " + vollDuration * 1000L + " " + this.localProperty.getString("lblMillisecond") : String.valueOf(strVollDuration) + "  " + vollDuration + " " + this.localProperty.getString("lblSecond");
        }
        return strVollDuration.trim();
    }

    private int reCalculateDuration() {
        int result = 0;
        result = PSEnvironment.getActionDuration(314);
        if (result == -1) {
            result = PSEnvironment.getActionDuration(79);
        }
        return result;
    }

    public String prepareForTokinize(String workString, String workSeparator) {
        String prepareString = new String(" ");
        int i = 0;
        while (i < workString.length()) {
            boolean sepIndex = false;
            String dataString = workString.charAt(i) == workSeparator.charAt(0) ? "  " + workSeparator : "" + workString.charAt(i);
            prepareString = String.valueOf(prepareString) + dataString;
            ++i;
        }
        prepareString = String.valueOf(prepareString) + " ";
        return prepareString;
    }

    public String delTabInLine(String workString) {
        String result = workString;
        char[] chars = workString.toCharArray();
        if (workString != null && !workString.equals("")) {
            int i = 0;
            while (i < chars.length) {
                if (chars[i] == '\t') {
                    chars[i] = 32;
                }
                if (chars[i] == '\n') {
                    chars[i] = 32;
                }
                if (chars[i] == '\r') {
                    chars[i] = 32;
                }
                ++i;
            }
            result = new String(chars);
        }
        return result;
    }

    public void setImportMillisecDuration(int duration) {
        importMillisecDuration = duration;
    }

    public int getImportMillisecDuration() {
        return importMillisecDuration;
    }

    public int getBudgetoptHH(int valueHH, String valueEntgelt, int zuschlag) {
        int result = 0;
        String entgeltTZA = "";
        double stueckzahl = 0.0;
        entgeltTZA = valueEntgelt;
        if (entgeltTZA.trim().length() > 0) {
            if (entgeltTZA.indexOf(" ") > 0) {
                entgeltTZA = entgeltTZA.substring(0, entgeltTZA.indexOf(" ")).trim();
            }
            entgeltTZA = entgeltTZA.replace(',', '.');
            stueckzahl = Double.valueOf(entgeltTZA) + (double)zuschlag;
            stueckzahl = (double)(valueHH * 1000) / stueckzahl;
            result = (int)stueckzahl;
        }
        return result;
    }
}

