/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.base.progress;

import javax.swing.JFrame;
import prospektservice.base.progress.ProgressDialog;
import prospektservice.base.progress.TimeProgressPanel;

public abstract class TimeProgressDialog
extends ProgressDialog {
    TimeProgressPanel timeProgressPanel;

    public TimeProgressDialog(JFrame parentFrame, long progressMaxMilliseconds) {
        super(parentFrame, true, true);
        this.createTimeProgressPanel(parentFrame, progressMaxMilliseconds, true);
    }

    public TimeProgressDialog(JFrame parentFrame, boolean isAutoClose, long progressMaxMilliseconds) {
        super(parentFrame, true, isAutoClose);
        this.createTimeProgressPanel(parentFrame, progressMaxMilliseconds, true);
    }

    public TimeProgressDialog(JFrame parentFrame, boolean isAutoStart, boolean isAutoClose, long progressMaxMilliseconds, boolean isMessagesVisible) {
        super(parentFrame, isAutoStart, isAutoClose);
        this.createTimeProgressPanel(parentFrame, progressMaxMilliseconds, isMessagesVisible);
    }

    private void createTimeProgressPanel(JFrame parentFrame, long progressMaxMilliseconds, boolean isMessagesVisible) {
        this.prgDialog.setTitle(localProperty.getString("TimeProgressTitle"));
        this.timeProgressPanel = new TimeProgressPanel((int)progressMaxMilliseconds / 1000, isMessagesVisible);
        TimeProgressPanel.DEBUG_MessageEnabled = ProgressDialog.debugMessageEnabled;
        this.timeProgressPanel.addProgressListener(this.workProgressListener);
        this.progressPanel.add(this.timeProgressPanel);
        this.workProgressPanel = this.timeProgressPanel;
        this.prgDialog.pack();
        this.prgDialog.setLocationRelativeTo(parentFrame);
    }

    public int getProgressStepDuration() {
        return this.timeProgressPanel.getProgressStepDuration();
    }

    public long getProgressMaximum() {
        return this.timeProgressPanel.getProgressMaximum() * 1000;
    }

    public void setProgressMaximum(long progressMaxMilliseconds) {
        int newMax = 0;
        String currProgressLabel = this.getProgressLabel();
        this.setProgressLabel(localProperty.getString("ProgressLabelMaxChangeText"));
        newMax = (int)progressMaxMilliseconds / 1000;
        this.timeProgressPanel.changeProgressMaximum(newMax);
        this.setProgressLabel(currProgressLabel);
    }

    public void restartProgress(int lastStepMillisecondsDuration) {
        this.timeProgressPanel.restartTimeProgress(lastStepMillisecondsDuration);
    }
}

