/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.base;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JList;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;
import prospektservice.base.PSComboBoxModel;

public class PSComboBoxUI
extends MetalComboBoxUI {
    private static final int KEY_PAGE_DOWN = 34;
    private BasicComboPopup popup;
    private PSComboBoxModel dataModel;
    private int lastVisibleIndex = -1;
    private boolean indexAdjusted = false;

    @Override
    protected ComboPopup createPopup() {
        BasicComboPopup popup = (BasicComboPopup)super.createPopup();
        this.listBox = popup.getList();
        this.listBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int actIndex = PSComboBoxUI.this.getListBox().getLastVisibleIndex();
                if (e.getKeyCode() == 34 && actIndex >= PSComboBoxUI.this.lastVisibleIndex + PSComboBoxUI.this.dataModel.getPackageSize()) {
                    PSComboBoxUI.this.processScrollEvent();
                }
            }
        });
        JViewport listView = (JViewport)this.listBox.getParent();
        listView.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int actIndex = PSComboBoxUI.this.getListBox().getLastVisibleIndex();
                while (actIndex >= PSComboBoxUI.this.lastVisibleIndex + PSComboBoxUI.this.dataModel.getPackageSize()) {
                    PSComboBoxUI.this.processScrollEvent();
                    actIndex = PSComboBoxUI.this.getListBox().getLastVisibleIndex();
                }
            }
        });
        return popup;
    }

    public JList getListBox() {
        return this.listBox;
    }

    public void setDataModel(PSComboBoxModel data) {
        this.dataModel = data;
    }

    public void adjustVisibleIndex(int diff) {
        if (diff != 0) {
            this.lastVisibleIndex -= diff;
            this.indexAdjusted = true;
        }
    }

    private void processScrollEvent() {
        this.lastVisibleIndex += this.dataModel.getPackageSize();
        if (this.indexAdjusted) {
            this.dataModel.GetNewData(++this.lastVisibleIndex);
            this.indexAdjusted = false;
        } else {
            this.dataModel.GetNewData(this.lastVisibleIndex);
        }
    }

    public void fireScrollEvent() {
        this.processScrollEvent();
    }
}

