/*
 * Decompiled with CFR 0.152.
 */
package de.codesolutions.pam.map;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class MapStateHelper {
    private static final int MAX_VIEWS = 50;
    private List<MapView> views;
    private int viewIndex = -1;
    private Logger logger = Logger.getLogger("MapStateHelper");

    public MapStateHelper() {
        this.views = new ArrayList<MapView>();
    }

    public void addView(Point center, double zoom) {
        if (this.isNewView(center, zoom)) {
            this.logger.info("adding a new view...");
            MapView mv = new MapView();
            mv.setMapCenter(center);
            mv.setMapZoom(zoom);
            if (this.views.size() == 50) {
                this.views.remove(0);
                --this.viewIndex;
            }
            this.views.add(mv);
            ++this.viewIndex;
        }
    }

    private boolean isNewView(Point center, double zoom) {
        boolean result = true;
        for (MapView mv : this.views) {
            if (!mv.getMapCenter().equals((Geometry)center) || mv.getMapZoom() != zoom) continue;
            result = false;
        }
        return result;
    }

    public MapView getPreviousView() {
        this.logger.info("getPreviousView, viewIndex: " + this.viewIndex);
        if (this.viewIndex > 0) {
            --this.viewIndex;
        }
        return this.views.get(this.viewIndex);
    }

    public MapView getNextView() {
        if (this.viewIndex < 49 && this.viewIndex < this.views.size() - 1) {
            ++this.viewIndex;
        }
        return this.views.get(this.viewIndex);
    }

    public MapView getViewAt(int index) {
        MapView mv = null;
        if (index < this.views.size()) {
            mv = this.views.get(index);
        }
        return mv;
    }

    public void reset() {
        this.views.clear();
        this.viewIndex = -1;
    }

    public class MapView {
        private Point mapCenter;
        private double mapZoom;

        public Point getMapCenter() {
            return this.mapCenter;
        }

        public void setMapCenter(Point mapCenter) {
            this.mapCenter = mapCenter;
        }

        public double getMapZoom() {
            return this.mapZoom;
        }

        public void setMapZoom(double mapZoom) {
            this.mapZoom = mapZoom;
        }
    }
}

