/*
 * Decompiled with CFR 0.152.
 */
package de.codesolutions.pam.map;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import de.codesolutions.pam.map.MapDataLoader;
import java.util.logging.Logger;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefQueryCallback;
import org.cef.handler.CefMessageRouterHandlerAdapter;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.dialog.frmDetails;

public class MapEventHandler
extends CefMessageRouterHandlerAdapter {
    private static final String MAP_CLICK_LEFT = "Lat:";
    private static final String MAP_CLICK_RIGHT = "rightClick:";
    private static final String MAP_POLY_SELCTION = "PolygonSelect:";
    private static final String MAP_REPORT_SELECTION = "Selection:";
    private static final String MAP_REQUEST_SELECTION = "RequestSelection:";
    private static final String MAP_SELECTION_CHANGED = "SelectionChanged:";
    private static final String MAP_REPORT_ZOOM = "Zoomlevel:";
    private static final String MAP_REPORT_RADIUS = "Radius:";
    private static final String MAP_PLZ_INFO = "infoPLZ:";
    private static final String MAP_KREIS_INFO = "infoKreis:";
    private static final String MAP_ZB_INFO = "infoZB:";
    private static final String MAP_IS_AREA_SELECTED = "IsAreaSelected:";
    private static final String MAP_ACTION_QUERY = "WTD?";
    private static final String RESPONSE_ACK = "ACK";
    private Logger logger = Logger.getLogger("MapEventHandler");
    private boolean initialModeSet = false;
    private double zoom;

    public boolean onQuery(CefBrowser browser, CefFrame frame, long query_id, String request, boolean persistent, CefQueryCallback callback) {
        boolean result = false;
        if (request.startsWith(MAP_CLICK_LEFT)) {
            String lon;
            String[] parts = request.split(",");
            String lat = parts[0].substring(4);
            String response = MapDataLoader.featureForPoint(lat, lon = parts[1].substring(5), MapDataLoader.AreaTypes.PLZ);
            if (response.length() > 0) {
                callback.success(response);
                result = true;
            }
        } else if (request.startsWith(MAP_CLICK_RIGHT) && PSO.Modus < 3) {
            String data = request.substring(MAP_CLICK_RIGHT.length());
            if (data.length() > 0) {
                PSO.frameDetails = frmDetails.getInstance(PSO.mainpanel, PSEnvironment.mainframe, "PLZ");
                PSO.frameDetails.setUntertitel(data);
                PSO.frameDetails.setVisible(true);
                PSO.cc.SendMessage(210001, "-" + data);
                callback.success(RESPONSE_ACK);
                result = true;
            }
        } else if (request.startsWith(MAP_REPORT_SELECTION)) {
            String data = request.substring(MAP_REPORT_SELECTION.length());
            this.logger.info(data);
            callback.success(RESPONSE_ACK);
            result = true;
            PSO.mainpanel.mapSelectionToDestinationList(data);
            PSO.mainpanel.setKarteSelectionChanged(false);
        } else if (request.startsWith(MAP_REQUEST_SELECTION)) {
            if (PSO.Modus == 5 && this.zoom < 13.0 || !PSO.mainpanel.getWmp().isZbnEnabled()) {
                PSO.cc.SendMessage(258, "OT");
            } else {
                PSO.cc.SendMessage(258, " ");
            }
            callback.success(RESPONSE_ACK);
            result = true;
        } else if (request.startsWith(MAP_SELECTION_CHANGED)) {
            String data = request.substring(MAP_SELECTION_CHANGED.length());
            if (data.length() > 0 && PSO.Modus == 3) {
                if (PSO.mainpanel.getWmp().isLrSelectionMode()) {
                    PSO.cc.SendMessage(289, data);
                } else {
                    PSO.cc.SendMessage(285, data);
                }
            }
            PSO.mainpanel.setKarteSelectionChanged(true);
            PSO.mainpanel.l_bar1.setText("");
            callback.success(RESPONSE_ACK);
            result = true;
        } else if (request.startsWith(MAP_IS_AREA_SELECTED)) {
            this.logger.info(request);
            String data = request.substring(MAP_IS_AREA_SELECTED.length());
            boolean state = Boolean.parseBoolean(data);
            this.logger.info("area selected: " + state);
            PSO.frameDetails.currentAreaSelected(state);
            callback.success(RESPONSE_ACK);
            result = true;
        } else if (request.startsWith(MAP_POLY_SELCTION)) {
            String data = request.substring(MAP_POLY_SELCTION.length());
            String response = MapDataLoader.featuresForDragBox(data, MapDataLoader.AreaTypes.PLZ);
            if (response.length() > 0) {
                callback.success(response);
                result = true;
            }
        } else if (request.startsWith(MAP_PLZ_INFO)) {
            String data = request.substring(MAP_PLZ_INFO.length());
            this.logger.info("PLZ: " + data);
            PSO.mainpanel.setPLZUnderCursor(data);
            PSO.cc.SendMessage(254, data);
            callback.success(RESPONSE_ACK);
            result = true;
        } else if (request.startsWith(MAP_KREIS_INFO)) {
            String data = request.substring(MAP_KREIS_INFO.length());
            this.logger.info("AGS: " + data);
            PSO.mainpanel.setPLZUnderCursor(data);
            PSO.cc.SendMessage(287, data);
            callback.success(RESPONSE_ACK);
            result = true;
        } else if (request.startsWith(MAP_ZB_INFO)) {
            String data = request.substring(MAP_ZB_INFO.length());
            this.logger.info("ZBez: " + data);
            data = String.valueOf(data.substring(0, 5)) + data.substring(6);
            PSO.mainpanel.setPLZUnderCursor(data);
            PSO.cc.SendMessage(313, data);
            callback.success(RESPONSE_ACK);
            result = true;
        } else if (request.startsWith(MAP_REPORT_ZOOM)) {
            String[] parts = request.substring(MAP_REPORT_ZOOM.length()).split(",");
            this.zoom = Double.parseDouble(parts[0]);
            GeometryFactory gf = new GeometryFactory();
            Point center = gf.createPoint(new Coordinate(Double.parseDouble(parts[1]), Double.parseDouble(parts[2])));
            MapDataLoader.getMapstatehelper().addView(center, this.zoom);
            PSO.mainpanel.getWmp().setCurrentZoom(this.zoom);
            this.logger.info(MAP_REPORT_ZOOM + this.zoom);
            if (!this.initialModeSet) {
                PSO.mainpanel.getWmp().mapReady();
                this.initialModeSet = true;
                PSO.mainpanel.getWmp().revalidate();
                PSO.mainpanel.getWmp().repaint();
            }
            callback.success(RESPONSE_ACK);
            result = true;
        } else if (request.startsWith(MAP_REPORT_RADIUS)) {
            String radius = request.substring(MAP_REPORT_RADIUS.length());
            PSO.mainpanel.l_bar1.setText("Radius: " + radius);
            callback.success(RESPONSE_ACK);
            result = true;
        }
        return result;
    }
}

