/*
 * Decompiled with CFR 0.152.
 */
package de.codesolutions.pam.map;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.GeometryCombiner;
import com.vividsolutions.jts.util.GeometricShapeFactory;
import de.codesolutions.pam.map.MapStateHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.geojson.geom.GeometryJSON;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class MapDataLoader {
    private static Map<String, Geometry> geoPLZ;
    private static Map<String, Geometry> geoZBN;
    private static Map<String, Geometry> geoCounties;
    private static final MapStateHelper mapStateHelper;
    private static Logger logger;

    static {
        mapStateHelper = new MapStateHelper();
    }

    public static void init() {
        logger = Logger.getLogger(MapDataLoader.class.getCanonicalName());
        geoPLZ = new HashMap<String, Geometry>();
        geoZBN = new HashMap<String, Geometry>();
        geoCounties = new HashMap<String, Geometry>();
    }

    public static void loadGeoJsonFromUrl(final String url, final AreaTypes type) {
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    URL address = new URL(url);
                    HttpURLConnection con = (HttpURLConnection)address.openConnection();
                    JSONParser parser = new JSONParser();
                    JSONObject json = (JSONObject)parser.parse((Reader)new BufferedReader(new InputStreamReader(con.getInputStream())));
                    JSONArray features = (JSONArray)json.get((Object)"features");
                    logger.info("feature count: " + features.size());
                    int i = 0;
                    while (i < features.size()) {
                        Map map;
                        JSONObject feature = (JSONObject)features.get(i);
                        JSONObject properties = (JSONObject)feature.get((Object)"properties");
                        JSONObject geometry = (JSONObject)feature.get((Object)"geometry");
                        GeometryJSON geoJSON = new GeometryJSON();
                        Geometry g = geoJSON.read((Object)geometry.toJSONString());
                        if (type == AreaTypes.PLZ) {
                            map = geoPLZ;
                            synchronized (map) {
                                geoPLZ.put(properties.get((Object)"PLZ_5").toString(), g);
                            }
                        }
                        if (type == AreaTypes.Kreise) {
                            map = geoCounties;
                            synchronized (map) {
                                geoCounties.put(properties.get((Object)"GEN").toString(), g);
                            }
                        }
                        ++i;
                    }
                }
                catch (IOException ioEx) {
                    logger.log(Level.WARNING, "IOException in loadGeoJsonFromUrl", ioEx);
                }
                catch (ParseException pe) {
                    logger.log(Level.WARNING, "ParseException in loadGeoJsonFromUrl", pe);
                }
            }
        };
        t.start();
    }

    public static String featureForPoint(String lat, String lon, AreaTypes type) {
        return MapDataLoader.featureForPoint(lat, lon, type, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String featureForPoint(String lat, String lon, AreaTypes type, boolean keyOnly) {
        String result = "";
        GeometryFactory gf = new GeometryFactory();
        Point p = gf.createPoint(new Coordinate(Double.parseDouble(lat), Double.parseDouble(lon)));
        Map<String, Geometry> map = MapDataLoader.collectionForAreaType(type);
        synchronized (map) {
            for (Map.Entry<String, Geometry> pair : MapDataLoader.collectionForAreaType(type).entrySet()) {
                Geometry g = pair.getValue();
                if (!g.contains((Geometry)p)) continue;
                result = String.valueOf(pair.getKey()) + (keyOnly ? "" : "|" + g.toText());
                logger.info("found: " + result);
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String featuresForDragBox(String extent, AreaTypes type) {
        String result = "";
        logger.info("extent:" + extent);
        String[] singleCoords = extent.split(",");
        Coordinate[] coordinates = new Coordinate[singleCoords.length / 2];
        coordinates[0] = new Coordinate(Double.valueOf(singleCoords[0]).doubleValue(), Double.valueOf(singleCoords[1]).doubleValue());
        coordinates[1] = new Coordinate(Double.valueOf(singleCoords[2]).doubleValue(), Double.valueOf(singleCoords[3]).doubleValue());
        GeometricShapeFactory gsf = new GeometricShapeFactory();
        gsf.setBase(coordinates[0]);
        gsf.setNumPoints(4);
        gsf.setWidth(coordinates[1].x - coordinates[0].x);
        gsf.setHeight(coordinates[1].y - coordinates[0].y);
        Polygon rect = gsf.createRectangle();
        Map<String, Geometry> map = MapDataLoader.collectionForAreaType(type);
        synchronized (map) {
            for (Map.Entry<String, Geometry> pair : MapDataLoader.collectionForAreaType(type).entrySet()) {
                Geometry g = pair.getValue();
                if (!g.intersects((Geometry)rect) && !rect.contains(g)) continue;
                if (result.length() > 0) {
                    result = String.valueOf(result) + ";";
                }
                result = String.valueOf(result) + pair.getKey() + "|" + g.toText();
                logger.info("found: " + pair.getKey());
            }
        }
        return result;
    }

    public static Point getFeatureCentroid(String key, AreaTypes type) {
        Geometry g = MapDataLoader.collectionForAreaType(type).get(key);
        Point pt = null;
        if (g != null) {
            pt = g.getCentroid();
        }
        return pt;
    }

    private static Map<String, Geometry> collectionForAreaType(AreaTypes type) {
        Map<String, Geometry> result = null;
        switch (type) {
            case PLZ: {
                result = geoPLZ;
                break;
            }
            case ZBN: {
                result = geoZBN;
                break;
            }
            case Kreise: {
                result = geoCounties;
            }
        }
        return result;
    }

    public static MapStateHelper getMapstatehelper() {
        return mapStateHelper;
    }

    public static Geometry combineGeometries(List<Geometry> geometries) {
        Geometry result = null;
        try {
            Geometry g = GeometryCombiner.combine(geometries);
            result = g.getEnvelope();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Exception in combineGeometries", ex);
        }
        return result;
    }

    public static Geometry getAreaGeometry(String key, AreaTypes type) {
        Geometry g = MapDataLoader.collectionForAreaType(type).get(key);
        return g;
    }

    public static enum AreaTypes {
        PLZ,
        ZBN,
        Kreise;

    }
}

