/*
 * Decompiled with CFR 0.152.
 */
package de.codesolutions.pam.map;

import de.codesolutions.pam.map.WebMapPanel;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefAuthCallback;
import org.cef.callback.CefRequestCallback;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefResourceRequestHandler;
import org.cef.handler.CefResourceRequestHandlerAdapter;
import org.cef.misc.BoolRef;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;
import org.cef.network.CefURLRequest;
import prospektservice.PSO;
import prospektservice.base.BrowserLauncher;

public class CefMapRequestHandler
extends CefResourceRequestHandlerAdapter
implements CefRequestHandler {
    private Logger logger = Logger.getLogger("CefMapRequestHandler");

    public boolean getAuthCredentials(CefBrowser arg0, String arg1, boolean arg2, String arg3, int arg4, String arg5, String arg6, CefAuthCallback arg7) {
        return false;
    }

    public CefResourceRequestHandler getResourceRequestHandler(CefBrowser arg0, CefFrame arg1, CefRequest arg2, boolean arg3, boolean arg4, String arg5, BoolRef arg6) {
        return this;
    }

    public boolean onBeforeBrowse(CefBrowser arg0, CefFrame arg1, CefRequest request, boolean arg3, boolean arg4) {
        boolean result;
        String url = request.getURL();
        this.logger.fine("in onBeforeBrowse, url=" + url);
        boolean bl = result = url.indexOf(WebMapPanel.MAP_BASE_URL) == -1;
        if (result) {
            try {
                BrowserLauncher.openURL(url);
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "IOException in onBeforeBrowse", e);
            }
        }
        return result;
    }

    public boolean onBeforeResourceLoad(CefBrowser browser, CefFrame frame, CefRequest request) {
        this.logger.fine("in onBeforeResourceLoad, url=" + request.getURL());
        String url = request.getURL();
        if (url.indexOf(WebMapPanel.MAP_BASE_ADDRESS) != -1) {
            HashMap<String, String> headers = new HashMap<String, String>();
            request.getHeaderMap(headers);
            PSO.mainpanel.getWmp();
            headers.put("MAK", WebMapPanel.getMapAccessKey());
            request.setHeaderMap(headers);
        }
        WebMapPanel wmp = PSO.mainpanel.getWmp();
        if (url.indexOf("ol-lr-short.geojson") > -1) {
            wmp.getProgressDlg().setLabelContent("Lade Leitregionen...");
        } else if (url.indexOf("ol-plz-short.geojson") > -1) {
            wmp.getProgressDlg().setLabelContent("Lade Postleitzahlgebiete...");
        } else if (url.indexOf("ol-krs-short.geojson") > -1) {
            wmp.getProgressDlg().setLabelContent("Lade Kreisgebiete...");
        }
        return false;
    }

    public void onResourceLoadComplete(CefBrowser browser, CefFrame frame, CefRequest request, CefResponse response, CefURLRequest.Status status, long receivedContentLength) {
        this.logger.fine("url: " + request.getURL());
        this.logger.fine("Status: " + response.getStatus() + ", " + response.getStatusText());
        this.logger.fine("contentlength: " + receivedContentLength);
        if (request.getURL().indexOf("ol-plz-short.geojson") > -1) {
            PSO.mainpanel.getWmp().getProgressDlg().dispose();
            if (PSO.Modus == 5) {
                PSO.mainpanel.getWmp().setMapMode(2);
            }
        }
    }

    public boolean onCertificateError(CefBrowser arg0, CefLoadHandler.ErrorCode arg1, String arg2, CefRequestCallback arg3) {
        return false;
    }

    public void onPluginCrashed(CefBrowser arg0, String arg1) {
    }

    public boolean onQuotaRequest(CefBrowser arg0, String arg1, long arg2, CefRequestCallback arg3) {
        return false;
    }

    public void onRenderProcessTerminated(CefBrowser arg0, CefRequestHandler.TerminationStatus arg1) {
    }
}

