/*
 * Decompiled with CFR 0.152.
 */
package com.standbysoft.component.date.swing;

import com.standbysoft.component.date.DateSelectionException;
import com.standbysoft.component.date.DateSelectionModel;
import com.standbysoft.component.date.DefaultDateSelectionModel;
import com.standbysoft.component.date.event.DateSelectionEvent;
import com.standbysoft.component.date.event.DateSelectionListener;
import com.standbysoft.component.date.swing.plaf.DateUI;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.UIManager;

public abstract class JDateComponent
extends JComponent {
    protected DateSelectionModel dateSelectionModel;
    protected DateSelectionListener dateSelectionModelListener;
    protected String actionCommand;
    protected Locale locale;
    protected Calendar calendar;
    protected TimeZone timeZone;
    public static final String selectNoneAction = "select-none";
    public static final String selectTodayAction = "select-today";
    public static final String selectFirstDayAction = "select-first-day";
    public static final String selectLastDayAction = "select-last-day";
    public static final String selectNextDayAction = "select-next-day";
    public static final String selectPreviousDayAction = "select-previous-day";
    public static final String selectSameDayNextWeekAction = "select-same-day-next-week";
    public static final String selectSameDayPreviousWeekAction = "select-same-day-previous-week";
    public static final String selectSameDayNextMonthAction = "select-same-day-next-month";
    public static final String selectSameDayPreviousMonthAction = "select-same-day-previous-month";
    public static final String selectSameDayNextYearAction = "select-same-day-next-year";
    public static final String selectSameDayPreviousYearAction = "select-same-day-previous-year";
    static /* synthetic */ Class class$java$awt$event$ActionListener;
    static /* synthetic */ Class class$com$standbysoft$component$date$event$DateSelectionListener;

    public JDateComponent() {
        this(new DefaultDateSelectionModel());
    }

    public JDateComponent(DateSelectionModel dateSelectionModel) {
        this.dateSelectionModel = dateSelectionModel;
        this.locale = Locale.getDefault();
        this.calendar = Calendar.getInstance();
        this.timeZone = TimeZone.getDefault();
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public Date getSelectedDate() {
        return this.dateSelectionModel.getLeadSelectionDate();
    }

    public void setSelectedDate(Date date) {
        if (date == null) {
            if (this.getSelectedDate() != null && this.isEmptySelectionAllowed()) {
                this.dateSelectionModel.removeAllDates();
            }
        } else {
            Date date2 = this.getSelectedDate();
            if (!date.equals(date2)) {
                this.dateSelectionModel.setDateSelectionIterval(date, date);
            }
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = JDateComponent.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = JDateComponent.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void fireActionEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        ActionEvent actionEvent = null;
        int n = 0;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$java$awt$event$ActionListener == null ? JDateComponent.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) continue;
            if (actionEvent == null) {
                actionEvent = new ActionEvent(this, 1001, this.getActionCommand(), n);
            }
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    public DateUI getUI() {
        return (DateUI)this.ui;
    }

    public void setUI(DateUI dateUI) {
        super.setUI(dateUI);
    }

    public void updateUI() {
        Object object;
        boolean bl = false;
        try {
            object = UIManager.getUI(this);
            if (object != null && object instanceof DateUI) {
                this.setUI((DateUI)object);
                this.invalidate();
                return;
            }
            bl = true;
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl) {
            object = (String)UIManager.get(this.getUIClassID());
            try {
                Class<?> clazz = Class.forName((String)object);
                DateUI dateUI = (DateUI)clazz.newInstance();
                this.setUI(dateUI);
                this.invalidate();
            }
            catch (Exception exception) {
                System.err.println("Failed to register a UI delegate for " + this.getName());
                exception.printStackTrace();
            }
        }
    }

    public void addDateSelectionListener(DateSelectionListener dateSelectionListener) {
        if (this.dateSelectionModelListener == null) {
            this.dateSelectionModelListener = new _A();
            this.dateSelectionModel.addDateSelectionListener(this.dateSelectionModelListener);
        }
        this.listenerList.add(class$com$standbysoft$component$date$event$DateSelectionListener == null ? (class$com$standbysoft$component$date$event$DateSelectionListener = JDateComponent.class$("com.standbysoft.component.date.event.DateSelectionListener")) : class$com$standbysoft$component$date$event$DateSelectionListener, dateSelectionListener);
    }

    public void removeDateSelectionListener(DateSelectionListener dateSelectionListener) {
        this.listenerList.remove(class$com$standbysoft$component$date$event$DateSelectionListener == null ? (class$com$standbysoft$component$date$event$DateSelectionListener = JDateComponent.class$("com.standbysoft.component.date.event.DateSelectionListener")) : class$com$standbysoft$component$date$event$DateSelectionListener, dateSelectionListener);
    }

    public DateSelectionModel getDateSelectionModel() {
        return this.dateSelectionModel;
    }

    public void setDateSelectionModel(DateSelectionModel dateSelectionModel) {
        if (dateSelectionModel == null) {
            throw new IllegalArgumentException("null model");
        }
        if (!dateSelectionModel.equals(this.dateSelectionModel)) {
            DateSelectionModel dateSelectionModel2 = this.dateSelectionModel;
            this.dateSelectionModel = dateSelectionModel;
            if (this.dateSelectionModelListener != null) {
                this.dateSelectionModel.addDateSelectionListener(this.dateSelectionModelListener);
            }
            this.firePropertyChange("dateSelectionModel", dateSelectionModel2, dateSelectionModel);
            this.repaint();
            this.revalidate();
        }
    }

    public boolean isEmptySelectionAllowed() {
        return this.dateSelectionModel.isEmptySelectionAllowed();
    }

    public void setEmptySelectionAllowed(boolean bl) throws DateSelectionException {
        this.dateSelectionModel.setEmptySelectionAllowed(bl);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        Locale locale2 = this.locale;
        this.locale = locale;
        this.firePropertyChange("locale", locale2, locale);
    }

    protected void fireDisabledDatesChanged(DateSelectionEvent dateSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$standbysoft$component$date$event$DateSelectionListener == null ? JDateComponent.class$("com.standbysoft.component.date.event.DateSelectionListener") : class$com$standbysoft$component$date$event$DateSelectionListener)) continue;
            ((DateSelectionListener)objectArray[i + 1]).disabledDatesChanged(dateSelectionEvent);
        }
    }

    protected void fireDateSelectionChanged(DateSelectionEvent dateSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$standbysoft$component$date$event$DateSelectionListener == null ? JDateComponent.class$("com.standbysoft.component.date.event.DateSelectionListener") : class$com$standbysoft$component$date$event$DateSelectionListener)) continue;
            ((DateSelectionListener)objectArray[i + 1]).dateSelectionChanged(dateSelectionEvent);
        }
    }

    protected void fireSelectionModeChanged(DateSelectionEvent dateSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$standbysoft$component$date$event$DateSelectionListener == null ? JDateComponent.class$("com.standbysoft.component.date.event.DateSelectionListener") : class$com$standbysoft$component$date$event$DateSelectionListener)) continue;
            ((DateSelectionListener)objectArray[i + 1]).selectionModeChanged(dateSelectionEvent);
        }
    }

    protected void fireEmptySelectionAllowedChanged(DateSelectionEvent dateSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$standbysoft$component$date$event$DateSelectionListener == null ? JDateComponent.class$("com.standbysoft.component.date.event.DateSelectionListener") : class$com$standbysoft$component$date$event$DateSelectionListener)) continue;
            ((DateSelectionListener)objectArray[i + 1]).emptySelectionAllowedChanged(dateSelectionEvent);
        }
    }

    protected void fireDisabledDateSelectionAttempted(DateSelectionEvent dateSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$standbysoft$component$date$event$DateSelectionListener == null ? JDateComponent.class$("com.standbysoft.component.date.event.DateSelectionListener") : class$com$standbysoft$component$date$event$DateSelectionListener)) continue;
            ((DateSelectionListener)objectArray[i + 1]).disabledDateSelectionAttempted(dateSelectionEvent);
        }
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        TimeZone timeZone2 = this.timeZone;
        this.timeZone = timeZone;
        this.firePropertyChange("timeZone", timeZone2, timeZone);
        if (timeZone2 != timeZone) {
            this.dateSelectionModel.setTimeZone(timeZone);
            this.calendar.setTimeZone(timeZone);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class SelectNoneAction
    extends DateAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JDateComponent jDateComponent = this.getDateComponent(actionEvent);
            if (jDateComponent == null) {
                return;
            }
            DateSelectionModel dateSelectionModel = jDateComponent.getDateSelectionModel();
            dateSelectionModel.removeAllDates();
        }
    }

    public static class SelectLastDayAction
    extends DateAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JDateComponent jDateComponent = this.getDateComponent(actionEvent);
            if (jDateComponent == null) {
                return;
            }
            DateSelectionModel dateSelectionModel = jDateComponent.getDateSelectionModel();
            Date date = dateSelectionModel.getAnchorSelectionDate();
            if (date != null) {
                Calendar calendar = jDateComponent.getCalendar();
                calendar.setTime(date);
                int n = calendar.getActualMinimum(5);
                int n2 = calendar.getActualMaximum(5);
                boolean bl = false;
                for (int i = n2; i >= n && !bl; --i) {
                    calendar.set(5, i);
                    date = calendar.getTime();
                    if (!dateSelectionModel.isDateSelectable(date)) continue;
                    bl = true;
                }
                if (bl) {
                    dateSelectionModel.setDateSelectionIterval(date, date);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }

    public static class SelectFirstDayAction
    extends DateAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JDateComponent jDateComponent = this.getDateComponent(actionEvent);
            if (jDateComponent == null) {
                return;
            }
            DateSelectionModel dateSelectionModel = jDateComponent.getDateSelectionModel();
            Date date = dateSelectionModel.getAnchorSelectionDate();
            if (date != null) {
                Calendar calendar = jDateComponent.getCalendar();
                calendar.setTime(date);
                int n = calendar.getActualMinimum(5);
                int n2 = calendar.getActualMaximum(5);
                boolean bl = false;
                for (int i = n; i <= n2 && !bl; ++i) {
                    calendar.set(5, i);
                    date = calendar.getTime();
                    if (!dateSelectionModel.isDateSelectable(date)) continue;
                    bl = true;
                }
                if (bl) {
                    dateSelectionModel.setDateSelectionIterval(date, date);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }

    public static class SelectTodayAction
    extends DateAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JDateComponent jDateComponent = this.getDateComponent(actionEvent);
            if (jDateComponent == null) {
                return;
            }
            Calendar calendar = jDateComponent.getCalendar();
            calendar.setTimeInMillis(System.currentTimeMillis());
            int n = calendar.get(1);
            int n2 = calendar.get(2);
            int n3 = calendar.get(5);
            DateSelectionModel dateSelectionModel = jDateComponent.getDateSelectionModel();
            if (dateSelectionModel.getSelectedDates().length > 0) {
                calendar.setTime(dateSelectionModel.getAnchorSelectionDate());
            } else {
                calendar.clear();
            }
            calendar.set(n, n2, n3);
            Date date = calendar.getTime();
            if (date != null) {
                if (dateSelectionModel.isDateSelectable(date)) {
                    dateSelectionModel.setDateSelectionIterval(date, date);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }

    public static class RollDateAction
    extends DateAction {
        private int B;
        private boolean A;

        public RollDateAction(int n, boolean bl) {
            this.B = n;
            this.A = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JDateComponent jDateComponent = this.getDateComponent(actionEvent);
            if (jDateComponent == null) {
                return;
            }
            DateSelectionModel dateSelectionModel = jDateComponent.getDateSelectionModel();
            Date date = dateSelectionModel.getAnchorSelectionDate();
            if (date != null) {
                Date date2;
                Calendar calendar = jDateComponent.getCalendar();
                calendar.setTime(date);
                calendar.add(this.B, this.A ? 1 : -1);
                Date date3 = calendar.getTime();
                Date date4 = dateSelectionModel.getMinimumAllowed();
                if (date4 != null && date4.after(date3)) {
                    date3 = date4;
                    Toolkit.getDefaultToolkit().beep();
                }
                if ((date2 = dateSelectionModel.getMaximumAllowed()) != null && date2.before(date3)) {
                    date3 = date2;
                    Toolkit.getDefaultToolkit().beep();
                }
                if (dateSelectionModel.isDateSelectable(date3)) {
                    dateSelectionModel.setDateSelectionIterval(date3, date3);
                } else {
                    int n = this.B;
                    if (n != 3) {
                        n = 5;
                    }
                    if (this.A) {
                        while ((date2 == null || date2 != null && date3.before(date2)) && !dateSelectionModel.isDateSelectable(date3)) {
                            calendar.add(n, 1);
                            date3 = calendar.getTime();
                        }
                    } else {
                        while ((date4 == null || date4 != null && date3.after(date4)) && !dateSelectionModel.isDateSelectable(date3)) {
                            calendar.add(n, -1);
                            date3 = calendar.getTime();
                        }
                    }
                    if (dateSelectionModel.isDateSelectable(date3)) {
                        dateSelectionModel.setDateSelectionIterval(date3, date3);
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            }
        }
    }

    public static abstract class DateAction
    extends AbstractAction {
        protected final JDateComponent getDateComponent(ActionEvent actionEvent) {
            Object object;
            if (actionEvent != null && (object = actionEvent.getSource()) instanceof JDateComponent) {
                return (JDateComponent)object;
            }
            return null;
        }
    }

    class _A
    implements DateSelectionListener {
        _A() {
        }

        public void dateSelectionChanged(DateSelectionEvent dateSelectionEvent) {
            JDateComponent.this.fireDateSelectionChanged(new DateSelectionEvent(JDateComponent.this, dateSelectionEvent.getFirstDate(), dateSelectionEvent.getLastDate()));
        }

        public void selectionModeChanged(DateSelectionEvent dateSelectionEvent) {
            JDateComponent.this.fireSelectionModeChanged(new DateSelectionEvent(JDateComponent.this, dateSelectionEvent.getFirstDate(), dateSelectionEvent.getLastDate()));
        }

        public void disabledDatesChanged(DateSelectionEvent dateSelectionEvent) {
            JDateComponent.this.fireDisabledDatesChanged(new DateSelectionEvent(JDateComponent.this, dateSelectionEvent.getFirstDate(), dateSelectionEvent.getLastDate()));
        }

        public void emptySelectionAllowedChanged(DateSelectionEvent dateSelectionEvent) {
            JDateComponent.this.fireEmptySelectionAllowedChanged(new DateSelectionEvent(JDateComponent.this, dateSelectionEvent.getFirstDate(), dateSelectionEvent.getLastDate()));
        }

        public void disabledDateSelectionAttempted(DateSelectionEvent dateSelectionEvent) {
            JDateComponent.this.fireDisabledDateSelectionAttempted(new DateSelectionEvent(JDateComponent.this, dateSelectionEvent.getFirstDate(), dateSelectionEvent.getLastDate()));
        }
    }
}

