/*
 * Decompiled with CFR 0.152.
 */
package com.standbysoft.component.date.swing;

import com.standbysoft.component.date.DateSelectionModel;
import com.standbysoft.component.date.swing.DateRenderer;
import com.standbysoft.component.date.swing.JMonth;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JLabel;

public class DefaultDateRenderer
extends JLabel
implements DateRenderer {
    protected Date date;
    protected JMonth month;

    public DefaultDateRenderer() {
        this.setOpaque(false);
    }

    public Component getDateRendererComponent(JMonth jMonth, Date date) {
        this.month = jMonth;
        this.setFont(jMonth.getFont());
        this.setHorizontalAlignment(0);
        Calendar calendar = jMonth.getCalendar();
        calendar.setTime(date);
        this.date = date;
        this.setText(calendar.get(5) + "");
        if (jMonth.getMonthModel().isTrailingNext(date)) {
            if (jMonth.isTrailingNextEnabled()) {
                this.setForeground(jMonth.getTrailingForeground());
            } else {
                this.setForeground(jMonth.getMonthBackground());
            }
        } else if (jMonth.getMonthModel().isTrailingPrevious(date)) {
            if (jMonth.isTrailingPreviousEnabled()) {
                this.setForeground(jMonth.getTrailingForeground());
            } else {
                this.setForeground(jMonth.getMonthBackground());
            }
        } else {
            this.setForeground(jMonth.getForeground());
        }
        return this;
    }

    public void paint(Graphics graphics) {
        Color color = graphics.getColor();
        if (this.month.getMonthModel().isTrailingNext(this.date) && this.month.isTrailingNextEnabled() || this.month.getMonthModel().isTrailingPrevious(this.date) && this.month.isTrailingPreviousEnabled() || !this.month.getMonthModel().isTrailingPrevious(this.date) && !this.month.getMonthModel().isTrailingNext(this.date)) {
            DateSelectionModel dateSelectionModel = this.month.getDateSelectionModel();
            if (dateSelectionModel.isDateSelected(this.date)) {
                this.setForeground(this.month.getTitleForeground());
                this.paintSelected(graphics);
            }
            if (this.month.getMonthModel().isToday(this.date)) {
                this.paintToday(graphics);
            }
            graphics.setColor(this.getForeground());
            FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
            int n = fontMetrics.stringWidth(this.getText());
            graphics.drawString(this.getText(), (this.getWidth() - n) / 2, (this.getHeight() - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
            if (!dateSelectionModel.isDateSelectable(this.date)) {
                this.paintDisabled(graphics);
            }
        }
        graphics.setColor(color);
    }

    protected void paintSelected(Graphics graphics) {
        graphics.setColor(this.month.getTitleBackground());
        graphics.fillOval(1, 1, this.getWidth() - 1, this.getHeight() - 1);
    }

    protected void paintToday(Graphics graphics) {
        graphics.setColor(Color.red);
        graphics.drawOval(1, 1, this.getWidth() - 2, this.getHeight() - 2);
    }

    protected void paintDisabled(Graphics graphics) {
        graphics.setColor(Color.red);
        graphics.drawLine(3, 3, this.getWidth() - 3, this.getHeight() - 3);
        graphics.drawLine(this.getWidth() - 3, 3, 3, this.getHeight() - 3);
    }
}

