/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.printj2;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.StringTokenizer;
import prospektservice.PSAuftrag;
import prospektservice.PSEnvironment;
import prospektservice.printj2.PrintableObject;

public class PrintVH
extends PrintableObject {
    private static final int MAX_ROWS_VH = 66;
    private String pageData;
    private int numPages;
    private static boolean flgDruckVariableAngaben;
    private static boolean isDruckOhneGrafik;
    private static boolean flgDruckStapel;

    public PrintVH(String data) {
        this.pageData = data;
    }

    @Override
    public int print(Graphics g, PageFormat pf, int actPage) throws PrinterException {
        int Seite = 0;
        g.translate(20, 20);
        StringTokenizer tmain = new StringTokenizer(this.pageData, "+");
        Seite = PSEnvironment.getIntValue(tmain.nextToken());
        int vh_maxparse = tmain.countTokens();
        if (vh_maxparse > 0) {
            this.Formular_V(g, 0, false, tmain.nextToken(), this.printModus);
        }
        if (vh_maxparse > 1) {
            this.Formular_V(g, 1, false, tmain.nextToken(), this.printModus);
        }
        g.setFont(Arial6);
        if (Seite > 0 && this.printModus == 0) {
            String tmp = "- " + String.valueOf(Seite) + " -";
            int w = this.getFontWidth(tmp, g);
            g.drawString(tmp, 276 - w / 2, 766);
        }
        g.dispose();
        return 0;
    }

    private void Formular_V(Graphics g, int position, boolean einzelprint, String value, int printmodus) {
        int OffSet = 0;
        StringTokenizer t = new StringTokenizer(value, "|");
        int vh_maxzeile = (t.countTokens() - 7) / 2;
        g.setColor(Color.black);
        if (position == 1) {
            OffSet = 395;
        }
        if (!flgDruckVariableAngaben && position == 0) {
            if (!isDruckOhneGrafik) {
                this.drawImage(5, 10 + OffSet, 30, 353, "images/rleft.bmp", g);
                this.drawImage(35, 340 + OffSet, 475, 23, "images/rdown.bmp", g);
                this.drawImage(510, 10 + OffSet, 30, 353, "images/rright.bmp", g);
            }
            g.drawLine(40, 69 + OffSet, 225, 69 + OffSet);
            g.drawRect(35, 80 + OffSet, 472, 30);
            g.drawLine(35, 127 + OffSet, 507, 127 + OffSet);
            g.drawLine(90, 115 + OffSet, 90, 730 + OffSet);
            if (vh_maxzeile > 66) {
                g.drawLine(340, 115 + OffSet, 340, 735 + OffSet);
                g.setFont(Arial8);
                g.drawString("PLZ-Bereich", 290, 125 + OffSet);
                g.drawString("Ort-Ortsteil [St\u00fcck]", 385, 125 + OffSet);
            }
            g.setFont(Arial12);
            g.drawString("Verteilhinweis f\u00fcr POSTAKTUELL", 40, 25 + OffSet);
            g.setFont(Arial6);
            g.drawString("Bearbeitungs-", 280, 20 + OffSet);
            g.drawString("Nr:", 280, 27 + OffSet);
            g.drawString("lfd.", 370, 20 + OffSet);
            g.drawString("Nr:", 370, 27 + OffSet);
            g.drawString("Blatt", 430, 20 + OffSet);
            g.drawString("(Postleitzahl)", 40, 76 + OffSet);
            g.drawString("Verteilstelle", 100, 76 + OffSet);
            this.drawVersionAndCopyright(g, 350, OffSet + 766);
            g.setFont(Arial8);
            g.drawString("Diesen Verteilhinweis in die Sendung einlegen !!  Die Verteilung erfolgt beim Zustellst\u00fctzpunkt", 100, 94 + OffSet);
            g.drawString("nach untenstehenden Angaben mit Hilfe der Verteilkarte f\u00fcr POSTAKTUELL Sendungen.", 100, 104 + OffSet);
            g.drawString("PLZ-Bereich", 40, 125 + OffSet);
            g.drawString("Ort-Ortsteil [St\u00fcck]", 135, 125 + OffSet);
            if (!isDruckOhneGrafik) {
                this.drawImage(50, 81 + OffSet, 28, 28, "images/hand.bmp", g);
            }
        }
        if (printmodus < 4 && position == 0) {
            g.setFont(Arial9);
            g.drawString(t.nextToken(), 330, 25 + OffSet);
            g.drawString(t.nextToken(), 390, 25 + OffSet);
            g.drawString(t.nextToken(), 450, 25 + OffSet);
            g.drawString(t.nextToken(), 40, 40 + OffSet);
            g.setFont(Arial10);
            g.drawString(t.nextToken(), 40, 66 + OffSet);
            g.setFont(Arial9);
            g.drawString("nach", 40, 53 + OffSet);
            g.drawString("St\u00fcckzahl insgesamt", 250, 48 + OffSet);
            g.drawString("f\u00fcr diese Verteilstelle:", 250, 57 + OffSet);
            g.drawString("Aktionsbezeichnung:", 250, 70 + OffSet);
            g.drawString(PSAuftrag.getJobName(), 350, 70 + OffSet);
            g.setFont(Arial12);
            g.drawString(t.nextToken(), 355, 57 + OffSet);
            g.setFont(Arial8);
            if (t.hasMoreTokens()) {
                String tmp = t.nextToken();
                if (!tmp.equals(" ")) {
                    g.drawString("abgerundet um:", 275, 75 + OffSet);
                    g.drawString(tmp, 360, 75 + OffSet);
                }
                int x1 = 40;
                int x2 = 95;
                int i = 1;
                while (i <= vh_maxzeile) {
                    g.setFont(Arial8);
                    int hFactor = i <= 66 ? i : i - 66;
                    g.drawString(t.nextToken(), x1, 140 + OffSet + (hFactor - 1) * 9);
                    String ortsteil = t.nextToken();
                    int width = this.getFontWidth(ortsteil, g);
                    if (width >= 195) {
                        this.setRightFontSize(g, ortsteil, 195, 0);
                    }
                    g.drawString(ortsteil, x2, 140 + OffSet + (hFactor - 1) * 9);
                    if (i == 66) {
                        x1 += 250;
                        x2 += 250;
                    }
                    ++i;
                }
            }
            if (t.hasMoreTokens()) {
                this.drawImage(5, 10 + OffSet, 30, 30, "images/mark.bmp", g);
                g.setFont(Arial12);
                g.drawString(t.nextToken(), 22, 34 + OffSet);
            }
        }
    }

    public static boolean isFlgDruckVariableAngaben() {
        return flgDruckVariableAngaben;
    }

    public static void setFlgDruckVariableAngaben(boolean flgDruckVariableAngaben) {
        PrintVH.flgDruckVariableAngaben = flgDruckVariableAngaben;
    }

    public static boolean isDruckOhneGrafik() {
        return isDruckOhneGrafik;
    }

    public static void setDruckOhneGrafik(boolean isDruckOhneGrafik) {
        PrintVH.isDruckOhneGrafik = isDruckOhneGrafik;
    }

    public static boolean isFlgDruckStapel() {
        return flgDruckStapel;
    }

    public static void setFlgDruckStapel(boolean flgDruckStapel) {
        PrintVH.flgDruckStapel = flgDruckStapel;
    }
}

