/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.printj2;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import prospektservice.PSAuftrag;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.printj2.PDFPrinterGraphics;
import prospektservice.printj2.PrintableObject;

public class PrintPaletteStorage
extends PrintableObject {
    private static final int MIN_PALETTE_CNT = 30;
    private String pageData;
    private int ArtFormular;
    private static double storagePrice;

    public PrintPaletteStorage(String data, int type) {
        this.pageData = data;
        this.ArtFormular = type;
    }

    @Override
    public int print(Graphics g, PageFormat pf, int actPage) throws PrinterException {
        try {
            PDFPrinterGraphics ppg;
            Graphics2D g2d = null;
            if (!(g instanceof PDFPrinterGraphics)) {
                g2d = (Graphics2D)g;
            }
            g.translate(20, 20);
            if (this.ArtFormular == 18) {
                return this.printBundlePlan(g, pf, actPage);
            }
            if (this.ArtFormular == 19) {
                return this.printAGB(g, pf, actPage);
            }
            g.setColor(Color.black);
            g.setFont(Arial12);
            this.drawCondensedString("Auftrag Palettenlagerung DIALOGPOST, POSTAKTUELL, POSTWURFSPEZIAL", 25, 4, 0.75f, 1.0f, g, Arial12);
            this.drawCondensedString("Bitte 7 Werktage vor Abholung der Paletten beim ELN-Depot anmelden!", 25, 13, 0.75f, 1.0f, g, Arial8);
            g.drawLine(25, 28, 359, 28);
            g.setFont(Arial8n);
            this.drawImage(395, -18, 140, 30, "images/dpostbw.bmp", g);
            g.drawLine(495, 31, 495, 47);
            g.drawLine(510, 39, 510, 47);
            g.drawLine(525, 39, 525, 47);
            g.drawLine(540, 31, 540, 47);
            g.drawLine(25, 31, 25, 47);
            g.drawLine(40, 39, 40, 47);
            g.drawLine(55, 39, 55, 47);
            g.drawLine(70, 39, 70, 47);
            g.drawLine(85, 39, 85, 47);
            g.drawLine(100, 39, 100, 47);
            g.drawLine(115, 39, 115, 47);
            g.drawLine(130, 39, 130, 47);
            g.drawLine(145, 39, 145, 47);
            g.drawLine(160, 39, 160, 47);
            g.drawLine(175, 39, 175, 47);
            g.drawLine(190, 39, 190, 47);
            g.drawLine(205, 39, 205, 47);
            g.drawLine(220, 39, 220, 47);
            g.drawLine(235, 39, 235, 47);
            g.drawLine(250, 39, 250, 47);
            g.drawLine(265, 39, 265, 47);
            g.drawLine(280, 39, 280, 47);
            g.drawLine(295, 39, 295, 47);
            g.drawLine(310, 39, 310, 47);
            g.drawLine(325, 39, 325, 47);
            g.drawLine(340, 39, 340, 47);
            g.drawLine(355, 39, 355, 47);
            g.drawLine(370, 39, 370, 47);
            g.drawLine(385, 39, 385, 47);
            g.drawLine(400, 39, 400, 47);
            g.drawLine(415, 31, 415, 47);
            g.setFont(Arial5.deriveFont(0));
            g.drawString("Zust\u00e4ndiges ELN-Depot, Telefonnummer, Faxnummer und E-Mail", 135, 34);
            g.drawString("Auftragsnummer", 26, 34);
            g.setFont(Arial6.deriveFont(0));
            int xWidth = this.getFontWidth("Leistungserbringende", g);
            g.drawString("Leistungserbringende", 540 - xWidth, 18);
            xWidth = this.getFontWidth("NiederLassung", g);
            g.drawString("NiederLassung", 540 - xWidth, 25);
            g.setFont(Arial9);
            Color fill = new Color(210, 210, 210);
            g.fillRect(25, 47, 515, 13);
            g.setFont(Arial9);
            g.setColor(Color.white);
            this.drawCondensedString("Angaben zum Kunden", 27, 57, 0.75f, 1.0f, g, Arial9);
            String pageDesc = "Blatt";
            int xHeader = 460;
            if (this.ArtFormular == 15) {
                pageDesc = String.valueOf(pageDesc) + " 1 f\u00fcr DPAG, SNL IT PeP, SG 7120, 30136 Hannover";
                xHeader = 355;
            } else if (this.ArtFormular == 16) {
                pageDesc = String.valueOf(pageDesc) + " 2 f\u00fcr ELN Depot";
                xHeader = 325;
            } else if (this.ArtFormular == 17) {
                pageDesc = String.valueOf(pageDesc) + " 3 f\u00fcr den Kunden";
            }
            this.drawCondensedString(pageDesc, xHeader, 57, 0.75f, 1.0f, g, Arial9);
            if (this.ArtFormular == 16) {
                int xtra = (int)((double)this.getFontWidth("Blatt  2 f\u00fcr ELN Depot", g) * 0.75);
                this.drawCondensedString(" (nach Abgleich an DPAG, SNL IT PeP, SG 7120, 30136 Hannover)", 325 + xtra, 57, 0.75f, 1.0f, g, Arial6);
            }
            g.setColor(Color.black);
            g.setFont(Arial8);
            String tmp = "Absender";
            int w = this.getFontWidth(tmp, g);
            g.drawString(tmp, 27, 69);
            g.setFont(Arial5);
            g.setFont(Arial8n);
            g.drawString("Kunden-/POSTCARD-Nummer", 27, 77);
            g.drawString("Name und Anschrift", 263, 67);
            g.drawString("Zahlung durch", 185, 77);
            g.drawString("Absender", 185, 85);
            g.setFont(Arial8);
            g.drawString("Einlieferer", 27, 106);
            g.setFont(Arial8n);
            g.drawString("Kunden-/POSTCARD-Nummer", 27, 114);
            g.drawString("Name und Anschrift", 263, 103);
            g.drawString("Zahlung durch", 185, 106);
            g.drawString("Einlieferer", 185, 114);
            g.drawLine(25, 96, 261, 96);
            g.drawLine(25, 129, 261, 129);
            g.drawLine(261, 83, 540, 83);
            g.drawLine(261, 96, 540, 96);
            g.drawLine(261, 116, 540, 116);
            g.drawLine(261, 129, 540, 129);
            g.drawRect(170, 71, 13, 13);
            g.drawRect(170, 100, 13, 13);
            int i = 0;
            while (i < 17) {
                if (i == 16) {
                    g.drawLine(37 + i * 14, 60, 37 + i * 14, 96);
                    g.drawLine(37 + i * 14, 96, 37 + i * 14, 129);
                    g.drawLine(37 + i * 14, 129, 37 + i * 14, 161);
                } else {
                    g.drawLine(37 + i * 14, 89, 37 + i * 14, 96);
                    g.drawLine(37 + i * 14, 122, 37 + i * 14, 129);
                    g.drawLine(37 + i * 14, 154, 37 + i * 14, 161);
                }
                ++i;
            }
            int diff = 3;
            g.setFont(Arial8);
            g.drawString("Abweichender Zahlungspflichtiger", 27, 137);
            g.setFont(Arial8n);
            g.drawString("Kunden-/POSTCARD-Nummer", 27, 145);
            g.drawLine(25, 164 - diff, 540, 164 - diff);
            g.drawString("Zahlung durch", 185, 139);
            g.drawString("Zahlungspflichtigen", 185, 147);
            g.drawRect(170, 133, 13, 13);
            g.setFont(Arial8n);
            g.drawString("Telefonnummer des Absenders f\u00fcr R\u00fcckfragen", 27, 169);
            g.drawString("Telefonnummer des Einlieferers f\u00fcr R\u00fcckfragen", 263, 169);
            g.setFont(Arial8n);
            diff = -22;
            g.setFont(Arial8n);
            g.drawString("Name und Anschrift", 263, 136);
            g.drawLine(261, 148, 540, 148);
            g.drawLine(261, 135, 261, 182);
            int yOff = 46;
            g.fillRect(25, 229 - yOff, 515, 13);
            g.setFont(Arial9);
            g.setColor(Color.white);
            this.drawCondensedString("Angaben zum Produkt", 27, 239 - yOff, 0.75f, 1.0f, g, Arial9);
            g.setColor(Color.black);
            g.setFont(Arial8n);
            g.drawString("Produkt", 27, 256 - yOff);
            g.drawRect(102, 248 - yOff, 10, 10);
            g.drawString("DIALOGPOST", 116, 256 - yOff);
            g.drawRect(176, 248 - yOff, 10, 10);
            g.drawString("POSTAKTUELL", 190, 256 - yOff);
            g.drawRect(255, 248 - yOff, 10, 10);
            g.drawString("POSTWURFSPEZIAL", 269, 256 - yOff);
            g.drawString("Gesamtgewicht in kg", 27, 275 - yOff);
            g.drawRect(102, 264 - yOff, 75, 16);
            g.drawString("Aktionsbezeichnung", 179, 275 - yOff);
            g.drawRect(255, 264 - yOff, 280, 16);
            g.drawString("Anzahl Paletten", 27, 294 - yOff);
            g.drawRect(102, 283 - yOff, 75, 16);
            g.drawString("+ ggf. aufgezahlte Paletten", 187, 294 - yOff);
            g.drawRect(290, 283 - yOff, 60, 16);
            g.drawString("= Summe Paletten", 370, 294 - yOff);
            g.drawRect(460, 283 - yOff, 75, 16);
            g.drawLine(25, 302 - yOff, 540, 302 - yOff);
            g.setFont(Arial8);
            g.drawString("Lagerung", 27, 316 - yOff);
            int xOffset = this.getFontWidth("Lagerung ", g);
            g.setFont(Arial8n);
            g.drawString("vom Abholdatum (mo.-fr.)", 27 + xOffset, 316 - yOff);
            g.drawLine(162, 321 - yOff, 252, 321 - yOff);
            g.drawLine(162, 306 - yOff, 162, 321 - yOff);
            g.drawLine(177, 313 - yOff, 177, 321 - yOff);
            g.drawLine(192, 306 - yOff, 192, 321 - yOff);
            g.drawLine(207, 313 - yOff, 207, 321 - yOff);
            g.drawLine(222, 306 - yOff, 222, 321 - yOff);
            g.drawLine(237, 313 - yOff, 237, 321 - yOff);
            g.drawLine(252, 306 - yOff, 252, 321 - yOff);
            g.drawString("Auslagerungsdatum", 269, 316 - yOff);
            g.drawLine(352, 321 - yOff, 442, 321 - yOff);
            g.drawLine(352, 306 - yOff, 352, 321 - yOff);
            g.drawLine(367, 313 - yOff, 367, 321 - yOff);
            g.drawLine(382, 306 - yOff, 382, 321 - yOff);
            g.drawLine(397, 313 - yOff, 397, 321 - yOff);
            g.drawLine(412, 306 - yOff, 412, 321 - yOff);
            g.drawLine(427, 313 - yOff, 427, 321 - yOff);
            g.drawLine(442, 306 - yOff, 442, 321 - yOff);
            g.drawString("=", 445, 316 - yOff);
            g.drawRect(460, 306 - yOff, 50, 16);
            g.drawString("Tage", 512, 316 - yOff);
            g.fillRect(25, 324 - yOff, 515, 13);
            g.setFont(Arial9);
            if (this.ArtFormular != 17) {
                g.setColor(Color.lightGray);
                g.fillRect(26, 338 - yOff, 515, 160);
            }
            g.setColor(Color.white);
            this.drawCondensedString("Angaben zur Abrechnung", 27, 334 - yOff, 0.75f, 1.0f, g, Arial9);
            g.fillRect(26, 338 - yOff, 257, 130);
            g.setColor(Color.black);
            if (this.ArtFormular != 17) {
                g.drawLine(283, 338 - yOff, 283, 468 - yOff);
                g.drawLine(26, 468 - yOff, 283, 468 - yOff);
            }
            g.setFont(Arial8);
            g.drawString("Berechnung des Lagerentgelts (\u20ac)", 27, 351 - yOff);
            if (this.ArtFormular != 17) {
                g.drawString("Von der Deutschen Post zur Abrechnung auszuf\u00fcllen", 289, 351 - yOff);
            }
            g.setFont(Arial8n);
            g.drawString("(Lagerentgelt pro Palette " + PSEnvironment.Format(storagePrice, "#,###,##0.00") + " \u20ac zzgl. gesetzl. USt. je 30 Tage)", 27, 360 - yOff);
            g.drawRect(27, 364 - yOff, 65, 16);
            g.drawString("x", 93, 374 - yOff);
            g.drawRect(98, 364 - yOff, 65, 16);
            g.drawString("=", 164, 374 - yOff);
            g.drawLine(170, 380 - yOff, 243, 380 - yOff);
            g.drawLine(170, 364 - yOff, 170, 380 - yOff);
            g.drawLine(185, 372 - yOff, 185, 380 - yOff);
            g.drawLine(200, 372 - yOff, 200, 380 - yOff);
            g.drawLine(215, 372 - yOff, 215, 380 - yOff);
            g.drawLine(230, 372 - yOff, 230, 380 - yOff);
            g.drawLine(245, 364 - yOff, 245, 378 - yOff);
            g.setFont(Arial10n);
            g.drawString(",", 244, 380 - yOff);
            g.drawLine(247, 380 - yOff, 275, 380 - yOff);
            g.drawLine(260, 372 - yOff, 260, 380 - yOff);
            g.drawLine(275, 364 - yOff, 275, 380 - yOff);
            g.setFont(Arial7.deriveFont(0));
            g.drawString("Summe Paletten", 32, 389 - yOff);
            g.drawString("Lagerentgelt / Palette", 98, 389 - yOff);
            g.drawString("(lagerdauerabh\u00e4ngig)", 98, 398 - yOff);
            g.drawString("Grundentgelt", 200, 389 - yOff);
            g.drawString("Zzgl. gesetzl. USt.", 27, 429 - yOff);
            g.drawString("=", 164, 429 - yOff);
            g.drawLine(170, 435 - yOff, 243, 435 - yOff);
            g.drawLine(170, 419 - yOff, 170, 435 - yOff);
            g.drawLine(185, 427 - yOff, 185, 435 - yOff);
            g.drawLine(200, 427 - yOff, 200, 435 - yOff);
            g.drawLine(215, 427 - yOff, 215, 435 - yOff);
            g.drawLine(230, 427 - yOff, 230, 435 - yOff);
            g.drawLine(245, 419 - yOff, 245, 433 - yOff);
            g.setFont(Arial10n);
            g.drawString(",", 244, 435 - yOff);
            g.drawLine(247, 435 - yOff, 275, 435 - yOff);
            g.drawLine(260, 427 - yOff, 260, 435 - yOff);
            g.drawLine(275, 419 - yOff, 275, 435 - yOff);
            g.setFont(Arial8n);
            g.drawString("Zu zahlender Betrag", 27, 457 - yOff);
            g.drawString("=", 164, 457 - yOff);
            g.drawLine(170, 463 - yOff, 243, 463 - yOff);
            g.drawLine(170, 447 - yOff, 170, 463 - yOff);
            g.drawLine(185, 454 - yOff, 185, 463 - yOff);
            g.drawLine(200, 454 - yOff, 200, 463 - yOff);
            g.drawLine(215, 454 - yOff, 215, 463 - yOff);
            g.drawLine(230, 454 - yOff, 230, 463 - yOff);
            g.drawLine(245, 447 - yOff, 245, 461 - yOff);
            g.setFont(Arial10n);
            g.drawString(",", 244, 463 - yOff);
            g.drawLine(247, 463 - yOff, 275, 463 - yOff);
            g.drawLine(260, 454 - yOff, 260, 463 - yOff);
            g.drawLine(275, 447 - yOff, 275, 463 - yOff);
            if (this.ArtFormular != 17) {
                int leftSideOff = 258;
                g.drawRect(27 + leftSideOff, 364 - yOff, 65, 16);
                g.drawString("x", 93 + leftSideOff, 374 - yOff);
                g.drawRect(98 + leftSideOff, 364 - yOff, 65, 16);
                g.drawString("=", 164 + leftSideOff, 374 - yOff);
                g.drawLine(170 + leftSideOff, 380 - yOff, 243 + leftSideOff, 380 - yOff);
                g.drawLine(170 + leftSideOff, 364 - yOff, 170 + leftSideOff, 380 - yOff);
                g.drawLine(185 + leftSideOff, 372 - yOff, 185 + leftSideOff, 380 - yOff);
                g.drawLine(200 + leftSideOff, 372 - yOff, 200 + leftSideOff, 380 - yOff);
                g.drawLine(215 + leftSideOff, 372 - yOff, 215 + leftSideOff, 380 - yOff);
                g.drawLine(230 + leftSideOff, 372 - yOff, 230 + leftSideOff, 380 - yOff);
                g.drawLine(245 + leftSideOff, 364 - yOff, 245 + leftSideOff, 378 - yOff);
                g.setFont(Arial10n);
                g.drawString(",", 244 + leftSideOff, 380 - yOff);
                g.drawLine(247 + leftSideOff, 380 - yOff, 275 + leftSideOff, 380 - yOff);
                g.drawLine(260 + leftSideOff, 372 - yOff, 260 + leftSideOff, 380 - yOff);
                g.drawLine(275 + leftSideOff, 364 - yOff, 275 + leftSideOff, 380 - yOff);
                g.setFont(Arial7.deriveFont(0));
                g.drawString("Summe Paletten", 32 + leftSideOff, 389 - yOff);
                g.drawString("Lagerentgelt / Palette", 98 + leftSideOff, 389 - yOff);
                g.drawString("Grundentgelt", 200 + leftSideOff, 389 - yOff);
                g.drawRect(27 + leftSideOff, 391 - yOff, 65, 16);
                g.drawString("x", 108 + leftSideOff, 401 - yOff);
                g.drawString("1,02 \u20ac", 128 + leftSideOff, 401 - yOff);
                g.drawString("=", 164 + leftSideOff, 401 - yOff);
                g.drawLine(170 + leftSideOff, 407 - yOff, 243 + leftSideOff, 407 - yOff);
                g.drawLine(170 + leftSideOff, 391 - yOff, 170 + leftSideOff, 407 - yOff);
                g.drawLine(185 + leftSideOff, 399 - yOff, 185 + leftSideOff, 407 - yOff);
                g.drawLine(200 + leftSideOff, 399 - yOff, 200 + leftSideOff, 407 - yOff);
                g.drawLine(215 + leftSideOff, 399 - yOff, 215 + leftSideOff, 407 - yOff);
                g.drawLine(230 + leftSideOff, 399 - yOff, 230 + leftSideOff, 407 - yOff);
                g.drawLine(245 + leftSideOff, 391 - yOff, 245 + leftSideOff, 405 - yOff);
                g.setFont(Arial10n);
                g.drawString(",", 244 + leftSideOff, 407 - yOff);
                g.drawLine(247 + leftSideOff, 407 - yOff, 275 + leftSideOff, 407 - yOff);
                g.drawLine(260 + leftSideOff, 399 - yOff, 260 + leftSideOff, 407 - yOff);
                g.drawLine(275 + leftSideOff, 391 - yOff, 275 + leftSideOff, 407 - yOff);
                g.setFont(Arial5n);
                g.drawString("Bereithaltungsentgelt f\u00fcr avisierte, aber nicht gelieferte Paletten", 27 + leftSideOff, 412 - yOff);
                g.setFont(Arial8n);
                g.drawString("Zzgl. gesetzl. USt.", 27 + leftSideOff, 429 - yOff);
                g.drawString("=", 164 + leftSideOff, 429 - yOff);
                g.drawLine(170 + leftSideOff, 435 - yOff, 243 + leftSideOff, 435 - yOff);
                g.drawLine(170 + leftSideOff, 419 - yOff, 170 + leftSideOff, 435 - yOff);
                g.drawLine(185 + leftSideOff, 427 - yOff, 185 + leftSideOff, 435 - yOff);
                g.drawLine(200 + leftSideOff, 427 - yOff, 200 + leftSideOff, 435 - yOff);
                g.drawLine(215 + leftSideOff, 427 - yOff, 215 + leftSideOff, 435 - yOff);
                g.drawLine(230 + leftSideOff, 427 - yOff, 230 + leftSideOff, 435 - yOff);
                g.drawLine(245 + leftSideOff, 419 - yOff, 245 + leftSideOff, 433 - yOff);
                g.setFont(Arial10n);
                g.drawString(",", 244 + leftSideOff, 435 - yOff);
                g.drawLine(247 + leftSideOff, 435 - yOff, 275 + leftSideOff, 435 - yOff);
                g.drawLine(260 + leftSideOff, 427 - yOff, 260 + leftSideOff, 435 - yOff);
                g.drawLine(275 + leftSideOff, 419 - yOff, 275 + leftSideOff, 435 - yOff);
                g.setFont(Arial8n);
                g.drawString("Zu zahlender Betrag", 27 + leftSideOff, 457 - yOff);
                g.drawString("=", 164 + leftSideOff, 457 - yOff);
                g.drawLine(170 + leftSideOff, 463 - yOff, 243 + leftSideOff, 463 - yOff);
                g.drawLine(170 + leftSideOff, 447 - yOff, 170 + leftSideOff, 463 - yOff);
                g.drawLine(185 + leftSideOff, 454 - yOff, 185 + leftSideOff, 463 - yOff);
                g.drawLine(200 + leftSideOff, 454 - yOff, 200 + leftSideOff, 463 - yOff);
                g.drawLine(215 + leftSideOff, 454 - yOff, 215 + leftSideOff, 463 - yOff);
                g.drawLine(230 + leftSideOff, 454 - yOff, 230 + leftSideOff, 463 - yOff);
                g.drawLine(245 + leftSideOff, 447 - yOff, 245 + leftSideOff, 461 - yOff);
                g.setFont(Arial10n);
                g.drawString(",", 244 + leftSideOff, 463 - yOff);
                g.drawLine(247 + leftSideOff, 463 - yOff, 275 + leftSideOff, 463 - yOff);
                g.drawLine(260 + leftSideOff, 454 - yOff, 260 + leftSideOff, 463 - yOff);
                g.drawLine(275 + leftSideOff, 447 - yOff, 275 + leftSideOff, 463 - yOff);
                g.setFont(Arial8n);
                g.drawString("Abrechnung vorgenommen:", 27, 485 - yOff);
                g.drawLine(128, 485 - yOff, leftSideOff + 20, 485 - yOff);
                g.drawLine(29 + leftSideOff, 485 - yOff, leftSideOff + 137, 485 - yOff);
                g.drawLine(141 + leftSideOff, 485 - yOff, leftSideOff + 270, 485 - yOff);
                g.setFont(Arial5n);
                g.drawString("Datum/Stelle", 188, 492 - yOff);
                g.drawString("Name des pr\u00fcfenden Mitarbeiters", 46 + leftSideOff, 492 - yOff);
                g.drawString("Unterschrift der Pr\u00fcfkraft", leftSideOff + 176, 492 - yOff);
            }
            g.setFont(Arial8n);
            g.setColor(Color.black);
            g.fillRect(25, 520 - (yOff += 23), 515, 13);
            g.setFont(Arial9);
            g.setColor(Color.white);
            this.drawCondensedString("Angaben zur Bezahlung", 27, 530 - yOff, 0.75f, 1.0f, g, Arial9);
            this.drawCondensedString("Angaben zum Konto", 290, 530 - yOff, 0.75f, 1.0f, g, Arial9);
            g.setFont(Arial8n.deriveFont(5.0f));
            g.drawString("(Bitte nur angeben, wenn keine POSTCARD genutzt wird)", 360, 529 - yOff);
            g.drawLine(417, 530 - yOff, 429, 530 - yOff);
            g.setColor(Color.black);
            g.setFont(Arial6n);
            g.drawString("IBAN des Zahlungspflichtigen", 290, 540 - yOff);
            g.drawString("BIC des Zahlungspflichtigen", 290, 565 - yOff);
            if (g instanceof PDFPrinterGraphics) {
                ppg = (PDFPrinterGraphics)g;
                ppg.setLineWidth(0.5f);
                ppg.setLineDash(4.0f, 1.0f, 0.5f);
            } else {
                float[] dash = new float[]{4.0f, 1.0f};
                g2d.setStroke(new BasicStroke(0.5f, 0, 0, 10.0f, dash, 0.5f));
            }
            g.drawRect(290, 542 - yOff, 238, 12);
            g.drawRect(290, 567 - yOff, 77, 12);
            if (g instanceof PDFPrinterGraphics) {
                ppg = (PDFPrinterGraphics)g;
                ppg.setLineDash(1.0f, 0.0f, 0.0f);
            } else {
                g2d.setStroke(new BasicStroke(0.5f));
            }
            int lineOff = 7;
            int i2 = 1;
            while (i2 < 34) {
                g.drawLine(290 + i2 * lineOff, 543 - yOff, 290 + i2 * lineOff, 553 - yOff);
                ++i2;
            }
            i2 = 1;
            while (i2 < 11) {
                g.drawLine(290 + i2 * lineOff, 568 - yOff, 290 + i2 * lineOff, 578 - yOff);
                ++i2;
            }
            if (g instanceof PDFPrinterGraphics) {
                PDFPrinterGraphics ppg2 = (PDFPrinterGraphics)g;
                ppg2.setLineWidth(1.0f);
            } else {
                g2d.setStroke(new BasicStroke(1.0f));
            }
            g.drawString("Kreditinstitut", 385, 565 - yOff);
            g.drawLine(385, 579 - yOff, 528, 579 - yOff);
            g.setFont(Arial6n.deriveFont(5.0f));
            g.drawString("Bei Abweichungen erstattet die Deutsche Post AG zu viel gezahlte Entgelte durch \u00dcberweisung auf das hier", 290, 585 - yOff);
            g.drawString("angegebene Konto. Bei Nachforderungen kontaktiert die Deutsche Post AG den Zahlungspflichtigen, um", 290, 591 - yOff);
            g.drawString("von ihm ein schriftliches SEPA-Lastschriftmandat zu erhalten.", 290, 597 - yOff);
            g.setFont(Arial8n);
            String agb = "01.20  912-106-400";
            if (g2d != null) {
                AffineTransform afOld = g2d.getTransform();
                AffineTransform af = new AffineTransform(afOld);
                af.rotate(Math.toRadians(270.0), pf.getWidth() / 2.0, pf.getHeight() / 2.0);
                g2d.setTransform(af);
                g2d.setFont(Arial10n);
                g2d.drawString(agb, (int)(pf.getWidth() / 2.0) - 344, (int)(pf.getHeight() / 2.0) - 278);
                g2d.setTransform(afOld);
            } else {
                PDFPrinterGraphics gPdf = (PDFPrinterGraphics)g;
                gPdf.setFont(Arial10n);
                gPdf.drawAngledString(agb, 20, 765, 90.0f);
            }
            g.setFont(Arial5n);
            tmp = "Der Einlieferer ist zum Abschlu\u00df des Bef\u00f6rderungsvertrags im Namen des Absenders bevollm\u00e4chtigt.";
            g.drawString(tmp, 27, 474);
            tmp = "Es gelten die anh\u00e4ngigen Allgemeinen Gesch\u00e4ftsbedingungen der Deutschen Post AG f\u00fcr die Bef\u00f6rderung und";
            g.drawString(tmp, 27, 486);
            tmp = "Lagerung von DIALOGPOST, POSTAKTUELL, POSTWURFSPEZIAL.";
            g.drawString(tmp, 27, 492);
            g.drawLine(35, 755, 150, 755);
            g.drawString("Unterschrift des Absenders/Einlieferers", 40, 762);
            g.drawLine(170, 755, 230, 755);
            g.drawString("Datum", 190, 762);
            g.setColor(Color.lightGray);
            g.fillRect(289, 540, 251, 225);
            g.setFont(Arial8n);
            g.setColor(Color.black);
            g.drawString("Feld f\u00fcr interne Postvermerke", 295, 550);
            int iLeft = 40;
            int iTop = 550;
            diff = 15;
            g.setColor(Color.black);
            g.drawRect(25, 60, 515, 705);
            g.setFont(Arial5n);
            g.setFont(Arial6n);
            this.drawVersionCopyrightAndLogo(g, 27, 775);
            if (this.printModus < 4) {
                char[] c;
                int i3;
                g.setFont(Arial8n);
                g.drawString(String.valueOf(PSAuftrag.getDepotName()) + ", " + PSAuftrag.getDepotZipTown() + ", " + PSAuftrag.getDepotPhone() + ", " + PSAuftrag.getDepotFax() + ", " + PSAuftrag.getDepotMail(), 27, 26);
                String amId = PSAuftrag.getAMNummer();
                int i4 = 0;
                while (i4 < amId.length()) {
                    g.drawString(amId.substring(i4, i4 + 1), 30 + i4 * 15, 43);
                    ++i4;
                }
                String absenderkdnr = PSAuftrag.absender.KDNR;
                String einliefererkdnr = PSAuftrag.einlieferer.KDNR;
                String absendername = PSAuftrag.absender.Name;
                String absenderergnr = PSAuftrag.absender.ERGNR;
                String einliefererergnr = PSAuftrag.einlieferer.ERGNR;
                String absenderkartennr = PSAuftrag.absender.KARTENNR;
                String einliefererkartennr = PSAuftrag.einlieferer.KARTENNR;
                String einlieferername = PSAuftrag.einlieferer.Name;
                String absenderadresse = "";
                absenderadresse = PSAuftrag.absender.usesPFAddress() ? (PSAuftrag.absender.Land.length() > 0 && !PSAuftrag.absender.Land.equals("D") ? "Postfach " + PSAuftrag.absender.PF + ", " + PSAuftrag.absender.Land + " - " + PSAuftrag.absender.PFPLZ + " " + PSAuftrag.absender.PFOrt : "Postfach " + PSAuftrag.absender.PF + ", " + PSAuftrag.absender.PFPLZ + " " + PSAuftrag.absender.PFOrt) : (PSAuftrag.absender.Land.length() > 0 && !PSAuftrag.absender.Land.equals("D") ? String.valueOf(PSAuftrag.absender.Strasse) + ", " + PSAuftrag.absender.Land + " - " + PSAuftrag.absender.PLZ + " " + PSAuftrag.absender.Ort : String.valueOf(PSAuftrag.absender.Strasse) + ", " + PSAuftrag.absender.PLZ + " " + PSAuftrag.absender.Ort);
                String einliefereradresse = "";
                einliefereradresse = PSAuftrag.einlieferer.usesPFAddress() ? (PSAuftrag.einlieferer.Land.length() > 0 && !PSAuftrag.einlieferer.Land.equals("D") ? "Postfach " + PSAuftrag.einlieferer.PF + ", " + PSAuftrag.einlieferer.Land + " - " + PSAuftrag.einlieferer.PFPLZ + " " + PSAuftrag.einlieferer.PFOrt : "Postfach " + PSAuftrag.einlieferer.PF + ", " + PSAuftrag.einlieferer.PFPLZ + " " + PSAuftrag.einlieferer.PFOrt) : (PSAuftrag.einlieferer.Land.length() > 0 && !PSAuftrag.einlieferer.Land.equals("D") ? String.valueOf(PSAuftrag.einlieferer.Strasse) + ", " + PSAuftrag.einlieferer.Land + " - " + PSAuftrag.einlieferer.PLZ + " " + PSAuftrag.einlieferer.Ort : String.valueOf(PSAuftrag.einlieferer.Strasse) + ", " + PSAuftrag.einlieferer.PLZ + " " + PSAuftrag.einlieferer.Ort);
                String absendertelefon = PSAuftrag.absender.Telefon;
                String einlieferertelefon = PSAuftrag.einlieferer.Telefon;
                String kontonummer = PSAuftrag.bank.Kontonummer;
                String blz = PSAuftrag.bank.BLZ;
                String kreditinstitut = PSAuftrag.bank.Geldinstitut;
                String kontobezeichnung = PSAuftrag.bank.Kontobezeichnung;
                String abwZahlungspflichtiger = PSAuftrag.zahlungspflichtiger.Name;
                String zahlungspflichtigerKdnr = PSAuftrag.zahlungspflichtiger.KDNR;
                String zahlungspflichtigerErgnr = PSAuftrag.zahlungspflichtiger.ERGNR;
                String zahlungspflichtigerKartenNr = PSAuftrag.zahlungspflichtiger.KARTENNR;
                String zahlungspflichtigerAdresse = "";
                zahlungspflichtigerAdresse = PSAuftrag.zahlungspflichtiger.usesPFAddress() ? (PSAuftrag.zahlungspflichtiger.Land.length() > 0 && !PSAuftrag.zahlungspflichtiger.Land.equals("D") ? "Postfach " + PSAuftrag.zahlungspflichtiger.PF + ", " + PSAuftrag.zahlungspflichtiger.Land + " - " + PSAuftrag.zahlungspflichtiger.PFPLZ + " " + PSAuftrag.zahlungspflichtiger.PFOrt : "Postfach " + PSAuftrag.zahlungspflichtiger.PF + ", " + PSAuftrag.zahlungspflichtiger.PFPLZ + " " + PSAuftrag.zahlungspflichtiger.PFOrt) : (PSAuftrag.zahlungspflichtiger.Land.length() > 0 && !PSAuftrag.zahlungspflichtiger.Land.equals("D") ? String.valueOf(PSAuftrag.zahlungspflichtiger.Strasse) + ", " + PSAuftrag.zahlungspflichtiger.Land + " - " + PSAuftrag.zahlungspflichtiger.PLZ + " " + PSAuftrag.zahlungspflichtiger.Ort : String.valueOf(PSAuftrag.zahlungspflichtiger.Strasse) + ", " + PSAuftrag.zahlungspflichtiger.PLZ + " " + PSAuftrag.zahlungspflichtiger.Ort);
                String zahlungspflichtigerTelefon = PSAuftrag.zahlungspflichtiger.Telefon;
                boolean cb_abs_einl = PSAuftrag.cbformulare.cb_abs_einl;
                int zahlungsart = PSAuftrag.cbformulare.cb_zahlungsart;
                int zahlungspflichtiger = PSAuftrag.cbformulare.cb_zahlungspflichtiger;
                boolean validPostCard = false;
                switch (zahlungspflichtiger) {
                    case 0: {
                        validPostCard = PSAuftrag.absender.ERGNR.length() == 4;
                        break;
                    }
                    case 1: {
                        validPostCard = PSAuftrag.einlieferer.ERGNR.length() == 4;
                        break;
                    }
                    case 2: {
                        validPostCard = PSAuftrag.zahlungspflichtiger.ERGNR.length() == 4;
                    }
                }
                String auftragbezeichnung = PSAuftrag.getJobName();
                g.setFont(Arial8);
                tmp = String.valueOf(absenderkdnr) + this.setLength(absenderergnr, 4, 2) + absenderkartennr;
                int lang = tmp.trim().length();
                if (lang > 0) {
                    i3 = 0;
                    while (i3 <= lang - 1) {
                        if (this.printModus == 5 || this.printModus == 0) {
                            c = new char[]{tmp.charAt(i3)};
                            g.drawChars(c, 0, 1, 29 + i3 * 14, 94);
                        }
                        ++i3;
                    }
                }
                g.setFont(Arial8);
                absendername = this.setRightFontSize(g, absendername, 280, 1);
                g.drawString(absendername, 265, 79);
                g.setFont(Arial8);
                absenderadresse = this.setRightFontSize(g, absenderadresse, 170, 1);
                g.drawString(absenderadresse, 265, 93);
                tmp = String.valueOf(einliefererkdnr) + this.setLength(einliefererergnr, 4, 2) + einliefererkartennr;
                lang = tmp.length();
                if (lang > 0) {
                    i3 = 0;
                    while (i3 <= lang - 1) {
                        if (this.printModus == 5 || this.printModus == 0) {
                            c = new char[]{tmp.charAt(i3)};
                            g.drawChars(c, 0, 1, 29 + i3 * 14, 127);
                        }
                        ++i3;
                    }
                }
                g.setFont(Arial8);
                einlieferername = this.setRightFontSize(g, einlieferername, 280, 1);
                if (!cb_abs_einl) {
                    g.drawString(einlieferername, 265, 113);
                }
                g.setFont(Arial8);
                einliefereradresse = this.setRightFontSize(g, einliefereradresse, 170, 1);
                if (!cb_abs_einl) {
                    g.drawString(einliefereradresse, 265, 126);
                }
                yOff -= 20;
                g.setFont(Arial8);
                diff = 3;
                abwZahlungspflichtiger = this.setRightFontSize(g, abwZahlungspflichtiger, 280, 1);
                if (PSAuftrag.cbformulare.cb_zahlungspflichtiger == 2) {
                    g.drawString(abwZahlungspflichtiger, 265, 146);
                }
                g.setFont(Arial8);
                zahlungspflichtigerAdresse = this.setRightFontSize(g, zahlungspflichtigerAdresse, 170, 1);
                if (PSAuftrag.cbformulare.cb_zahlungspflichtiger == 2) {
                    g.drawString(zahlungspflichtigerAdresse, 265, 158);
                }
                g.setFont(Arial8);
                tmp = String.valueOf(zahlungspflichtigerKdnr) + this.setLength(zahlungspflichtigerErgnr, 4, 2) + zahlungspflichtigerKartenNr;
                lang = tmp.length();
                if (lang > 0 && PSAuftrag.cbformulare.cb_zahlungspflichtiger == 2) {
                    i3 = 0;
                    while (i3 <= lang - 1) {
                        if (this.printModus == 5 || this.printModus == 0) {
                            c = new char[]{tmp.charAt(i3)};
                            g.drawChars(c, 0, 1, 29 + i3 * 14, 159);
                        }
                        ++i3;
                    }
                }
                String telefon = "";
                telefon = zahlungspflichtiger == 2 ? zahlungspflichtigerTelefon : (zahlungspflichtiger == 1 ? einlieferertelefon : absendertelefon);
                g.drawString(telefon, 29, 180);
                if (zahlungspflichtiger == 0) {
                    this.printCheckbox(g, 170, 71, 13);
                }
                if (zahlungspflichtiger == 1) {
                    this.printCheckbox(g, 170, 100, 13);
                }
                if (zahlungspflichtiger == 2) {
                    this.printCheckbox(g, 170, 132, 13);
                }
                this.printCheckbox(g, 176, 202, 10);
                g.setFont(Arial8);
                yOff += 20;
                if (PSAuftrag.cbformulare.cb_zahlungsart == 0 && !validPostCard) {
                    int i5 = 0;
                    while (i5 < PSAuftrag.bank.iban.length()) {
                        g.drawString(PSAuftrag.bank.iban.substring(i5, i5 + 1), 291 + i5 * 7, 549 - yOff);
                        ++i5;
                    }
                    i5 = 0;
                    while (i5 < PSAuftrag.bank.bic.length()) {
                        g.drawString(PSAuftrag.bank.bic.substring(i5, i5 + 1), 291 + i5 * 7, 574 - yOff);
                        ++i5;
                    }
                    g.drawString(PSAuftrag.bank.Geldinstitut, 385, 574 - yOff);
                    g.setFont(Arial8);
                }
                g.drawString(PSEnvironment.Format(PSAuftrag.getPaletteWeight(), "#,###,##0"), 104, 298 - yOff);
                g.drawString(auftragbezeichnung, 257, 298 - yOff);
                int palCnt = PSAuftrag.getPaletteCnt();
                g.drawString("" + palCnt, 104, 317 - yOff);
                if (palCnt < 30) {
                    int restCnt = 30 - palCnt;
                    g.drawString("" + restCnt, 292, 317 - yOff);
                    palCnt = 30;
                }
                g.drawString("" + palCnt, 462, 317 - yOff);
                Date d = PSAuftrag.getCommitalDate();
                SimpleDateFormat sdf = new SimpleDateFormat("ddMMyy");
                String cDate = sdf.format(d);
                int i6 = 0;
                while (i6 < cDate.length()) {
                    g.drawString(cDate.substring(i6, i6 + 1), 166 + i6 * 15, 270);
                    ++i6;
                }
                d = PSAuftrag.getStorageEnd();
                cDate = sdf.format(d);
                i6 = 0;
                while (i6 < cDate.length()) {
                    g.drawString(cDate.substring(i6, i6 + 1), 356 + i6 * 15, 270);
                    ++i6;
                }
                int stDays = this.getStorageDays();
                g.drawString("" + stDays, 462, 270);
                double netCost = this.calcCosts(stDays);
                g.drawString("" + palCnt, 29, 329);
                g.drawString(PSEnvironment.Format(netCost, "###,##0.00"), 100, 329);
                double netto = netCost * (double)palCnt;
                String netMoney = PSEnvironment.Format(netto, "#####0.00");
                int cnt = 0;
                int i7 = netMoney.length() - 1;
                while (i7 >= 0) {
                    if (netMoney.charAt(i7) != ',') {
                        g.drawString(netMoney.substring(i7, i7 + 1), 266 - 15 * cnt, 329);
                        ++cnt;
                    }
                    --i7;
                }
                double mwst = netto / 100.0 * (double)PSEnvironment.getMwstValue();
                String mwstMoney = PSEnvironment.Format(mwst, "#####0.00");
                cnt = 0;
                int i8 = mwstMoney.length() - 1;
                while (i8 >= 0) {
                    if (mwstMoney.charAt(i8) != ',') {
                        g.drawString(mwstMoney.substring(i8, i8 + 1), 266 - 15 * cnt, 383);
                        ++cnt;
                    }
                    --i8;
                }
                double total = netto + mwst;
                String totalMoney = PSEnvironment.Format(total, "#####0.00");
                cnt = 0;
                int i9 = totalMoney.length() - 1;
                while (i9 >= 0) {
                    if (totalMoney.charAt(i9) != ',') {
                        g.drawString(totalMoney.substring(i9, i9 + 1), 266 - 15 * cnt, 411);
                        ++cnt;
                    }
                    --i9;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return 0;
    }

    private int getStorageDays() {
        int result = 0;
        Date d1 = PSAuftrag.getCommitalDate();
        Date d2 = PSAuftrag.getStorageEnd();
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(d1);
        c2.setTime(d2);
        result = PrintPaletteStorage.daysBetween(c2, c1) + 1;
        return result;
    }

    private static int daysBetween(Calendar day1, Calendar day2) {
        Calendar dayOne = (Calendar)day1.clone();
        Calendar dayTwo = (Calendar)day2.clone();
        if (dayOne.get(1) == dayTwo.get(1)) {
            return Math.abs(dayOne.get(6) - dayTwo.get(6));
        }
        if (dayTwo.get(1) > dayOne.get(1)) {
            Calendar temp = dayOne;
            dayOne = dayTwo;
            dayTwo = temp;
        }
        int extraDays = 0;
        int dayOneOriginalYearDays = dayOne.get(6);
        while (dayOne.get(1) > dayTwo.get(1)) {
            dayOne.add(1, -1);
            extraDays += dayOne.getActualMaximum(6);
        }
        return extraDays - dayTwo.get(6) + dayOneOriginalYearDays;
    }

    private double calcCosts(int stDays) {
        double storageDays = stDays;
        double num = Math.ceil(storageDays / 30.0);
        if (num == 0.0) {
            num = 1.0;
        }
        double cost = num * storagePrice;
        return cost;
    }

    private int printBundlePlan(Graphics g, PageFormat pf, int actPage) {
        char[] c;
        int i;
        Graphics2D g2d = null;
        if (!(g instanceof PDFPrinterGraphics)) {
            g2d = (Graphics2D)g;
        }
        g.setColor(Color.black);
        g.setFont(Arial12);
        if (g instanceof PDFPrinterGraphics) {
            PDFPrinterGraphics pdfGraphics = (PDFPrinterGraphics)g;
            pdfGraphics.drawCondensedString("Gebindeplan f\u00fcr die Einlagerung von Paletten bei der Deutschen Post AG", 25, 9, 0.75f, 1.0f);
        } else {
            Font condensedFont = Arial12.deriveFont(AffineTransform.getScaleInstance(0.75, 1.0));
            g.setFont(condensedFont);
            g2d.drawString("Gebindeplan f\u00fcr die Einlagerung von Paletten bei der Deutschen Post AG", 25, 9);
        }
        g.drawLine(25, 28, 359, 28);
        g.setFont(Arial8n);
        g.drawString(String.valueOf(PSAuftrag.getDepotName()) + ", " + PSAuftrag.getDepotZipTown() + ", " + PSAuftrag.getDepotPhone() + ", " + PSAuftrag.getDepotFax() + ", " + PSAuftrag.getDepotMail(), 27, 26);
        this.drawImage(395, -18, 140, 30, "images/dpostbw.bmp", g);
        g.drawLine(25, 31, 25, 47);
        g.drawLine(40, 39, 40, 47);
        g.drawLine(55, 39, 55, 47);
        g.drawLine(70, 39, 70, 47);
        g.drawLine(85, 39, 85, 47);
        g.drawLine(100, 39, 100, 47);
        g.drawLine(115, 39, 115, 47);
        g.drawLine(130, 39, 130, 47);
        g.drawLine(145, 39, 145, 47);
        g.drawLine(160, 39, 160, 47);
        g.drawLine(175, 39, 175, 47);
        g.drawLine(190, 39, 190, 47);
        g.drawLine(205, 39, 205, 47);
        g.drawLine(220, 39, 220, 47);
        g.drawLine(235, 39, 235, 47);
        g.drawLine(250, 39, 250, 47);
        g.drawLine(265, 39, 265, 47);
        g.drawLine(280, 39, 280, 47);
        g.drawLine(295, 39, 295, 47);
        g.drawLine(310, 39, 310, 47);
        g.drawLine(325, 39, 325, 47);
        g.drawLine(340, 39, 340, 47);
        g.drawLine(355, 39, 355, 47);
        g.drawLine(370, 39, 370, 47);
        g.drawLine(385, 39, 385, 47);
        g.drawLine(400, 39, 400, 47);
        g.drawLine(415, 31, 415, 47);
        String amId = PSAuftrag.getAMNummer();
        int i2 = 0;
        while (i2 < amId.length()) {
            g.drawString(amId.substring(i2, i2 + 1), 30 + i2 * 15, 43);
            ++i2;
        }
        g.setFont(Arial5.deriveFont(0));
        g.drawString("Zust\u00e4ndiges ELN-Depot, Telefonnummer, Faxnummer und E-Mail", 135, 34);
        g.drawString("Auftragsnummer", 26, 34);
        g.setFont(Arial9);
        Color fill = new Color(210, 210, 210);
        g.fillRect(25, 47, 515, 13);
        g.setFont(Arial9);
        g.setColor(Color.white);
        this.drawCondensedString("Angaben zum Kunden", 27, 57, 0.75f, 1.0f, g, Arial9);
        g.setColor(Color.black);
        g.setFont(Arial8);
        String tmp = "Absender";
        int w = this.getFontWidth(tmp, g);
        g.drawString(tmp, 27, 69);
        g.setFont(Arial5);
        g.setFont(Arial8n);
        g.drawString("Kunden-/POSTCARD-Nummer", 27, 77);
        g.drawString("Name und Anschrift", 263, 67);
        g.drawString("Zahlung durch", 185, 77);
        g.drawString("Absender", 185, 85);
        g.setFont(Arial8);
        g.drawString("Einlieferer", 27, 106);
        g.setFont(Arial8n);
        g.drawString("Kunden-/POSTCARD-Nummer", 27, 114);
        g.drawString("Name und Anschrift", 263, 103);
        g.drawString("Zahlung durch", 185, 106);
        g.drawString("Einlieferer", 185, 114);
        g.drawLine(25, 96, 261, 96);
        g.drawLine(25, 129, 261, 129);
        g.drawLine(261, 83, 540, 83);
        g.drawLine(261, 96, 540, 96);
        g.drawLine(261, 116, 540, 116);
        g.drawLine(261, 129, 540, 129);
        g.drawLine(261, 129, 261, 151);
        g.drawRect(170, 71, 13, 13);
        g.drawRect(170, 100, 13, 13);
        g.setFont(Arial8);
        g.setFont(Arial8n);
        g.drawString("Telefonnummer des Absenders f\u00fcr R\u00fcckfragen", 27, 137);
        g.drawString("Telefonnummer des Einlieferers f\u00fcr R\u00fcckfragen", 263, 137);
        int i3 = 0;
        while (i3 < 17) {
            if (i3 == 16) {
                g.drawLine(37 + i3 * 14, 60, 37 + i3 * 14, 96);
                g.drawLine(37 + i3 * 14, 96, 37 + i3 * 14, 129);
                g.drawLine(37 + i3 * 14, 151, 37 + i3 * 14, 183);
            } else {
                g.drawLine(37 + i3 * 14, 89, 37 + i3 * 14, 96);
                g.drawLine(37 + i3 * 14, 122, 37 + i3 * 14, 129);
            }
            ++i3;
        }
        int diff = 3;
        g.setFont(Arial8);
        g.drawString("Abholort", 27, 159);
        g.setFont(Arial8n);
        g.drawLine(25, 186 - diff, 540, 186 - diff);
        g.drawString("Abholort mit", 185, 160);
        g.drawString("Einlieferer identisch", 185, 169);
        g.drawRect(170, 155, 13, 13);
        diff = -22;
        g.setFont(Arial8n);
        g.drawString("Name und Anschrift", 263, 158);
        g.drawLine(25, 151, 540, 151);
        g.fillRect(25, 184, 515, 13);
        g.setFont(Arial9);
        g.setColor(Color.white);
        this.drawCondensedString("Angaben zum Produkt", 27, 194, 0.75f, 1.0f, g, Arial9);
        g.setColor(Color.black);
        g.setFont(Arial8n);
        g.drawLine(25, 212, 540, 212);
        g.drawString("Aktionsbezeichnung", 27, 207);
        g.drawLine(25, 227, 540, 227);
        g.drawString("Produkt", 27, 222);
        g.drawLine(25, 242, 540, 242);
        g.drawString("Auslagerung f\u00fcr die Zustellung", 27, 237);
        g.setFont(Arial8);
        g.drawString("Einlieferungsart", 27, 252);
        g.drawString("Paletten", 267, 252);
        g.setFont(Arial8n);
        g.drawRect(27, 259, 10, 10);
        g.drawString("Gesamteinlieferung", 39, 267);
        g.drawRect(27, 274, 10, 10);
        g.drawString("Teileinlieferung", 39, 282);
        g.drawRect(27, 289, 10, 10);
        g.drawString("letzte Einlieferung", 39, 297);
        g.drawRect(267, 259, 10, 10);
        g.drawString("stapelf\u00e4hig", 279, 267);
        g.drawRect(267, 274, 10, 10);
        g.drawString("teilweise stapelf\u00e4hig", 279, 282);
        g.drawRect(267, 289, 10, 10);
        g.drawString("nicht stapelf\u00e4hig", 279, 297);
        g.drawLine(261, 242, 261, 304);
        g.drawLine(25, 304, 540, 304);
        g.drawLine(25, 34, 25, 304);
        g.drawLine(540, 34, 540, 304);
        g.drawRect(40, 354, 484, 322);
        g.drawLine(40, 354, 87, 396);
        g.setColor(Color.lightGray);
        g.fillRect(87, 396, 28, 28);
        g.fillRect(227, 396, 28, 28);
        g.fillRect(115, 424, 28, 28);
        g.fillRect(171, 508, 28, 28);
        g.fillRect(143, 564, 28, 28);
        g.setColor(Color.black);
        int i4 = 0;
        while (i4 < 10) {
            g.drawLine(40, 396 + i4 * 28, 524, 396 + i4 * 28);
            g.drawString("" + i4, 61, 412 + i4 * 28);
            ++i4;
        }
        i4 = 0;
        while (i4 < 12) {
            g.drawLine(87 + i4 * 28, 396, 87 + i4 * 28, 676);
            if (i4 < 10) {
                g.drawString("" + i4, 100 + i4 * 28, 392);
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < 3) {
            g.drawLine(395 + i4 * 43, 354, 395 + i4 * 43, 704);
            ++i4;
        }
        g.drawLine(395, 704, 524, 704);
        g.drawLine(524, 676, 524, 704);
        g.setFont(Arial8);
        g.drawString("LZ", 58, 392);
        g.drawString("LReg", 61, 366);
        g.setFont(Arial7.deriveFont(0, 6.5f));
        g.drawString("Anzahl", 406, 369);
        g.drawString("Paletten", 404, 377);
        g.drawString("je LZ", 408, 385);
        g.drawString("Gesamt-", 447, 369);
        g.drawString("gewicht", 448, 377);
        g.drawString("in kg", 451, 385);
        g.drawString("Durchschnittl.", 482, 369);
        g.drawString("Paletten-", 488, 377);
        g.drawString("gewicht je LZ", 482, 385);
        g.setFont(Arial8);
        String sumStr = "Gesamtsummen ";
        int width = this.getFontWidth(sumStr, g);
        g.drawString(sumStr.trim(), 395 - width - 5, 694);
        String agb = "09.16  912-106-400";
        if (g2d != null) {
            AffineTransform afOld = g2d.getTransform();
            AffineTransform af = new AffineTransform(afOld);
            af.rotate(Math.toRadians(270.0), pf.getWidth() / 2.0, pf.getHeight() / 2.0);
            g2d.setTransform(af);
            g2d.setFont(Arial10n);
            g2d.drawString(agb, (int)(pf.getWidth() / 2.0) - 344, (int)(pf.getHeight() / 2.0) - 278);
            g2d.setTransform(afOld);
        } else {
            PDFPrinterGraphics gPdf = (PDFPrinterGraphics)g;
            gPdf.setFont(Arial10n);
            gPdf.drawAngledString(agb, 20, 765, 90.0f);
        }
        String absenderkdnr = PSAuftrag.absender.KDNR;
        String einliefererkdnr = PSAuftrag.einlieferer.KDNR;
        String absendername = PSAuftrag.absender.Name;
        String absenderergnr = PSAuftrag.absender.ERGNR;
        String einliefererergnr = PSAuftrag.einlieferer.ERGNR;
        String absenderkartennr = PSAuftrag.absender.KARTENNR;
        String einliefererkartennr = PSAuftrag.einlieferer.KARTENNR;
        String einlieferername = PSAuftrag.einlieferer.Name;
        String absenderadresse = "";
        absenderadresse = PSAuftrag.absender.usesPFAddress() ? (PSAuftrag.absender.Land.length() > 0 && !PSAuftrag.absender.Land.equals("D") ? "Postfach " + PSAuftrag.absender.PF + ", " + PSAuftrag.absender.Land + " - " + PSAuftrag.absender.PFPLZ + " " + PSAuftrag.absender.PFOrt : "Postfach " + PSAuftrag.absender.PF + ", " + PSAuftrag.absender.PFPLZ + " " + PSAuftrag.absender.PFOrt) : (PSAuftrag.absender.Land.length() > 0 && !PSAuftrag.absender.Land.equals("D") ? String.valueOf(PSAuftrag.absender.Strasse) + ", " + PSAuftrag.absender.Land + " - " + PSAuftrag.absender.PLZ + " " + PSAuftrag.absender.Ort : String.valueOf(PSAuftrag.absender.Strasse) + ", " + PSAuftrag.absender.PLZ + " " + PSAuftrag.absender.Ort);
        String einliefereradresse = "";
        einliefereradresse = PSAuftrag.einlieferer.usesPFAddress() ? (PSAuftrag.einlieferer.Land.length() > 0 && !PSAuftrag.einlieferer.Land.equals("D") ? "Postfach " + PSAuftrag.einlieferer.PF + ", " + PSAuftrag.einlieferer.Land + " - " + PSAuftrag.einlieferer.PFPLZ + " " + PSAuftrag.einlieferer.PFOrt : "Postfach " + PSAuftrag.einlieferer.PF + ", " + PSAuftrag.einlieferer.PFPLZ + " " + PSAuftrag.einlieferer.PFOrt) : (PSAuftrag.einlieferer.Land.length() > 0 && !PSAuftrag.einlieferer.Land.equals("D") ? String.valueOf(PSAuftrag.einlieferer.Strasse) + ", " + PSAuftrag.einlieferer.Land + " - " + PSAuftrag.einlieferer.PLZ + " " + PSAuftrag.einlieferer.Ort : String.valueOf(PSAuftrag.einlieferer.Strasse) + ", " + PSAuftrag.einlieferer.PLZ + " " + PSAuftrag.einlieferer.Ort);
        String absendertelefon = PSAuftrag.absender.Telefon;
        String einlieferertelefon = PSAuftrag.einlieferer.Telefon;
        boolean cb_abs_einl = PSAuftrag.cbformulare.cb_abs_einl;
        int zahlungspflichtiger = PSAuftrag.cbformulare.cb_zahlungspflichtiger;
        String auftragbezeichnung = PSAuftrag.getJobName();
        g.setFont(Arial8);
        tmp = String.valueOf(absenderkdnr) + this.setLength(absenderergnr, 4, 2) + absenderkartennr;
        int lang = tmp.trim().length();
        if (lang > 0) {
            i = 0;
            while (i <= lang - 1) {
                if (this.printModus == 5 || this.printModus == 0) {
                    c = new char[]{tmp.charAt(i)};
                    g.drawChars(c, 0, 1, 29 + i * 14, 94);
                }
                ++i;
            }
        }
        g.setFont(Arial8);
        absendername = this.setRightFontSize(g, absendername, 280, 1);
        g.drawString(absendername, 265, 79);
        g.setFont(Arial8);
        g.drawString(this.cutText(absenderadresse, g, 170), 265, 93);
        tmp = String.valueOf(einliefererkdnr) + this.setLength(einliefererergnr, 4, 2) + einliefererkartennr;
        lang = tmp.length();
        if (lang > 0) {
            i = 0;
            while (i <= lang - 1) {
                if (this.printModus == 5 || this.printModus == 0) {
                    c = new char[]{tmp.charAt(i)};
                    g.drawChars(c, 0, 1, 29 + i * 14, 127);
                }
                ++i;
            }
        }
        g.setFont(Arial8);
        einlieferername = this.setRightFontSize(g, einlieferername, 280, 1);
        if (!cb_abs_einl) {
            g.drawString(einlieferername, 265, 113);
        }
        g.setFont(Arial8);
        if (!cb_abs_einl) {
            g.drawString(this.cutText(einliefereradresse, g, 170), 265, 126);
        }
        g.setFont(Arial8);
        String telefon = "";
        if (zahlungspflichtiger == 0) {
            this.printCheckbox(g, 170, 71, 13);
            telefon = absendertelefon;
        }
        if (zahlungspflichtiger == 1) {
            this.printCheckbox(g, 170, 100, 13);
            telefon = einlieferertelefon;
        }
        g.drawString(telefon, 29, 148);
        String abholAnschrift = PSO.mainpanel.AE.getAbholer();
        g.drawString(this.cutText(abholAnschrift, g, 170), 265, 179);
        g.drawString(auftragbezeichnung, 27 + this.getFontWidth("Aktionsbezeichnung ", g), 207);
        g.drawString("POSTAKTUELL", 27 + this.getFontWidth("Aktionsbezeichnung ", g), 222);
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
        g.drawString(sdf.format(PSAuftrag.getStorageEnd()), 27 + this.getFontWidth("Auslagerung f\u00fcr die Zustellung ", g), 237);
        return 0;
    }

    private String getDeliveryWeek() {
        String result = "";
        Date d = PSAuftrag.getCommitalDate();
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.add(3, PSAuftrag.getDeliveryOffset());
        result = "KW " + c.get(3) + " / " + c.get(1);
        return result;
    }

    private int printAGB(Graphics g, PageFormat pf, int actPage) {
        int xCorrection = -10;
        Graphics2D g2d = null;
        if (!(g instanceof PDFPrinterGraphics)) {
            g2d = (Graphics2D)g;
        }
        g.setColor(Color.black);
        g.setFont(Arial12);
        if (g instanceof PDFPrinterGraphics) {
            PDFPrinterGraphics pdfGraphics = (PDFPrinterGraphics)g;
            pdfGraphics.drawCondensedString("Allgemeine Gesch\u00e4ftsbedingungen der Deutschen Post AG", xCorrection + 15, 9, 0.75f, 1.0f);
            pdfGraphics.drawCondensedString("f\u00fcr die Bef\u00f6rderung und Lagerung von DIALOGPOST, POSTAKTUELL, POSTWURFSPEZIAL (AGB Palettenlagerung)", xCorrection + 15, 22, 0.75f, 1.0f);
        } else {
            Font condensedFont = Arial12.deriveFont(AffineTransform.getScaleInstance(0.75, 1.0));
            g.setFont(condensedFont);
            g2d.drawString("Allgemeine Gesch\u00e4ftsbedingungen der Deutschen Post AG", xCorrection + 15, 9);
            g2d.drawString("f\u00fcr die Bef\u00f6rderung und Lagerung von DIALOGPOST, POSTAKTUELL, POSTWURFSPEZIAL (AGB Palettenlagerung)", xCorrection + 15, 22);
        }
        Font Arial7b = Arial7.deriveFont(1);
        g.setFont(Arial7b);
        g.drawString("1. Geltungsbereich/Vertragsgrundlagen", xCorrection + 15, 48);
        g.setFont(Arial7);
        g.drawString("(1)", xCorrection + 15, 63);
        g.drawString("Diese Allgemeinen Gesch\u00e4ftsbedingungen (AGB) gelten f\u00fcr Vertr\u00e4ge mit", xCorrection + 30, 63);
        g.drawString("der Deutschen Post AG (Deutsche Post) \u00fcber die Bef\u00f6rderung und Lagerung", xCorrection + 30, 71);
        g.drawString("von DIALOGPOST, POSTAKTUELL und POSTWURFSPEZIAL.", xCorrection + 30, 79);
        g.drawString("(2)", xCorrection + 15, 94);
        g.drawString("Das Vertragsverh\u00e4ltnis wird durch Annahme eines schriftlichen Auftrags", xCorrection + 30, 94);
        g.drawString("des Beauftragenden der Lagerung (Einlagerer) durch die Deutsche Post", xCorrection + 30, 102);
        g.drawString("begr\u00fcndet. Die Verwendung der von der Deutschen Post hierf\u00fcr", xCorrection + 30, 110);
        g.drawString("vorgesehenen Auftragsformulare ist zwingend.", xCorrection + 30, 118);
        g.drawString("(3)", xCorrection + 15, 133);
        g.drawString("Rechte und Pflichten der Vertragsparteien bestimmen sich vorbehaltlich", xCorrection + 30, 133);
        g.drawString("zwingender gesetzlicher Vorschriften nach den Allgemeinen Gesch\u00e4fts-", xCorrection + 30, 141);
        g.drawString("bedingungen der Deutschen Post BRIEF NATIONAL (AGB BRIEF", xCorrection + 30, 149);
        g.drawString("NATIONAL) sowie der jeweiligen Produktbrosch\u00fcre in der jeweils zum", xCorrection + 30, 157);
        g.drawString("Zeitpunkt der Einlieferung g\u00fcltigen Fassung, soweit nachfolgend keine", xCorrection + 30, 165);
        g.drawString("anderweitigen Regelungen getroffen werden. Die Anwendung abweichender", xCorrection + 30, 173);
        g.drawString("Allgemeiner Gesch\u00e4ftsbedingungen des Einlagerers ist ausgeschlossen.", xCorrection + 30, 181);
        g.setFont(Arial7b);
        g.drawString("2. Leistungen der Deutschen Post", xCorrection + 15, 201);
        g.setFont(Arial7);
        g.drawString("(1)", xCorrection + 15, 216);
        g.drawString("Die Deutsche Post erbringt \u00fcber den in Abschnitt 4 der AGB BRIEF", xCorrection + 30, 216);
        g.drawString("NATIONAL festgelegten Umfang hinaus folgende Leistungen:", xCorrection + 30, 224);
        g.drawString("(2)", xCorrection + 15, 239);
        g.drawString("Die Ein- bzw. Auslagerung der Sendungen ist an den Wochentagen Montag", xCorrection + 30, 239);
        g.drawString("bis Freitag (ausgenommen an Feiertagen) m\u00f6glich.", xCorrection + 30, 247);
        g.drawString("(3)", xCorrection + 15, 262);
        g.drawString("\u00dcbernahme der gem\u00e4\u00df Abschnitt 3 vorbereiteten, bezahlten Sendungen,", xCorrection + 30, 262);
        g.drawString("ggf. gegen ein zus\u00e4tzliches Abholentgelt, vom Einlagerer oder einem", xCorrection + 30, 270);
        g.drawString("von ihm beauftragten Dritten am vereinbarten Ort und zur vereinbarten", xCorrection + 30, 278);
        g.drawString("Zeit sowie Bef\u00f6rderung zu von der Deutschen Post festgelegten Lagern", xCorrection + 30, 286);
        g.drawString("(Terminabholung). Die Abholung erfolgt nach den geltenden Regelungen", xCorrection + 30, 294);
        g.drawString("f\u00fcr die Abholung des jeweiligen Produkts.", xCorrection + 30, 302);
        g.drawString("(4)", xCorrection + 15, 317);
        g.drawString("Lagerung der Sendungen im vereinbarten Zeitraum an von der Deutschen", xCorrection + 30, 317);
        g.drawString("Post zu bestimmenden Orten bis zur Bef\u00f6rderung und Zustellung an die", xCorrection + 30, 325);
        g.drawString("Empf\u00e4nger gem\u00e4\u00df Abs\u00e4tzen 5 und 6 (Verf\u00fcgte Lagerung).", xCorrection + 30, 333);
        g.drawString("(5)", xCorrection + 15, 348);
        g.drawString("Bef\u00f6rderung der Sendungen in vom Einlagerer definierte Postleitzahlgebiete", xCorrection + 30, 348);
        g.drawString("und Auslieferung (Zustellung) an die Empf\u00e4nger.", xCorrection + 30, 356);
        int yAdd = -32;
        g.drawString("(6)", xCorrection + 15, 403 + yAdd);
        g.drawString("Die Deutsche Post ist bestrebt, die Sendungen nach Beendigung der Lagerung nach", xCorrection + 30, 403 + yAdd);
        g.drawString("den f\u00fcr das jeweilige Produkt geltenden Bedingungen zuzustellen. Bei den dort ", xCorrection + 30, 411 + yAdd);
        g.drawString("genannten Bedingungen handelt es sich um eine Regellaufzeit, auf deren Einhaltung ", xCorrection + 30, 419 + yAdd);
        g.drawString("kein Anspruch besteht (keine Lieferfristvereinbarung).", xCorrection + 30, 427 + yAdd);
        g.setFont(Arial7b);
        g.drawString("3. Mitwirkungspflichten des Einlagerers / Einlieferungsbedingungen", xCorrection + 15, 447 + yAdd);
        g.setFont(Arial7);
        g.drawString("(1)", xCorrection + 15, 462 + yAdd);
        g.drawString("Die Sendungen haben den Anforderungen der AGB BRIEF NATIONAL und", xCorrection + 30, 462 + yAdd);
        g.drawString("der Leistungsbeschreibung zu entsprechen. Insbesondere d\u00fcrfen deren Ma\u00dfe", xCorrection + 30, 470 + yAdd);
        g.drawString("und Gewichte nicht die danach zugelassenen Mindest- und H\u00f6chstgrenzen", xCorrection + 30, 478 + yAdd);
        g.drawString("unter- bzw. \u00fcberschreiten. \u00a7\u00a7 410, 411 HGB bleiben unber\u00fchrt.", xCorrection + 30, 486 + yAdd);
        g.drawString("(2)", xCorrection + 15, 501 + yAdd);
        g.drawString("Der Einlagerer hat, soweit nichts Abweichendes vereinbart ist, eine.", xCorrection + 30, 501 + yAdd);
        g.drawString("Menge von mindestens 30 Paletten einzuliefern. Eine Aufzahlung auf die", xCorrection + 30, 509 + yAdd);
        g.drawString("Mindestmenge von 30 Paletten ist m\u00f6glich.", xCorrection + 30, 517 + yAdd);
        g.drawString("(3)", xCorrection + 15, 532 + yAdd);
        g.drawString("\u00dcber die gesetzlichen und in den AGB BRIEF NATIONAL sowie in der", xCorrection + 30, 532 + yAdd);
        g.drawString("Leistungsbeschreibung definierten Obliegenheiten hinaus treffen den", xCorrection + 30, 540 + yAdd);
        g.drawString("Einlagerer folgende Mitwirkungspflichten:", xCorrection + 30, 548 + yAdd);
        g.drawString("1.", xCorrection + 30, 564 + yAdd);
        g.drawString("Konfektionieren der Sendungen in Gebinde:", xCorrection + 40, 564 + yAdd);
        g.drawString("Jede Palette ist mit 3 Palettenleitzetteln in der durch die Deutsche Post ", xCorrection + 40, 572 + yAdd);
        g.drawString("vorgegebenen Form zu kennzeichnen. Je ein Palettenleitzettel wird an der ,", xCorrection + 40, 580 + yAdd);
        g.drawString("Stirnseite, der Seitenflanke und oben auf der Palette positioniert. Darauf sind die", xCorrection + 40, 588 + yAdd);
        g.drawString("von der Deutschen Post vorgegebenen Angaben zu vermerken.", xCorrection + 40, 596 + yAdd);
        g.drawString("Die Paletten d\u00fcrfen eine maximale H\u00f6he von 1,6 m nicht \u00fcberschreiten.", xCorrection + 40, 604 + yAdd);
        yAdd = -64;
        g.drawString("2.", xCorrection + 30, 651 + yAdd);
        g.drawString("Schriftliche Mitteilung des Beladeorts und des Beladezeitpunkts", xCorrection + 40, 651 + yAdd);
        g.drawString("mindestens 7 Werktage im voraus unter Angabe von Gesamtmenge und", xCorrection + 40, 659 + yAdd);
        g.drawString("Menge je Leitregion an die Deutsche Post entsprechend des anh\u00e4ngigen", xCorrection + 40, 667 + yAdd);
        g.drawString("Gebindeplans.", xCorrection + 40, 675 + yAdd);
        g.drawString("3.", xCorrection + 30, 690 + yAdd);
        g.drawString("Die Beladung der Fahrzeuge erfolgt durch den Einlagerer oder durch von", xCorrection + 40, 690 + yAdd);
        g.drawString("ihm beauftragte Dritte.", xCorrection + 40, 698 + yAdd);
        g.drawString("4.", xCorrection + 30, 713 + yAdd);
        g.drawString("Der Einlagerer \u00fcbergibt dem ausf\u00fchrenden Frachtf\u00fchrer f\u00fcr jeden", xCorrection + 40, 713 + yAdd);
        g.drawString("Transport (LKW-Ladung) einen ordnungsgem\u00e4\u00df ausgef\u00fcllten und unter-", xCorrection + 40, 721 + yAdd);
        g.drawString("zeichneten CMR-Frachtbrief, sofern die Sendungen grenz\u00fcberschreitend", xCorrection + 40, 729 + yAdd);
        g.drawString("bef\u00f6rdert (abgeholt) werden.", xCorrection + 40, 737 + yAdd);
        int xCol2 = xCorrection + (int)(pf.getImageableWidth() / 2.0);
        g.setFont(Arial7b);
        g.drawString("4. Verg\u00fctung und Abrechnung", xCol2 + 15, 48);
        g.setFont(Arial7);
        g.drawString("(1)", xCol2 + 15, 63);
        g.drawString("Der Einlagerer hat f\u00fcr die Leistungen der Deutschen Post die vereinbarte", xCol2 + 30, 63);
        g.drawString("Verg\u00fctung zuz\u00fcglich der gesetzlichen Umsatzsteuer zu entrichten. Das", xCol2 + 30, 71);
        g.drawString("Lagerentgelt  pro  Palette  wird  f\u00fcr  je  30  Tage  berechnet. Die", xCol2 + 30, 79);
        g.drawString("Lagerdauer  berechnet  sich  vom  Abholdatum  bis  einschlie\u00dflich", xCol2 + 30, 87);
        g.drawString("Auslagerungsdatum.", xCol2 + 30, 95);
        g.drawString("(2)", xCol2 + 15, 110);
        g.drawString("Beladezeiten von mehr als 1 Stunde \u00fcber den vereinbarten Abholtermin", xCol2 + 30, 110);
        g.drawString("hinaus sind zus\u00e4tzlich mit einem Standgeld in H\u00f6he von 40 EUR pro Stunde", xCol2 + 30, 118);
        g.drawString("je Fahrzeug zu verg\u00fcten.", xCol2 + 30, 126);
        g.drawString("(3)", xCol2 + 15, 141);
        g.drawString("Der Einlagerer hat f\u00fcr avisierte, aber nicht eingelieferte und eingelagerte", xCol2 + 30, 141);
        g.drawString("Paletten ein Bereitstellungsentgelt in H\u00f6he von 1,02 EUR pro Palette zu", xCol2 + 30, 149);
        g.drawString("zahlen.", xCol2 + 30, 157);
        g.drawString("(4)", xCol2 + 15, 172);
        g.drawString("Die Deutsche Post stellt eine ordnungsgem\u00e4\u00dfe Rechnung \u00fcber die gesamte", xCol2 + 30, 172);
        g.drawString("Verg\u00fctung an den Einlagerer. Der Rechnungsbetrag ist 2 Wochen nach", xCol2 + 30, 180);
        g.drawString("Rechnungseingang beim Einlagerer ohne Abzug von Skonti f\u00e4llig. Die", xCol2 + 30, 188);
        g.drawString("Deutsche Post wird den Rechnungsbetrag bei F\u00e4lligkeit vom angegebenen", xCol2 + 30, 196);
        g.drawString("Konto im SEPA-Lastschriftverfahren abbuchen. Er ist im Falle des", xCol2 + 30, 204);
        g.drawString("Verzugs mit 2 % p.a. \u00fcber den Basiszinssatz oder dem jeweils geltenden", xCol2 + 30, 212);
        g.drawString("entsprechenden Zinssatz der Europ\u00e4ischen Zentralbank zu verzinsen.", xCol2 + 30, 220);
        g.setFont(Arial7b);
        g.drawString("5. Haftung", xCol2 + 15, 240);
        g.setFont(Arial7);
        g.drawString("(1)", xCol2 + 15, 255);
        g.drawString("Die Haftung der Deutschen Post f\u00fcr Sch\u00e4den im Rahmen der", xCol2 + 30, 255);
        g.drawString("grenz\u00fcberschreitenden Bef\u00f6rderung von Sendungen richtet sich nach den", xCol2 + 30, 263);
        g.drawString("Vorschriften der CMR.", xCol2 + 30, 271);
        g.drawString("(2)", xCol2 + 15, 286);
        g.drawString("Die Haftung der Deutschen Post richtet sich im \u00fcbrigen nach Abschnitt", xCol2 + 30, 286);
        g.drawString("6 der jeweils aktuellen Fassung der AGB BRIEF NATIONAL. Dies gilt", xCol2 + 30, 294);
        g.drawString("einheitlich f\u00fcr alle Leistungen gem\u00e4\u00df Abschnitt 2 AGB Palettenlagerung", xCol2 + 30, 302);
        g.drawString("einschlie\u00dflich der verf\u00fcgten Lagerung und sonstiger Leistungen. Dies gilt", xCol2 + 30, 310);
        g.drawString("f\u00fcr alle Sch\u00e4den, die w\u00e4hrend des gesamten Zeitraums von der \u00dcbernahme", xCol2 + 30, 318);
        g.drawString("der brief\u00e4hnlichen Sendungen (\u00a7 449 HGB) durch die Deutsche Post", xCol2 + 30, 326);
        g.drawString("einschlie\u00dflich deren verf\u00fcgter Lagerung bis zu deren Auslieferung an die", xCol2 + 30, 334);
        g.drawString("Empf\u00e4nger eintreten. Abweichend von Abschnitt 6 Abs. 2 AGB BRIEF", xCol2 + 30, 342);
        g.drawString("NATIONAL haftet jedoch die Deutsche Post ausschlie\u00dflich f\u00fcr Verlust und", xCol2 + 30, 350);
        g.drawString("Besch\u00e4digung (G\u00fctersch\u00e4den) bis zum Betrag von 5 EUR je kg Rohgewicht", xCol2 + 30, 358);
        g.drawString("der Sendung, h\u00f6chstens jedoch 5.000 EUR je Schadensfall, auch dann, wenn", xCol2 + 30, 366);
        g.drawString("keine Zusatzleistungen vereinbart wurden.", xCol2 + 30, 374);
        g.drawString("(3)", xCol2 + 15, 389);
        g.drawString("Besteht der (G\u00fcter-)Schaden eines Einlagerers in einer Differenz zwischen", xCol2 + 30, 389);
        g.drawString("Soll- und Ist-Bestand des Lagerbestands, so ist die Haftungsh\u00f6he auf 25.000", xCol2 + 30, 397);
        g.drawString("EUR begrenzt, unabh\u00e4ngig von der Zahl der f\u00fcr die Inventurdifferenz", xCol2 + 30, 405);
        g.drawString("urs\u00e4chlichen Schadenf\u00e4lle; Abschnitt 5 Abs. 2 bleibt unber\u00fchrt. Die", xCol2 + 30, 413);
        g.drawString("Haftung f\u00fcr andere als G\u00fctersch\u00e4den (mit Ausnahme von Personensch\u00e4den", xCol2 + 30, 421);
        g.drawString("und Sachsch\u00e4den an Drittgut) im Rahmen der verf\u00fcgten Lagerung ist", xCol2 + 30, 429);
        g.drawString("begrenzt auf 5.000 EUR je Schadenfall. Die Haftung f\u00fcr Sch\u00e4den (G\u00fcter-,", xCol2 + 30, 437);
        g.drawString("Verm\u00f6genssch\u00e4den, sonstige Sch\u00e4den) ist in jedem Fall, unabh\u00e4ngig davon,", xCol2 + 30, 445);
        g.drawString("wie viele Anspr\u00fcche aus einem Schadenereignis erhoben werden, auf 2 Mio.", xCol2 + 30, 453);
        g.drawString("EUR je Schadenereignis begrenzt; bei mehreren Gesch\u00e4digten haftet die", xCol2 + 30, 461);
        g.drawString("Deutsche Post anteilig im Verh\u00e4ltnis ihrer Anspr\u00fcche.", xCol2 + 30, 469);
        g.drawString("(4)", xCol2 + 15, 489);
        g.drawString("Gesetzliche Ausschl\u00fcsse und Voraussetzungen der Haftung dem Grunde", xCol2 + 30, 489);
        g.drawString("nach, insbesondere aus den \u00a7\u00a7 425 Abs. 2, 426, 427 und 475 HGB, bleiben", xCol2 + 30, 497);
        g.drawString("von den vorstehenden Abs\u00e4tzen 2 und 3, die lediglich die gesetzliche", xCol2 + 30, 505);
        g.drawString("Haftung der H\u00f6he nach gestalten, unber\u00fchrt.", xCol2 + 30, 513);
        g.drawString("(5)", xCol2 + 15, 528);
        g.drawString("Eine Verpflichtung zur Eindeckung einer Versicherung einschlie\u00dflich einer", xCol2 + 30, 528);
        g.drawString("Lagerschadenversicherung besteht nicht.", xCol2 + 30, 536);
        g.setFont(Arial7b);
        g.drawString("6. Aufrechnungs- und Zur\u00fcckhaltungsverbot, Sonstige Bestimmungen", xCol2 + 15, 556);
        g.setFont(Arial7);
        g.drawString("(1)", xCol2 + 15, 571);
        g.drawString("Die Aufrechnung oder Zur\u00fcckbehaltung durch den Einlagerer gegen\u00fcber", xCol2 + 30, 571);
        g.drawString("Anspr\u00fcchen der Deutschen Post aus diesem Vertrag oder damit", xCol2 + 30, 579);
        g.drawString("zusammenh\u00e4ngenden au\u00dfervertraglichen Anspr\u00fcchen ist nur statthaft,", xCol2 + 30, 587);
        g.drawString("sofern die f\u00e4llige Gegenforderung rechtskr\u00e4ftig festgestellt oder unbestritten", xCol2 + 30, 595);
        g.drawString("ist.", xCol2 + 30, 603);
        g.drawString("(2)", xCol2 + 15, 618);
        g.drawString("\u00c4nderungen und Erg\u00e4nzungen der Vertragsbedingungen bed\u00fcrfen der", xCol2 + 30, 618);
        g.drawString("Schriftform.", xCol2 + 30, 626);
        g.drawString("(3)", xCol2 + 15, 641);
        g.drawString("Es gilt deutsches Recht, insbesondere Fracht- und Lagerrecht (\u00a7\u00a7 407 ff.; 467", xCol2 + 30, 641);
        g.drawString("ff. HGB). Bei Anwendung zwingender internationaler oder ausl\u00e4ndischer", xCol2 + 30, 649);
        g.drawString("Vorschriften gilt deutsches Recht erg\u00e4nzend.", xCol2 + 30, 657);
        String agb = "01.21  912-106-400";
        if (g2d != null) {
            AffineTransform afOld = g2d.getTransform();
            AffineTransform af = new AffineTransform(afOld);
            af.rotate(Math.toRadians(270.0), pf.getWidth() / 2.0, pf.getHeight() / 2.0);
            g2d.setTransform(af);
            g2d.setFont(Arial10n);
            g2d.drawString(agb, (int)(pf.getWidth() / 2.0) - 364, (int)(pf.getHeight() / 2.0) - 278);
            g2d.setTransform(afOld);
        } else {
            PDFPrinterGraphics gPdf = (PDFPrinterGraphics)g;
            gPdf.setFont(Arial10n);
            gPdf.drawAngledString(agb, 0, 765, 90.0f);
        }
        return 0;
    }

    public int printOld(Graphics g, PageFormat pf, int actPage) throws PrinterException {
        try {
            char[] c;
            int i;
            Graphics2D g2d = null;
            if (!(g instanceof PDFPrinterGraphics)) {
                g2d = (Graphics2D)g;
            }
            int w = 0;
            int diff = 0;
            StringTokenizer tprint = new StringTokenizer(this.pageData, "|");
            int stringcount = tprint.countTokens();
            String absenderkdnr = PSAuftrag.absender.KDNR;
            String einliefererkdnr = PSAuftrag.einlieferer.KDNR;
            String absendername = PSAuftrag.absender.Name;
            String absenderergnr = PSAuftrag.absender.ERGNR;
            String einliefererergnr = PSAuftrag.einlieferer.ERGNR;
            String absenderkartennr = PSAuftrag.absender.KARTENNR;
            String einliefererkartennr = PSAuftrag.einlieferer.KARTENNR;
            String einlieferername = PSAuftrag.einlieferer.Name;
            String absenderadresse = "";
            absenderadresse = PSAuftrag.absender.usesPFAddress() ? (PSAuftrag.absender.Land.length() > 0 && !PSAuftrag.absender.Land.equals("D") ? "Postfach " + PSAuftrag.absender.PF + ", " + PSAuftrag.absender.Land + " - " + PSAuftrag.absender.PFPLZ + " " + PSAuftrag.absender.PFOrt : "Postfach " + PSAuftrag.absender.PF + ", " + PSAuftrag.absender.PFPLZ + " " + PSAuftrag.absender.PFOrt) : (PSAuftrag.absender.Land.length() > 0 && !PSAuftrag.absender.Land.equals("D") ? String.valueOf(PSAuftrag.absender.Strasse) + ", " + PSAuftrag.absender.Land + " - " + PSAuftrag.absender.PLZ + " " + PSAuftrag.absender.Ort : String.valueOf(PSAuftrag.absender.Strasse) + ", " + PSAuftrag.absender.PLZ + " " + PSAuftrag.absender.Ort);
            String einliefereradresse = "";
            einliefereradresse = PSAuftrag.einlieferer.usesPFAddress() ? "Postfach " + PSAuftrag.einlieferer.PF + ", " + PSAuftrag.einlieferer.Land + " - " + PSAuftrag.einlieferer.PFPLZ + " " + PSAuftrag.einlieferer.PFOrt : String.valueOf(PSAuftrag.einlieferer.Strasse) + ", " + PSAuftrag.einlieferer.Land + " - " + PSAuftrag.einlieferer.PLZ + " " + PSAuftrag.einlieferer.Ort;
            String absendertelefon = PSAuftrag.absender.Telefon;
            String einlieferertelefon = PSAuftrag.einlieferer.Telefon;
            String kontonummer = PSAuftrag.bank.Kontonummer;
            String blz = PSAuftrag.bank.BLZ;
            String kreditinstitut = PSAuftrag.bank.Geldinstitut;
            String kontobezeichnung = PSAuftrag.bank.Kontobezeichnung;
            String abwZahlungspflichtiger = PSAuftrag.zahlungspflichtiger.Name;
            String zahlungspflichtigerKdnr = PSAuftrag.zahlungspflichtiger.KDNR;
            String zahlungspflichtigerErgnr = PSAuftrag.zahlungspflichtiger.ERGNR;
            String zahlungspflichtigerKartenNr = PSAuftrag.zahlungspflichtiger.KARTENNR;
            String zahlungspflichtigerAdresse = "";
            zahlungspflichtigerAdresse = PSAuftrag.zahlungspflichtiger.usesPFAddress() ? String.valueOf(PSAuftrag.zahlungspflichtiger.PF) + ", " + PSAuftrag.zahlungspflichtiger.Land + " - " + PSAuftrag.zahlungspflichtiger.PFPLZ + " " + PSAuftrag.zahlungspflichtiger.PFOrt : String.valueOf(PSAuftrag.zahlungspflichtiger.Strasse) + ", " + PSAuftrag.zahlungspflichtiger.Land + " - " + PSAuftrag.zahlungspflichtiger.PLZ + " " + PSAuftrag.zahlungspflichtiger.Ort;
            String zahlungspflichtigerTelefon = PSAuftrag.zahlungspflichtiger.Telefon;
            boolean cb_abs_einl = PSAuftrag.cbformulare.cb_abs_einl;
            int zahlungsart = PSAuftrag.cbformulare.cb_zahlungsart;
            int zahlungspflichtiger = PSAuftrag.cbformulare.cb_zahlungspflichtiger;
            int postwurfan = PSO.mainpanel.AE.postwurfan;
            String auftragbezeichnung = PSAuftrag.getMainJobName();
            String abholDate = PSO.mainpanel.AE.getAbholTermin();
            String depot = String.valueOf(PSAuftrag.getDepotName()) + ", " + PSAuftrag.getDepotZipTown();
            int paletteCount = PSAuftrag.getPaletteCnt();
            String totalWeight = PSEnvironment.Format(Math.round((double)((long)PSO.mainpanel.AE.getGewicht() * PSAuftrag.getSumSdgAsLong()) * 0.001), "###,###,##0.00");
            String lagerEntgelt = String.valueOf(PSEnvironment.Format(storagePrice, "#,###,##0,00")) + " \u20ac";
            String einlagerDate = PSAuftrag.getStorageStartDate();
            String auslagerDate = PSAuftrag.getStorageEndDate();
            g.translate(20, 20);
            g.setColor(Color.black);
            g.setFont(Arial12);
            g.drawString("Auftrag zur Palettenlagerung Postaktuell", 25, 2);
            g.setFont(Arial6);
            g.drawString("(Blatt 1 f\u00fcr SMAwB 30136 Hannover)", 25, 10);
            g.setFont(Arial8n.deriveFont(7.0f));
            g.drawString("Niederlassung", 25, 18);
            g.drawLine(25, 25, 200, 25);
            g.drawString("Telefon:", 25, 33);
            g.drawString("Telefax:", 125, 33);
            g.drawLine(25, 40, 200, 40);
            g.drawLine(120, 29, 120, 40);
            g.setFont(Arial6);
            g.drawString("Leistungserbringende", 250, 10);
            g.drawString("Niederlassung", 250, 16);
            g.drawLine(250, 25, 250, 40);
            g.drawLine(260, 30, 260, 40);
            g.drawLine(270, 30, 270, 40);
            g.drawLine(280, 25, 280, 40);
            g.drawLine(250, 40, 280, 40);
            Color fill = new Color(210, 210, 210);
            g.fillRect(25, 47, 515, 13);
            g.drawLine(25, 60, 25, 440);
            g.drawLine(25, 440, 540, 440);
            g.setFont(Arial9);
            g.setColor(Color.white);
            g.drawString("Angaben zum Absender / Einlieferer", 27, 57);
            g.setColor(Color.black);
            g.setFont(Arial8);
            String tmp = "Absender *) (Auftraggeber)";
            w = this.getFontWidth(tmp, g);
            g.drawString(tmp, 27, 69);
            g.setFont(Arial5);
            g.drawString("*) Es gilt Abschnitt 2 Abs. 1 Satz 1 AGB BfD Inl", 37 + w + 5, 68);
            g.setFont(Arial8n);
            g.drawString("Kunden- / Kartennummer", 27, 77);
            g.drawString("Name und Anschrift", 263, 67);
            g.drawString("Zahlung durch", 185, 77);
            g.drawString("Absender", 185, 85);
            g.setFont(Arial8);
            g.drawString("Einlieferer", 27, 106);
            g.setFont(Arial6n);
            g.drawString("(soweit vom Absender abweichend)", 71, 105);
            g.setFont(Arial8n);
            g.drawString("Kunden- / Kartennummer", 27, 114);
            g.drawString("Name und Anschrift", 263, 103);
            g.drawString("Zahlung durch", 185, 106);
            g.drawString("Einlieferer", 185, 114);
            g.drawLine(25, 96, 261, 96);
            g.drawLine(25, 129, 261, 129);
            g.drawLine(261, 83, 540, 83);
            g.drawLine(261, 96, 540, 96);
            g.drawLine(428, 83, 428, 96);
            g.drawString("Telefon", 430, 93);
            g.drawLine(261, 116, 540, 116);
            g.drawLine(261, 129, 540, 129);
            g.drawLine(428, 117, 428, 129);
            g.drawString("Telefon", 430, 126);
            g.drawRect(170, 71, 13, 13);
            g.drawRect(170, 100, 13, 13);
            int i2 = 0;
            while (i2 < 17) {
                if (i2 == 16) {
                    g.drawLine(37 + i2 * 14, 60, 37 + i2 * 14, 96);
                    g.drawLine(37 + i2 * 14, 96, 37 + i2 * 14, 129);
                    g.drawLine(37 + i2 * 14, 129, 37 + i2 * 14, 161);
                } else {
                    g.drawLine(37 + i2 * 14, 89, 37 + i2 * 14, 96);
                    g.drawLine(37 + i2 * 14, 122, 37 + i2 * 14, 129);
                    g.drawLine(37 + i2 * 14, 154, 37 + i2 * 14, 161);
                }
                ++i2;
            }
            diff = 3;
            g.setFont(Arial8);
            g.drawString("Abweichender Zahlungspflichtiger", 27, 137);
            g.setFont(Arial8n);
            g.drawString("Kunden- /Kartennummer", 27, 145);
            g.drawLine(25, 164 - diff, 540, 164 - diff);
            g.drawString("Zahlung durch", 185, 139);
            g.drawString("Zahlungspflichtigen", 185, 147);
            g.drawRect(170, 133, 13, 13);
            g.setFont(Arial8n);
            g.drawString("Kontonummer", 27, 173 - diff);
            g.drawString("Kreditinstitut", 165, 173 - diff);
            g.drawString("Bankleitzahl", 430, 173 - diff);
            i2 = 0;
            while (i2 < 10) {
                if (i2 == 9) {
                    g.drawLine(37 + i2 * 14, 173 - diff, 37 + i2 * 14, 187 - diff);
                } else {
                    g.drawLine(37 + i2 * 14, 181 - diff, 37 + i2 * 14, 187 - diff);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < 9) {
                if (i2 == 0 || i2 == 8) {
                    g.drawLine(540 - i2 * 14, 173 - diff, 540 - i2 * 14, 187 - diff);
                } else {
                    g.drawLine(540 - i2 * 14, 181 - diff, 540 - i2 * 14, 187 - diff);
                }
                ++i2;
            }
            g.drawLine(25, 187 - diff, 540, 187 - diff);
            g.drawString("Name und Anschrift", 263, 136);
            g.drawLine(261, 148, 540, 148);
            g.drawLine(428, 148, 428, 161);
            g.drawString("Telefon", 430, 158);
            g.drawLine(261, 135, 261, 161);
            g.fillRect(25, 184, 515, 13);
            g.setFont(Arial9);
            g.setColor(Color.white);
            g.drawString("Angaben zur Sendung", 27, 194);
            g.setColor(Color.black);
            g.setFont(Arial8n);
            g.drawLine(25, 227, 540, 227);
            g.drawString("Auftrags-/Aktionsbezeichnung", 27, 205);
            g.drawLine(25, 257, 540, 257);
            g.drawString("Abholtag der Paletten", 27, 235);
            g.drawLine(25, 287, 540, 287);
            g.drawString("Depot", 27, 265);
            g.drawLine(25, 317, 540, 317);
            g.drawString("Anzahl Paletten", 27, 295);
            g.drawLine(25, 347, 540, 347);
            g.drawString("Gesamtgewicht in kg", 27, 325);
            g.drawLine(25, 377, 540, 377);
            g.drawString("Lagerentgelt", 27, 355);
            g.drawLine(25, 412, 540, 412);
            g.drawString("Lagerung", 27, 385);
            g.drawString("vom", 27, 393);
            g.drawString("bis", 185, 393);
            g.drawLine(185, 397, 185, 412);
            g.drawString("Zustellung", 27, 420);
            g.drawString("Die Zustellung erfolgt in der Regel innerhalb von drei Werktagen nach der vereinbarten Beendigung der Lagerung.", 27, 428);
            g.drawString("Bitte beachten Sie hier Abschnitt 2.4 unserer umseitigen AGB Palettenlagerung.", 27, 436);
            g.drawString("Es gelten die umseitigen Allgemeinen Gesch\u00e4ftsbedingungen der Deutschen Post AG f\u00fcr die Bef\u00f6rderung und Lagerung", 27, 455);
            g.drawString("von Postaktuell-Sendungen (AGB Palettenlagerung).", 27, 463);
            g.drawRect(25, 470, 257, 170);
            g.drawRect(283, 470, 257, 170);
            g.setColor(Color.lightGray);
            g.fillRect(26, 471, 256, 168);
            g.fillRect(284, 471, 255, 168);
            g.setColor(Color.black);
            g.setFont(Arial8);
            g.drawString("Entgeltberechnung", 27, 480);
            g.setFont(Arial6n);
            g.drawString("(Anzahl der Paletten) x (Lagerkosten/Palette)", 27, 488);
            g.drawString("x", 100, 528);
            g.drawLine(27, 530, 160, 530);
            g.drawString("=", 162, 528);
            g.drawLine(168, 530, 218, 530);
            g.drawLine(223, 530, 253, 530);
            g.drawLine(223, 515, 223, 530);
            g.drawLine(233, 520, 233, 530);
            g.drawLine(243, 520, 243, 530);
            g.drawLine(253, 515, 253, 530);
            g.setFont(Arial8n);
            g.drawString("EUR", 224, 514);
            g.drawString("zzgl. 19% Mehrwertsteuer", 27, 590);
            g.drawString("=", 162, 590);
            g.drawLine(168, 595, 218, 595);
            g.drawString("zu zahlen", 27, 630);
            g.drawString("=", 162, 630);
            g.drawLine(168, 635, 218, 635);
            g.drawLine(223, 635, 253, 635);
            g.drawLine(223, 620, 223, 635);
            g.drawLine(233, 625, 233, 635);
            g.drawLine(243, 625, 243, 635);
            g.drawLine(253, 620, 253, 635);
            g.drawString("EUR", 224, 619);
            g.setFont(Arial8);
            g.drawString("Abgleich Gebindeplan", 285, 480);
            g.setFont(Arial6n);
            g.drawString("(Anzahl der Paletten) x (Lagerkosten/Palette)", 285, 488);
            g.drawString("x", 358, 528);
            g.drawLine(285, 530, 418, 530);
            g.drawString("=", 420, 528);
            g.drawLine(426, 530, 476, 530);
            g.drawLine(481, 530, 511, 530);
            g.drawLine(481, 515, 481, 530);
            g.drawLine(491, 520, 491, 530);
            g.drawLine(501, 520, 501, 530);
            g.drawLine(511, 515, 511, 530);
            g.drawString("x 1,02 EUR", 358, 558);
            g.drawLine(285, 560, 355, 560);
            g.setFont(Arial6n);
            g.drawString("Bereithaltungskosten f\u00fcr avisierte aber nicht gelieferte Paletten", 285, 566);
            g.drawLine(426, 560, 476, 560);
            g.setFont(Arial8n);
            g.drawString("EUR", 482, 514);
            g.drawString("zzgl. 19% Mehrwertsteuer", 285, 590);
            g.drawString("=", 420, 590);
            g.drawLine(426, 595, 476, 595);
            g.drawString("zu zahlen", 285, 630);
            g.drawString("=", 420, 630);
            g.drawLine(426, 635, 476, 635);
            g.drawLine(481, 635, 511, 635);
            g.drawLine(481, 620, 481, 635);
            g.drawLine(491, 625, 491, 635);
            g.drawLine(501, 625, 501, 635);
            g.drawLine(511, 620, 511, 635);
            g.drawString("EUR", 482, 619);
            g.setFont(Arial6n);
            g.drawString("*) Der Einlieferer ist zum Abschluss berechtigt.", 27, 647);
            g.setFont(Arial8n);
            g.drawString("Abgleich vorgenommen", 310, 647);
            g.drawLine(40, 670, 275, 670);
            g.setFont(Arial6n);
            g.drawString("(Ort, Datum)", 40, 677);
            g.drawLine(298, 670, 533, 670);
            g.drawString("(Datum, Stelle)", 298, 677);
            g.drawLine(40, 700, 275, 700);
            g.drawString("(Unterschrift des Absenders / Einlieferer)", 40, 707);
            g.drawLine(298, 700, 533, 700);
            g.drawString("(Name des pr\u00fcfenden Mitarbeiters)", 298, 707);
            g.drawLine(40, 730, 275, 730);
            g.drawString("(Unterschrift des Vertretungsberechtigten der Deutschen Post AG)", 40, 737);
            g.drawString("(Unterschrift der Pr\u00fcfkraft)", 298, 737);
            g.drawLine(298, 730, 533, 730);
            this.drawVersionCopyrightAndLogo(g, 25, 750);
            g.setFont(Arial8);
            tmp = String.valueOf(absenderkdnr) + this.setLength(absenderergnr, 4, 2) + absenderkartennr;
            int lang = tmp.trim().length();
            if (lang > 0) {
                i = 0;
                while (i <= lang - 1) {
                    if (this.printModus == 5 || this.printModus == 0) {
                        c = new char[]{tmp.charAt(i)};
                        g.drawChars(c, 0, 1, 29 + i * 14, 94);
                    }
                    ++i;
                }
            }
            if (this.printModus == 5 || this.printModus == 0) {
                g.setFont(Arial8);
                absendername = this.setRightFontSize(g, absendername, 280, 1);
                g.drawString(absendername, 265, 79);
                g.setFont(Arial8);
                absenderadresse = this.setRightFontSize(g, absenderadresse, 170, 1);
                g.drawString(absenderadresse, 265, 93);
                absendertelefon = this.setRightFontSize(g, absendertelefon, 170, 1);
                g.drawString(absendertelefon, 460, 93);
            }
            if ((lang = (tmp = String.valueOf(einliefererkdnr) + this.setLength(einliefererergnr, 4, 2) + einliefererkartennr).length()) > 0) {
                i = 0;
                while (i <= lang - 1) {
                    if (this.printModus == 5 || this.printModus == 0) {
                        c = new char[]{tmp.charAt(i)};
                        g.drawChars(c, 0, 1, 29 + i * 14, 127);
                    }
                    ++i;
                }
            }
            if (this.printModus == 5 || this.printModus == 0) {
                g.setFont(Arial8);
                einlieferername = this.setRightFontSize(g, einlieferername, 280, 1);
                if (!cb_abs_einl) {
                    g.drawString(einlieferername, 265, 113);
                }
                g.setFont(Arial8);
                einliefereradresse = this.setRightFontSize(g, einliefereradresse, 170, 1);
                if (!cb_abs_einl) {
                    g.drawString(einliefereradresse, 265, 126);
                }
                einlieferertelefon = this.setRightFontSize(g, einlieferertelefon, 170, 1);
                g.drawString(einlieferertelefon, 460, 126);
                g.setFont(Arial8);
                auftragbezeichnung = this.setRightFontSize(g, auftragbezeichnung, 150, 1);
                g.drawString(auftragbezeichnung, 27, 223);
                g.drawString(abholDate, 27, 253);
                g.drawString(depot, 27, 283);
                g.drawString("" + paletteCount, 27, 313);
                g.drawString(totalWeight, 27, 343);
                g.drawString(lagerEntgelt, 27, 373);
                g.drawString(einlagerDate, 27, 408);
                g.drawString(auslagerDate, 187, 408);
            }
            diff = 3;
            if (this.printModus == 5 || this.printModus == 0) {
                abwZahlungspflichtiger = this.setRightFontSize(g, abwZahlungspflichtiger, 280, 1);
                if (PSAuftrag.cbformulare.cb_zahlungspflichtiger == 2) {
                    g.drawString(abwZahlungspflichtiger, 265, 146);
                }
                g.setFont(Arial8);
                zahlungspflichtigerAdresse = this.setRightFontSize(g, zahlungspflichtigerAdresse, 170, 1);
                if (PSAuftrag.cbformulare.cb_zahlungspflichtiger == 2) {
                    g.drawString(zahlungspflichtigerAdresse, 265, 158);
                }
                zahlungspflichtigerTelefon = this.setRightFontSize(g, zahlungspflichtigerTelefon, 170, 1);
                if (PSAuftrag.cbformulare.cb_zahlungspflichtiger == 2) {
                    g.drawString(zahlungspflichtigerTelefon, 460, 158);
                }
                g.setFont(Arial8);
                tmp = String.valueOf(zahlungspflichtigerKdnr) + this.setLength(zahlungspflichtigerErgnr, 4, 2) + zahlungspflichtigerKartenNr;
                lang = tmp.length();
                if (lang > 0 && PSAuftrag.cbformulare.cb_zahlungspflichtiger == 2) {
                    i = 0;
                    while (i <= lang - 1) {
                        if (this.printModus == 5 || this.printModus == 0) {
                            c = new char[]{tmp.charAt(i)};
                            g.drawChars(c, 0, 1, 29 + i * 14, 159);
                        }
                        ++i;
                    }
                }
                g.setFont(Arial8);
                kreditinstitut = this.setRightFontSize(g, kreditinstitut, 260, 1);
                g.drawString(kreditinstitut, 168, 185 - diff);
            }
            if ((lang = kontonummer.length()) > 0) {
                i = 0;
                while (i < lang) {
                    if (this.printModus == 5 || this.printModus == 0) {
                        c = new char[]{kontonummer.charAt(i)};
                        g.drawChars(c, 0, 1, 29 + i * 14, 185 - diff);
                    }
                    ++i;
                }
            }
            if ((lang = blz.length()) > 0) {
                i = 0;
                while (i < lang) {
                    if (this.printModus == 5 || this.printModus == 0) {
                        c = new char[]{blz.charAt(i)};
                        g.drawChars(c, 0, 1, 434 + i * 14, 185 - diff);
                    }
                    ++i;
                }
            }
            g.dispose();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return 0;
    }

    public void printCheckbox(Graphics g, int x, int y, int width) {
        g.drawLine(x + 2, y + 2, x + width - 1, y + width - 2);
        g.drawLine(x + width - 1, y + 2, x + 2, y + width - 2);
    }

    public static double getStoragePrice() {
        return storagePrice;
    }

    public static void setStoragePrice(double storagePrice) {
        PrintPaletteStorage.storagePrice = storagePrice;
    }
}

