/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.printj2;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.krysalis.barcode4j.tools.UnitConv;
import prospektservice.PSAuftrag;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.PSUser;
import prospektservice.printj2.PrintableObject;

public class PrintAZ
extends PrintableObject {
    protected String pageData;
    protected static boolean flgDruckAuftragsbezeichnung = false;
    protected static boolean flgDruckVariableAngaben = false;
    protected static boolean flgDruckASLeitregion = false;
    protected static boolean flgDruckOhneGrafik = false;
    protected static boolean flgDruckStapel = false;
    protected static boolean flgDruckPaletteNr = false;
    protected static boolean flgDruckZbnZusatz = false;
    protected static Font freitextFont;
    protected static int bundleCnt;

    static {
        bundleCnt = 0;
    }

    public PrintAZ() {
        if (freitextFont == null) {
            freitextFont = Arial10;
        }
    }

    public PrintAZ(String data) {
        this.pageData = data;
        if (freitextFont == null) {
            freitextFont = Arial10;
        }
    }

    @Override
    public void setPrintModus(int modus) {
        this.printModus = modus;
    }

    @Override
    public int print(Graphics g, PageFormat pf, int actPage) throws PrinterException {
        boolean twoPerPage;
        int Seite = 0;
        g.translate(20, 20);
        StringTokenizer tmain = new StringTokenizer(this.pageData, "+");
        Seite = PSEnvironment.getIntValue(tmain.nextToken());
        int as_maxparse = tmain.countTokens();
        bundleCnt = 4 * (Seite - 1);
        boolean bl = twoPerPage = PSUser.isFreitextAktiv() && PSAuftrag.getActFreiText().trim().length() > 0;
        if (as_maxparse > 0) {
            this.Formular_A(g, 0, tmain.nextToken(), this.printModus);
        }
        if (as_maxparse > 1) {
            this.Formular_A(g, twoPerPage ? 2 : 1, tmain.nextToken(), this.printModus);
        }
        if (!twoPerPage) {
            if (as_maxparse > 2) {
                this.Formular_A(g, 2, tmain.nextToken(), this.printModus);
            }
            if (as_maxparse > 3) {
                this.Formular_A(g, 3, tmain.nextToken(), this.printModus);
            }
        } else {
            this.Formular_A_Freitext(g, 1, PSAuftrag.getActFreiText(), this.printModus);
            if (as_maxparse > 1) {
                this.Formular_A_Freitext(g, 3, PSAuftrag.getActFreiText(), this.printModus);
            }
        }
        g.setFont(Arial6);
        if (Seite > 0 && this.printModus == 0) {
            String tmp = "- " + String.valueOf(Seite) + " -";
            int w = this.getFontWidth(tmp, g);
            g.drawString(tmp, 265 - w / 2, 786);
        }
        g.dispose();
        return 0;
    }

    protected void Formular_A(Graphics g, int position, String value, int printmodus) {
        int OffSetX = 0;
        int OffSetY = 0;
        String einlieferer = "";
        String e_strasse = "";
        String absender = "";
        String a_strasse = "";
        String e_annahme = "";
        String e_bezeichnung = "";
        String e_verpackung_start = "";
        String e_verpackung_end = "";
        String e_verpackungeinheit = "";
        String e_gesamtsendungen = "";
        String e_abrunden = "";
        String e_an = "";
        String e_tarif = "";
        String e_nach = "";
        String e_Zusatz = "";
        String e_janein = "";
        String e_bnr = "";
        String palette_nr = "";
        String zustell_termin = "";
        String bundleId = "";
        String tmp = "";
        if (printmodus == 5 || printmodus == 7) {
            if (PSAuftrag.cbformulare.cb_abs_einl) {
                einlieferer = PSAuftrag.absender.KDNR;
                e_strasse = PSAuftrag.absender.usesPFAddress() ? "/" + PSAuftrag.absender.Name + ", " + PSAuftrag.absender.PFPLZ + " " + PSAuftrag.absender.PFOrt : "/" + PSAuftrag.absender.Name + ", " + PSAuftrag.absender.PLZ + " " + PSAuftrag.absender.Ort;
                absender = einlieferer;
                a_strasse = e_strasse;
            } else {
                einlieferer = PSAuftrag.einlieferer.KDNR;
                e_strasse = PSAuftrag.einlieferer.usesPFAddress() ? "/" + PSAuftrag.einlieferer.Name + ", " + PSAuftrag.einlieferer.PFPLZ + " " + PSAuftrag.einlieferer.PFOrt : "/" + PSAuftrag.einlieferer.Name + ", " + PSAuftrag.einlieferer.PLZ + " " + PSAuftrag.einlieferer.Ort;
                absender = PSAuftrag.absender.KDNR;
                a_strasse = PSAuftrag.absender.usesPFAddress() ? "/" + PSAuftrag.absender.Name + ", " + PSAuftrag.absender.PFPLZ + " " + PSAuftrag.absender.PFOrt : "/" + PSAuftrag.absender.Name + ", " + PSAuftrag.absender.PLZ + " " + PSAuftrag.absender.Ort;
            }
        }
        if (printmodus < 4) {
            StringTokenizer t = new StringTokenizer(value, "|");
            if (t.hasMoreTokens()) {
                einlieferer = t.nextToken();
            }
            if (t.hasMoreTokens()) {
                e_strasse = "/" + t.nextToken() + ", " + t.nextToken() + " " + t.nextToken();
            }
            if (t.hasMoreTokens()) {
                absender = t.nextToken();
            }
            if (t.hasMoreTokens()) {
                a_strasse = "/" + t.nextToken() + ", " + t.nextToken() + " " + t.nextToken();
            }
            if (t.hasMoreTokens()) {
                e_annahme = t.nextToken();
            }
            if (t.hasMoreTokens()) {
                tmp = t.nextToken();
            }
            if (flgDruckAuftragsbezeichnung) {
                e_bezeichnung = tmp;
            }
            if (t.hasMoreTokens()) {
                e_verpackung_start = t.nextToken();
            }
            if (t.hasMoreTokens()) {
                e_verpackung_end = t.nextToken();
            }
            if (t.hasMoreTokens()) {
                e_verpackungeinheit = t.nextToken();
            }
            if (t.hasMoreTokens()) {
                e_gesamtsendungen = t.nextToken();
            }
            if (t.hasMoreTokens()) {
                e_abrunden = t.nextToken();
            }
            if (t.hasMoreTokens()) {
                e_an = t.nextToken();
            }
            if (t.hasMoreTokens()) {
                e_tarif = t.nextToken();
            }
            if (t.hasMoreTokens()) {
                e_nach = String.valueOf(t.nextToken()) + "   " + t.nextToken();
            }
            if (t.hasMoreTokens()) {
                e_Zusatz = t.nextToken();
            }
            if (t.hasMoreTokens()) {
                e_janein = t.nextToken();
            }
            if (t.hasMoreTokens()) {
                e_bnr = t.nextToken();
            }
            if (t.hasMoreTokens()) {
                palette_nr = t.nextToken();
            }
            if (t.hasMoreTokens()) {
                zustell_termin = t.nextToken();
            }
            if (t.hasMoreTokens()) {
                bundleId = t.nextToken();
            }
        }
        if (position == 0) {
            OffSetX = 0;
            OffSetY = 0;
        } else if (position == 1) {
            OffSetX = 275;
            OffSetY = 0;
        } else if (position == 2) {
            OffSetX = 0;
            OffSetY = 394;
        } else {
            OffSetX = 275;
            OffSetY = 394;
        }
        if (!flgDruckVariableAngaben) {
            this.drawAZDefaults(g, OffSetX, OffSetY);
            Color fill = new Color(210, 210, 210);
            g.setColor(fill);
            if (!flgDruckZbnZusatz) {
                OffSetY -= 15;
            }
            if (!flgDruckOhneGrafik) {
                g.fillRect(OffSetX, 167 + OffSetY, 255, 30);
                g.fillRect(OffSetX, 212 + OffSetY, 255, 25);
                if (PSO.Modus < 3) {
                    g.fillRect(OffSetX, 252 + OffSetY, 255, 45);
                }
            }
            g.setColor(Color.black);
            g.setFont(Arial18);
            String baseProduct = "POSTAKTUELL";
            g.drawString(baseProduct, 5 + OffSetX, 97 + (OffSetY += 35));
            g.setFont(Arial8);
            g.drawString("VE", 20 + OffSetX, 172 + OffSetY);
            g.drawString("Sdg/VE", 55 + OffSetX, 172 + OffSetY);
            g.drawString("Sdg/ZSP", 105 + OffSetX, 172 + OffSetY);
            g.drawString("Palette", 158 + OffSetX, 172 + OffSetY);
            g.drawString("abgerundet", 205 + OffSetX, 172 + OffSetY);
            if (PSO.Modus < 3) {
                g.setFont(Arial9);
                g.drawString("Verteilhinweis f\u00fcr POSTAKTUELL", 10 + OffSetX, 212 + OffSetY);
                g.setColor(Color.black);
                g.drawRect(20 + OffSetX, 222 + OffSetY, 14, 14);
                g.drawString("nein", 40 + OffSetX, 232 + OffSetY);
                g.drawRect(20 + OffSetX, 242 + OffSetY, 14, 14);
                g.drawString("ja, Bearbeitungs-Nr.", 40 + OffSetX, 252 + OffSetY);
            }
        }
        g.setFont(Arial8);
        tmp = PSO.Modus == 4 ? "incl. Mitbenutzer:" : "abgerundet um:";
        int w = this.getFontWidth(tmp, g);
        if (printmodus < 4) {
            if (!e_tarif.equals(" ")) {
                e_tarif = e_tarif.equalsIgnoreCase("-A-") ? "-Kerngebiet-" : "-Randgebiet-";
                tmp = "Tarif " + e_tarif;
                w = this.getFontWidth(tmp, g);
                g.drawString(tmp, 255 - w + OffSetX, 129 + OffSetY);
            }
            g.setFont(Arial18);
            if (PSO.mainpanel.AE.postwurfan == 1) {
                g.drawString("an Haushalte mit Tagespost", 5 + OffSetX, 116 + OffSetY);
            } else if (PSO.mainpanel.AE.postwurfan == 0) {
                g.drawString("an alle Haushalte", 5 + OffSetX, 116 + OffSetY);
            } else if (PSO.mainpanel.AE.postwurfan == 2) {
                g.drawString("an alle Briefabholer", 5 + OffSetX, 116 + OffSetY);
            } else if (PSO.mainpanel.AE.postwurfan == 3) {
                g.drawString("an s\u00e4mtliche Haushalte", 5 + OffSetX, 116 + OffSetY);
                g.setFont(Arial9);
                g.drawString("incl. Werbeverweigerer", 5 + OffSetX, 126 + OffSetY);
            }
            int stdFontSize = 24;
            if (PSO.Modus == 4) {
                g.setFont(Arial18.deriveFont(1, stdFontSize));
                while (this.getFontWidth(e_nach, g) > 251) {
                    g.setFont(Arial18.deriveFont(1, --stdFontSize));
                }
                g.drawString(e_nach, 10 + OffSetX, 148 + OffSetY);
                g.setFont(Arial9n);
                e_Zusatz = this.setRightFontSize(g, e_Zusatz, 185, 0);
                g.drawString(e_Zusatz, 76 + OffSetX, 159 + OffSetY);
            } else {
                g.setFont(Arial18.deriveFont(1, stdFontSize));
                while (this.getFontWidth(e_nach, g) > 251) {
                    g.setFont(Arial18.deriveFont(1, --stdFontSize));
                }
                g.drawString(e_nach, 10 + OffSetX, 153 + OffSetY);
            }
            g.setFont(Arial14);
            w = this.getFontWidth(String.valueOf(e_verpackung_start) + "/" + e_verpackung_end, g);
            g.drawString(String.valueOf(e_verpackung_start) + "/" + e_verpackung_end, 25 - w / 2 + OffSetX, 195 + OffSetY);
            if (!PSO.mainpanel.getPsc().isDruckEinfach()) {
                w = this.getFontWidth(e_verpackungeinheit, g);
                g.drawString(PSEnvironment.Format(e_verpackungeinheit, "#,###,###,##0"), 70 - w / 2 + OffSetX, 195 + OffSetY);
            }
            w = this.getFontWidth(e_gesamtsendungen, g);
            g.drawString(PSEnvironment.Format(e_gesamtsendungen, "#,###,###,##0"), 120 - w / 2 + OffSetX, 195 + OffSetY);
            if (flgDruckPaletteNr) {
                w = this.getFontWidth(palette_nr, g);
                g.drawString(palette_nr, 170 - w / 2 + OffSetX, 195 + OffSetY);
            }
            if (!e_abrunden.equals(" ")) {
                tmp = e_abrunden;
                w = this.getFontWidth(tmp, g);
                g.drawString(tmp, 230 - w / 2 + OffSetX, 195 + OffSetY);
            }
        }
        OffSetY += 15;
        if (flgDruckStapel) {
            this.drawStapelNumbers(g, OffSetX, OffSetY - 35, String.valueOf(position + 1));
        }
        if (position == 0 || position == 2) {
            this.drawCuttingHelpers(g, OffSetX, OffSetY - 35, position);
        }
        g.setFont(Arial9);
        tmp = einlieferer;
        g.drawString(tmp, 97 + OffSetX, 30 + (OffSetY -= 35));
        g.setFont(Arial9);
        tmp = e_strasse;
        tmp = this.setRightFontSize(g, tmp, 102, 0);
        g.drawString(tmp, 150 + OffSetX, 30 + OffSetY);
        g.setFont(Arial9);
        tmp = absender;
        g.drawString(tmp, 97 + OffSetX, 45 + OffSetY);
        g.setFont(Arial9);
        tmp = a_strasse;
        tmp = this.setRightFontSize(g, tmp, 102, 0);
        g.drawString(tmp, 150 + OffSetX, 45 + OffSetY);
        g.setFont(Arial9);
        tmp = e_bezeichnung;
        tmp = this.setRightFontSize(g, tmp, 160, 0);
        g.drawString(tmp, 97 + OffSetX, 75 + (OffSetY -= 15));
        this.drawPaDates(g, 97 + OffSetX, 95 + OffSetY);
        g.setFont(Arial9);
        if (PSO.Modus < 3) {
            if (e_janein.equals("1")) {
                g.drawString(e_bnr, 150 + OffSetX, 287 + OffSetY);
                g.drawLine(22 + OffSetX, 279 + OffSetY, 33 + OffSetX, 289 + OffSetY);
                g.drawLine(33 + OffSetX, 279 + OffSetY, 22 + OffSetX, 289 + OffSetY);
            }
            if (e_janein.equals("0")) {
                g.drawLine(22 + OffSetX, 259 + OffSetY, 33 + OffSetX, 269 + OffSetY);
                g.drawLine(33 + OffSetX, 259 + OffSetY, 22 + OffSetX, 269 + OffSetY);
            }
        }
        if (printmodus < 4) {
            this.barCodeGenerator.setPLZ(e_nach);
            ++bundleCnt;
            this.barCodeGenerator.setDate(zustell_termin);
            this.barCodeGenerator.setCustomerID(PSAuftrag.getCurrentJobID());
            this.barCodeGenerator.setIdSubmitter(String.valueOf(bundleId));
            this.barCodeGenerator.setSubmitter(PSUser.getsubmitterEKP());
            BufferedImage img = this.barCodeGenerator.CreateAZBarcode(this.barCodeGenerator.getBarcodeMessage());
            if (PSO.mainpanel.AE.isUseAM()) {
                g.drawString("AM-Nr.: " + PSAuftrag.getAMNummer(), 145 + OffSetX, 332 + (int)UnitConv.mm2pt((double)15.0) + OffSetY + 10);
                g.drawString("Gebinde-ID: " + PSEnvironment.Format(bundleId, "###,##0"), 145 + OffSetX, 332 + (int)UnitConv.mm2pt((double)15.0) + OffSetY + 20);
            }
        }
    }

    protected void drawAZDefaults(Graphics g, int offSetX, int offSetY) {
        if (!flgDruckOhneGrafik) {
            this.drawImage(185 + offSetX, offSetY + 2, 70, 15, "images/dpost256.bmp", g);
            Color fill = new Color(210, 210, 210);
            g.setColor(fill);
            g.fillRect(95 + offSetX, 20 + offSetY, 160, 13);
            g.fillRect(95 + offSetX, 35 + offSetY, 160, 13);
            g.fillRect(95 + offSetX, 50 + offSetY, 160, 13);
        }
        g.setColor(Color.black);
        g.setFont(Arial8);
        g.drawString("Einlieferer:", 5 + offSetX, 30 + offSetY);
        g.drawString("Absender:", 5 + offSetX, 45 + offSetY);
        g.drawString("Auftragsbezeichnung:", 5 + offSetX, 60 + offSetY);
        int yCoord = flgDruckZbnZusatz ? 95 + offSetY : 80 + offSetY;
        g.drawString(PSAuftrag.getStorageEnd() != null ? "Auslagerungsdatum:" : "Einlieferungsdatum:", 5 + offSetX, yCoord);
        g.setFont(Arial6);
        this.drawVersionCopyrightAndLogo(g, offSetX + 5, offSetY + 356, flgDruckStapel);
    }

    protected void drawPaDates(Graphics g, int offSetX, int offSetY, Font font) {
        Date d;
        Date date = d = PSAuftrag.getStorageEnd() == null ? PSAuftrag.getCommitalDate() : PSAuftrag.getStorageEnd();
        if (d != null) {
            SimpleDateFormat formattter = new SimpleDateFormat("dd.MM.yyyy");
            String value = formattter.format(d);
            g.setFont(font);
            g.drawString(value, offSetX + 4, offSetY);
        }
    }

    protected void drawPaDates(Graphics g, int offSetX, int offSetY) {
        this.drawPaDates(g, offSetX, offSetY, Arial10);
    }

    protected void drawStapelNumbers(Graphics g, int offSetX, int offSetY, String number) {
        this.drawImage(offSetX + 5, offSetY + 5, 8, 8, "images/mark.gif", g);
        g.setFont(Arial8);
        g.drawString(number, offSetX + 10, offSetY + 15);
    }

    protected void drawCuttingHelpers(Graphics g, int offSetX, int offSetY, int pos) {
        g.drawLine(265, offSetY, 265, offSetY + 384);
        if (pos == 0) {
            g.drawLine(0, 389, 550, 389);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void Formular_A_Freitext(Graphics g, int position, String value, int printmodus) {
        block8: {
            OffSetX = 0;
            OffSetY = 0;
            locFreitext = "";
            tmp = "";
            if (printmodus < 4) {
                locFreitext = value;
            }
            if (position == 0) {
                OffSetX = 0;
                OffSetY = 0;
            } else if (position == 1) {
                OffSetX = 275;
                OffSetY = 0;
            } else if (position == 2) {
                OffSetX = 0;
                OffSetY = 394;
            } else {
                OffSetX = 275;
                OffSetY = 394;
            }
            g.setFont(PrintAZ.freitextFont);
            OffSetX += 15;
            OffSetY += 128;
            locFreitext = this.insertCRLFSequence(locFreitext, 260, PrintAZ.freitextFont);
            t = new StringTokenizer(locFreitext, "\n");
            if (t.countTokens() != 0) ** GOTO lbl32
            g.drawString(locFreitext, OffSetX, OffSetY);
            break block8;
lbl-1000:
            // 1 sources

            {
                tmp = t.nextToken();
                g.drawString(tmp, OffSetX, OffSetY);
                OffSetY += 15;
lbl32:
                // 2 sources

                ** while (t.hasMoreTokens())
            }
        }
    }

    public static boolean isFlgDruckASLeitregion() {
        return flgDruckASLeitregion;
    }

    public static boolean isFlgDruckAuftragsbezeichnung() {
        return flgDruckAuftragsbezeichnung;
    }

    public static boolean isFlgDruckOhneGrafik() {
        return flgDruckOhneGrafik;
    }

    public static boolean isFlgDruckPaletteNr() {
        return flgDruckPaletteNr;
    }

    public static boolean isFlgDruckStapel() {
        return flgDruckStapel;
    }

    public static boolean isFlgDruckVariableAngaben() {
        return flgDruckVariableAngaben;
    }

    public static boolean isFlgDruckZbnZusatz() {
        return flgDruckZbnZusatz;
    }

    public static void setFlgDruckASLeitregion(boolean b) {
        flgDruckASLeitregion = b;
    }

    public static void setFlgDruckAuftragsbezeichnung(boolean b) {
        flgDruckAuftragsbezeichnung = b;
        if (b) {
            PSO.cc.SendMessage(47, "1");
        } else {
            PSO.cc.SendMessage(47, "0");
        }
    }

    public static void setFlgDruckOhneGrafik(boolean b) {
        flgDruckOhneGrafik = b;
    }

    public static void setFlgDruckPaletteNr(boolean b) {
        flgDruckPaletteNr = b;
    }

    public static void setFlgDruckStapel(boolean b) {
        flgDruckStapel = b;
    }

    public static void setFlgDruckVariableAngaben(boolean b) {
        flgDruckVariableAngaben = b;
    }

    public static void setFlgDruckZbnZusatz(boolean b) {
        flgDruckZbnZusatz = b;
    }

    public static void resetFlags() {
        flgDruckAuftragsbezeichnung = false;
        flgDruckVariableAngaben = false;
        flgDruckASLeitregion = false;
        flgDruckOhneGrafik = false;
        flgDruckStapel = false;
        flgDruckPaletteNr = false;
        flgDruckZbnZusatz = false;
    }

    public static Font getFreitextFont() {
        return freitextFont;
    }

    public static void setFreitextFont(Font f) {
        freitextFont = f;
    }

    public static void resetBundleCnt() {
        bundleCnt = 0;
    }
}

