/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.printj2;

import com.lowagie.text.Annotation;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.print.PrinterGraphics;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import prospektservice.Feedback;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.base.BrowserLauncher;
import prospektservice.base.PSFileFilter;
import prospektservice.base.progress.ProgressDialog;
import prospektservice.base.progress.ProgressEvent;
import prospektservice.base.progress.VolumeProgressDialog;

public class PDFPrinterGraphics
extends Graphics
implements PrinterGraphics {
    public static final int ORIENTATION_PORTRAIT = 0;
    public static final int ORIENTATION_LANDSCAPE = 1;
    public static final int CANCEL_PDF = 0;
    public static final int SAVE_PDF = 1;
    public static final int EXISTS_PDF = 2;
    private int fileChooserResult = 0;
    private int pdfOrientation = 0;
    private static final String PDF_STD_TITLE = "POSTAKTUELL MANAGER Dokument";
    private static final int PDF_MARGIN_X = 25;
    private static final int PDF_MARGIN_Y = 25;
    private int pdfDocPages = 0;
    private int pdfDocActPage = 1;
    private String pdfFilename;
    private VolumeProgressDialog progressDialog;
    private Document doc;
    private PdfWriter writer;
    private static boolean isPdfGfx = false;
    private static boolean isPdfOpen = true;
    private PdfContentByte cb;
    private BaseFont bf;
    private int pdfFontSize;
    private PrinterJob myPrinterJob;
    boolean pdfMultiDoc = false;
    boolean isAutoSplitDocument = false;

    public boolean initPdf(int orientation, int docPageCnt) {
        this.pdfOrientation = orientation;
        this.pdfDocActPage = 1;
        this.pdfDocPages = docPageCnt;
        return this.newPdfDoc();
    }

    public boolean initPdf(int orientation, int docPageCnt, String fileName) {
        this.pdfOrientation = orientation;
        this.pdfDocActPage = 1;
        this.pdfDocPages = docPageCnt;
        return this.newPdfDoc(fileName);
    }

    @Override
    public void dispose() {
        if (this.pdfDocActPage == this.pdfDocPages || this.pdfDocPages == 0) {
            if (this.doc.isOpen()) {
                PSEnvironment.printDebugMessage("GraphicManager", "Closing Pdf-Document " + this.pdfFilename);
                this.doc.close();
                this.pdfDocPages = 0;
                this.pdfDocActPage = 1;
                if (PSO.mainpanel.getPsc().getOpenPdf()) {
                    try {
                        BrowserLauncher.openURL(this.pdfFilename);
                    }
                    catch (IOException ioEx) {
                        ioEx.printStackTrace();
                    }
                }
            }
        } else if (!this.pdfMultiDoc) {
            this.NewPage();
        }
    }

    public void NewPage() {
        try {
            if (PSEnvironment.isMacOSPlatform()) {
                PSEnvironment.manuellfreeMemory();
            } else {
                PSEnvironment.freeMemory();
            }
            this.doc.newPage();
            ++this.pdfDocActPage;
        }
        catch (DocumentException docEx) {
            docEx.printStackTrace();
        }
    }

    public void setPageOrientation(int orientation) {
        this.doc.setPageSize(orientation == 0 ? PageSize.A4 : PageSize.A4.rotate());
    }

    public PdfContentByte getPdfContentByte() {
        return this.cb;
    }

    public Document getPdfDocument() {
        return this.doc;
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.cb.moveTo((float)this.getPdfCoordX(x1), (float)this.getPdfCoordY(y1));
        this.cb.lineTo((float)this.getPdfCoordX(x2), (float)this.getPdfCoordY(y2));
        this.cb.stroke();
    }

    public void setLineDash(float dash, float end, float phase) {
        this.cb.setLineDash(dash, end, phase);
    }

    public void setLineWidth(float width) {
        this.cb.setLineWidth(width);
    }

    public void setHorizontalScaling(float factor) {
        this.cb.setHorizontalScaling(factor);
    }

    @Override
    public void drawRect(int x1, int y1, int x2, int y2) {
        this.cb.rectangle((float)this.getPdfCoordX(x1), (float)this.getPdfCoordY(y1 + y2), (float)x2, (float)y2);
        this.cb.stroke();
    }

    @Override
    public void fillRect(int x1, int y1, int x2, int y2) {
        this.cb.rectangle((float)this.getPdfCoordX(x1), (float)this.getPdfCoordY(y1 + y2), (float)x2, (float)y2);
        this.cb.fillStroke();
    }

    @Override
    public void drawOval(int x1, int y1, int x2, int y2) {
        this.cb.ellipse((float)this.getPdfCoordX(x1), (float)this.getPdfCoordY(y1), (float)this.getPdfCoordX(x1 + x2), (float)this.getPdfCoordY(y1 + y2));
        this.cb.stroke();
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.cb.beginText();
        this.cb.setFontAndSize(this.bf, (float)this.pdfFontSize);
        this.cb.setTextMatrix((float)this.getPdfCoordX(x), (float)this.getPdfCoordY(y));
        this.cb.showText(str);
        this.cb.endText();
    }

    public void drawString(String str, float spacing, int x, int y) {
        try {
            this.cb.beginText();
            this.cb.setFontAndSize(this.bf, (float)this.pdfFontSize);
            this.cb.setTextMatrix((float)this.getPdfCoordX(x), (float)this.getPdfCoordY(y));
            this.cb.setCharacterSpacing(spacing);
            this.cb.showText(str);
            this.cb.endText();
            this.cb.setCharacterSpacing(0.0f);
        }
        catch (Exception ex) {
            ex.getMessage();
            ex.printStackTrace();
        }
    }

    @Override
    public void drawChars(char[] data, int offset, int length, int x, int y) {
        String strPrintText = "";
        int i = offset;
        while (i < length) {
            strPrintText = String.valueOf(strPrintText) + data[i];
            ++i;
        }
        this.drawString(strPrintText, x, y);
    }

    public void drawImage(int x1, int y1, int x2, int y2, Image img) {
        try {
            com.lowagie.text.Image pdfImg = com.lowagie.text.Image.getInstance((Image)img, null);
            pdfImg.setAbsolutePosition((float)this.getPdfCoordX(x1), (float)this.getPdfCoordY(y1 + y2));
            pdfImg.scaleAbsolute((float)x2, (float)y2);
            this.cb.addImage(pdfImg);
            pdfImg = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void drawImage(int x1, int y1, int x2, int y2, String Filename) {
        try {
            if (Filename.endsWith(".bmp")) {
                Filename = String.valueOf(Filename.substring(0, Filename.lastIndexOf("."))) + ".gif";
            }
            if (Filename.indexOf(PSEnvironment.getPSStdPath()) < 0) {
                Filename = String.valueOf(PSEnvironment.getPSStdPath()) + Filename;
            }
            File bla = new File(Filename);
            try {
                Filename = bla.getCanonicalPath();
                if (bla.exists()) {
                    Image awtImg = Toolkit.getDefaultToolkit().getImage(Filename);
                    com.lowagie.text.Image img = com.lowagie.text.Image.getInstance((Image)awtImg, null);
                    img.setAbsolutePosition((float)this.getPdfCoordX(x1), (float)this.getPdfCoordY(y1 + y2));
                    img.scaleAbsolute((float)x2, (float)y2);
                    this.cb.addImage(img);
                    awtImg = null;
                    img = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            bla = null;
        }
        catch (DocumentException docEx) {
            docEx.printStackTrace();
        }
    }

    public void drawImageLink(int x1, int y1, int x2, int y2, String fileName, String url) {
        try {
            if (fileName.endsWith(".bmp")) {
                fileName = String.valueOf(fileName.substring(0, fileName.lastIndexOf("."))) + ".gif";
            }
            if (fileName.indexOf(PSEnvironment.getPSStdPath()) < 0) {
                fileName = String.valueOf(PSEnvironment.getPSStdPath()) + fileName;
            }
            File bla = new File(fileName);
            try {
                fileName = bla.getCanonicalPath();
                if (bla.exists()) {
                    Image awtImg = Toolkit.getDefaultToolkit().getImage(fileName);
                    com.lowagie.text.Image img = com.lowagie.text.Image.getInstance((Image)awtImg, null);
                    img.setAbsolutePosition((float)this.getPdfCoordX(x1), (float)this.getPdfCoordY(y1 + y2));
                    img.scaleAbsolute((float)x2, (float)y2);
                    img.setAnnotation(new Annotation(0.0f, 0.0f, 0.0f, 0.0f, url));
                    this.doc.add((Element)img);
                    awtImg = null;
                    img = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            bla = null;
        }
        catch (DocumentException docEx) {
            docEx.printStackTrace();
        }
    }

    public void drawAngledString(String str, int x, int y, float angle) {
        this.cb.beginText();
        double radian = Math.toRadians(angle);
        this.cb.setTextMatrix((float)Math.cos(radian), (float)Math.sin(radian), -((float)Math.sin(radian)), (float)Math.cos(radian), (float)this.getPdfCoordX(x), (float)this.getPdfCoordY(y));
        this.cb.setFontAndSize(this.bf, (float)this.pdfFontSize);
        this.cb.showText(str);
        this.cb.endText();
    }

    public void drawCondensedString(String str, int x, int y, float xScale, float yScale) {
        this.cb.beginText();
        this.cb.setTextMatrix(xScale, 0.0f, 0.0f, yScale, (float)this.getPdfCoordX(x), (float)this.getPdfCoordY(y));
        this.cb.setFontAndSize(this.bf, (float)this.pdfFontSize);
        this.cb.showText(str);
        this.cb.endText();
    }

    public int getFontSize() {
        return this.pdfFontSize;
    }

    @Override
    public void setClip(int x1, int y1, int x2, int y2) {
    }

    @Override
    public void translate(int x, int y) {
    }

    @Override
    public void setColor(Color AColor) {
        this.cb.setColorStroke(AColor);
        this.cb.setColorFill(AColor);
    }

    @Override
    public void setFont(Font AFont) {
        try {
            this.bf = AFont.getFamily().startsWith("Arial") || !PSEnvironment.isWindowsPlatform() ? BaseFont.createFont((String)(AFont.isBold() ? "Helvetica-Bold" : "Helvetica"), (String)"Cp1252", (boolean)false) : BaseFont.createFont((String)(AFont.isBold() ? "Courier-Bold" : "Courier"), (String)"Cp1252", (boolean)false);
            this.pdfFontSize = AFont.getSize();
        }
        catch (DocumentException docEx) {
            docEx.printStackTrace();
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
        }
    }

    public int getFontWidth(String str) {
        return (int)this.bf.getWidthPoint(str, (float)this.pdfFontSize);
    }

    @Override
    public Graphics create() {
        return null;
    }

    @Override
    public java.awt.Rectangle getClipBounds() {
        return null;
    }

    @Override
    public void setXORMode(Color c1) {
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        this.drawImage(x, y, width, height, img);
        return true;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return true;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return true;
    }

    @Override
    public void setClip(Shape clip) {
    }

    @Override
    public Shape getClip() {
        return null;
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
    }

    @Override
    public Color getColor() {
        return null;
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public Font getFont() {
        return null;
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return super.getFontMetrics();
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
    }

    private void setPdfOutputFile() throws DocumentException, IOException {
        String filename = "";
        final JFileChooser chooser = new JFileChooser();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        PSFileFilter filter = new PSFileFilter("pdf Dateien|pdf");
        chooser.addChoosableFileFilter(filter);
        chooser.setFileFilter(filter);
        String defaultPath = PSEnvironment.getPSClientProperty("PS.PdfOutputDir", String.valueOf(PSEnvironment.getPSPath()) + "/dokumente");
        File f = new File(defaultPath);
        if (!f.exists()) {
            f.mkdir();
        }
        chooser.setCurrentDirectory(f);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (chooser.showSaveDialog(PSO.mainpanel) == 0) {
                        File file = chooser.getSelectedFile();
                        if (file.exists()) {
                            int fb = Feedback.showQuestion((Component)PSO.mainpanel, 13);
                            if (fb == 1) {
                                PDFPrinterGraphics.this.fileChooserResult = 2;
                            } else {
                                PDFPrinterGraphics.this.pdfFilename = file.getAbsolutePath();
                                if (!PDFPrinterGraphics.this.pdfFilename.endsWith(".pdf")) {
                                    PDFPrinterGraphics pDFPrinterGraphics = PDFPrinterGraphics.this;
                                    pDFPrinterGraphics.pdfFilename = String.valueOf(pDFPrinterGraphics.pdfFilename) + ".pdf";
                                }
                                PDFPrinterGraphics.this.fileChooserResult = 1;
                            }
                        } else {
                            PDFPrinterGraphics.this.pdfFilename = file.getAbsolutePath();
                            if (!PDFPrinterGraphics.this.pdfFilename.endsWith(".pdf")) {
                                PDFPrinterGraphics pDFPrinterGraphics = PDFPrinterGraphics.this;
                                pDFPrinterGraphics.pdfFilename = String.valueOf(pDFPrinterGraphics.pdfFilename) + ".pdf";
                            }
                            if (!PDFPrinterGraphics.this.isLegalFilename(file.getName())) {
                                Feedback.showMessage(PSO.mainpanel, 69);
                                PDFPrinterGraphics.this.fileChooserResult = 2;
                            } else {
                                PDFPrinterGraphics.this.fileChooserResult = 1;
                            }
                        }
                    } else {
                        PDFPrinterGraphics.this.fileChooserResult = 0;
                    }
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean isLegalFilename(String name) {
        String illegalChars = "\"~#%&*:<>?/\\{|}";
        boolean result = true;
        int i = 0;
        while (i < name.length()) {
            if ("\"~#%&*:<>?/\\{|}".indexOf(name.charAt(i)) > -1) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    private boolean newPdfDoc() {
        int fileResult = 2;
        boolean fileOverwrite = false;
        try {
            while (fileResult == 2) {
                this.setPdfOutputFile();
                fileResult = this.fileChooserResult;
            }
            if (this.fileChooserResult == 1) {
                PSEnvironment.printDebugMessage("GraphicManager", "Creating new Pdf-Document " + this.pdfFilename);
                this.doc = new Document(this.pdfOrientation == 0 ? PageSize.A4 : PageSize.A4.rotate());
                if (this.isAutoSplitDocument) {
                    String ext = "_" + PSEnvironment.Format(1L, "0000") + "_" + PSEnvironment.Format(500L, "0000") + ".pdf";
                    String shortName = this.pdfFilename.substring(0, this.pdfFilename.length() - 4);
                    this.pdfFilename = String.valueOf(shortName) + ext;
                }
                this.writer = PdfWriter.getInstance((Document)this.doc, (OutputStream)new FileOutputStream(this.pdfFilename));
                this.writer.setViewerPreferences(65536);
                this.doc.addCreator("Prospektservice Online");
                this.doc.addAuthor("Deutsche Post AG");
                this.doc.addTitle(PDF_STD_TITLE);
                this.doc.open();
                this.cb = this.writer.getDirectContent();
                if (this.pdfDocPages > 0) {
                    this.createPdfProgressDlg(this.pdfDocPages);
                }
                return true;
            }
            return false;
        }
        catch (DocumentException docEx) {
            docEx.printStackTrace();
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
            Feedback.showMessage((Component)PSO.mainpanel, 41, this.pdfFilename);
        }
        return false;
    }

    public boolean newPdfDoc(String fileName) {
        boolean result = false;
        try {
            this.pdfFilename = fileName;
            PSEnvironment.printDebugMessage("GraphicManager", "Creating new Pdf-Document " + this.pdfFilename);
            this.doc = new Document(this.pdfOrientation == 0 ? PageSize.A4 : PageSize.A4.rotate());
            this.writer = PdfWriter.getInstance((Document)this.doc, (OutputStream)new FileOutputStream(this.pdfFilename));
            this.writer.setViewerPreferences(65536);
            this.doc.addCreator("Prospektservice Online");
            this.doc.addAuthor("Deutsche Post AG");
            this.doc.addTitle(PDF_STD_TITLE);
            this.doc.open();
            this.cb = this.writer.getDirectContent();
            if (this.pdfDocPages > 0) {
                this.createPdfProgressDlg(this.pdfDocPages);
            }
            return true;
        }
        catch (DocumentException docEx) {
            docEx.printStackTrace();
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
            Feedback.showMessage((Component)PSO.mainpanel, 41, this.pdfFilename);
        }
        return false;
    }

    public static void enablePdfOutput(boolean enable) {
        isPdfGfx = enable;
    }

    public static void enablePdfOpen(boolean enable) {
        isPdfOpen = enable;
    }

    private int getPdfCoordY(int y) {
        Rectangle pageRect = this.doc.getPageSize();
        return (int)pageRect.getTop() - (y + 25);
    }

    private int getPdfCoordX(int x) {
        return x + 25;
    }

    public void setPdfMaxPage(int pages) {
        this.pdfDocPages = pages;
    }

    public int getPdfMaxPage() {
        return this.pdfDocPages;
    }

    private void setPdfStdEncryption() throws DocumentException {
        this.writer.setEncryption(false, null, null, 2580);
    }

    private void createPdfProgressDlg(long count) {
        this.progressDialog = new VolumeProgressDialog(PSO.mainpanel, true, false, count, 10, false){

            @Override
            public void progressDialogStarted(ProgressEvent ppe) {
            }

            @Override
            public void progressDialogBroken(ProgressEvent ppe) {
            }

            @Override
            public void progressDialogChanged(ProgressEvent ppe) {
                PDFPrinterGraphics.this.progressDialog.setProgressValue(PDFPrinterGraphics.this.pdfDocActPage);
                PDFPrinterGraphics.this.progressDialog.setProgressLabel("Seite " + PDFPrinterGraphics.this.pdfDocActPage + " / " + PDFPrinterGraphics.this.pdfDocPages);
                PDFPrinterGraphics.this.progressDialog.showProgressDialog();
                if (PDFPrinterGraphics.this.pdfDocActPage == PDFPrinterGraphics.this.pdfDocPages || PDFPrinterGraphics.this.pdfDocPages == 0) {
                    PDFPrinterGraphics.this.progressDialog.closeProgressDialog();
                }
            }

            @Override
            public void progressDialogEndet(ProgressEvent ppe) {
            }
        };
        this.progressDialog.setPureVolumeProgress(true);
        this.progressDialog.setProgressTitle("Exportiere pdf...");
        this.progressDialog.setProgressLabel("Seite " + this.pdfDocActPage + " / " + this.pdfDocPages);
        ProgressDialog.debugMessageEnabled = PSEnvironment.DEBUG;
        this.progressDialog.run();
        this.progressDialog.setActionButtonVisible(false);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
    }

    @Override
    public PrinterJob getPrinterJob() {
        return this.myPrinterJob;
    }

    public void setPrinterJob(PrinterJob pj) {
        this.myPrinterJob = pj;
    }

    public boolean isPdfMultiDoc() {
        return this.pdfMultiDoc;
    }

    public void setPdfMultiDoc(boolean pdfMultiDoc) {
        this.pdfMultiDoc = pdfMultiDoc;
    }

    public String getPdfFileName() {
        return this.pdfFilename;
    }

    public boolean isAutoSplitDocument() {
        return this.isAutoSplitDocument;
    }

    public void setAutoSplitDocument(boolean isAutoSplitDocument) {
        this.isAutoSplitDocument = isAutoSplitDocument;
    }
}

