/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.mdbimport;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;
import prospektservice.Feedback;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.PSUser;
import prospektservice.base.PSFileFilter;
import prospektservice.dialog.DlgShowJobInfo;
import prospektservice.dialog.DlgTASelect;
import prospektservice.mdbimport.MdbImportWin32;
import prospektservice.mdbimport.PSJobImporter;
import prospektservice.mdbimport.PSJobImporterBFAH;
import prospektservice.mdbimport.PSJobImporterOrt;
import prospektservice.mdbimport.PSJobImporterZSP;

public class PSJobImporterFactory {
    private static Connection con;
    private static PSJobImporter actImporter;
    private static Vector<Vector> unresolvedRecords;
    private static int jobID;
    private static boolean cancelled;
    private static String jobname;
    private static boolean ignoreJobID;

    static {
        cancelled = false;
        jobname = "";
        ignoreJobID = false;
    }

    public static void importJob() {
        try {
            jobname = "";
            String jobFile = PSJobImporterFactory.getFileName();
            if (jobFile.length() > 0) {
                con = MdbImportWin32.openMdbFile(jobFile);
                unresolvedRecords = new Vector();
                PSJobImporterFactory.showTASelection();
                if (jobID < 1) {
                    jobID = 1;
                }
                PSJobImporterFactory.showJobStats();
                if (cancelled) {
                    con.close();
                    cancelled = false;
                    return;
                }
                int type = PSJobImporterFactory.getJobType();
                if (type >= 0) {
                    switch (type) {
                        case 0: 
                        case 1: {
                            actImporter = new PSJobImporterOrt(con, jobID, ignoreJobID);
                            break;
                        }
                        case 3: {
                            actImporter = new PSJobImporterZSP(con, jobID, ignoreJobID);
                            break;
                        }
                        case 4: {
                            actImporter = new PSJobImporterBFAH(con, jobID, ignoreJobID);
                        }
                    }
                } else {
                    Feedback.showMessage(PSO.mainpanel, 47);
                }
                con.close();
                PSO.cc.SendMessage(268, "");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static String getFileName() {
        String result = "";
        try {
            JFileChooser chooser = new JFileChooser();
            File f = new File(PSEnvironment.getPSPath());
            chooser.setCurrentDirectory(f);
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            PSFileFilter filter2 = new PSFileFilter("Prospektservice 2009 Auftr\u00e4ge|p09");
            chooser.addChoosableFileFilter(filter2);
            PSFileFilter filter = new PSFileFilter("Prospektservice 2008 Auftr\u00e4ge|p08");
            chooser.addChoosableFileFilter(filter);
            int returnVal = chooser.showOpenDialog(PSO.mainpanel);
            if (returnVal == 0) {
                result = chooser.getSelectedFile().getAbsolutePath();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getJobType() {
        int result = -1;
        try {
            String sql = "Select * From Auftragseinstellungen Where RefAuftragsID=" + jobID;
            PreparedStatement ps = con.prepareStatement(sql);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt("Anzeige");
                if (result != PSO.Modus && PSO.mainpanel.switchModus(result) != 0) {
                    return -1;
                }
                PSJobImporterFactory.importJobSettings(rs);
            }
            ps.close();
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private static void importJobSettings(ResultSet rs) {
        try {
            PSO.mainpanel.AE.txtBezeichnung.setText(jobname);
            PSO.mainpanel.setWindowTitle(jobname);
            int pwAn = rs.getInt("PostwurfAn");
            if (pwAn == 3 && !PSUser.isSaemtlicheHHAktiv()) {
                pwAn = 0;
            }
            PSO.mainpanel.AE.setServerPostwurfAn(pwAn);
            PSO.mainpanel.AE.setGewicht("" + rs.getInt("Einzelgewicht"));
            PSO.mainpanel.AE.handleEventEinzelgewicht();
            PSO.mainpanel.AE.setAnzahlVE("" + rs.getInt("AnzahlSdg"));
            int gebModus = rs.getInt("Gebindemodus");
            PSO.mainpanel.AE.YoReloadAuftrag("" + gebModus);
            if (gebModus == 0) {
                PSO.cc.SendMessage(58, "0");
                PSO.mainpanel.AE.setToleranz("" + rs.getInt("GebindemodusWert"));
                PSO.mainpanel.AE.handleEventToleranz();
            } else if (gebModus == 1) {
                PSO.cc.SendMessage(58, "1");
                PSO.mainpanel.AE.setRundung("" + rs.getInt("GebindemodusWert"));
                PSO.mainpanel.AE.handleEventAbrunden();
            }
            boolean absEinl = rs.getBoolean("AbsGleichEin");
            PSO.mainpanel.AE.abs_gleich.setSelected(absEinl);
            int zp = rs.getInt("Zahlungspflichtiger");
            if (zp == 0) {
                zp = 1;
            } else if (zp == 1) {
                zp = 0;
            }
            PSO.mainpanel.AE.setZahlungspflichtiger(zp, false);
            String bankData = String.valueOf(PSJobImporterFactory.checkNullStr(rs.getString("Geldinstitut"))) + "|" + PSJobImporterFactory.checkNullStr(rs.getString("Kontobezeichnung")) + "|" + PSJobImporterFactory.checkNullStr(String.valueOf(rs.getString("KNNR")) + "|" + PSJobImporterFactory.checkNullStr(rs.getString("BLZ"))) + "|" + PSJobImporterFactory.checkNullStr(String.valueOf(rs.getString("IBAN")) + "|" + PSJobImporterFactory.checkNullStr(rs.getString("BIC")));
            String absender = PSJobImporterFactory.checkNullStr(rs.getString("Absender"));
            absender = String.valueOf(absender) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("AOrt"));
            absender = String.valueOf(absender) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("AStra\u00dfe"));
            absender = String.valueOf(absender) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("APLZ"));
            absender = String.valueOf(absender) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("APPLZ"));
            absender = String.valueOf(absender) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("APNr"));
            absender = String.valueOf(absender) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("APOrt"));
            absender = String.valueOf(absender) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("ALand"));
            absender = String.valueOf(absender) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("ATelefon"));
            absender = String.valueOf(absender) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("AKDNR"));
            absender = String.valueOf(absender) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("AErg\u00e4nzungsnummer"));
            absender = String.valueOf(absender) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("AKartennummer"));
            if (zp == 0) {
                absender = String.valueOf(absender) + " |" + bankData;
            }
            PSO.mainpanel.AE.setAbsender(absender);
            if (!absEinl) {
                String einlieferer = PSJobImporterFactory.checkNullStr(rs.getString("Einlieferer"));
                einlieferer = String.valueOf(einlieferer) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("Ort"));
                einlieferer = String.valueOf(einlieferer) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("Stra\u00dfe"));
                einlieferer = String.valueOf(einlieferer) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("PLZ"));
                einlieferer = String.valueOf(einlieferer) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("PPLZ"));
                einlieferer = String.valueOf(einlieferer) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("PNr"));
                einlieferer = String.valueOf(einlieferer) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("POrt"));
                einlieferer = String.valueOf(einlieferer) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("Land"));
                einlieferer = String.valueOf(einlieferer) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("Telefon"));
                einlieferer = String.valueOf(einlieferer) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("KDNR"));
                einlieferer = String.valueOf(einlieferer) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("Erg\u00e4nzungsnummer"));
                einlieferer = String.valueOf(einlieferer) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("Kartennummer"));
                if (zp == 1) {
                    einlieferer = String.valueOf(einlieferer) + " |" + bankData;
                }
                PSO.mainpanel.AE.setEinlieferer(einlieferer);
            }
            if (zp == 2) {
                String zahler = PSJobImporterFactory.checkNullStr(rs.getString("Zahler"));
                zahler = String.valueOf(zahler) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("ZOrt"));
                zahler = String.valueOf(zahler) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("ZStra\u00dfe"));
                zahler = String.valueOf(zahler) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("ZPLZ"));
                zahler = String.valueOf(zahler) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("ZPPLZ"));
                zahler = String.valueOf(zahler) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("ZPNr"));
                zahler = String.valueOf(zahler) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("ZPOrt"));
                zahler = String.valueOf(zahler) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("ZLand"));
                zahler = String.valueOf(zahler) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("ZTelefon"));
                zahler = String.valueOf(zahler) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("ZKDNR"));
                zahler = String.valueOf(zahler) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("ZErg\u00e4nzungsnummer"));
                zahler = String.valueOf(zahler) + " |" + PSJobImporterFactory.checkNullStr(rs.getString("ZKartennummer"));
                zahler = String.valueOf(zahler) + " |" + bankData;
                PSO.mainpanel.AE.setAbwZahlungspflichtiger(zahler);
            }
            PSO.mainpanel.AE.setKontoverbindung(bankData);
            PSO.mainpanel.AE.setZahlungsweise(rs.getInt("Zahlungsweise"), false);
            String actAnnahme = rs.getString("Adr_Annahmestelle").trim();
            String annahmeMode = "1";
            if (actAnnahme.equalsIgnoreCase("Ohne Auswahl") || actAnnahme.equalsIgnoreCase("Keine Auswahl")) {
                annahmeMode = "2";
            }
            PSO.mainpanel.AE.YoAnnahmeModus(annahmeMode);
            PSO.mainpanel.AE.setAnnahmestelle(actAnnahme);
            PSO.mainpanel.AE.formulareSendData();
        }
        catch (SQLException sqlEx) {
            sqlEx.printStackTrace();
        }
    }

    public static void incrementProgress(String data) {
        if (data.trim().length() > 0) {
            StringTokenizer t = new StringTokenizer(data, ";");
            while (t.hasMoreTokens()) {
                StringTokenizer t2 = new StringTokenizer(t.nextToken(), "|");
                Vector<String> v = new Vector<String>();
                if (t2.hasMoreTokens()) {
                    v.addElement(t2.nextToken());
                }
                if (t2.hasMoreTokens()) {
                    v.addElement(t2.nextToken());
                }
                unresolvedRecords.addElement(v);
            }
        }
        if (actImporter.isDone()) {
            if (unresolvedRecords.size() > 0) {
                PSO.mainpanel.psIW.buildResultsPanel(unresolvedRecords);
                PSO.mainpanel.psIW.setVisible(true);
            }
            MdbImportWin32.endImport();
        }
        actImporter.incrementProgress();
    }

    public static void setJobID(int id) {
        jobID = id;
    }

    private static void showTASelection() {
        try {
            int numTA;
            PreparedStatement ps = con.prepareStatement("Select Count(*) As AnzTA From Auftr\u00e4ge");
            ResultSet rsTA = ps.executeQuery();
            if (rsTA.next() && (numTA = rsTA.getInt("AnzTA")) > 1) {
                DlgTASelect dlgTA = new DlgTASelect();
                dlgTA.fillTAList(con);
                dlgTA.setVisible(true);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private static void showJobStats() {
        try {
            int jobModus = 0;
            Vector<String> data = new Vector<String>();
            String sql = "Select * From Auftr\u00e4ge Where AuftragsID=" + jobID;
            PreparedStatement ps = con.prepareStatement(sql);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                jobname = rs.getString("Bezeichnung");
                data.addElement(jobname);
                rs.close();
            }
            ps.close();
            sql = "Select * From Auftragseinstellungen Where RefAuftragsID=" + jobID;
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            if (rs.next()) {
                int pwAn = rs.getInt("PostwurfAn");
                String tmp = "";
                if (pwAn == 0) {
                    tmp = "Alle Haushalte";
                } else if (pwAn == 3) {
                    tmp = "S\u00e4mtliche Haushalte";
                } else if (pwAn == 1) {
                    tmp = "Haushalte mit Tagespost";
                } else if (pwAn == 2) {
                    throw new IllegalArgumentException();
                }
                data.addElement(tmp);
                jobModus = rs.getInt("Anzeige");
                if (jobModus == 0 || jobModus == 1) {
                    tmp = "Orte/Ortsteile";
                } else if (jobModus == 3) {
                    tmp = "Zustellst\u00fctzpunkte";
                } else if (jobModus == 4) {
                    tmp = "Abholst\u00fctzpunkte";
                }
                data.addElement(tmp);
                data.addElement("" + rs.getInt("Einzelgewicht"));
                data.addElement("" + rs.getInt("AnzahlSdg"));
                data.addElement("" + rs.getInt("Gebindemodus"));
                data.addElement("" + rs.getInt("GebindemodusWert"));
                rs.close();
            }
            ps.close();
            switch (jobModus) {
                case 3: {
                    sql = "Select Count(*) As AnzSel From Sel_Zustell" + (ignoreJobID ? "" : " Where RefAuftragsID=" + jobID);
                    break;
                }
                case 4: {
                    sql = "Select Count(*) As AnzSel From Sel_Abhol" + (ignoreJobID ? "" : " Where RefAuftragsID=" + jobID);
                    break;
                }
                default: {
                    sql = "Select Count(*) As AnzSel From Sel_Orte" + (ignoreJobID ? "" : " Where RefAuftragsID=" + jobID) + " And Art=2";
                    ps = con.prepareStatement(sql);
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        data.addElement("" + rs.getInt("AnzSel"));
                        rs.close();
                    }
                    sql = "Select Count(*) As AnzSel From Sel_Orte " + (ignoreJobID ? "" : " Where RefAuftragsID=" + jobID) + " And Art=5";
                }
            }
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            if (rs.next()) {
                data.addElement("" + rs.getInt("AnzSel"));
            }
            DlgShowJobInfo dlgSJI = new DlgShowJobInfo(PSO.mainpanel, true);
            dlgSJI.setData(data, jobModus);
            dlgSJI.setVisible(true);
        }
        catch (IllegalArgumentException iaEx) {
            Feedback.showMessage(PSO.mainpanel, 53);
            cancelled = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String checkNullStr(String value) {
        return value == null ? "" : value;
    }

    public static void cancelImport() {
        cancelled = true;
    }

    public static boolean isIgnoreJobID() {
        return ignoreJobID;
    }

    public static void setIgnoreJobID(boolean flag) {
        ignoreJobID = flag;
    }
}

