/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import prospektservice.PSAuftrag;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.PSUser;
import prospektservice.base.PSJCheckBox;
import prospektservice.base.SpinButton;
import prospektservice.textfield.JTextFieldFilter;
import prospektservice.textfield.PSJTextField;

@Deprecated
public class frmAutoSave
extends JDialog {
    private static final long serialVersionUID = 3762536732519707443L;
    private static final int WIDTH = 250;
    private static final int HEIGHT = 140;
    private static final String DEFAULT_AUTOSAVE_NAME = "Autosave";
    private static ResourceBundle localProperty;
    private static int storedInterval;
    private static boolean isActive;
    private PSO pso;
    private JPanel panelCenter;
    private JPanel panelBottom;
    private JPanel panelBtn;
    private JButton btnOK;
    private JButton btnCancel;
    private PSJCheckBox chkEnable;
    private JLabel lblDescription;
    private JLabel lblMinutes;
    private SpinButton spbInterval;
    private PSJTextField txtInterval;

    static {
        storedInterval = 10;
        isActive = false;
    }

    public frmAutoSave(PSO mainpanel) {
        super(mainpanel, "", true);
        this.pso = mainpanel;
        localProperty = ResourceBundle.getBundle("properties.frmAutoSave", PSUser.getLanguage());
        this.getContentPane().setLayout(new BorderLayout());
        this.setTitle(localProperty.getString("dlgTitle"));
        this.setSize(250, 140);
        this.setResizable(false);
        this.setLocationRelativeTo(this.pso);
        this.panelCenter = new JPanel();
        this.panelCenter.setLayout(new FlowLayout(1));
        this.chkEnable = new PSJCheckBox(localProperty.getString("chkEnableTxt"));
        this.chkEnable.setSelected(isActive);
        this.chkEnable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frmAutoSave.this.txtInterval.setEnabled(frmAutoSave.this.chkEnable.isSelected());
                frmAutoSave.this.spbInterval.setEnabled(frmAutoSave.this.chkEnable.isSelected());
                isActive = frmAutoSave.this.chkEnable.isSelected();
                if (isActive) {
                    frmAutoSave.this.txtInterval.setText("" + frmAutoSave.this.spbInterval.getMinSpinValue());
                }
                frmAutoSave.this.spbInterval.enableTimer(isActive);
            }
        });
        this.panelCenter.add(this.chkEnable);
        this.getContentPane().add((Component)this.panelCenter, "North");
        this.panelBottom = new JPanel();
        this.panelBottom.setLayout(new FlowLayout(1));
        this.lblDescription = new JLabel(localProperty.getString("lblDescriptionTxt"));
        this.panelBottom.add(this.lblDescription);
        this.txtInterval = new PSJTextField(new JTextFieldFilter("0123456789", 2), "0", 0);
        this.txtInterval.setHorizontalAlignment(4);
        this.txtInterval.setEnabled(isActive);
        this.txtInterval.setPreferredSize(new Dimension(20, 18));
        this.txtInterval.setText(String.valueOf(storedInterval));
        this.txtInterval.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (PSEnvironment.getIntValue(frmAutoSave.this.txtInterval.getText(), 0) < 10) {
                    frmAutoSave.this.txtInterval.setText("" + frmAutoSave.this.spbInterval.getMinSpinValue());
                }
            }
        });
        this.panelBottom.add(this.txtInterval);
        this.spbInterval = new SpinButton();
        this.spbInterval.setMinSpinValue(10);
        this.spbInterval.setMaxSpinValue(30);
        this.spbInterval.setEnabled(isActive);
        this.spbInterval.setChildField(this.txtInterval);
        this.spbInterval.enableTimer(isActive);
        this.panelBottom.add(this.spbInterval);
        this.lblMinutes = new JLabel(localProperty.getString("lblMinutesTxt"));
        this.panelBottom.add(this.lblMinutes);
        this.getContentPane().add((Component)this.panelBottom, "Center");
        this.panelBtn = new JPanel();
        this.panelBtn.setLayout(new FlowLayout(1));
        this.btnOK = new JButton("OK");
        this.btnOK.setPreferredSize(new Dimension(100, 25));
        this.btnOK.setMnemonic(this.btnOK.getText().charAt(0));
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int interval = 0;
                try {
                    if (frmAutoSave.this.chkEnable.isSelected()) {
                        interval = PSEnvironment.getIntValue(frmAutoSave.this.txtInterval.getText());
                    }
                    if (interval < frmAutoSave.this.spbInterval.getMinSpinValue()) {
                        frmAutoSave.this.txtInterval.setText("" + frmAutoSave.this.spbInterval.getMinSpinValue());
                        interval = frmAutoSave.this.spbInterval.getMinSpinValue();
                    }
                }
                catch (NumberFormatException nfEx) {
                    nfEx.printStackTrace();
                    interval = 0;
                }
                frmAutoSave.this.pso.activateAutoSave(interval > 0, interval);
                frmAutoSave.this.saveInterval(interval);
                frmAutoSave.this.dispose();
            }
        });
        this.panelBtn.add(this.btnOK);
        this.btnCancel = new JButton(localProperty.getString("btnCancelTxt"));
        this.btnCancel.setPreferredSize(new Dimension(100, 25));
        this.btnCancel.setMnemonic(this.btnCancel.getText().charAt(0));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frmAutoSave.this.dispose();
            }
        });
        this.panelBtn.add(this.btnCancel);
        this.getContentPane().add((Component)this.panelBtn, "South");
    }

    public static void autoSaveJob() {
        if (PSAuftrag.isAutosaveAllowed()) {
            PSO.cc.SendMessage(321, DEFAULT_AUTOSAVE_NAME);
        }
    }

    private void saveInterval(int interval) {
        storedInterval = interval;
        PSEnvironment.setPSClientProperty("PS.Autosave.interval", String.valueOf(interval));
    }

    public static void loadSettings(PSO psoInstance) {
        try {
            int interval = PSEnvironment.getIntValue(PSEnvironment.getPSClientProperty("PS.Autosave.interval", "10"));
            if (interval < 10 && interval > 0) {
                interval = 10;
            }
            if (interval > 0) {
                psoInstance.activateAutoSave(true, interval);
                isActive = true;
                storedInterval = interval;
            }
        }
        catch (Exception Ex) {
            return;
        }
    }

    public static boolean isAutoSaveActive() {
        return isActive;
    }
}

