/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.dialog;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.bouncycastle.util.encoders.Base64;
import prospektservice.AutoProxyHelper;
import prospektservice.ComboBoxRenderer;
import prospektservice.Feedback;
import prospektservice.PSAuftrag;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.PSUser;
import prospektservice.base.Crypt;
import prospektservice.base.PSImageIcon;
import prospektservice.base.PSJCheckBox;
import prospektservice.base.PSJRadioButton;
import prospektservice.base.PamDialog;
import prospektservice.base.SpinButton;
import prospektservice.textfield.BorderJTextField;
import prospektservice.textfield.JTextFieldFilter;
import prospektservice.textfield.PSJTextField;

public class PSOProgramOptions
extends PamDialog {
    private static final long serialVersionUID = 3257569507693049139L;
    private static final int WIDTH = 440;
    private static final int HEIGHT = 375;
    private static ResourceBundle localProperty;
    private JTabbedPane tabCtrl;
    private PSJCheckBox chkProxy;
    private JLabel lblProxy;
    private JTextField txtProxy;
    private JLabel lblProxyPort;
    private PSJCheckBox chkProxyAuth;
    private JLabel lblProxyLogin;
    private JTextField txtProxyLogin;
    private JLabel lblProxyPass;
    private JPasswordField txtProxyPass;
    private PSJCheckBox chkAutoProxy;
    private JLabel lblAutoProxy;
    private JTextField txtAutoProxyURL;
    private JTextField txtProxyPort;
    private PSJRadioButton optSSL;
    private PSJRadioButton optHttpBlowfish;
    private PSJRadioButton optHttp;
    private JLabel lblLookAndFeel;
    private JLabel txtLookAndFeelInfo;
    private ButtonGroup lnfOptions;
    private PSJRadioButton optSwing;
    private PSJRadioButton optPlatform;
    private PSJRadioButton optCustom;
    private PSJCheckBox chkDecoratedFrames;
    private JLabel lblCustomLnF;
    private JComboBox cmbCustomThemes;
    private JPanel btnPanel;
    private JButton btnOk;
    private JButton btnCancel;
    private JButton btnHelp;
    private JPanel workPanel;
    private PSJCheckBox chkUseAM;
    private PSJCheckBox chkVisualizeTASelection;
    private PSJCheckBox chkBankAccounts;
    private JLabel alphaLabel;
    private JSlider alphaSlider;
    private JTextField alphaValue;
    private static Hashtable<Integer, String> foundSkins;
    private boolean isConnectionTab = false;
    private JTextField txtHotkey;
    private int hotkey = 0;
    private int hkModifiers = 0;
    private JComboBox cmbLanguage;
    private JPanel generalPanel;
    private JPanel amPanel;
    private JLabel lblAmExplanation;
    private JLabel lblAmEkp;
    private JTextField txtAmEkp;
    private JLabel lblAmUser;
    private JTextField txtAmUser;
    private JLabel lblAmPw;
    private JPasswordField txtAmPw;
    private PSJCheckBox chkEnable;
    private PSJTextField txtInterval;
    private JLabel lblDescription;
    private SpinButton spbInterval;
    private JLabel lblMinutes;
    private static int storedInterval;
    private static boolean isActive;
    private static final String DEFAULT_AUTOSAVE_NAME = "Autosave";
    private boolean validEkp = true;

    static {
        foundSkins = new Hashtable();
        storedInterval = 10;
        isActive = false;
        PSOProgramOptions.createSkinList();
    }

    public PSOProgramOptions(Frame parent, boolean modal, boolean isStartupWizard) {
        super(parent, modal);
        localProperty = ResourceBundle.getBundle("properties.PSOProgramOptions", PSEnvironment.getEnvironmentLanguage());
        this.setSize(new Dimension(440, 375));
        this.setLocationRelativeTo(parent);
        this.setResizable(false);
        this.setTitle(localProperty.getString("WelcomeTitle"));
        this.setDefaultCloseOperation(0);
        this.workPanel = new JPanel(new BorderLayout());
        if (isStartupWizard) {
            this.setSize(new Dimension(440, 305));
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout());
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    PSOProgramOptions.this.dispose();
                    System.exit(0);
                }
            });
            JLabel lblWelcome = new JLabel(localProperty.getString("WelcomeInfo"));
            lblWelcome.setVerticalTextPosition(1);
            lblWelcome.setIcon(new PSImageIcon("./Images/logo.jpg"));
            mainPanel.add((Component)lblWelcome, "Center");
            this.btnPanel = new JPanel();
            this.btnPanel.setLayout(new FlowLayout(2));
            this.btnOk = new JButton(localProperty.getString("WelcomeOK"));
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PSOProgramOptions.this.showWelcomeConfigScreen(true);
                }
            });
            this.btnPanel.add(this.btnOk);
            this.workPanel.add((Component)mainPanel, "Center");
            this.workPanel.add((Component)this.btnPanel, "South");
            this.getContentPane().add(this.workPanel);
        } else {
            this.getContentPane().add(this.workPanel);
            this.showWelcomeConfigScreen(false);
            this.setSize(new Dimension(440, 375));
        }
    }

    private void showWelcomeConfigScreen(final boolean restart) {
        try {
            this.getContentPane().remove(this.workPanel);
            this.setSize(new Dimension(440, 355));
            this.workPanel = new JPanel(new BorderLayout());
            this.isConnectionTab = true;
            JPanel optPanel = this.buildConnectionTab();
            this.btnPanel = new JPanel();
            this.btnPanel.setLayout(new FlowLayout(2));
            JButton btnCancel = new JButton(localProperty.getString("btnCancel"));
            btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PSOProgramOptions.this.dispose();
                    System.exit(0);
                }
            });
            this.btnPanel.add(btnCancel);
            JButton btnTestConnection = new JButton(localProperty.getString("btnTestConnection"));
            btnTestConnection.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PSOProgramOptions.this.testConnectionSettings()) {
                        JOptionPane.showMessageDialog(null, localProperty.getString("connectSuccessMsg"));
                    } else {
                        JOptionPane.showMessageDialog(null, localProperty.getString("connectFailureMsg"));
                    }
                }
            });
            this.btnPanel.add(btnTestConnection);
            this.btnOk = new JButton(localProperty.getString("WelcomeOK"));
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PSOProgramOptions.this.storeSettings(false);
                    if (restart) {
                        if (!PSEnvironment.isMacOSPlatform()) {
                            PSEnvironment.restartPSO(localProperty.getString("restartMsg"));
                        } else {
                            Feedback.showMessage(PSO.mainpanel, 31);
                            System.exit(0);
                        }
                    }
                    PSOProgramOptions.this.dispose();
                }
            });
            this.btnPanel.add(this.btnOk);
            this.workPanel.add((Component)optPanel, "Center");
            this.workPanel.add((Component)this.btnPanel, "South");
            this.getContentPane().add(this.workPanel);
            this.initControls(false);
            this.validate();
            this.repaint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public PSOProgramOptions(Frame arg0, boolean arg1) throws HeadlessException {
        super(arg0, arg1);
        localProperty = ResourceBundle.getBundle("properties.PSOProgramOptions", PSUser.getLanguage());
        this.setSize(new Dimension(440, 375));
        this.setLocationRelativeTo(arg0);
        this.setResizable(false);
        this.setTitle(localProperty.getString("Title"));
        this.getContentPane().setLayout(new BorderLayout());
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                boolean keyHandled = false;
                if (PSOProgramOptions.this.tabCtrl.getSelectedIndex() == 2 && e.getID() == 401) {
                    int modMask = e.getModifiersEx();
                    int key = e.getKeyCode();
                    if ((modMask & 0x40) == 64 && (modMask & 0x200) == 512 && key == 65) {
                        PSOProgramOptions.this.chkUseAM.setVisible(!PSOProgramOptions.this.chkUseAM.isVisible());
                        keyHandled = true;
                    }
                }
                return keyHandled;
            }
        });
        this.tabCtrl = new JTabbedPane(1);
        this.tabCtrl.addTab(localProperty.getString("ConnectionTabTitle"), this.buildConnectionTab());
        this.tabCtrl.addTab(localProperty.getString("LookAndFeelTabTitle"), this.buildLookAndFeelTab());
        this.tabCtrl.addTab(localProperty.getString("GeneralTabTitle"), this.buildGeneralTab());
        if (!PSEnvironment.isGpwsClient()) {
            this.tabCtrl.addTab(localProperty.getString("AMTabTitle"), this.buildAMTab());
        }
        this.getContentPane().add((Component)this.tabCtrl, "North");
        this.btnPanel = new JPanel();
        this.btnPanel.setLayout(new FlowLayout(2));
        this.btnOk = new JButton(localProperty.getString("btnOK"));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PSOProgramOptions.this.storeSettings(true);
                if (PSOProgramOptions.this.validEkp) {
                    PSOProgramOptions.this.dispose();
                }
            }
        });
        this.btnPanel.add(this.btnOk);
        this.btnCancel = new JButton(localProperty.getString("btnCancel"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UIManager.getLookAndFeel() instanceof SkinLookAndFeel) {
                    PSOProgramOptions.this.changeTheme(PSEnvironment.getIntValue(PSEnvironment.getPSClientProperty("PS.Skin", "0")));
                }
                PSOProgramOptions.this.dispose();
            }
        });
        this.btnPanel.add(this.btnCancel);
        this.btnHelp = new JButton(localProperty.getString("btnHelp"));
        this.getContentPane().add((Component)this.btnPanel, "South");
        this.initControls(true);
    }

    private JPanel buildConnectionTab() {
        JPanel connectionPanel = new JPanel();
        connectionPanel.setLayout(null);
        connectionPanel.setPreferredSize(new Dimension(440, 255));
        JPanel proxyPanel = new JPanel();
        proxyPanel.setBounds(4, 4, 424, 210);
        proxyPanel.setLayout(null);
        proxyPanel.setBorder(new TitledBorder(localProperty.getString("ProxySettings")));
        this.chkProxy = new PSJCheckBox(localProperty.getString("chkProxy"));
        this.chkProxy.setBounds(10, 15, 150, 20);
        this.chkProxy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PSOProgramOptions.this.txtProxy.setEnabled(PSOProgramOptions.this.chkProxy.isSelected());
                PSOProgramOptions.this.txtProxyPort.setEnabled(PSOProgramOptions.this.chkProxy.isSelected());
                PSOProgramOptions.this.chkProxyAuth.setEnabled(PSOProgramOptions.this.chkProxy.isSelected());
                PSOProgramOptions.this.chkAutoProxy.setEnabled(!PSOProgramOptions.this.chkProxy.isSelected());
                if (!PSOProgramOptions.this.chkProxy.isSelected()) {
                    PSOProgramOptions.this.chkProxyAuth.setSelected(false);
                    PSOProgramOptions.this.txtProxyLogin.setEnabled(false);
                    PSOProgramOptions.this.txtProxyPass.setEnabled(false);
                }
            }
        });
        proxyPanel.add(this.chkProxy);
        this.lblProxy = new JLabel(localProperty.getString("lblProxy"));
        this.lblProxy.setHorizontalAlignment(4);
        this.lblProxy.setBounds(15, 35, 70, 20);
        proxyPanel.add(this.lblProxy);
        this.txtProxy = new JTextField();
        this.txtProxy.setBounds(90, 35, 150, 20);
        this.txtProxy.setEnabled(this.chkProxy.isSelected());
        proxyPanel.add(this.txtProxy);
        this.lblProxyPort = new JLabel(localProperty.getString("lblProxyPort"));
        this.lblProxyPort.setHorizontalAlignment(4);
        this.lblProxyPort.setBounds(15, 60, 70, 20);
        proxyPanel.add(this.lblProxyPort);
        this.txtProxyPort = new JTextField();
        this.txtProxyPort.setBounds(90, 60, 150, 20);
        this.txtProxyPort.setEnabled(this.chkProxy.isSelected());
        proxyPanel.add(this.txtProxyPort);
        this.chkProxyAuth = new PSJCheckBox(localProperty.getString("chkProxyAuth"));
        this.chkProxyAuth.setBounds(10, 85, 170, 20);
        this.chkProxyAuth.setEnabled(this.chkProxy.isSelected());
        this.chkProxyAuth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PSOProgramOptions.this.txtProxyLogin.setEnabled(PSOProgramOptions.this.chkProxyAuth.isSelected());
                PSOProgramOptions.this.txtProxyPass.setEnabled(PSOProgramOptions.this.chkProxyAuth.isSelected());
            }
        });
        proxyPanel.add(this.chkProxyAuth);
        this.lblProxyLogin = new JLabel(localProperty.getString("lblProxyLogin"));
        this.lblProxyLogin.setHorizontalAlignment(4);
        this.lblProxyLogin.setBounds(15, 105, 70, 20);
        proxyPanel.add(this.lblProxyLogin);
        this.txtProxyLogin = new JTextField();
        this.txtProxyLogin.setBounds(90, 105, 150, 20);
        this.txtProxyLogin.setEnabled(this.chkProxyAuth.isSelected());
        proxyPanel.add(this.txtProxyLogin);
        this.lblProxyPass = new JLabel(localProperty.getString("lblProxyPass"));
        this.lblProxyPass.setHorizontalAlignment(4);
        this.lblProxyPass.setBounds(15, 130, 70, 20);
        proxyPanel.add(this.lblProxyPass);
        this.txtProxyPass = new JPasswordField();
        this.txtProxyPass.setBounds(90, 130, 150, 20);
        this.txtProxyPass.setEnabled(this.chkProxyAuth.isSelected());
        proxyPanel.add(this.txtProxyPass);
        this.chkAutoProxy = new PSJCheckBox(localProperty.getString("chkAutoProxy"));
        this.chkAutoProxy.setBounds(10, 155, 300, 20);
        this.chkAutoProxy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean flag = PSOProgramOptions.this.chkAutoProxy.isSelected();
                PSOProgramOptions.this.chkProxy.setEnabled(!flag);
                PSOProgramOptions.this.chkProxyAuth.setEnabled(!flag && PSOProgramOptions.this.chkProxy.isSelected());
                if (!flag) {
                    PSOProgramOptions.this.chkProxy.setSelected(false);
                    PSOProgramOptions.this.chkProxyAuth.setSelected(false);
                    PSOProgramOptions.this.txtProxy.setEnabled(false);
                    PSOProgramOptions.this.txtProxyPort.setEnabled(false);
                    PSOProgramOptions.this.txtProxyLogin.setEnabled(false);
                    PSOProgramOptions.this.txtProxyPass.setEnabled(false);
                }
                PSOProgramOptions.this.txtAutoProxyURL.setEnabled(flag);
            }
        });
        proxyPanel.add(this.chkAutoProxy);
        this.lblAutoProxy = new JLabel(localProperty.getString("lblAutoProxy"));
        this.lblAutoProxy.setHorizontalAlignment(4);
        this.lblAutoProxy.setBounds(15, 175, 70, 20);
        proxyPanel.add(this.lblAutoProxy);
        this.txtAutoProxyURL = new JTextField();
        this.txtAutoProxyURL.setBounds(90, 175, 150, 20);
        proxyPanel.add(this.txtAutoProxyURL);
        connectionPanel.add(proxyPanel);
        JPanel sslPanel = new JPanel();
        sslPanel.setBorder(new TitledBorder(localProperty.getString("ConnectionType")));
        sslPanel.setBounds(4, 215, 424, 50);
        sslPanel.setLayout(null);
        ButtonGroup bg = new ButtonGroup();
        this.optSSL = new PSJRadioButton(localProperty.getString("optSSL"));
        this.optSSL.setBounds(55, 15, 60, 20);
        bg.add(this.optSSL);
        sslPanel.add(this.optSSL);
        this.optHttpBlowfish = new PSJRadioButton(localProperty.getString("optHTTPBlowfish"));
        this.optHttpBlowfish.setBounds(130, 15, 170, 20);
        bg.add(this.optHttpBlowfish);
        sslPanel.add(this.optHttpBlowfish);
        this.optHttp = new PSJRadioButton(localProperty.getString("optHTTP"));
        this.optHttp.setBounds(315, 15, 80, 20);
        bg.add(this.optHttp);
        sslPanel.add(this.optHttp);
        return connectionPanel;
    }

    private JPanel buildLookAndFeelTab() {
        JPanel lnfPanel = new JPanel();
        lnfPanel.setBorder(new TitledBorder("Look And Feel"));
        lnfPanel.setPreferredSize(new Dimension(430, 285));
        lnfPanel.setLayout(null);
        this.txtLookAndFeelInfo = new JLabel();
        this.txtLookAndFeelInfo.setBounds(15, 15, 405, 50);
        this.txtLookAndFeelInfo.setBackground(lnfPanel.getBackground());
        this.txtLookAndFeelInfo.setText("<html>" + localProperty.getString("lblLookAndFeelInfo") + "</html>");
        lnfPanel.add(this.txtLookAndFeelInfo);
        JPanel lfOptionPanel = new JPanel();
        lfOptionPanel.setBounds(10, 60, 410, 195);
        lfOptionPanel.setLayout(null);
        this.lnfOptions = new ButtonGroup();
        this.optSwing = new PSJRadioButton(localProperty.getString("optSwing"));
        this.optSwing.setBounds(10, 20, 130, 20);
        this.optSwing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PSOProgramOptions.this.cmbCustomThemes.setEnabled(false);
                    PSOProgramOptions.this.chkDecoratedFrames.setSelected(false);
                    PSOProgramOptions.this.chkDecoratedFrames.setEnabled(false);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.lnfOptions.add(this.optSwing);
        lfOptionPanel.add(this.optSwing);
        this.optPlatform = new PSJRadioButton(localProperty.getString("optNative"));
        this.optPlatform.setBounds(10, 40, 140, 20);
        this.optPlatform.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PSOProgramOptions.this.cmbCustomThemes.setEnabled(false);
                    if (PSOProgramOptions.this.optPlatform.isSelected()) {
                        PSOProgramOptions.this.chkDecoratedFrames.setSelected(false);
                        PSOProgramOptions.this.chkDecoratedFrames.setEnabled(false);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.lnfOptions.add(this.optPlatform);
        lfOptionPanel.add(this.optPlatform);
        this.optCustom = new PSJRadioButton(localProperty.getString("optCustom"));
        this.optCustom.setBounds(10, 60, 130, 20);
        this.optCustom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PSOProgramOptions.this.cmbCustomThemes.setEnabled(PSOProgramOptions.this.optCustom.isSelected());
                PSOProgramOptions.this.chkDecoratedFrames.setEnabled(true);
            }
        });
        this.lnfOptions.add(this.optCustom);
        lfOptionPanel.add(this.optCustom);
        JLabel lblSkinSelect = new JLabel(localProperty.getString("lblSkin"));
        this.cmbCustomThemes = new JComboBox();
        this.cmbCustomThemes.setBounds(160, 60, 150, 20);
        this.cmbCustomThemes.setEnabled(this.optCustom.isSelected());
        int i = 0;
        while (i < foundSkins.size()) {
            String skinName = foundSkins.get(new Integer(i));
            skinName = skinName.substring(0, skinName.indexOf("themepack"));
            this.cmbCustomThemes.addItem(skinName);
            ++i;
        }
        this.cmbCustomThemes.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (UIManager.getLookAndFeel() instanceof SkinLookAndFeel) {
                    PSOProgramOptions.this.changeTheme();
                }
            }
        });
        lfOptionPanel.add(this.cmbCustomThemes);
        this.chkDecoratedFrames = new PSJCheckBox(localProperty.getString("chkDecoratedFrames"));
        this.chkDecoratedFrames.setBounds(10, 90, 200, 20);
        this.chkDecoratedFrames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        lfOptionPanel.add(this.chkDecoratedFrames);
        lnfPanel.add(lfOptionPanel);
        return lnfPanel;
    }

    private JPanel buildGeneralTab() {
        this.generalPanel = new JPanel();
        this.generalPanel.setLayout(null);
        JLabel lblGeneralSettings = new JLabel(localProperty.getString("lblGeneralSettings"));
        lblGeneralSettings.setBounds(15, 5, 405, 50);
        this.generalPanel.add(lblGeneralSettings);
        PSJCheckBox chkShowStartupOptions = new PSJCheckBox(localProperty.getString("chkShowStartupOptions"));
        chkShowStartupOptions.setBounds(15, 45, 405, 20);
        String val = PSEnvironment.getPSClientProperty("PS.ShowStartupDlg");
        boolean selected = val == null ? true : val.equals("1");
        chkShowStartupOptions.setSelected(selected);
        chkShowStartupOptions.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int newVal = e.getStateChange() == 1 ? 1 : 0;
                PSEnvironment.setPSClientProperty("PS.ShowStartupDlg", String.valueOf(newVal));
            }
        });
        this.chkUseAM = new PSJCheckBox(localProperty.getString("chkUseAM"));
        this.chkUseAM.setBounds(15, 105, 405, 20);
        val = PSEnvironment.getPSClientProperty("PS.UseAM");
        selected = val == null ? true : val.equals("1");
        this.chkUseAM.setSelected(selected);
        this.chkUseAM.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int newVal = e.getStateChange() == 1 ? 1 : 0;
                PSEnvironment.setPSClientProperty("PS.UseAM", String.valueOf(newVal));
                PSO.mainpanel.AE.enableAMOptions(newVal == 1);
                PSO.mainpanel.AE.checkKKAnnahme();
                PSO.mainpanel.AE.checkKKAM();
            }
        });
        this.chkUseAM.setVisible(false);
        this.chkEnable = new PSJCheckBox(localProperty.getString("chkEnableTxt"));
        this.chkEnable.setBounds(15, 105, 210, 20);
        this.chkEnable.setSelected(isActive);
        this.chkEnable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PSOProgramOptions.this.txtInterval.setEnabled(PSOProgramOptions.this.chkEnable.isSelected());
                PSOProgramOptions.this.spbInterval.setEnabled(PSOProgramOptions.this.chkEnable.isSelected());
                isActive = PSOProgramOptions.this.chkEnable.isSelected();
                if (isActive) {
                    PSOProgramOptions.this.txtInterval.setText("" + PSOProgramOptions.this.spbInterval.getMinSpinValue());
                }
                PSOProgramOptions.this.spbInterval.enableTimer(isActive);
            }
        });
        this.lblDescription = new JLabel(localProperty.getString("lblDescriptionTxt"));
        this.lblDescription.setBounds(227, 105, 25, 20);
        this.txtInterval = new PSJTextField(new JTextFieldFilter("0123456789", 2), "0", 0);
        this.txtInterval.setHorizontalAlignment(4);
        this.txtInterval.setEnabled(isActive);
        this.txtInterval.setPreferredSize(new Dimension(20, 18));
        this.txtInterval.setText(String.valueOf(storedInterval));
        this.txtInterval.setBounds(250, 105, 20, 20);
        this.txtInterval.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (PSEnvironment.getIntValue(PSOProgramOptions.this.txtInterval.getText(), 0) < 10) {
                    PSOProgramOptions.this.txtInterval.setText("" + PSOProgramOptions.this.spbInterval.getMinSpinValue());
                }
            }
        });
        this.spbInterval = new SpinButton();
        this.spbInterval.setMinSpinValue(10);
        this.spbInterval.setMaxSpinValue(30);
        this.spbInterval.setEnabled(isActive);
        this.spbInterval.setChildField(this.txtInterval);
        this.spbInterval.setBounds(272, 105, 20, 20);
        this.spbInterval.enableTimer(isActive);
        this.lblMinutes = new JLabel(localProperty.getString("lblMinutesTxt"));
        this.lblMinutes.setBounds(295, 105, 100, 20);
        this.chkVisualizeTASelection = new PSJCheckBox(localProperty.getString("chkVisualizeTASelection"));
        this.chkVisualizeTASelection.setBounds(15, 65, 405, 20);
        val = PSEnvironment.getPSClientProperty("PS.VisualizeTASelection");
        selected = val == null ? true : val.equals("1");
        this.chkVisualizeTASelection.setSelected(selected);
        this.chkVisualizeTASelection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int newVal = e.getStateChange() == 1 ? 1 : 0;
                PSEnvironment.setPSClientProperty("PS.VisualizeTASelection", String.valueOf(newVal));
            }
        });
        this.chkBankAccounts = new PSJCheckBox(localProperty.getString("chkBankAccounts"));
        this.chkBankAccounts.setBounds(15, 85, 405, 20);
        val = PSEnvironment.getPSClientProperty("PS.CheckBankAccounts", "1");
        selected = val == null ? true : val.equals("1");
        this.chkBankAccounts.setSelected(selected);
        this.chkBankAccounts.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int newVal = e.getStateChange() == 1 ? 1 : 0;
                PSEnvironment.setPSClientProperty("PS.CheckBankAccounts", String.valueOf(newVal));
            }
        });
        this.generalPanel.add(chkShowStartupOptions);
        this.generalPanel.add(this.chkVisualizeTASelection);
        this.generalPanel.add(this.chkBankAccounts);
        this.generalPanel.add(this.chkEnable);
        this.generalPanel.add(this.lblDescription);
        this.generalPanel.add(this.txtInterval);
        this.generalPanel.add(this.spbInterval);
        this.generalPanel.add(this.lblMinutes);
        JLabel alphaExplanation = new JLabel();
        alphaExplanation.setText(localProperty.getString("alphaExplanation"));
        alphaExplanation.setBounds(15, 105, 405, 40);
        JPanel alphaPanel = new JPanel();
        alphaPanel.setBounds(15, 140, 405, 50);
        alphaPanel.add(Box.createHorizontalGlue());
        alphaPanel.setLayout(new BoxLayout(alphaPanel, 0));
        this.alphaLabel = new JLabel("A");
        alphaPanel.add(this.alphaLabel);
        this.alphaSlider = new JSlider(0, 0, 255, PSEnvironment.globalAlpha);
        this.alphaSlider.setMajorTickSpacing(85);
        this.alphaSlider.setMinorTickSpacing(17);
        this.alphaSlider.setPaintTicks(true);
        this.alphaSlider.setPaintLabels(true);
        this.alphaSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                int actValue = PSOProgramOptions.this.alphaSlider.getValue();
                PSOProgramOptions.this.alphaValue.setText("" + actValue);
            }
        });
        this.alphaLabel.setLabelFor(this.alphaSlider);
        alphaPanel.add(this.alphaSlider);
        alphaPanel.add(Box.createHorizontalGlue());
        Dimension size = new Dimension(30, 20);
        this.alphaValue = new JTextField();
        this.alphaValue.setText("" + PSEnvironment.globalAlpha);
        this.alphaValue.setHorizontalAlignment(4);
        this.alphaValue.setMaximumSize(size);
        this.alphaValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                int newChar = e.getKeyCode();
                char actChar = e.getKeyChar();
                JTextField actTxtField = (JTextField)e.getSource();
                if (!PSEnvironment.isNumeric(actChar)) {
                    e.consume();
                    return;
                }
                if (PSEnvironment.getIntValue(String.valueOf(actTxtField.getText()) + actChar) > 255) {
                    e.consume();
                    return;
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                PSOProgramOptions.this.alphaSlider.setValue(PSEnvironment.getIntValue(PSOProgramOptions.this.alphaValue.getText()));
            }
        });
        this.alphaValue.setMinimumSize(size);
        this.alphaValue.setPreferredSize(size);
        alphaPanel.add(this.alphaValue);
        alphaPanel.add(Box.createHorizontalGlue());
        JLabel hotkeyExplanation = new JLabel();
        hotkeyExplanation.setText(localProperty.getString("deathHotkeyExplanation"));
        hotkeyExplanation.setBounds(15, 130, 405, 40);
        this.generalPanel.add(hotkeyExplanation);
        this.txtHotkey = new JTextField();
        this.hotkey = PSEnvironment.hotkey;
        this.hkModifiers = PSEnvironment.hkModifiers;
        this.txtHotkey.setText(this.getKeyDiplayString());
        this.txtHotkey.setBounds(15, 170, 250, 20);
        this.txtHotkey.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                e.consume();
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                PSOProgramOptions.this.hotkey = e.getKeyCode();
                PSOProgramOptions.this.hkModifiers = e.getModifiersEx();
                PSOProgramOptions.this.txtHotkey.setText(PSOProgramOptions.this.getKeyDiplayString());
            }
        });
        this.generalPanel.add(this.txtHotkey);
        PSImageIcon[] languages = new PSImageIcon[2];
        languages[0] = new PSImageIcon("images/langID1.gif");
        languages[0].setDescription("Deutsch");
        languages[1] = new PSImageIcon("images/langID2.gif");
        languages[1].setDescription("English");
        JLabel lblLanguage = new JLabel(localProperty.getString("lblLanguage"));
        lblLanguage.setBounds(15, 200, 405, 20);
        this.generalPanel.add(lblLanguage);
        this.cmbLanguage = new JComboBox<PSImageIcon>(languages);
        this.cmbLanguage.setBackground(Color.white);
        ComboBoxRenderer comboBoxRendererLanguages = new ComboBoxRenderer();
        this.cmbLanguage.setRenderer(comboBoxRendererLanguages);
        this.cmbLanguage.setSelectedIndex(PSUser.getLanguage() == Locale.GERMAN ? 0 : 1);
        this.cmbLanguage.setPreferredSize(new Dimension(40, 20));
        this.cmbLanguage.setMinimumSize(new Dimension(30, 20));
        this.cmbLanguage.setMaximumSize(new Dimension(40, 20));
        this.cmbLanguage.setBounds(15, 220, 100, 20);
        this.cmbLanguage.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int actIndex = PSOProgramOptions.this.cmbLanguage.getSelectedIndex();
                PSUser.setLanguage(actIndex);
                PSEnvironment.setPSClientProperty("PS.Language", "" + actIndex);
                PSO.cc.SendMessage(386, "" + actIndex);
            }
        });
        this.generalPanel.add(this.cmbLanguage);
        JButton btnResetMessages = new JButton(localProperty.getString("btnResetMessages"));
        btnResetMessages.setToolTipText(localProperty.getString("btnResetMessagesTT"));
        btnResetMessages.setBounds(15, 250, 180, 25);
        btnResetMessages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PSEnvironment.setPSClientProperty("PS.NoWizardAd", "0");
                PSEnvironment.setPSClientProperty("PS.ShowAMInfo", "1");
                PSEnvironment.setPSClientProperty("PS.NoSsWarning", "0");
                PSEnvironment.setPSClientProperty("PS.NoTAInfo", "0");
                PSEnvironment.setPSClientProperty("PS.NoPPInfo", "0");
            }
        });
        this.generalPanel.add(btnResetMessages);
        return this.generalPanel;
    }

    private JPanel buildAMTab() {
        this.amPanel = new JPanel();
        this.amPanel.setLayout(null);
        this.lblAmExplanation = new JLabel(localProperty.getString("lblAmExplanation"));
        this.lblAmExplanation.setBounds(15, 5, 405, 100);
        this.amPanel.add(this.lblAmExplanation);
        this.lblAmEkp = new JLabel(localProperty.getString("lblAmEkp"));
        this.lblAmEkp.setBounds(15, 135, 100, 20);
        this.amPanel.add(this.lblAmEkp);
        this.txtAmEkp = new BorderJTextField(9, 10, 26, 1);
        this.txtAmEkp.setBounds(120, 135, 160, 20);
        this.txtAmEkp.setText(PSUser.getsubmitterEKP());
        this.txtAmEkp.addPropertyChangeListener("InputValid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PSOProgramOptions.this.validEkp = evt.getNewValue() == Boolean.TRUE;
            }
        });
        this.amPanel.add(this.txtAmEkp);
        this.lblAmUser = new JLabel(localProperty.getString("lblAmUser"));
        this.lblAmUser.setBounds(15, 165, 100, 20);
        this.amPanel.add(this.lblAmUser);
        this.txtAmUser = new JTextField();
        this.txtAmUser.setBounds(120, 165, 160, 20);
        this.txtAmUser.setText(PSUser.getsubmitterName());
        this.amPanel.add(this.txtAmUser);
        this.lblAmPw = new JLabel(localProperty.getString("lblAmPw"));
        this.lblAmPw.setBounds(15, 195, 100, 20);
        this.amPanel.add(this.lblAmPw);
        this.txtAmPw = new JPasswordField();
        this.txtAmPw.setBounds(120, 195, 160, 20);
        this.txtAmPw.setText(PSUser.getsubmitterPassword().trim());
        this.amPanel.add(this.txtAmPw);
        return this.amPanel;
    }

    private String getKeyDiplayString() {
        String keyText;
        String strDisplay = "";
        if ((this.hkModifiers & 0x80) == 128) {
            strDisplay = String.valueOf(strDisplay) + localProperty.getString("CTRL_KEY") + "+";
        }
        if ((this.hkModifiers & 0x40) == 64) {
            strDisplay = String.valueOf(strDisplay) + localProperty.getString("SHIFT_KEY") + "+";
        }
        if ((this.hkModifiers & 0x200) == 512) {
            strDisplay = String.valueOf(strDisplay) + "Alt+";
        }
        if (!((keyText = KeyEvent.getKeyText(this.hotkey)).equals("Strg") || keyText.equals("Umschalt") || keyText.equals("Alt"))) {
            strDisplay = String.valueOf(strDisplay) + keyText;
        }
        return strDisplay;
    }

    private void initControls(boolean all) {
        String autoProxy = PSEnvironment.getPSClientProperty("PS.Proxy.AutoScriptURL", "");
        this.chkAutoProxy.setSelected(autoProxy.length() > 0);
        this.txtAutoProxyURL.setEnabled(this.chkAutoProxy.isSelected());
        this.txtAutoProxyURL.setText(autoProxy);
        this.chkProxy.setSelected(PSEnvironment.getPSClientProperty("PS.UseProxy", "0").equals("1") && !this.chkAutoProxy.isSelected());
        if (this.chkProxy.isSelected()) {
            this.txtProxy.setText(PSEnvironment.getPSClientProperty("PS.Proxy.URL"));
            this.txtProxy.setEnabled(true);
            this.txtProxyPort.setText(PSEnvironment.getPSClientProperty("PS.Proxy.Port"));
            this.txtProxyPort.setEnabled(true);
            this.chkProxyAuth.setEnabled(true);
        }
        this.chkProxyAuth.setSelected(PSEnvironment.getPSClientProperty("PS.UseProxyAuth", "0").equals("1"));
        if (this.chkProxyAuth.isSelected()) {
            this.txtProxyLogin.setText(Crypt.simpleTextDecryption(PSEnvironment.getPSClientProperty("PS.Proxy.Auth.Login")));
            this.txtProxyPass.setText(Crypt.simpleTextDecryption(PSEnvironment.getPSClientProperty("PS.Proxy.Auth.Pass")));
        }
        boolean useSSL = PSEnvironment.getPSClientProperty("PS.SSL", "").equals("1");
        this.optSSL.setSelected(useSSL);
        boolean useBF = PSEnvironment.getPSClientProperty("PS.UseBF", "").equals("1");
        this.optHttpBlowfish.setSelected(useBF && !useSSL);
        this.optHttp.setSelected(!useBF && !useSSL);
        if (all) {
            int selectedLnF = PSEnvironment.getIntValue(PSEnvironment.getPSClientProperty("PS.LookAndFeel"));
            this.chkDecoratedFrames.setSelected(PSEnvironment.getPSClientProperty("PS.DecoratedFrames").equals("1") && selectedLnF != 1);
            this.chkDecoratedFrames.setEnabled(selectedLnF == 2);
            switch (selectedLnF) {
                case 0: {
                    this.optSwing.setSelected(true);
                    break;
                }
                case 1: {
                    this.optPlatform.setSelected(true);
                    break;
                }
                case 2: {
                    this.optCustom.setSelected(true);
                    this.cmbCustomThemes.setEnabled(true);
                    int currentSkin = PSEnvironment.getIntValue(PSEnvironment.getPSClientProperty("PS.Skin", "0"));
                    if (currentSkin < this.cmbCustomThemes.getItemCount()) {
                        this.cmbCustomThemes.setSelectedIndex(currentSkin);
                    }
                    this.txtLookAndFeelInfo.setBackground(this.getContentPane().getBackground());
                }
            }
        }
    }

    private boolean testConnectionSettings() {
        try {
            String ip = PSEnvironment.getPSClientProperty("PS.Server.IP");
            String port = PSEnvironment.getPSClientProperty("PS.Server.Port");
            String servlet = PSEnvironment.getPSClientProperty("PS.Server.Servlet");
            String encodedLogin = "";
            Properties sysProps = System.getProperties();
            sysProps.put("http.proxyHost", "");
            sysProps.put("http.proxyPort", "");
            sysProps.put("http.proxySet", "false");
            sysProps.put("https.proxyHost", "");
            sysProps.put("https.proxyPort", "");
            sysProps.put("https.proxySet", "false");
            if (this.chkProxy.isSelected()) {
                sysProps.put("http.proxyHost", this.txtProxy.getText());
                sysProps.put("http.proxyPort", this.txtProxyPort.getText());
                sysProps.put("http.proxySet", "true");
                sysProps.put("https.proxyHost", this.txtProxy.getText());
                sysProps.put("https.proxyPort", this.txtProxyPort.getText());
                sysProps.put("https.proxySet", "true");
            }
            if (this.chkProxyAuth.isSelected()) {
                String proxyLogin = String.valueOf(this.txtProxyLogin.getText()) + ":" + new String(this.txtProxyPass.getPassword());
                encodedLogin = new String(Base64.encode((byte[])proxyLogin.getBytes("ISO8859_1")), "ISO8859_1");
            }
            if (this.chkAutoProxy.isSelected()) {
                AutoProxyHelper.getAutomaticProxy(this.txtAutoProxyURL.getText().trim());
            }
            String urlString = "";
            if (this.optSSL.isSelected()) {
                urlString = "https://" + ip + ":" + 443 + "/" + servlet;
                HostnameVerifier hv = new HostnameVerifier(){

                    @Override
                    public boolean verify(String urlHostName, SSLSession session) {
                        if (!urlHostName.equals(session.getPeerHost()) && PSEnvironment.DEBUG) {
                            System.out.println("Warning: URL Host: " + urlHostName + " vs. " + session.getPeerHost());
                        }
                        return true;
                    }
                };
                HttpsURLConnection.setDefaultHostnameVerifier(hv);
            } else {
                urlString = "http://" + ip + ":" + port + "/" + servlet;
            }
            URL testUrl = new URL(urlString);
            URLConnection urlCon = testUrl.openConnection();
            if (encodedLogin.length() > 0) {
                urlCon.setRequestProperty("Proxy-Authorization", "Basic " + encodedLogin);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(urlCon.getInputStream()));
            int response = ((HttpURLConnection)urlCon).getResponseCode();
            boolean result = response >= 200 && response < 300;
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private void storeSettings(boolean storeAll) {
        PSEnvironment.setPSClientProperty("PS.SSL", this.optSSL.isSelected() ? "1" : "0");
        PSEnvironment.setPSClientProperty("PS.UseBF", this.optHttpBlowfish.isSelected() ? "1" : "0");
        PSEnvironment.setPSClientProperty("PS.UseProxy", this.chkProxy.isSelected() || this.chkAutoProxy.isSelected() ? "1" : "0");
        if (this.chkProxy.isSelected()) {
            PSEnvironment.setPSClientProperty("PS.Proxy.URL", this.txtProxy.getText());
            PSEnvironment.setPSClientProperty("PS.Proxy.Port", this.txtProxyPort.getText());
            if (this.chkProxyAuth.isSelected()) {
                String proxyLogin = Crypt.simpleTextEncryption(this.txtProxyLogin.getText());
                PSEnvironment.setPSClientProperty("PS.Proxy.Auth.Login", proxyLogin);
                String proxyPass = Crypt.simpleTextEncryption(new String(this.txtProxyPass.getPassword()));
                PSEnvironment.setPSClientProperty("PS.Proxy.Auth.Pass", proxyPass);
            }
            PSEnvironment.setPSClientProperty("PS.Proxy.AutoScriptURL", "");
        } else if (this.chkAutoProxy.isSelected()) {
            PSEnvironment.setPSClientProperty("PS.Proxy.AutoScriptURL", this.txtAutoProxyURL.getText().trim());
        } else {
            PSEnvironment.setPSClientProperty("PS.Proxy.AutoScriptURL", "");
        }
        PSEnvironment.setPSClientProperty("PS.UseProxyAuth", this.chkProxyAuth.isSelected() ? "1" : "0");
        if (storeAll) {
            PSEnvironment.setPSClientProperty("PS.DecoratedFrames", this.chkDecoratedFrames.isSelected() ? "1" : "0");
            if (this.optCustom.isSelected()) {
                PSEnvironment.setPSClientProperty("PS.LookAndFeel", "2");
                PSEnvironment.setPSClientProperty("PS.Skin", "" + this.cmbCustomThemes.getSelectedIndex());
            }
            if (this.optPlatform.isSelected()) {
                PSEnvironment.setPSClientProperty("PS.LookAndFeel", "1");
            }
            if (this.optSwing.isSelected()) {
                PSEnvironment.setPSClientProperty("PS.LookAndFeel", "0");
            }
            int value = this.chkVisualizeTASelection.isSelected() ? 1 : 0;
            PSEnvironment.setPSClientProperty("PS.VisualizeTASelection", "" + value);
            value = this.chkBankAccounts.isSelected() ? 1 : 0;
            PSEnvironment.setPSClientProperty("PS.CheckBankAccounts", "" + value);
            if (PSO.mainpanel.table_orte != null) {
                PSO.mainpanel.table_orte.invalidate();
                PSO.mainpanel.table_orte.repaint();
            }
            if (PSO.mainpanel.table_ortsteile != null) {
                PSO.mainpanel.table_ortsteile.invalidate();
                PSO.mainpanel.table_ortsteile.repaint();
            }
            int actValue = this.alphaSlider.getValue();
            PSEnvironment.setEmergencyDeathHotkey(this.hotkey, this.hkModifiers);
            if (!PSEnvironment.isGpwsClient()) {
                if (this.validEkp) {
                    PSUser.setsubmitterEKP(this.txtAmEkp.getText());
                    PSUser.setsubmitterName(this.txtAmUser.getText());
                    PSUser.setsubmitterPassword(new String(this.txtAmPw.getPassword()));
                    String amCreds = String.valueOf(this.txtAmEkp.getText()) + "|" + this.txtAmUser.getText() + "|" + new String(this.txtAmPw.getPassword());
                    PSO.cc.SendMessage(393, amCreds);
                } else {
                    Feedback.showMessage(this, 74);
                }
            }
            this.saveInterval(this.chkEnable.isSelected() ? PSEnvironment.getIntValue(this.txtInterval.getText()) : 0);
        }
    }

    private void changeTheme(int index) {
        try {
            Skin skin = SkinLookAndFeel.loadThemePack((String)("./skins/" + foundSkins.get(new Integer(index))));
            SkinLookAndFeel.setSkin((Skin)skin);
            UIManager.setLookAndFeel((LookAndFeel)new SkinLookAndFeel());
            this.switchUI();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void changeTheme() {
        int selIndex = this.cmbCustomThemes.getSelectedIndex();
        this.changeTheme(selIndex);
    }

    private void switchUI() {
        SwingUtilities.updateComponentTreeUI(PSO.mainpanel);
        if (PSO.mainpanel.AE != null) {
            SwingUtilities.updateComponentTreeUI(PSO.mainpanel.AE);
        }
        SwingUtilities.updateComponentTreeUI(this);
        this.txtLookAndFeelInfo.setBackground(this.getContentPane().getBackground());
    }

    private static void createSkinList() {
        try {
            File f = new File(String.valueOf(PSEnvironment.getPSStdPath()) + "skins/");
            if (f.exists()) {
                String[] foundFiles = f.list();
                int cnt = 0;
                int i = 0;
                while (i < foundFiles.length) {
                    if (foundFiles[i].indexOf("themepack.zip") > -1) {
                        foundSkins.put(new Integer(cnt), foundFiles[i]);
                        ++cnt;
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getThemePack(int index) {
        String result = foundSkins.get(new Integer(index));
        return String.valueOf(PSEnvironment.getPSStdPath()) + "skins/" + result;
    }

    public static void autoSaveJob() {
        if (PSAuftrag.isAutosaveAllowed()) {
            System.out.println("Sending autosave request!!!");
            PSO.cc.SendMessage(321, DEFAULT_AUTOSAVE_NAME);
        }
    }

    public static void loadAutosaveSettings(PSO psoInstance) {
        try {
            int interval = PSEnvironment.getIntValue(PSEnvironment.getPSClientProperty("PS.Autosave.interval", "10"));
            if (interval < 10 && interval > 0) {
                interval = 10;
            }
            if (interval > 0) {
                psoInstance.activateAutoSave(true, interval);
                isActive = true;
                storedInterval = interval;
            }
        }
        catch (Exception Ex) {
            return;
        }
    }

    private void saveInterval(int interval) {
        storedInterval = interval;
        PSEnvironment.setPSClientProperty("PS.Autosave.interval", String.valueOf(interval));
    }

    public static boolean isAutoSaveActive() {
        return isActive;
    }
}

