/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.dialog;

import de.codesolutions.pam.map.ScriptBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.RepaintManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import prospektservice.AKManager;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.PSOConstants;
import prospektservice.PSUser;
import prospektservice.base.ColorButton;
import prospektservice.definitions.DefAK;
import prospektservice.definitions.DefAKcolors;
import prospektservice.layoutmanager.CellLayout;

public class ChangeColorForm
extends JDialog
implements PSOConstants {
    private static final long serialVersionUID = 3258417209549076273L;
    private static final int WIDTH = 485;
    private static final int HEIGHT = 465;
    private static ResourceBundle localProperty;
    private PSO pso;
    private ColorButton[] oldColorButton = new ColorButton[10];
    private ColorButton[] colorButton = new ColorButton[10];
    private Color[] oldcolor = new Color[10];
    private Color[] color = new Color[10];
    private MyRGBColorChooserPanel chooser;
    private DefAKcolors oldcolors;
    private int Source = 0;
    private int selected = -1;
    private Border border1 = BorderFactory.createEtchedBorder(SystemColor.white, SystemColor.gray);
    private Border border2 = BorderFactory.createEtchedBorder(SystemColor.black, SystemColor.gray);
    private MinimalRepainter repainter;

    public ChangeColorForm(PSO mainpanel, int button, int source, DefAKcolors colors) {
        super(mainpanel, "", false);
        this.pso = mainpanel;
        localProperty = ResourceBundle.getBundle("properties.ChangeColorForm", PSUser.getLanguage());
        this.getContentPane().setLayout(new CellLayout());
        this.setSize(485, 465);
        this.setFont(PSEnvironment.Arial10);
        this.setResizable(false);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d.width - 485) / 2, (d.height - 465) / 2);
        this.chooser = new MyRGBColorChooserPanel();
        this.chooser.setPreferredSize(new Dimension(450, 250));
        JPanel nonSelectedColorButtonPane = new JPanel();
        nonSelectedColorButtonPane.setLayout(new CellLayout());
        nonSelectedColorButtonPane.setBorder(new TitledBorder(localProperty.getString("nSCBPTitle")));
        JPanel selectedColorButtonPane = new JPanel();
        selectedColorButtonPane.setLayout(new CellLayout());
        selectedColorButtonPane.setBorder(new TitledBorder(localProperty.getString("sCBPTitle")));
        ColorButtonListener cbl = new ColorButtonListener();
        int i = 0;
        while (i < 10) {
            this.colorButton[i] = new ColorButton();
            this.colorButton[i].setBackground(Color.gray);
            this.colorButton[i].setMinimumSize(new Dimension(25, 20));
            this.colorButton[i].setMaximumSize(new Dimension(50, 40));
            this.colorButton[i].setBorder(this.border1);
            this.colorButton[i].setActionCommand(String.valueOf(i));
            this.colorButton[i].addActionListener(cbl);
            if (i < 5) {
                nonSelectedColorButtonPane.add("y=1 x=" + (i + 1) + " w=1 h=1 f=none a=c px=4 py=4 wx=20 wy=50", this.colorButton[i]);
            } else {
                selectedColorButtonPane.add("y=1 x=" + (i - 4) + " w=1 h=1 f=none a=c px=4 py=4 wx=20 wy=50", this.colorButton[i]);
            }
            ++i;
        }
        i = 0;
        while (i < 10) {
            this.oldColorButton[i] = new ColorButton();
            this.oldColorButton[i].setBackground(Color.gray);
            this.oldColorButton[i].setMinimumSize(new Dimension(25, 20));
            this.oldColorButton[i].setMaximumSize(new Dimension(50, 40));
            this.oldColorButton[i].setBorder(this.border1);
            this.oldColorButton[i].setActionCommand(String.valueOf(-(i + 1)));
            this.oldColorButton[i].addActionListener(cbl);
            if (i < 5) {
                nonSelectedColorButtonPane.add("y=2 x=" + (i + 1) + " w=1 h=1 f=none a=c px=4 py=4 wx=20 wy=50", this.oldColorButton[i]);
            } else {
                selectedColorButtonPane.add("y=2 x=" + (i - 4) + " w=1 h=1 f=none a=c px=4 py=4 wx=20 wy=50", this.oldColorButton[i]);
            }
            ++i;
        }
        JLabel textlabel1 = new JLabel(localProperty.getString("label1"));
        JLabel textlabel2 = new JLabel(localProperty.getString("label2"));
        JButton cmd_ok = new JButton(localProperty.getString("cmdok"));
        JButton cmd_cancel = new JButton(localProperty.getString("cmdcancel"));
        JButton cmd_reset = new JButton(localProperty.getString("cmdreset"));
        this.getContentPane().add("y=1 x=1 w=10 h=1 f=both a=c px=10 py=10 wx=00 wy=20", this.chooser);
        this.getContentPane().add("y=2 x=1 w=04 h=3 f=both a=c px=10 py=5 wx=33 wy=20", nonSelectedColorButtonPane);
        this.getContentPane().add("y=3 x=5 w=02 h=1 f=none a=n px=04 py=0 wx=33 wy=20", textlabel1);
        this.getContentPane().add("y=4 x=5 w=02 h=1 f=none a=n px=04 py=0 wx=33 wy=20", textlabel2);
        this.getContentPane().add("y=2 x=7 w=04 h=3 f=both a=c px=10 py=5 wx=33 wy=20", selectedColorButtonPane);
        this.getContentPane().add("y=5 x=1 w=05 h=1 f=width a=c px=10 py=5 wx=33 wy=20", cmd_reset);
        this.getContentPane().add("y=5 x=6 w=02 h=1 f=width a=c px=10 py=5 wx=33 wy=20", cmd_ok);
        this.getContentPane().add("y=5 x=8 w=03 h=1 f=width a=c px=10 py=5 wx=33 wy=20", cmd_cancel);
        this.resetForm(button, source, colors);
        cmd_ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefAKcolors newcolors = new DefAKcolors();
                newcolors.id = ((ChangeColorForm)ChangeColorForm.this).oldcolors.id;
                newcolors.typ = ((ChangeColorForm)ChangeColorForm.this).oldcolors.typ;
                int i = 0;
                while (i < 10) {
                    if (i < 5) {
                        newcolors.Class.addElement(String.valueOf(i + 1));
                        newcolors.unselected.addElement(ChangeColorForm.this.color[i]);
                    } else {
                        newcolors.selected.addElement(ChangeColorForm.this.color[i]);
                    }
                    ++i;
                }
                if (ChangeColorForm.this.Source == 1) {
                    AKManager.setAKcolors(newcolors);
                }
                ((ChangeColorForm)ChangeColorForm.this).pso.mapOptions.setColors(newcolors);
                ScriptBuilder.updateColorTable(AKManager.getActualIndex(), newcolors);
                ChangeColorForm.this.pso.getWmp().enableDataVisualization(AKManager.getActualIndex());
                ChangeColorForm.this.setVisible(false);
            }
        });
        cmd_cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangeColorForm.this.setVisible(false);
            }
        });
        cmd_reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefAKcolors defColors = AKManager.getAKdefaultColors();
                int i = 0;
                while (i < defColors.Class.size()) {
                    int slot = PSEnvironment.getIntValue(defColors.Class.elementAt(i));
                    if (slot != 0) {
                        ((ChangeColorForm)ChangeColorForm.this).color[--slot] = defColors.unselected.elementAt(i);
                        ((ChangeColorForm)ChangeColorForm.this).color[slot + 5] = defColors.selected.elementAt(i);
                    }
                    ++i;
                }
                i = 0;
                while (i < 10) {
                    ChangeColorForm.this.colorButton[i].setBackground(ChangeColorForm.this.color[i]);
                    ++i;
                }
            }
        });
        this.chooser.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ChangeColorForm.this.selected >= 0) {
                    ((ChangeColorForm)ChangeColorForm.this).color[((ChangeColorForm)ChangeColorForm.this).selected] = ChangeColorForm.this.chooser.getColor();
                    ChangeColorForm.this.colorButton[ChangeColorForm.this.selected].setBackground(ChangeColorForm.this.color[ChangeColorForm.this.selected]);
                }
            }
        });
        this.setDefaultCloseOperation(1);
    }

    @Override
    public void setVisible(boolean flag) {
        if (!flag) {
            this.repainter.restoreStdManager();
        }
        super.setVisible(flag);
    }

    public void resetForm(int button, int source, DefAKcolors colors) {
        this.repainter = MinimalRepainter.getInstance();
        this.repainter.setRepaintInterval(5);
        RepaintManager.setCurrentManager(this.repainter);
        this.oldcolors = colors;
        this.Source = source;
        int i = 0;
        while (i < 10) {
            this.colorButton[i].setBackground(Color.gray);
            this.oldColorButton[i].setBackground(Color.gray);
            ++i;
        }
        if (this.selected >= 0) {
            this.colorButton[this.selected].setBorder(this.border1);
            this.colorButton[this.selected].setSelected(false);
            this.selected = -1;
        }
        i = 0;
        while (i < this.oldcolors.Class.size()) {
            int slot = PSEnvironment.getIntValue(this.oldcolors.Class.elementAt(i));
            if (slot != 0) {
                this.oldcolor[--slot] = this.color[slot] = this.oldcolors.unselected.elementAt(i);
                Color color = this.oldcolors.selected.elementAt(i);
                this.color[slot + 5] = color;
                this.oldcolor[slot + 5] = color;
            }
            ++i;
        }
        i = 0;
        while (i < 10) {
            this.colorButton[i].setBackground(this.color[i]);
            this.oldColorButton[i].setBackground(this.oldcolor[i]);
            ++i;
        }
        if (this.oldcolors.id != 0) {
            DefAK ak = AKManager.getAK(this.oldcolors.id, this.oldcolors.typ);
            this.setTitle(String.valueOf(localProperty.getString("Title")) + ": " + ak.text);
        }
        if (button >= 0) {
            this.selected = button;
            this.chooser.setColor(this.color[this.selected]);
            this.colorButton[this.selected].setBorder(this.border2);
            this.colorButton[this.selected].setSelected(true);
        }
    }

    class ColorButtonListener
    implements ActionListener {
        ColorButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton source = (JButton)e.getSource();
            int taste = PSEnvironment.getIntValue(source.getActionCommand());
            if (taste < 0 && ChangeColorForm.this.selected != -1) {
                ChangeColorForm.this.chooser.setColor(ChangeColorForm.this.oldcolor[-taste - 1]);
            }
            if (taste >= 0) {
                if (ChangeColorForm.this.selected >= 0) {
                    ChangeColorForm.this.colorButton[ChangeColorForm.this.selected].setBorder(ChangeColorForm.this.border1);
                    ChangeColorForm.this.colorButton[ChangeColorForm.this.selected].setSelected(false);
                }
                ChangeColorForm.this.selected = taste;
                ChangeColorForm.this.chooser.setColor(ChangeColorForm.this.color[ChangeColorForm.this.selected]);
                ChangeColorForm.this.colorButton[ChangeColorForm.this.selected].setBorder(ChangeColorForm.this.border2);
                ChangeColorForm.this.colorButton[ChangeColorForm.this.selected].setSelected(true);
            }
        }
    }

    public static class MinimalRepainter
    extends RepaintManager {
        private int repaintInterval = 50;
        private long lastUpdateTime = 0L;
        protected Dimension doubleBufferSize = new Dimension(0, 0);
        protected Image doubleBuffer;
        protected Dimension doubleBufferMaxSize;
        private static RepaintManager stdRepainter;
        private static MinimalRepainter instance;

        static {
            instance = null;
        }

        public static MinimalRepainter getInstance() {
            if (instance == null) {
                instance = new MinimalRepainter();
            }
            return instance;
        }

        private MinimalRepainter() {
            stdRepainter = RepaintManager.currentManager(PSO.mainpanel);
            this.doubleBufferMaxSize = Toolkit.getDefaultToolkit().getScreenSize();
            PSEnvironment.printDebugMessage("MinimalRepainter", "alternative repaintManager initialized!!!");
        }

        public void setRepaintInterval(int interval) {
            this.repaintInterval = interval;
        }

        public int getRepaintInterval() {
            return this.repaintInterval;
        }

        @Override
        public void paintDirtyRegions() {
            long actTime = System.currentTimeMillis();
            if (actTime > this.lastUpdateTime + (long)this.repaintInterval) {
                this.lastUpdateTime = actTime;
                super.paintDirtyRegions();
            }
        }

        public void restoreStdManager() {
            RepaintManager.setCurrentManager(stdRepainter);
            PSEnvironment.printDebugMessage("MinimalRepainter", "original repaintManager restored!!!");
        }

        @Override
        public void setDoubleBufferMaximumSize(Dimension d) {
            this.doubleBufferMaxSize = d;
            if (this.doubleBuffer != null && (this.doubleBufferSize.width > d.width || this.doubleBufferSize.height > d.height)) {
                this.setDoubleBufferNull();
            }
        }

        protected void setDoubleBufferNull() {
            if (this.doubleBuffer != null) {
                this.doubleBuffer.flush();
            }
            this.doubleBuffer = null;
        }

        @Override
        public Image getOffscreenBuffer(Component c, int proposedWidth, int proposedHeight) {
            int width = proposedWidth > this.doubleBufferMaxSize.width ? this.doubleBufferMaxSize.width : proposedWidth;
            int height = proposedHeight > this.doubleBufferMaxSize.height ? this.doubleBufferMaxSize.height : proposedHeight;
            int go_width = width;
            int go_height = height;
            if (this.doubleBuffer != null) {
                go_width = this.doubleBufferSize.width;
                go_height = this.doubleBufferSize.height;
                if (this.doubleBufferSize.width < width) {
                    go_width = width;
                    this.setDoubleBufferNull();
                }
                if (this.doubleBufferSize.height < height) {
                    go_height = height;
                    this.setDoubleBufferNull();
                }
            }
            if (this.doubleBuffer == null) {
                this.doubleBuffer = c.createImage(go_width, go_height);
                this.doubleBufferSize = new Dimension(go_width, go_height);
            }
            return this.doubleBuffer;
        }
    }

    class MyRGBColorChooserPanel
    extends JPanel {
        private static final long serialVersionUID = 3834872477179785529L;
        private JSlider redSlider;
        private JSlider greenSlider;
        private JSlider blueSlider;
        private JTextField redValue;
        private JTextField greenValue;
        private JTextField blueValue;
        private JLabel redLabel;
        private JLabel greenLabel;
        private JLabel blueLabel;
        private ChangeListener myChangeListener;
        private Color actColor = new Color(255, 255, 255);
        private Vector<Integer> navKeys = new Vector();

        public MyRGBColorChooserPanel() {
            this.buildChooser();
            this.navKeys.addElement(new Integer(8));
            this.navKeys.addElement(new Integer(127));
            this.navKeys.addElement(new Integer(39));
            this.navKeys.addElement(new Integer(37));
            this.navKeys.addElement(new Integer(36));
            this.navKeys.addElement(new Integer(35));
        }

        protected void buildChooser() {
            MyKeyAdapter myKeyHandler = new MyKeyAdapter();
            this.setLayout(new GridLayout(3, 1));
            rgbListener myListener = new rgbListener();
            Dimension size = new Dimension(25, 20);
            JPanel redPanel = new JPanel();
            redPanel.add(Box.createHorizontalGlue());
            redPanel.setLayout(new BoxLayout(redPanel, 0));
            this.redLabel = new JLabel("R");
            redPanel.add(this.redLabel);
            this.redSlider = new JSlider(0, 0, 255, this.actColor.getRed());
            this.redSlider.setMajorTickSpacing(85);
            this.redSlider.setMinorTickSpacing(17);
            this.redSlider.setPaintTicks(true);
            this.redSlider.addChangeListener(myListener);
            redPanel.add(this.redSlider);
            redPanel.add(Box.createHorizontalGlue());
            this.redValue = new JTextField();
            this.redValue.setText("255");
            this.redValue.addKeyListener(myKeyHandler);
            this.redValue.setHorizontalAlignment(4);
            this.redValue.setMaximumSize(size);
            this.redValue.setMinimumSize(size);
            this.redValue.setPreferredSize(size);
            redPanel.add(this.redValue);
            redPanel.add(Box.createHorizontalGlue());
            this.add(redPanel);
            JPanel greenPanel = new JPanel();
            greenPanel.setLayout(new BoxLayout(greenPanel, 0));
            greenPanel.add(Box.createHorizontalGlue());
            this.greenLabel = new JLabel("G");
            greenPanel.add(this.greenLabel);
            this.greenSlider = new JSlider(0, 0, 255, this.actColor.getGreen());
            this.greenSlider.setMajorTickSpacing(85);
            this.greenSlider.setMinorTickSpacing(17);
            this.greenSlider.setPaintTicks(true);
            this.greenSlider.addChangeListener(myListener);
            greenPanel.add(this.greenSlider);
            greenPanel.add(Box.createHorizontalGlue());
            this.greenValue = new JTextField();
            this.greenValue.setText("255");
            this.greenValue.addKeyListener(myKeyHandler);
            this.greenValue.setHorizontalAlignment(4);
            this.greenValue.setMaximumSize(size);
            this.greenValue.setMinimumSize(size);
            this.greenValue.setPreferredSize(size);
            greenPanel.add(this.greenValue);
            greenPanel.add(Box.createHorizontalGlue());
            this.add(greenPanel);
            JPanel bluePanel = new JPanel();
            bluePanel.add(Box.createHorizontalGlue());
            bluePanel.setLayout(new BoxLayout(bluePanel, 0));
            this.blueLabel = new JLabel("B");
            bluePanel.add(this.blueLabel);
            this.blueSlider = new JSlider(0, 0, 255, this.actColor.getBlue());
            this.blueSlider.setMajorTickSpacing(85);
            this.blueSlider.setMinorTickSpacing(17);
            this.blueSlider.setPaintTicks(true);
            this.blueSlider.setPaintLabels(true);
            this.blueSlider.addChangeListener(myListener);
            this.blueLabel.setLabelFor(this.blueSlider);
            bluePanel.add(this.blueSlider);
            bluePanel.add(Box.createHorizontalGlue());
            this.blueValue = new JTextField();
            this.blueValue.setText("255");
            this.blueValue.addKeyListener(myKeyHandler);
            this.blueValue.setHorizontalAlignment(4);
            this.blueValue.setMaximumSize(size);
            this.blueValue.setMinimumSize(size);
            this.blueValue.setPreferredSize(size);
            bluePanel.add(this.blueValue);
            bluePanel.add(Box.createHorizontalGlue());
            this.add(bluePanel);
        }

        public void setColor(Color newColor) {
            this.actColor = newColor;
            this.updateChooser();
            if (this.myChangeListener != null) {
                this.myChangeListener.stateChanged(new ChangeEvent(this));
            }
        }

        public Color getColor() {
            return this.actColor;
        }

        public void updateChooser() {
            if (this.actColor.getRed() != PSEnvironment.getIntValue(this.redValue.getText())) {
                this.redValue.setText(String.valueOf(this.actColor.getRed()));
            }
            if (this.actColor.getRed() != this.redSlider.getValue()) {
                this.redSlider.setValue(this.actColor.getRed());
            }
            if (this.actColor.getGreen() != PSEnvironment.getIntValue(this.greenValue.getText())) {
                this.greenValue.setText(String.valueOf(this.actColor.getGreen()));
            }
            if (this.actColor.getGreen() != this.greenSlider.getValue()) {
                this.greenSlider.setValue(this.actColor.getGreen());
            }
            if (this.actColor.getBlue() != PSEnvironment.getIntValue(this.blueValue.getText())) {
                this.blueValue.setText(String.valueOf(this.actColor.getBlue()));
            }
            if (this.actColor.getBlue() != this.blueSlider.getValue()) {
                this.blueSlider.setValue(this.actColor.getBlue());
            }
        }

        public void addChangeListener(ChangeListener listener) {
            this.myChangeListener = listener;
        }

        class MyKeyAdapter
        extends KeyAdapter {
            MyKeyAdapter() {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                int newChar = e.getKeyCode();
                char actChar = e.getKeyChar();
                JTextField actTxtField = (JTextField)e.getSource();
                if (!PSEnvironment.isNumeric(actChar) && !MyRGBColorChooserPanel.this.navKeys.contains(new Integer(newChar))) {
                    e.consume();
                    return;
                }
                if (!MyRGBColorChooserPanel.this.navKeys.contains(new Integer(newChar)) && PSEnvironment.getIntValue(String.valueOf(actTxtField.getText()) + actChar) > 255) {
                    e.consume();
                    return;
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (MyRGBColorChooserPanel.this.redValue.getText().length() == 0 || MyRGBColorChooserPanel.this.greenValue.getText().length() == 0 || MyRGBColorChooserPanel.this.blueValue.getText().length() == 0) {
                    e.consume();
                    return;
                }
                Color newColor = new Color(PSEnvironment.getIntValue(MyRGBColorChooserPanel.this.redValue.getText()), PSEnvironment.getIntValue(MyRGBColorChooserPanel.this.greenValue.getText()), PSEnvironment.getIntValue(MyRGBColorChooserPanel.this.blueValue.getText()));
                if (!newColor.equals(MyRGBColorChooserPanel.this.actColor)) {
                    MyRGBColorChooserPanel.this.setColor(newColor);
                }
            }
        }

        class rgbListener
        implements ChangeListener {
            rgbListener() {
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                Color newColor = Color.white;
                JSlider actSlider = (JSlider)e.getSource();
                boolean useAlpha = true;
                if (actSlider.equals(MyRGBColorChooserPanel.this.redSlider)) {
                    newColor = new Color(MyRGBColorChooserPanel.this.redSlider.getValue(), MyRGBColorChooserPanel.this.actColor.getGreen(), MyRGBColorChooserPanel.this.actColor.getBlue(), useAlpha ? PSEnvironment.globalAlpha : 255);
                }
                if (actSlider.equals(MyRGBColorChooserPanel.this.greenSlider)) {
                    newColor = new Color(MyRGBColorChooserPanel.this.actColor.getRed(), MyRGBColorChooserPanel.this.greenSlider.getValue(), MyRGBColorChooserPanel.this.actColor.getBlue(), useAlpha ? PSEnvironment.globalAlpha : 255);
                }
                if (actSlider.equals(MyRGBColorChooserPanel.this.blueSlider)) {
                    newColor = new Color(MyRGBColorChooserPanel.this.actColor.getRed(), MyRGBColorChooserPanel.this.actColor.getGreen(), MyRGBColorChooserPanel.this.blueSlider.getValue(), useAlpha ? PSEnvironment.globalAlpha : 255);
                }
                MyRGBColorChooserPanel.this.setColor(newColor);
            }
        }
    }
}

