/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.datamodels;

import java.io.StringReader;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.datamodels.PsoTableModel;

public class TablePalette
extends PsoTableModel {
    private static final long serialVersionUID = 3978423624447179061L;
    private int Counter = 0;
    private DOMParser parser = new DOMParser();
    boolean modeKG = false;

    public void initColumnNames(String[] header) {
        this.setDbHeader(header);
        this.BLOCK_SIZE = 10;
    }

    @Override
    public Object getValueAt(int row, int col) {
        String result = (String)super.getValueAt(row, col);
        if (!result.equals("c/f")) {
            if (this.modeKG && col == 4) {
                int anzSdg = PSEnvironment.getIntValue(super.getValueAt(row, col + 1).toString());
                result = PSEnvironment.calcPalWeight(anzSdg);
            }
            return result;
        }
        if (row == this.lastFetchedRow[0] || row > this.lastFetchedRow[0] && row < this.lastFetchedRow[0] + this.BLOCK_SIZE && this.lastFetchedRow[0] > -1 || row == this.lastFetchedRow[1] || row > this.lastFetchedRow[1] && row < this.lastFetchedRow[1] + this.BLOCK_SIZE && this.lastFetchedRow[1] > -1) {
            return "c/f";
        }
        int rowToGet = this.optimizeRequest(row);
        if (rowToGet % this.BLOCK_SIZE == 0) {
            int n;
            PSO.cc.SendMessage(277, String.valueOf(rowToGet + 1) + "+" + this.BLOCK_SIZE);
            if (this.lastRowIndex == 0) {
                int n2 = this.lastRowIndex;
                n = n2;
                this.lastRowIndex = n2 + 1;
            } else {
                int n3 = this.lastRowIndex;
                n = n3;
                this.lastRowIndex = n3 - 1;
            }
            this.lastFetchedRow[n] = rowToGet;
        }
        return "n/a";
    }

    public void setData(String Data) {
        try {
            this.parser.parse(new InputSource(new StringReader(Data)));
            Document doc = this.parser.getDocument();
            if (PSEnvironment.DEBUG) {
                System.out.println("passing Doc to model...");
            }
            super.setData(doc);
            if (this.isRowInDocument(0, this.getSelectedRow()) || this.isRowInDocument(1, this.getSelectedRow())) {
                this.setSelectedRow(-1);
            }
        }
        catch (SAXParseException Ex) {
            if (PSEnvironment.DEBUG) {
                if (PSEnvironment.DEBUG) {
                    System.out.println(String.valueOf(Ex.getLineNumber()));
                }
                Ex.printStackTrace();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setModeKG(boolean flag) {
        this.modeKG = flag;
    }

    public int getBlockSize() {
        return this.BLOCK_SIZE;
    }
}

