/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.base;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class DirectoryTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 3257290231622153781L;
    private final FileSystemView fileSystemView;
    private boolean childrenAreLoaded;

    private DirectoryTreeNode(File directory, FileSystemView fileSystemView) {
        super(directory);
        this.fileSystemView = fileSystemView;
        this.childrenAreLoaded = false;
    }

    public DirectoryTreeNode(String name, File[] children, FileSystemView fileSystemView) {
        super(name);
        this.fileSystemView = fileSystemView;
        this.addChildren(children);
    }

    private void addChildren(File[] children) {
        this.childrenAreLoaded = true;
        int i = 0;
        while (i < children.length) {
            this.add(new DirectoryTreeNode(children[i], this.fileSystemView));
            ++i;
        }
    }

    public Enumeration children() {
        this.ensureChildrenAreLoaded();
        return super.children();
    }

    public void ensureChildrenAreLoaded() {
        if (!this.childrenAreLoaded) {
            this.loadChildren();
        }
    }

    @Override
    public TreeNode getChildAt(int index) {
        this.ensureChildrenAreLoaded();
        return super.getChildAt(index);
    }

    @Override
    public int getChildCount() {
        this.ensureChildrenAreLoaded();
        return super.getChildCount();
    }

    public File getDirectory() {
        return (File)this.getUserObject();
    }

    @Override
    public boolean isLeaf() {
        return this.childrenAreLoaded && super.isLeaf();
    }

    private void loadChildren() {
        this.childrenAreLoaded = true;
        File[] fileList = this.fileSystemView.getFiles(this.getDirectory(), false);
        if (fileList == null) {
            return;
        }
        ArrayList<File> childDirectories = new ArrayList<File>();
        int i = 0;
        while (i < fileList.length) {
            File file = fileList[i];
            if (this.fileSystemView.isTraversable(file).booleanValue()) {
                childDirectories.add(file);
            }
            ++i;
        }
        Collections.sort(childDirectories);
        for (File aDirectory : childDirectories) {
            this.add(new DirectoryTreeNode(aDirectory, this.fileSystemView));
        }
    }
}

