/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.base;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.BlowfishEngine;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.engines.RijndaelEngine;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.util.encoders.Base64;
import prospektservice.PSO;

public class Crypt {
    private static byte[] blowfishKey;
    private static boolean useBlowfish;
    private static final String SERVER_CERT = "weblogic";
    private static final char[] ksPass;
    private static final String cryptKey = "!!zx8?Wq$9rN2u3F";

    static {
        useBlowfish = false;
        ksPass = new char[]{'s', 'e', 'c', 'r', 'e', 't'};
    }

    public static void init(String data) {
        try {
            Crypt.generateBlowfishSessionKey(128);
            byte[] keyData = Crypt.encryptSessionKey(Crypt.decode(data));
            String tmp = new String(keyData, "ISO8859_1");
            PSO.cc.SendMessage(10000, Crypt.encode(tmp.getBytes("ISO8859_1")));
            useBlowfish = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static byte[] EncodeDll(byte[] wert) {
        try {
            return Crypt.encode(wert).getBytes("ISO8859_1");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static byte[] DecodeDll(String wert) {
        try {
            return Crypt.decode(wert).getBytes("ISO8859_1");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String encode(byte[] data) {
        String result = "";
        try {
            if (useBlowfish) {
                data = Crypt.encryptBlowfish(data);
            }
            result = new String(Base64.encode((byte[])data), "ISO8859_1");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static String decode(String s) {
        String outstr = "";
        try {
            outstr = new String(Base64.decode((String)s), "ISO8859_1");
            if (useBlowfish) {
                outstr = Crypt.decryptBlowfish(outstr);
            }
            return outstr;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return outstr;
        }
    }

    public static byte[] EasyCryption(byte[] value) {
        byte[] out = new byte[value.length];
        try {
            int i = 0;
            while (i < value.length) {
                BigInteger BigInt1 = BigInteger.valueOf(value[i]);
                BigInteger BigInt2 = BigInteger.valueOf(255L);
                BigInt1 = BigInt1.xor(BigInt2);
                out[i] = BigInt1.byteValue();
                ++i;
            }
            return out;
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static void generateBlowfishSessionKey(int keyLengthBits) {
        int byteCount = keyLengthBits / 8;
        blowfishKey = new byte[byteCount];
        int i = 0;
        while (i < byteCount) {
            double seat = Math.random();
            int num = seat <= 0.127 || seat >= -0.128 ? (int)(seat * 1000.0) : (int)(seat * 100.0);
            Crypt.blowfishKey[i] = (byte)num;
            ++i;
        }
    }

    private static byte[] encryptSessionKey(String data) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(data.getBytes("ISO8859_1"));
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(in);
            RSAPublicKey key = (RSAPublicKey)cert.getPublicKey();
            RSAEngine rsaEngine = new RSAEngine();
            rsaEngine.init(true, (CipherParameters)new RSAKeyParameters(false, key.getModulus(), key.getPublicExponent()));
            return rsaEngine.processBlock(blowfishKey, 0, blowfishKey.length);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String simpleTextEncryption(String in) {
        String result = "";
        try {
            byte[] input = in.getBytes("ISO8859_1");
            RijndaelEngine rijndael = new RijndaelEngine();
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)rijndael);
            cipher.init(true, (CipherParameters)new KeyParameter(cryptKey.getBytes("ISO8859_1")));
            byte[] output = new byte[cipher.getOutputSize(input.length)];
            int len = cipher.processBytes(input, 0, input.length, output, 0);
            cipher.doFinal(output, len);
            result = new String(Base64.encode((byte[])output), "ISO8859_1");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static String simpleTextDecryption(String in) {
        String result = "";
        try {
            result = new String(Base64.decode((String)in), "ISO8859_1");
            RijndaelEngine cryptEngine = new RijndaelEngine();
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)cryptEngine);
            byte[] input = result.getBytes("ISO8859_1");
            cipher.init(false, (CipherParameters)new KeyParameter(cryptKey.getBytes("ISO8859_1")));
            byte[] output = new byte[cipher.getOutputSize(input.length)];
            int len = cipher.processBytes(input, 0, input.length, output, 0);
            cipher.doFinal(output, len);
            result = new String(output, "ISO8859_1").trim();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result = in;
        }
        return result;
    }

    public static byte[] encryptBlowfish(byte[] input) {
        String value = "";
        try {
            BlowfishEngine cryptEngine = new BlowfishEngine();
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)cryptEngine);
            cipher.init(true, (CipherParameters)new KeyParameter(blowfishKey));
            byte[] output = new byte[cipher.getOutputSize(input.length)];
            int len = cipher.processBytes(input, 0, input.length, output, 0);
            cipher.doFinal(output, len);
            return output;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String decryptBlowfish(String data) {
        String value = "";
        try {
            BlowfishEngine cryptEngine = new BlowfishEngine();
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)cryptEngine);
            byte[] input = data.getBytes("ISO8859_1");
            cipher.init(false, (CipherParameters)new KeyParameter(blowfishKey));
            byte[] output = new byte[cipher.getOutputSize(input.length)];
            int len = cipher.processBytes(input, 0, input.length, output, 0);
            cipher.doFinal(output, len);
            value = new String(output, "ISO8859_1");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return value;
    }

    public static boolean isUseBlowfish() {
        return useBlowfish;
    }

    public static void setUseBlowfish(boolean b) {
        useBlowfish = b;
    }

    public static boolean verifyCertificateValidity() {
        boolean result = false;
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream("lib/security/trustedcerts"), ksPass);
            X509Certificate cert = (X509Certificate)ks.getCertificate(SERVER_CERT);
            cert.checkValidity();
            result = true;
        }
        catch (CertificateExpiredException ks) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static void storeNewCert(String data) {
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream("lib/security/trustedcerts"), ksPass);
            ByteArrayInputStream in = new ByteArrayInputStream(Crypt.decode(data).getBytes("ISO8859_1"));
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(in);
            ks.setCertificateEntry(SERVER_CERT, cert);
            ks.store(new FileOutputStream("lib/security/trustedcerts"), ksPass);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

