/*
 * Decompiled with CFR 0.152.
 */
package prospektservice;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.Vector;
import prospektservice.PSAuftrag;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.PSUser;
import prospektservice.definitions.DefAddressData;
import prospektservice.definitions.DefBank;
import prospektservice.definitions.DefKunde;

public class AddressManager
implements Serializable {
    private static final long serialVersionUID = 3258133548417495352L;
    private static final boolean useServerSide = true;
    private static final String DELIMITER = ";";
    private static final String DATADIR = "data";
    private static final String FILENAME = "Adressen.csv";
    private static final String STORED_DEFAULTS = "defaultaddress";
    private static boolean pointerInPlz = false;
    private static boolean neueAdresse = true;
    private static int adrPointer = -1;
    private static int[] idxTable = new int[40];
    private static String dataFileName;
    private static String dataPath;
    private static String userID;
    private static Vector<DefAddressData> addressRecords;
    private static Vector<DefAddressData> useableAddresses;
    private static Field[] addressFields;
    private static Field[] bankFields;

    static {
        addressFields = DefKunde.class.getFields();
        bankFields = DefBank.class.getFields();
    }

    public static void init() {
        userID = PSUser.getUserID();
        dataPath = String.valueOf(PSEnvironment.getPSPath()) + DATADIR + "/" + userID;
        try {
            File tmpFile = new File(dataPath);
            dataPath = tmpFile.getCanonicalPath();
            Object var0 = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        addressRecords = new Vector();
        useableAddresses = new Vector();
        PSO.cc.SendMessage(373, "");
        AddressManager.sortRecords();
    }

    private static void initFromFile() {
        userID = PSUser.getUserID();
        dataPath = String.valueOf(PSEnvironment.getPSPath()) + DATADIR + "/" + userID;
        try {
            File tmpFile = new File(dataPath);
            dataPath = tmpFile.getCanonicalPath();
            Object var0 = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        dataFileName = String.valueOf(dataPath) + "/" + FILENAME;
        addressRecords = new Vector();
        useableAddresses = new Vector();
        if (AddressManager.testForOldFileType()) {
            AddressManager.convertAddressData();
        } else {
            AddressManager.loadRecords();
        }
    }

    private static boolean testForOldFileType() {
        boolean result = false;
        try {
            File data = new File(dataFileName);
            if (data.exists()) {
                String line;
                String[] oldData;
                BufferedReader br = new BufferedReader(new FileReader(dataFileName));
                if (br.ready() && (oldData = PSEnvironment.tokenStringToStringArray(line = br.readLine(), DELIMITER)).length > 17) {
                    result = true;
                }
                br.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static void convertAddressData() {
        try {
            File data = new File(dataFileName);
            if (data.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(dataFileName));
                while (br.ready()) {
                    String line = br.readLine();
                    String[] oldData = PSEnvironment.tokenStringToStringArray(line, DELIMITER);
                    int i = 0;
                    while (i < oldData.length) {
                        if (PSEnvironment.DEBUG) {
                            System.out.println("oldData[" + i + "]" + " -> " + oldData[i]);
                        }
                        ++i;
                    }
                    String absData = "";
                    int i2 = 0;
                    while (i2 < 8) {
                        absData = String.valueOf(absData) + oldData[i2] + DELIMITER;
                        ++i2;
                    }
                    absData = String.valueOf(absData) + oldData[24] + DELIMITER + oldData[27] + DELIMITER + oldData[8] + DELIMITER;
                    absData = String.valueOf(absData) + "1;";
                    boolean absZahlt = oldData[26].equals("0");
                    absData = absZahlt ? String.valueOf(absData) + oldData[9] + DELIMITER + oldData[10] + DELIMITER + oldData[11] + DELIMITER + oldData[12] : String.valueOf(absData) + ";;;";
                    AddressManager.convertIn(absData);
                    boolean noEinl = Boolean.valueOf(oldData[22]);
                    if (noEinl) continue;
                    String einlData = "";
                    int i3 = 13;
                    while (i3 < 22) {
                        einlData = String.valueOf(einlData) + oldData[i3] + DELIMITER;
                        ++i3;
                    }
                    einlData = String.valueOf(einlData) + oldData[25] + DELIMITER + oldData[28] + DELIMITER;
                    einlData = String.valueOf(einlData) + "1;";
                    einlData = !absZahlt ? String.valueOf(einlData) + oldData[9] + DELIMITER + oldData[10] + DELIMITER + oldData[11] + DELIMITER + oldData[12] : String.valueOf(einlData) + ";;;";
                    AddressManager.convertIn(einlData);
                }
                br.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void loadRecords() {
        try {
            File data = new File(dataFileName);
            if (data.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(dataFileName));
                while (br.ready()) {
                    String line = br.readLine();
                    AddressManager.convertIn(line);
                }
                br.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static String[] checkIfPFOrtAvailable(String[] in) {
        if (in.length < addressFields.length + bankFields.length) {
            String[] tmp = new String[addressFields.length + bankFields.length];
            System.arraycopy(in, 0, tmp, 0, 14);
            tmp[14] = "";
            System.arraycopy(in, 14, tmp, 15, in.length - 14);
            in = tmp;
        }
        return in;
    }

    private static void convertIn(String data) throws IllegalAccessException {
        String[] field = PSEnvironment.tokenStringToStringArray(data, DELIMITER);
        field = AddressManager.checkIfPFOrtAvailable(field);
        int i = 0;
        while (i < field.length) {
            field[i] = field[i].replace('+', '&');
            ++i;
        }
        DefAddressData address = new DefAddressData();
        int i2 = 0;
        while (i2 < addressFields.length) {
            addressFields[i2].set(address.absender, field[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < bankFields.length) {
            bankFields[i2].set(address.bank, field[i2 + addressFields.length]);
            ++i2;
        }
        addressRecords.add(address);
        if (address.absender.importedAddress.equals("0") && (AddressManager.recordHasBankData(AddressManager.getAddressIndex(address)) || address.absender.ERGNR.length() == 4)) {
            useableAddresses.add(address);
        }
    }

    private static String convertOut(DefAddressData address) throws IllegalAccessException {
        String result = "";
        int i = 0;
        while (i < addressFields.length) {
            result = String.valueOf(result) + addressFields[i].get(address.absender) + DELIMITER;
            ++i;
        }
        i = 0;
        while (i < bankFields.length) {
            result = String.valueOf(result) + bankFields[i].get(address.bank);
            if (i < bankFields.length - 1) {
                result = String.valueOf(result) + DELIMITER;
            }
            ++i;
        }
        return result;
    }

    public static void storeRecords() {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(dataFileName));
            int i = 0;
            while (i < addressRecords.size()) {
                DefAddressData address = addressRecords.elementAt(i);
                String line = AddressManager.convertOut(address);
                bw.write(line);
                bw.newLine();
                ++i;
            }
            bw.flush();
            bw.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void sortRecords() {
        Collections.sort(addressRecords, new AddressComparator());
        Collections.sort(useableAddresses, new AddressComparator());
    }

    public static DefAddressData getRecord(int index) {
        return useableAddresses.elementAt(index);
    }

    public static DefAddressData getRecordFromAll(int index) {
        return addressRecords.elementAt(index);
    }

    public static void addRecord(String data) {
        try {
            AddressManager.convertIn(data);
            AddressManager.sortRecords();
        }
        catch (IllegalAccessException iaEx) {
            iaEx.printStackTrace();
        }
    }

    public static void addRecord(DefAddressData data) {
        addressRecords.add(data);
        useableAddresses.add(data);
        AddressManager.sortRecords();
        AddressManager.storeRecordsServerSide();
    }

    public static void updateRecord(DefAddressData data, int index) {
        DefAddressData dad = addressRecords.elementAt(index);
        dad.absender.ERGNR = data.absender.ERGNR;
        dad.absender.KARTENNR = data.absender.KARTENNR;
        dad.absender.KDNR = data.absender.KDNR;
        dad.absender.Land = data.absender.Land;
        dad.absender.Name = data.absender.Name;
        dad.absender.Ort = data.absender.Ort;
        dad.absender.PF = data.absender.PF;
        dad.absender.PFPLZ = data.absender.PFPLZ;
        dad.absender.PFOrt = data.absender.PFOrt;
        dad.absender.PLZ = data.absender.PLZ;
        dad.absender.Strasse = data.absender.Strasse;
        dad.absender.Telefon = data.absender.Telefon;
        dad.absender.importedAddress = "0";
        dad.absender.emailAddress = data.absender.emailAddress;
        dad.bank.Geldinstitut = data.bank.Geldinstitut;
        dad.bank.Kontobezeichnung = data.bank.Kontobezeichnung;
        dad.bank.BLZ = data.bank.BLZ;
        dad.bank.Kontonummer = data.bank.Kontonummer;
        dad.bank.bic = data.bank.bic;
        dad.bank.iban = data.bank.iban;
        if (dad.bank.iban.trim().length() == 0 && dad.bank.bic.trim().length() == 0) {
            dad.bank.Geldinstitut = "";
            dad.bank.Kontobezeichnung = "";
            dad.bank.BLZ = "";
            dad.bank.Kontonummer = "";
        }
        if (useableAddresses.contains(dad)) {
            useableAddresses.remove(dad);
        }
        useableAddresses.add(dad);
        AddressManager.sortRecords();
        AddressManager.storeRecordsServerSide();
    }

    public static void delRecord(int index) {
        DefAddressData toDel = addressRecords.elementAt(index);
        addressRecords.removeElementAt(index);
        addressRecords.trimToSize();
        AddressManager.storeRecordsServerSide();
    }

    public static Vector getUseableAddresses() {
        return useableAddresses;
    }

    public static Vector<DefAddressData> getAddresses() {
        return addressRecords;
    }

    public static int checkJobAddress(String data, boolean compareAll) {
        int result = AddressManager.findUseableAddress(data, compareAll);
        return result;
    }

    public static void addMissingJobAddress(String data, boolean addAll) {
        DefAddressData dad;
        block5: {
            String[] jobAddressData = PSEnvironment.tokenStringToStringArray(data, "|");
            int i = 0;
            while (i < jobAddressData.length) {
                jobAddressData[i] = jobAddressData[i].replace('+', '&');
                ++i;
            }
            dad = new DefAddressData();
            dad.absender.Name = jobAddressData[0].trim();
            dad.absender.Ort = jobAddressData[1].trim();
            dad.absender.Strasse = jobAddressData[2].trim();
            dad.absender.PLZ = jobAddressData[3].trim();
            dad.absender.PFPLZ = jobAddressData[4].trim();
            dad.absender.PF = jobAddressData[5].trim();
            dad.absender.PFOrt = jobAddressData[6].trim();
            dad.absender.Land = jobAddressData[7].trim();
            dad.absender.Telefon = jobAddressData[8].trim();
            dad.absender.KDNR = jobAddressData[9].trim();
            dad.absender.ERGNR = jobAddressData[10].trim();
            dad.absender.KARTENNR = jobAddressData[11].trim();
            dad.absender.importedAddress = "1";
            if (addAll && jobAddressData.length > 12) {
                dad.bank.Geldinstitut = jobAddressData[12].trim();
                dad.bank.Kontobezeichnung = jobAddressData[13].trim();
                dad.bank.Kontonummer = jobAddressData[14].trim();
                dad.bank.BLZ = jobAddressData[15].trim();
                try {
                    dad.bank.iban = jobAddressData[16].trim();
                    dad.bank.bic = jobAddressData[17].trim();
                }
                catch (ArrayIndexOutOfBoundsException aioobEx) {
                    System.out.println("NO SEPA data in record!");
                    if (dad.bank.Kontonummer.length() > 2 && dad.bank.BLZ.length() == 8) {
                        String sepaData = String.valueOf(dad.bank.Kontonummer) + "|" + dad.bank.BLZ;
                        PSO.cc.SendMessage(380, sepaData);
                    }
                    if (dad.bank.iban.length() < 15 || dad.bank.bic.length() < 8) break block5;
                    String sepaData = String.valueOf(dad.bank.iban) + "|" + dad.bank.bic;
                    PSO.cc.SendMessage(381, sepaData);
                }
            }
        }
        addressRecords.addElement(dad);
        AddressManager.sortRecords();
        AddressManager.storeRecordsServerSide();
        PSO.mainpanel.AE.addressDataReady();
    }

    public static int findAddressInUse(DefKunde jobAddress) {
        int result = -1;
        int i = 0;
        while (i < addressRecords.size()) {
            DefAddressData dad = addressRecords.elementAt(i);
            DefKunde dk = dad.absender;
            if (dk.equals(jobAddress)) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    public static int findAddress(String jobAddress, boolean compareAll) {
        int addressIndex = -1;
        int kdnrPos = 9;
        String[] jobAddressData = PSEnvironment.tokenStringToStringArray(jobAddress, "|");
        int i = 0;
        while (i < addressRecords.size()) {
            DefAddressData dad = addressRecords.elementAt(i);
            if (jobAddressData[kdnrPos].trim().equals(dad.absender.KDNR.trim())) {
                boolean isSameRecord;
                block22: {
                    isSameRecord = jobAddressData[0].trim().equals(dad.absender.Name.trim());
                    if (isSameRecord) {
                        isSameRecord = jobAddressData[1].trim().equals(dad.absender.Ort.trim());
                    }
                    if (isSameRecord) {
                        isSameRecord = jobAddressData[2].trim().equals(dad.absender.Strasse.trim());
                    }
                    if (isSameRecord) {
                        isSameRecord = jobAddressData[3].trim().equals(dad.absender.PLZ.trim());
                    }
                    if (isSameRecord) {
                        isSameRecord = jobAddressData[4].trim().equals(dad.absender.PFPLZ.trim());
                    }
                    if (isSameRecord) {
                        isSameRecord = jobAddressData[5].trim().equals(dad.absender.PF.trim());
                    }
                    if (isSameRecord) {
                        isSameRecord = jobAddressData[6].trim().equals(dad.absender.PFOrt.trim());
                    }
                    if (isSameRecord) {
                        isSameRecord = jobAddressData[7].trim().equals(dad.absender.Land.trim());
                    }
                    if (isSameRecord) {
                        isSameRecord = jobAddressData[8].trim().equals(dad.absender.Telefon.trim());
                    }
                    if (compareAll) {
                        if (isSameRecord) {
                            isSameRecord = jobAddressData[10].trim().equals(dad.absender.ERGNR.trim());
                        }
                        if (isSameRecord) {
                            isSameRecord = jobAddressData[11].trim().equals(dad.absender.KARTENNR.trim());
                        }
                        if (isSameRecord) {
                            isSameRecord = jobAddressData[12].trim().equals(dad.bank.Geldinstitut);
                        }
                        if (isSameRecord) {
                            isSameRecord = jobAddressData[13].trim().equals(dad.bank.Kontobezeichnung);
                        }
                        if (isSameRecord) {
                            isSameRecord = jobAddressData[14].trim().equals(dad.bank.Kontonummer);
                        }
                        if (isSameRecord) {
                            isSameRecord = jobAddressData[15].trim().equals(dad.bank.BLZ);
                        }
                        try {
                            if (isSameRecord) {
                                isSameRecord = jobAddressData[16].trim().equals(dad.bank.iban);
                            }
                            if (isSameRecord) {
                                isSameRecord = jobAddressData[17].trim().equals(dad.bank.bic);
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException aioobEx) {
                            if (!PSEnvironment.DEBUG) break block22;
                            System.out.println("NO SEPA data in record!");
                        }
                    }
                }
                if (isSameRecord) {
                    addressIndex = i;
                    break;
                }
            }
            ++i;
        }
        return addressIndex;
    }

    public static int findUseableAddress(String jobAddress, boolean compareAll) {
        int addressIndex = -1;
        int kdnrPos = 9;
        String[] jobAddressData = PSEnvironment.tokenStringToStringArray(jobAddress, "|");
        int i = 0;
        while (i < useableAddresses.size()) {
            DefAddressData dad = useableAddresses.elementAt(i);
            if (jobAddressData[kdnrPos].trim().equals(dad.absender.KDNR.trim())) {
                boolean isSameRecord;
                block22: {
                    isSameRecord = jobAddressData[0].trim().equals(dad.absender.Name.trim());
                    if (isSameRecord) {
                        isSameRecord = jobAddressData[1].trim().equals(dad.absender.Ort.trim());
                    }
                    if (isSameRecord) {
                        isSameRecord = jobAddressData[2].trim().equals(dad.absender.Strasse.trim());
                    }
                    if (isSameRecord) {
                        isSameRecord = jobAddressData[3].trim().equals(dad.absender.PLZ.trim());
                    }
                    if (isSameRecord) {
                        isSameRecord = jobAddressData[4].trim().equals(dad.absender.PFPLZ.trim());
                    }
                    if (isSameRecord) {
                        isSameRecord = jobAddressData[5].trim().equals(dad.absender.PF.trim());
                    }
                    if (isSameRecord) {
                        isSameRecord = jobAddressData[6].trim().equals(dad.absender.PFOrt.trim());
                    }
                    if (isSameRecord) {
                        isSameRecord = jobAddressData[7].trim().equals(dad.absender.Land.trim());
                    }
                    if (isSameRecord) {
                        isSameRecord = jobAddressData[8].trim().equals(dad.absender.Telefon.trim());
                    }
                    if (isSameRecord) {
                        isSameRecord = jobAddressData[10].trim().equals(dad.absender.ERGNR.trim());
                    }
                    if (isSameRecord) {
                        isSameRecord = jobAddressData[11].trim().equals(dad.absender.KARTENNR.trim());
                    }
                    if (compareAll) {
                        if (isSameRecord) {
                            isSameRecord = jobAddressData[12].trim().equals(dad.bank.Geldinstitut.trim());
                        }
                        if (isSameRecord) {
                            isSameRecord = jobAddressData[13].trim().equals(dad.bank.Kontobezeichnung.trim());
                        }
                        if (isSameRecord) {
                            isSameRecord = jobAddressData[14].trim().equals(dad.bank.Kontonummer.trim());
                        }
                        if (isSameRecord) {
                            isSameRecord = jobAddressData[15].trim().equals(dad.bank.BLZ.trim());
                        }
                        try {
                            if (isSameRecord) {
                                isSameRecord = jobAddressData[16].trim().equals(dad.bank.iban);
                            }
                            if (isSameRecord) {
                                isSameRecord = jobAddressData[17].trim().equals(dad.bank.bic);
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException aioobEx) {
                            if (!PSEnvironment.DEBUG) break block22;
                            System.out.println("NO SEPA data in record!");
                        }
                    }
                }
                if (isSameRecord) {
                    addressIndex = i;
                    break;
                }
            }
            ++i;
        }
        return addressIndex;
    }

    public static boolean bankDataVerified(int index) {
        boolean result = false;
        if (index > -1 && index < addressRecords.size()) {
            DefAddressData dad = addressRecords.elementAt(index);
            result = dad.bank.iban.length() >= 15 && dad.bank.bic.length() >= 8 && dad.bank.BLZ.length() >= 3 && dad.bank.Kontonummer.length() >= 2;
        }
        return result;
    }

    public static boolean recordHasBankData(int index) {
        boolean result = false;
        if (index > -1 && index < addressRecords.size()) {
            if (PSEnvironment.isSepaActive()) {
                DefAddressData dad = addressRecords.elementAt(index);
                if (dad.bank.iban.length() >= 15 && dad.bank.bic.length() >= 8) {
                    result = true;
                }
            } else {
                DefAddressData dad = addressRecords.elementAt(index);
                if (dad.bank.BLZ.length() >= 3 && dad.bank.Geldinstitut.length() > 2 && dad.bank.Kontonummer.length() > 1) {
                    result = true;
                }
            }
        }
        return result;
    }

    public static int getAddressIndex(DefAddressData dad) {
        int index = -1;
        int i = 0;
        while (i < addressRecords.size()) {
            DefAddressData storedRecord = addressRecords.elementAt(i);
            if (storedRecord.equals(dad)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public static boolean isEmptyRecord(String data) {
        boolean result = false;
        String[] record = PSEnvironment.tokenStringToStringArray(data, "|");
        if (record[0].trim().length() == 0) {
            result = true;
        }
        return result;
    }

    public static boolean needsToPayCash(int index) {
        DefAddressData dad = addressRecords.elementAt(index);
        return dad.absender.ERGNR.length() <= 0;
    }

    public static void storeDefaults(int aIndex, int eIndex, int zIndex, int zahler, int zahlungsweise) {
        try {
            Vector<Serializable> toStore = new Vector<Serializable>();
            toStore.addElement(aIndex > -1 ? addressRecords.elementAt(aIndex) : new DefAddressData());
            toStore.addElement(eIndex > -1 ? addressRecords.elementAt(eIndex) : new DefAddressData());
            toStore.addElement(zIndex > -1 ? addressRecords.elementAt(zIndex) : new DefAddressData());
            toStore.addElement(new Integer(zahler));
            toStore.addElement(new Integer(PSAuftrag.cbformulare.cb_abs_einl ? 1 : 0));
            toStore.addElement(new Integer(zahlungsweise));
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(String.valueOf(dataPath) + "/" + STORED_DEFAULTS));
            oos.writeObject(toStore);
            oos.flush();
            oos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void resetDefaults() {
        try {
            File f = new File(String.valueOf(dataPath) + "/" + STORED_DEFAULTS);
            if (f.exists()) {
                f.delete();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getStoredDefaults() {
        String result = "";
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(String.valueOf(dataPath) + "/" + STORED_DEFAULTS));
            Vector defaults = (Vector)ois.readObject();
            DefAddressData dad = (DefAddressData)defaults.elementAt(0);
            int index = AddressManager.findIdenticalRecord(dad);
            result = String.valueOf(index) + DELIMITER;
            dad = (DefAddressData)defaults.elementAt(1);
            index = AddressManager.findIdenticalRecord(dad);
            result = String.valueOf(result) + index + DELIMITER;
            dad = (DefAddressData)defaults.elementAt(2);
            index = AddressManager.findIdenticalRecord(dad);
            result = String.valueOf(result) + index + DELIMITER;
            Integer val = (Integer)defaults.elementAt(3);
            result = String.valueOf(result) + val + DELIMITER;
            val = (Integer)defaults.elementAt(4);
            result = String.valueOf(result) + val;
            if (defaults.size() > 5) {
                result = String.valueOf(result) + DELIMITER;
                val = (Integer)defaults.elementAt(5);
                result = String.valueOf(result) + val;
            }
            ois.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static int findIdenticalRecord(DefAddressData dad) {
        int result = -1;
        int i = 0;
        while (i < addressRecords.size()) {
            DefAddressData used = addressRecords.elementAt(i);
            boolean identical = used.absender.Name.equals(dad.absender.Name);
            if (identical) {
                identical = used.absender.ERGNR.equals(dad.absender.ERGNR);
            }
            if (identical) {
                identical = used.absender.KARTENNR.equals(dad.absender.KARTENNR);
            }
            if (identical) {
                identical = used.absender.KDNR.equals(dad.absender.KDNR);
            }
            if (identical) {
                identical = used.absender.Land.equals(dad.absender.Land);
            }
            if (identical) {
                identical = used.absender.Ort.equals(dad.absender.Ort);
            }
            if (identical) {
                identical = used.absender.PF.equals(dad.absender.PF);
            }
            if (identical) {
                identical = used.absender.PFPLZ.equals(dad.absender.PFPLZ);
            }
            if (identical) {
                identical = used.absender.PFOrt.equals(dad.absender.PFOrt);
            }
            if (identical) {
                identical = used.absender.PLZ.equals(dad.absender.PLZ);
            }
            if (identical) {
                identical = used.absender.Strasse.equals(dad.absender.Strasse);
            }
            if (identical) {
                identical = used.absender.Telefon.equals(dad.absender.Telefon);
            }
            if (identical) {
                identical = used.bank.BLZ.equals(dad.bank.BLZ);
            }
            if (identical) {
                identical = used.bank.Geldinstitut.equals(dad.bank.Geldinstitut);
            }
            if (identical) {
                identical = used.bank.Kontonummer.equals(dad.bank.Kontonummer);
            }
            if (identical) {
                identical = used.bank.iban.equals(dad.bank.iban);
            }
            if (identical) {
                identical = used.bank.bic.equals(dad.bank.bic);
            }
            if (identical) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    public static void loadRecordsServerSide(String data) {
        try {
            if (data.length() > 0) {
                StringTokenizer t = new StringTokenizer(data, "|");
                while (t.hasMoreTokens()) {
                    AddressManager.convertIn(t.nextToken());
                }
            } else {
                AddressManager.initFromFile();
                AddressManager.storeRecordsServerSide();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void storeRecordsServerSide() {
        try {
            String data = "";
            int i = 0;
            while (i < addressRecords.size()) {
                DefAddressData address = addressRecords.elementAt(i);
                String line = AddressManager.convertOut(address);
                data = String.valueOf(data) + line + "|";
                ++i;
            }
            if (data.length() > 0) {
                data = data.substring(0, data.length() - 1);
                PSO.cc.SendMessage(372, data);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static class AddressComparator
    implements Comparator<DefAddressData> {
        private AddressComparator() {
        }

        @Override
        public int compare(DefAddressData adr1, DefAddressData adr2) {
            int result;
            block11: {
                result = 0;
                char[] name1 = adr1.absender.Name.toCharArray();
                char[] name2 = adr2.absender.Name.toCharArray();
                int i = 0;
                while (i < name1.length) {
                    if (i >= name2.length) {
                        result = -1;
                        break;
                    }
                    if (name1[i] > name2[i]) {
                        result = 1;
                        break;
                    }
                    if (name1[i] < name2[i]) {
                        result = -1;
                        break;
                    }
                    ++i;
                }
                if (result == 0) {
                    try {
                        if (Long.parseLong(adr1.absender.KDNR) > Long.parseLong(adr2.absender.KDNR)) {
                            result = 1;
                        } else if (Long.parseLong(adr1.absender.KDNR) < Long.parseLong(adr2.absender.KDNR)) {
                            result = -1;
                        }
                    }
                    catch (Exception ex) {
                        if (adr1.absender.KDNR.length() < 10) {
                            result = 1;
                        }
                        if (adr2.absender.KDNR.length() >= 10) break block11;
                        result = -1;
                    }
                }
            }
            return result;
        }
    }
}

