/*
 * Decompiled with CFR 0.152.
 */
package de.codesolutions.pam.map;

import de.codesolutions.pam.map.ScriptBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import prospektservice.AKManager;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.PSOConstants;
import prospektservice.PSUser;
import prospektservice.base.ColorButton;
import prospektservice.base.PSJCheckBox;
import prospektservice.base.PSJRadioButton;
import prospektservice.base.progress.ProgressEvent;
import prospektservice.base.progress.VolumeProgressDialog;
import prospektservice.definitions.DefAK;
import prospektservice.definitions.DefAKcolors;
import prospektservice.definitions.DefAKinfo;
import prospektservice.dialog.ChangeColorForm;
import prospektservice.dialog.frmHelp;

public class MapOptionsPane
extends JTabbedPane
implements PSOConstants {
    private static final long serialVersionUID = -4096816469911028511L;
    private static ResourceBundle localProperty;
    private PSO pso;
    private ChangeColorForm chgcolor;
    private JScrollPane legendScroller;
    private Vector<DefAK> AKchoiceList = new Vector();
    private JPanel mpanel;
    private JLabel lbl1;
    private JLabel lbl2;
    private JLabel lbl2b;
    private JLabel lbl3;
    private JLabel[] lblp = new JLabel[5];
    private JButton[] txtc = new JButton[5];
    private JButton[] txtcs = new JButton[5];
    private JPanel uppanel;
    private JPanel legendepanel;
    private PSJCheckBox chkShowZBez;
    private JPanel choicepanel;
    private JList AKchoose;
    private PSJRadioButton[] akSelection;
    private ActionListener akSelListener;
    private JComboBox<String> cmbRasterLayer;
    private JComboBox cmbAKOwn = new JComboBox();
    private JComboBox cmbAKElection = new JComboBox();
    private JLabel lblUnselected;
    private JLabel lblSelected;
    private DefaultComboBoxModel AKchooseCbm;
    private JTextArea txtarea;
    private JButton cmdEinfarben;
    private JButton cmdHelp;
    private JTextArea txtDownloadHint;
    private JRadioButton optPLZMap;
    private JRadioButton optKreisMap;
    private VolumeProgressDialog progress;
    private int updateCnt;
    private int progressCnt;

    public MapOptionsPane(int width, int height) {
        this.pso = PSO.mainpanel;
        localProperty = ResourceBundle.getBundle("properties.MapOptionsPane", PSUser.getLanguage());
        AKManager.initialize(this.pso);
        this.setBounds(0, 12, width, height);
        this.legendScroller = new JScrollPane(20, 31);
        this.legendScroller.setBounds(0, 12, width, height);
        this.legendScroller.setViewportView(this.createPaneChoice());
        this.add((Component)this.legendScroller, localProperty.getString("Title"));
    }

    public void updateSize(int width, int height) {
        this.setBounds(0, 12, width, height);
        this.legendScroller.setBounds(0, 12, width, height);
    }

    public JPanel createPaneChoice() {
        this.mpanel = new JPanel();
        Dimension d = new Dimension(this.getSize().width, 540);
        this.mpanel.setPreferredSize(d);
        this.mpanel.setLayout(null);
        this.uppanel = new JPanel();
        this.uppanel.setBorder(new TitledBorder(""));
        this.uppanel.setBounds(11, 15, 376, 150);
        this.uppanel.setLayout(null);
        JLabel lblMapBase = new JLabel(localProperty.getString("lblMapProvider"));
        lblMapBase.setBounds(10, 10, 100, 20);
        this.uppanel.add(lblMapBase);
        this.cmbRasterLayer = new JComboBox();
        this.cmbRasterLayer.addItem("Bing Maps");
        this.cmbRasterLayer.addItem("Open street Maps");
        this.cmbRasterLayer.addItem("Top Plus Open");
        this.cmbRasterLayer.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    int index = MapOptionsPane.this.cmbRasterLayer.getSelectedIndex();
                    MapOptionsPane.this.pso.getWmp().setRasterLayer(index);
                }
            }
        });
        this.cmbRasterLayer.setBounds(120, 10, 150, 25);
        this.uppanel.add(this.cmbRasterLayer);
        this.legendepanel = new JPanel();
        this.legendepanel.setBorder(new TitledBorder(localProperty.getString("cPCTitel")));
        this.legendepanel.setBounds(9, 165, 380, 380);
        this.legendepanel.setLayout(null);
        this.chkShowZBez = this.MyCheckBox(localProperty.getString("chkZBez"), 'D', 10, 105, 170, 16);
        if (PSEnvironment.isMacOSPlatform()) {
            this.chkShowZBez.setFont(PSEnvironment.Arial9);
        }
        this.chkShowZBez.setToolTipText(localProperty.getString("chkZBezTT"));
        this.chkShowZBez.setEnabled(PSO.Modus == 5);
        this.chkShowZBez.setSelected(PSO.Modus == 5);
        this.uppanel.add(this.chkShowZBez);
        this.chkShowZBez.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PSJCheckBox cb = (PSJCheckBox)e.getSource();
                MapOptionsPane.this.pso.getWmp().setZBezEnabled(cb.isSelected());
            }
        });
        JLabel lblActiveMap = new JLabel(localProperty.getString("lblActiveMap"));
        lblActiveMap.setBounds(10, 50, 100, 20);
        this.uppanel.add(lblActiveMap);
        ButtonGroup bg = new ButtonGroup();
        this.optPLZMap = new JRadioButton(localProperty.getString("optPLZMap"));
        this.optPLZMap.setBounds(115, 50, 140, 20);
        this.optPLZMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MapOptionsPane.this.optPLZMap.isSelected()) {
                    MapOptionsPane.this.pso.getWmp().setMapMode(0);
                    PSEnvironment.aktiveKarte = 10;
                    PSO.cc.SendMessage(80, Integer.toString(PSEnvironment.aktiveKarte));
                    if (MapOptionsPane.this.pso.isSelectionContainingRows()) {
                        PSO.cc.SendMessage(258, " ");
                    }
                }
                int i = 0;
                while (i < 3) {
                    MapOptionsPane.this.akSelection[i].setEnabled(true);
                    ++i;
                }
            }
        });
        this.optPLZMap.setSelected(true);
        bg.add(this.optPLZMap);
        this.uppanel.add(this.optPLZMap);
        this.optKreisMap = new JRadioButton(localProperty.getString("optKreisMap"));
        this.optKreisMap.setBounds(115, 75, 180, 20);
        this.optKreisMap.setEnabled(PSO.Modus < 3);
        this.optKreisMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MapOptionsPane.this.optKreisMap.isSelected()) {
                    MapOptionsPane.this.pso.getWmp().setMapMode(1);
                    PSEnvironment.aktiveKarte = 11;
                    PSO.cc.SendMessage(80, Integer.toString(PSEnvironment.aktiveKarte));
                    if (MapOptionsPane.this.pso.isSelectionContainingRows()) {
                        PSO.cc.SendMessage(258, " ");
                    }
                    int i = 0;
                    while (i < 3) {
                        MapOptionsPane.this.akSelection[i].setEnabled(false);
                        ++i;
                    }
                }
            }
        });
        bg.add(this.optKreisMap);
        this.uppanel.add(this.optKreisMap);
        this.choicepanel = new JPanel();
        this.choicepanel.setBounds(10, 20, 180, 100);
        this.choicepanel.updateUI();
        this.choicepanel.setLayout(new BorderLayout());
        this.AKchoose = new JList();
        this.AKchoose.setVisibleRowCount(10);
        JScrollPane choiceListScrollPane = new JScrollPane();
        choiceListScrollPane.getViewport().setView(this.AKchoose);
        this.choicepanel.add((Component)choiceListScrollPane, "Center");
        this.AKchoose.setEnabled(false);
        this.AKchoose.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
            }
        });
        int i = 0;
        while (i < 3) {
            ++i;
        }
        this.lbl1 = new JLabel();
        this.lbl1.setBounds(200, 20, PSEnvironment.isMacOSPlatform() ? 160 : 180, 16);
        this.legendepanel.add(this.lbl1);
        this.lbl2 = new JLabel();
        this.lbl2.setFont(PSEnvironment.Arial10);
        this.lbl2.setBounds(200, 40, PSEnvironment.isMacOSPlatform() ? 160 : 180, 12);
        this.legendepanel.add(this.lbl2);
        this.lbl2b = new JLabel();
        this.lbl2b.setFont(PSEnvironment.Arial10);
        this.lbl2b.setBounds(200, 52, PSEnvironment.isMacOSPlatform() ? 160 : 180, 12);
        this.legendepanel.add(this.lbl2b);
        this.txtarea = new JTextArea();
        this.txtarea.setLineWrap(true);
        this.txtarea.setWrapStyleWord(true);
        this.txtarea.setEditable(false);
        this.txtarea.setBackground(this.mpanel.getBackground());
        JScrollPane txtareascroller = new JScrollPane();
        txtareascroller.setBounds(10, 281, PSEnvironment.isMacOSPlatform() ? 350 : 360, 66);
        txtareascroller.getViewport().add(this.txtarea);
        this.legendepanel.add(txtareascroller);
        this.lblUnselected = new JLabel(localProperty.getString("lblUnselected"));
        this.lblUnselected.setBounds(160, 80, 100, 20);
        this.lblUnselected.setHorizontalAlignment(0);
        this.lblUnselected.setVisible(false);
        this.legendepanel.add(this.lblUnselected);
        this.lblSelected = new JLabel(localProperty.getString("lblSelected"));
        this.lblSelected.setBounds(288, 80, 60, 20);
        this.lblSelected.setHorizontalAlignment(0);
        this.lblSelected.setVisible(false);
        this.legendepanel.add(this.lblSelected);
        ColorButtonListener cbl = new ColorButtonListener();
        int i2 = 0;
        while (i2 < 5) {
            this.txtc[i2] = new ColorButton();
            this.txtc[i2].setBounds(200, 100 + i2 * 30, 25, 20);
            this.txtc[i2].setVisible(false);
            this.txtc[i2].setActionCommand(String.valueOf(i2));
            this.txtc[i2].addActionListener(cbl);
            this.txtc[i2].setBorder(BorderFactory.createEtchedBorder(SystemColor.white, SystemColor.gray));
            this.legendepanel.add(this.txtc[i2]);
            this.lblp[i2] = new JLabel();
            this.lblp[i2].setBounds(225, 100 + i2 * 30, 80, 16);
            this.lblp[i2].setHorizontalAlignment(0);
            this.lblp[i2].setVisible(false);
            this.legendepanel.add(this.lblp[i2]);
            this.txtcs[i2] = new ColorButton();
            this.txtcs[i2].setBounds(305, 100 + i2 * 30, 25, 20);
            this.txtcs[i2].setVisible(false);
            this.txtcs[i2].setActionCommand(String.valueOf(i2 + 5));
            this.txtcs[i2].addActionListener(cbl);
            this.txtcs[i2].setBorder(BorderFactory.createEtchedBorder(SystemColor.white, SystemColor.gray));
            this.legendepanel.add(this.txtcs[i2]);
            ++i2;
        }
        this.lbl3 = new JLabel();
        this.lbl3.setFont(PSEnvironment.Arial10);
        this.lbl3.setBounds(210, 240, 150, 32);
        this.lbl3.setHorizontalAlignment(4);
        this.legendepanel.add(this.lbl3);
        this.akSelection = new PSJRadioButton[3];
        boolean cntXtra = false;
        ButtonGroup bg2 = new ButtonGroup();
        int i3 = 0;
        while (i3 < this.akSelection.length) {
            this.akSelection[i3] = new PSJRadioButton(localProperty.getString("akSel_" + i3));
            if (i3 == 0) {
                this.akSelection[i3].setSelected(true);
            }
            this.akSelection[i3].setBounds(10, 15 + i3 * 20, 170, 16);
            this.akSelection[i3].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JRadioButton src = (JRadioButton)e.getSource();
                    int id = PSEnvironment.getIntValue(src.getActionCommand());
                    MapOptionsPane.this.lbl1.setVisible(false);
                    MapOptionsPane.this.lbl2.setVisible(false);
                    MapOptionsPane.this.lbl2b.setVisible(false);
                    MapOptionsPane.this.lbl3.setVisible(false);
                    int i = 0;
                    while (i < 5) {
                        MapOptionsPane.this.txtc[i].setVisible(false);
                        MapOptionsPane.this.txtcs[i].setVisible(false);
                        MapOptionsPane.this.lblp[i].setVisible(false);
                        MapOptionsPane.this.lblSelected.setVisible(false);
                        MapOptionsPane.this.lblUnselected.setVisible(false);
                        ++i;
                    }
                    if (src == MapOptionsPane.this.akSelection[0]) {
                        MapOptionsPane.this.pso.getWmp().disableDataVisualization();
                        MapOptionsPane.this.txtarea.setText("");
                        AKManager.setActualIndex(0);
                    } else {
                        AKManager.setActualIndex(id);
                        AKManager.AKload(id, 0);
                        DefAKinfo info = AKManager.getAKinfo();
                        MapOptionsPane.this.updatePaneChoice(info);
                        MapOptionsPane.this.pso.getWmp().enableDataVisualization(id);
                    }
                }
            });
            if (PSEnvironment.isMacOSPlatform()) {
                this.akSelection[i3].setFont(PSEnvironment.Arial9);
            }
            this.akSelection[i3].setActionCommand("" + (i3 + 1));
            this.legendepanel.add(this.akSelection[i3]);
            bg2.add(this.akSelection[i3]);
            ++i3;
        }
        this.cmdHelp = this.MyButton(localProperty.getString("cmdHelp"), 'H', 160, 425, 90, 20);
        this.mpanel.add(this.cmdHelp);
        this.cmdHelp.setEnabled(true);
        this.cmdHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frmHelp frmHelp2 = frmHelp.getInstance("hilfe/hilfe_legende.html", MapOptionsPane.this.pso);
            }
        });
        this.mpanel.add(this.uppanel);
        this.mpanel.add(this.legendepanel);
        this.mpanel.invalidate();
        this.mpanel.validate();
        this.mpanel.repaint();
        return this.mpanel;
    }

    public void reset() {
        this.optPLZMap.setSelected(true);
        this.chkShowZBez.setSelected(false);
        this.akSelection[0].setSelected(true);
        this.pso.getWmp().disableDataVisualization();
        this.txtarea.setText("");
        AKManager.setActualIndex(0);
        this.lbl1.setVisible(false);
        this.lbl2.setVisible(false);
        this.lbl2b.setVisible(false);
        this.lbl3.setVisible(false);
        int i = 0;
        while (i < 5) {
            this.txtc[i].setVisible(false);
            this.txtcs[i].setVisible(false);
            this.lblp[i].setVisible(false);
            this.lblSelected.setVisible(false);
            this.lblUnselected.setVisible(false);
            ++i;
        }
    }

    private JButton MyButton(String caption, char shortkey, int x, int y, int w, int h) {
        JButton mybutton = new JButton(caption);
        if (shortkey != ' ') {
            mybutton.setMnemonic(shortkey);
        }
        mybutton.setBounds(x, y, w, h);
        mybutton.setMinimumSize(new Dimension(w, h));
        return mybutton;
    }

    private PSJCheckBox MyCheckBox(String caption, char shortkey, int x, int y, int w, int h) {
        PSJCheckBox mycheckbox = new PSJCheckBox(caption);
        if (shortkey != ' ') {
            mycheckbox.setMnemonic(shortkey);
        }
        mycheckbox.setBounds(x, y, w, h);
        mycheckbox.setMinimumSize(new Dimension(w, h));
        return mycheckbox;
    }

    private void updatePaneChoice(DefAKinfo info) {
        this.txtarea.setText(info.Beschreibung);
        this.txtarea.setVisible(true);
        this.lbl1.setText(info.Titel);
        if (PSEnvironment.getComponentWidth(info.Untertitel, this.pso, this.lbl2.getFont()) > this.lbl2.getWidth()) {
            int cutIndex = -1;
            String tmp = info.Untertitel;
            while (PSEnvironment.getComponentWidth(tmp, this.pso, this.lbl2.getFont()) > this.lbl2.getWidth()) {
                cutIndex = tmp.lastIndexOf(" ");
                tmp = tmp.substring(0, cutIndex);
            }
            this.lbl2.setText(tmp);
            this.lbl2b.setText(info.Untertitel.substring(++cutIndex, info.Untertitel.length()));
            this.lbl2b.setVisible(true);
        } else {
            this.lbl2.setText(info.Untertitel);
            this.lbl2b.setText("");
            this.lbl2b.setVisible(false);
        }
        this.lbl3.setText("<html>" + info.Summary + "</html>");
        this.lbl1.setVisible(true);
        this.lbl2.setVisible(true);
        this.lbl3.setVisible(true);
        this.setColors(AKManager.getAKcolors());
        int i = 0;
        while (i < info.Feldanzahl) {
            int idx = PSEnvironment.getIntValue(info.Class.elementAt(i)) - 1;
            this.txtc[idx].setVisible(true);
            this.txtcs[idx].setVisible(true);
            this.lblp[idx].setText(info.Label.elementAt(i));
            this.lblp[idx].setVisible(true);
            ++i;
        }
        this.lblSelected.setVisible(true);
        this.lblUnselected.setVisible(true);
    }

    public void setColors(DefAKcolors colors) {
        int i = 0;
        while (i < colors.Class.size()) {
            int index = PSEnvironment.getIntValue(colors.Class.elementAt(i));
            this.txtc[--index].setBackground(colors.unselected.elementAt(i));
            this.txtcs[index].setBackground(colors.selected.elementAt(i));
            ++i;
        }
    }

    public void enableZbnOption(boolean flag) {
        this.chkShowZBez.setEnabled(flag);
        this.chkShowZBez.setSelected(flag);
    }

    public void setKreiskarteAvailable(boolean flag) {
        this.optKreisMap.setEnabled(flag);
    }

    public void getUpdatedAKs() {
        int i = 0;
        while (i < AKManager.AKsOrg.size()) {
            DefAK ak = AKManager.AKsOrg.elementAt(i);
            if (!ak.up2date) {
                PSO.cc.SendMessage(257, String.valueOf(ak.id));
                PSO.cc.SendMessage(256, String.valueOf(ak.id));
                ++this.updateCnt;
            }
            ++i;
        }
        if (this.updateCnt > 0) {
            this.progress = new VolumeProgressDialog(this.pso, true, false, this.updateCnt, 100, false){

                @Override
                public void progressDialogStarted(ProgressEvent ppe) {
                }

                @Override
                public void progressDialogBroken(ProgressEvent ppe) {
                }

                @Override
                public void progressDialogChanged(ProgressEvent ppe) {
                    MapOptionsPane.this.progress.showProgressDialog();
                }

                @Override
                public void progressDialogEndet(ProgressEvent ppe) {
                }
            };
            this.progress.setPureVolumeProgress(true);
            this.progress.setProgressTitle("Einen Moment bitte");
            this.progress.setProgressLabel("Aktualisiere Strukturdaten...");
            this.progress.run();
            this.progress.setActionButtonVisible(false);
        }
    }

    public void YoAKData(String value) {
        StringTokenizer tmain = new StringTokenizer(value, "|");
        int id = PSEnvironment.getIntValue(tmain.nextToken());
        AKManager.dataSave(id, 0, tmain.nextToken());
        AKManager.updateVersion(id, 0);
        this.progress.setProgressValue(++this.progressCnt);
        if (this.progressCnt == this.updateCnt) {
            this.progress.closeProgressDialog();
            ScriptBuilder.init();
        }
    }

    class ColorButtonListener
    implements ActionListener {
        ColorButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefAKcolors colors;
            JButton source = (JButton)e.getSource();
            int src = 1;
            int taste = PSEnvironment.getIntValue(source.getActionCommand());
            if (src == 1) {
                colors = AKManager.getAKcolors();
            } else {
                colors = new DefAKcolors();
                int i = 0;
                while (i < 5) {
                    ++i;
                }
            }
            if (MapOptionsPane.this.chgcolor == null) {
                MapOptionsPane.this.chgcolor = new ChangeColorForm(MapOptionsPane.this.pso, taste, src, colors);
            } else {
                MapOptionsPane.this.chgcolor.resetForm(taste, src, colors);
            }
            MapOptionsPane.this.chgcolor.setVisible(true);
        }
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 3256442495239073843L;

        public MyCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Vector aklist = MapOptionsPane.this.AKchoiceList;
            boolean min = true;
            Color fore = UIManager.getColor("ComboBox.Foreground");
            Color back = UIManager.getColor("ComboBox.Background");
            Color sfore = UIManager.getColor("ComboBox.selectionForeground");
            Color sback = UIManager.getColor("ComboBox.selectionBackground");
            Color color = fore;
            if (value != null) {
                this.setText(value.toString());
            }
            this.setBackground(isSelected ? sback : back);
            return this;
        }
    }
}

