/*
 * Decompiled with CFR 0.152.
 */
import de.codesolutions.pam.map.WebMapPanel;
import java.io.File;
import java.io.PrintStream;
import java.util.ResourceBundle;
import prospektservice.ClassPathHacker;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import ru.krlvm.swingdpi.SwingDPI;

public class PSOStart {
    private static boolean dbgVersion = false;
    private static final String DBG_FILE_MAC = "../../../pamdbg.log";
    private static final String DBG_FILE_WIN = "%USERPROFILE%/Desktop/pamdbg.log";

    public static void main(String[] args) {
        try {
            PSOStart.adjustPath();
            if (dbgVersion) {
                File f = new File(DBG_FILE_WIN);
                PrintStream ps = new PrintStream(f);
                System.setOut(ps);
                System.setErr(ps);
            }
            System.out.println("POSTAKTUELL MANAGER - Version " + PSEnvironment.getPSVersionProperty("PS.Client.Version"));
            System.out.println("(c) 2025 Code-Solutions GmbH Berlin");
            System.out.println("Running on jvm " + System.getProperty("java.version"));
            PSEnvironment.setLookAndFeel();
            PSEnvironment.setEmergencyDeathHotkey(PSEnvironment.hotkey, PSEnvironment.hkModifiers);
            ClassPathHacker.addFile("./classes/js.jar");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PSEnvironment.DEBUG = dbgVersion;
        if (PSEnvironment.isMacOSPlatform() && PSEnvironment.DEBUG) {
            System.out.println("Oh my god, it's a MAC!!!");
        }
        SwingDPI.applyScalingAutomatically();
        WebMapPanel.init(args);
        PSO bla = new PSO(ResourceBundle.getBundle("properties.PSO", PSEnvironment.getEnvironmentLanguage()).getString("Title"));
        if (PSEnvironment.isMacOSPlatform()) {
            PSEnvironment.fixOSXModalWndBug(bla);
        }
    }

    private static void adjustPath() {
        File f = new File("");
        String cwd = f.getAbsolutePath();
        if (cwd.endsWith("bin") || cwd.endsWith("bin" + PSEnvironment.FILE_SEPARATOR)) {
            int endPos;
            if (cwd.endsWith(PSEnvironment.FILE_SEPARATOR)) {
                cwd = cwd.substring(0, cwd.length() - 1);
            }
            if ((endPos = cwd.lastIndexOf(PSEnvironment.FILE_SEPARATOR)) > -1) {
                cwd = cwd.substring(0, ++endPos);
            }
            System.setProperty("user.dir", cwd);
        }
        PSEnvironment.init();
        PSEnvironment.checkTerminalServerMode();
    }
}

