/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.sun.pdfview.font.FlPoint;
import com.sun.pdfview.font.FontSupport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TestType1CFont
extends JPanel
implements KeyListener {
    int[] encoding = new int[256];
    int[] glyphnames;
    String[] names;
    HashMap<String, GlyphData> charset = new HashMap();
    ArrayList<String> charnames = new ArrayList();
    int charcounter = -1;
    byte[] data;
    int pos;
    byte[][] subrs;
    float[] stack = new float[100];
    int stackptr = 0;
    AffineTransform at = new AffineTransform(0.001f, 0.0f, 0.0f, 0.001f, 0.0f, 0.0f);
    int num;
    float fnum;
    int type;
    static int CMD = 0;
    static int NUM = 1;
    static int FLT = 2;
    GlyphData showing;
    String showname;
    Font gfont = new Font("Sans-serif", 0, 24).deriveFont(AffineTransform.getScaleInstance(1.0, -1.0));
    Color fillColor = new Color(224, 255, 255);
    int charstringtype = 2;
    float[] temps = new float[32];
    int charsetbase = 0;
    int encodingbase = 0;
    int charstringbase = 0;
    int privatebase = 0;
    int privatesize = 0;
    int gsubrbase = 0;
    int lsubrbase = 0;
    int gsubrsoffset = 0;
    int lsubrsoffset = 0;
    int defaultWidthX = 0;
    int nominalWidthX = 0;
    int nglyphs = 1;

    public boolean isRequestFocusEnabled() {
        return true;
    }

    public TestType1CFont(InputStream is) throws IOException {
        int len;
        this.setPreferredSize(new Dimension(800, 800));
        this.addKeyListener(this);
        BufferedInputStream bis = new BufferedInputStream(is);
        int count = 0;
        ArrayList al = new ArrayList();
        byte[] b = new byte[32000];
        while ((len = bis.read(b, 0, b.length)) >= 0) {
            byte[] c = new byte[len];
            System.arraycopy(b, 0, c, 0, len);
            al.add(c);
            count += len;
            b = new byte[32000];
        }
        this.data = new byte[count];
        len = 0;
        for (int i = 0; i < al.size(); ++i) {
            byte[] from = (byte[])al.get(i);
            System.arraycopy(from, 0, this.data, len, from.length);
            len += from.length;
        }
        this.pos = 0;
        this.parse();
    }

    public void keyTyped(KeyEvent evt) {
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 39) {
            ++this.charcounter;
            if (this.charcounter >= this.charnames.size()) {
                this.charcounter = 0;
            }
            this.showing = this.readGlyph((String)this.charnames.get(this.charcounter));
        } else if (evt.getKeyCode() == 37) {
            --this.charcounter;
            if (this.charcounter < 0) {
                this.charcounter = this.charnames.size() - 1;
            }
            this.showing = this.readGlyph((String)this.charnames.get(this.charcounter));
        } else {
            char c = evt.getKeyChar();
            this.showing = this.readGlyph(FontSupport.stdNames[FontSupport.standardEncoding[c & 0xFF]]);
        }
        this.repaint();
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.white);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        AffineTransform at = new AffineTransform(0.5, 0.0, 0.0, -0.5, 30.0, (double)(this.getHeight() * 3 / 4));
        g2.transform(at);
        g2.setColor(Color.black);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.showing != null) {
            this.showing.draw(g2);
        }
    }

    private void printData() {
        char[] parts = new char[17];
        int partsloc = 0;
        for (int i = 0; i < this.data.length; ++i) {
            int d = this.data[i] & 0xFF;
            parts[partsloc++] = d == 0 ? 46 : (d < 32 || d >= 127 ? 63 : (char)d);
            if (d < 16) {
                System.out.print("0" + Integer.toHexString(d));
            } else {
                System.out.print(Integer.toHexString(d));
            }
            if ((i & 0xF) == 15) {
                System.out.println("      " + new String(parts));
                partsloc = 0;
                continue;
            }
            if ((i & 7) == 7) {
                System.out.print("  ");
                parts[partsloc++] = 32;
                continue;
            }
            if ((i & 1) != 1) continue;
            System.out.print(" ");
        }
        System.out.println();
    }

    private int readNext(boolean charstring) {
        this.num = this.data[this.pos++] & 0xFF;
        if (this.num == 30 && !charstring) {
            this.readFNum();
            this.type = FLT;
            return this.type;
        }
        if (this.num == 28) {
            this.num = (this.data[this.pos] << 8) + (this.data[this.pos + 1] & 0xFF);
            this.pos += 2;
            this.type = NUM;
            return this.type;
        }
        if (this.num == 29 && !charstring) {
            this.num = (this.data[this.pos] & 0xFF) << 24 | (this.data[this.pos + 1] & 0xFF) << 16 | (this.data[this.pos + 2] & 0xFF) << 8 | this.data[this.pos + 3] & 0xFF;
            this.pos += 4;
            this.type = NUM;
            return this.type;
        }
        if (this.num == 12) {
            this.num = 1000 + (this.data[this.pos++] & 0xFF);
            this.type = CMD;
            return this.type;
        }
        if (this.num < 32) {
            this.type = CMD;
            return this.type;
        }
        if (this.num < 247) {
            this.num -= 139;
            this.type = NUM;
            return this.type;
        }
        if (this.num < 251) {
            this.num = (this.num - 247) * 256 + (this.data[this.pos++] & 0xFF) + 108;
            this.type = NUM;
            return this.type;
        }
        if (this.num < 255) {
            this.num = -(this.num - 251) * 256 - (this.data[this.pos++] & 0xFF) - 108;
            this.type = NUM;
            return this.type;
        }
        if (!charstring) {
            this.printData();
            throw new RuntimeException("Got a 255 code while reading dict");
        }
        this.fnum = (float)((this.data[this.pos] & 0xFF) << 24 | (this.data[this.pos + 1] & 0xFF) << 16 | (this.data[this.pos + 2] & 0xFF) << 8 | this.data[this.pos + 3] & 0xFF) / 65536.0f;
        this.pos += 4;
        this.type = FLT;
        return this.type;
    }

    public void readFNum() {
        float f = 0.0f;
        boolean neg = false;
        int exp = 0;
        int eval = 0;
        float mul = 1.0f;
        byte work = this.data[this.pos++];
        while (true) {
            if (work == -35) {
                work = this.data[this.pos++];
            }
            int nyb = work >> 4 & 0xF;
            work = (byte)(work << 4 | 0xD);
            if (nyb < 10) {
                if (exp != 0) {
                    eval = eval * 10 + nyb;
                    continue;
                }
                if (mul == 1.0f) {
                    f = f * 10.0f + (float)nyb;
                    continue;
                }
                f += (float)nyb * mul;
                mul /= 10.0f;
                continue;
            }
            if (nyb == 10) {
                mul = 0.1f;
                continue;
            }
            if (nyb == 11) {
                exp = 1;
                continue;
            }
            if (nyb == 12) {
                exp = -1;
                continue;
            }
            if (nyb != 14) break;
            neg = true;
        }
        this.fnum = (float)(neg ? -1 : 1) * f * (float)Math.pow(10.0, eval * exp);
    }

    private int readInt(int len) {
        int n = 0;
        for (int i = 0; i < len; ++i) {
            n = n << 8 | this.data[this.pos++] & 0xFF;
        }
        return n;
    }

    private int readByte() {
        return this.data[this.pos++] & 0xFF;
    }

    public int getIndexSize(int loc) {
        int hold = this.pos;
        this.pos = loc;
        int count = this.readInt(2);
        if (count == 0) {
            return 2;
        }
        int encsz = this.readByte();
        this.pos += count * encsz;
        int end = this.readInt(encsz);
        this.pos = hold;
        return 2 + (count + 1) * encsz + end;
    }

    public Range getIndexEntry(int index, int id) {
        int hold = this.pos;
        this.pos = index;
        int count = this.readInt(2);
        int encsz = this.readByte();
        this.pos += encsz * id;
        int from = this.readInt(encsz);
        Range r = new Range(from + 2 + index + encsz * (count + 1), this.readInt(encsz) - from);
        this.pos = hold;
        return r;
    }

    private void readDict(Range r) {
        this.pos = r.getStart();
        while (this.pos < r.getEnd()) {
            int cmd = this.readCommand(false);
            if (cmd == 1006) {
                this.charstringtype = (int)this.stack[0];
            } else if (cmd == 1007) {
                this.at = this.stackptr == 4 ? new AffineTransform(this.stack[0], this.stack[1], this.stack[2], this.stack[3], 0.0f, 0.0f) : new AffineTransform(this.stack[0], this.stack[1], this.stack[2], this.stack[3], this.stack[4], this.stack[5]);
            } else if (cmd == 15) {
                this.charsetbase = (int)this.stack[0];
            } else if (cmd == 16) {
                this.encodingbase = (int)this.stack[0];
            } else if (cmd == 17) {
                this.charstringbase = (int)this.stack[0];
            } else if (cmd == 18) {
                this.privatesize = (int)this.stack[0];
                this.privatebase = (int)this.stack[1];
            } else if (cmd == 19) {
                this.lsubrbase = (int)this.stack[0];
                this.lsubrsoffset = this.calcoffset(this.lsubrbase);
            } else if (cmd == 20) {
                this.defaultWidthX = (int)this.stack[0];
            } else if (cmd == 21) {
                this.nominalWidthX = (int)this.stack[0];
            }
            this.stackptr = 0;
        }
    }

    private int readCommand(boolean charstring) {
        while (true) {
            int type;
            if ((type = this.readNext(charstring)) == CMD) {
                System.out.print("CMD= " + this.num + ", args=");
                for (int i = 0; i < this.stackptr; ++i) {
                    System.out.print(" " + this.stack[i]);
                }
                System.out.println();
                return this.num;
            }
            this.stack[this.stackptr++] = type == NUM ? (float)this.num : this.fnum;
        }
    }

    private void readEncodingData(int base) {
        if (base == 0) {
            System.out.println("**** STANDARD ENCODING!");
        } else if (base == 1) {
            System.out.println("**** EXPERT ENCODING!");
        } else {
            this.pos = base;
            int encodingtype = this.readByte();
            if ((encodingtype & 0x7F) == 0) {
                System.out.println("**** Type 0 Encoding:");
                int ncodes = this.readByte();
                for (int i = 1; i < ncodes + 1; ++i) {
                    this.encoding[i] = this.readByte();
                    System.out.println("Encoding[" + i + "] = " + this.encoding[i]);
                }
            } else if ((encodingtype & 0x7F) == 1) {
                System.out.println("**** Type 1 Encoding:");
                int nranges = this.readByte();
                int pos = 0;
                for (int i = 0; i < nranges; ++i) {
                    int start = this.readByte();
                    int more = this.readByte();
                    int j = start;
                    while (j < start + more + 1) {
                        System.out.println("Encoding[" + pos + "] = " + j);
                        this.encoding[pos++] = j++;
                    }
                }
            } else {
                System.out.println("Bad encoding type: " + encodingtype);
            }
        }
    }

    private void readGlyphNames(int base) {
        block10: {
            int type;
            block11: {
                block9: {
                    if (base == 0) {
                        System.out.println("**** Identity glyphNames");
                        this.glyphnames = new int[229];
                        for (int i = 0; i < this.glyphnames.length; ++i) {
                            this.glyphnames[i] = i;
                        }
                        return;
                    }
                    if (base == 1) {
                        System.out.println("**** Type1CExpertCharset glyphNames");
                        this.glyphnames = FontSupport.type1CExpertCharset;
                        return;
                    }
                    if (base == 2) {
                        System.out.println("**** Type1CExpertSubCharset glyphNames");
                        this.glyphnames = FontSupport.type1CExpertSubCharset;
                        return;
                    }
                    System.out.print("**** Custom glyphNames Type ");
                    this.glyphnames = new int[this.nglyphs];
                    this.glyphnames[0] = 0;
                    this.pos = base;
                    type = this.readByte();
                    if (type != 0) break block9;
                    System.out.println("0");
                    for (int i = 1; i < this.nglyphs; ++i) {
                        this.glyphnames[i] = this.readInt(2);
                        System.out.println("glyphnames[" + i + "] = " + this.glyphnames[i]);
                    }
                    break block10;
                }
                if (type != 1) break block11;
                System.out.println("1");
                int n = 1;
                while (n < this.nglyphs) {
                    int sid = this.readInt(2);
                    int range = this.readByte() + 1;
                    for (int i = 0; i < range; ++i) {
                        System.out.println("glyphnames[" + n + "] = " + sid);
                        this.glyphnames[n++] = sid++;
                    }
                }
                break block10;
            }
            if (type != 2) break block10;
            System.out.println("2");
            int n = 1;
            while (n < this.nglyphs) {
                int sid = this.readInt(2);
                int range = this.readInt(2) + 1;
                for (int i = 0; i < range; ++i) {
                    System.out.println("glyphnames[" + n + "] = " + sid);
                    this.glyphnames[n++] = sid++;
                }
            }
        }
    }

    private void readNames(int base) {
        this.pos = base;
        int nextra = this.readInt(2);
        this.names = new String[nextra];
        for (int i = 0; i < nextra; ++i) {
            Range r = this.getIndexEntry(base, i);
            this.names[i] = new String(this.data, r.getStart(), r.getLen());
            System.out.println("Read name: " + i + " from " + r.getStart() + " to " + r.getEnd() + ": " + this.safe(this.names[i]));
        }
    }

    private void parse() {
        int majorVersion = this.readByte();
        int minorVersion = this.readByte();
        int hdrsz = this.readByte();
        int offsize = this.readByte();
        int fnames = hdrsz;
        int topdicts = fnames + this.getIndexSize(fnames);
        int names = topdicts + this.getIndexSize(topdicts);
        this.gsubrbase = names + this.getIndexSize(names);
        this.gsubrsoffset = this.calcoffset(this.gsubrbase);
        this.readNames(names);
        this.pos = topdicts;
        if (this.readInt(2) != 1) {
            this.printData();
            throw new RuntimeException("More than one font in this file!");
        }
        System.out.println("TOPDICT[0]:");
        this.readDict(this.getIndexEntry(topdicts, 0));
        System.out.println("PRIVATE DICT:");
        this.readDict(new Range(this.privatebase, this.privatesize));
        this.pos = this.charstringbase;
        this.nglyphs = this.readInt(2);
        System.out.println("GLYPHNAMES:");
        this.readGlyphNames(this.charsetbase);
        System.out.println("ENCODING:");
        this.readEncodingData(this.encodingbase);
        System.out.println("GLYPHS:");
        this.readGlyphs(this.charstringbase);
    }

    private String safe(String src) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (c >= ' ' && c < '\u0080') {
                sb.append(c);
                continue;
            }
            sb.append("<" + c + ">");
        }
        return sb.toString();
    }

    private void readGlyphs(int base) {
        for (int i = 1; i < this.nglyphs; ++i) {
            System.out.println("Reading glyph " + this.safe(this.getSID(this.glyphnames[i])));
            this.charnames.add((Object)this.getSID(this.glyphnames[i]));
        }
    }

    public GlyphData readGlyph(String sid) {
        int index = this.getNameIndex(sid);
        for (int i = 0; i < this.glyphnames.length; ++i) {
            if (this.glyphnames[i] != index) continue;
            return this.readGlyph(i);
        }
        return this.readGlyph(0);
    }

    public GlyphData readGlyph(int index) {
        String sid = this.getSID(index);
        if (this.charset.containsKey(sid)) {
            return this.charset.get(sid);
        }
        Range r = this.getIndexEntry(this.charstringbase, index);
        FlPoint pt = new FlPoint();
        GlyphData gd = new GlyphData();
        this.parseGlyph(r, gd, pt);
        gd.setName(sid);
        this.charset.put(sid, gd);
        return gd;
    }

    private void buildAccentChar(float x, float y, float a, float b, GlyphData gv) {
        System.out.println("Building accent character!!!!!!");
        for (int i = 0; i < this.nglyphs; ++i) {
            if (this.encoding[i] == (int)a) {
                gv.addGlyph(this.readGlyph(i + 1), x, y);
                continue;
            }
            if (this.encoding[i] != (int)b) continue;
            gv.addGlyph(this.readGlyph(i + 1), 0.0f, 0.0f);
        }
    }

    public int calcoffset(int base) {
        int len = this.getIndexSize(base);
        if (len < 1240) {
            return -107;
        }
        if (len < 33900) {
            return -1131;
        }
        return Short.MIN_VALUE;
    }

    public String getSID(int id) {
        if (id < FontSupport.stdNames.length) {
            return FontSupport.stdNames[id];
        }
        return this.names[id -= FontSupport.stdNames.length];
    }

    private int getNameIndex(String name) {
        int val = FontSupport.findName(name, FontSupport.stdNames);
        if (val == -1) {
            val = FontSupport.findName(name, this.names) + FontSupport.stdNames.length;
        }
        if (val == -1) {
            val = 0;
        }
        return val;
    }

    public void parseGlyph(Range r, GlyphData gp, FlPoint pt) {
        this.pos = r.getStart();
        int stemhints = 0;
        gp.setAdvance(this.defaultWidthX);
        block47: while (this.pos < r.getEnd()) {
            int cmd = this.readCommand(true);
            int hold = 0;
            switch (cmd) {
                case 1: 
                case 3: {
                    if ((this.stackptr & 1) == 1) {
                        gp.setAdvance((float)this.nominalWidthX + this.stack[0]);
                    }
                    this.stackptr = 0;
                    continue block47;
                }
                case 4: {
                    if (this.stackptr > 1) {
                        gp.setAdvance((float)this.nominalWidthX + this.stack[0]);
                        this.stack[0] = this.stack[1];
                    }
                    pt.y += this.stack[0];
                    if (pt.open) {
                        gp.closePath();
                    }
                    pt.open = false;
                    gp.moveTo(pt.x, pt.y);
                    this.stackptr = 0;
                    continue block47;
                }
                case 5: {
                    int i = 0;
                    while (i < this.stackptr) {
                        pt.x += this.stack[i++];
                        pt.y += this.stack[i++];
                        gp.lineTo(pt.x, pt.y);
                    }
                    pt.open = true;
                    this.stackptr = 0;
                    continue block47;
                }
                case 6: {
                    int i = 0;
                    while (i < this.stackptr) {
                        if ((i & 1) == 0) {
                            pt.x += this.stack[i++];
                        } else {
                            pt.y += this.stack[i++];
                        }
                        gp.lineTo(pt.x, pt.y);
                    }
                    pt.open = true;
                    this.stackptr = 0;
                    continue block47;
                }
                case 7: {
                    int i = 0;
                    while (i < this.stackptr) {
                        if ((i & 1) == 0) {
                            pt.y += this.stack[i++];
                        } else {
                            pt.x += this.stack[i++];
                        }
                        gp.lineTo(pt.x, pt.y);
                    }
                    pt.open = true;
                    this.stackptr = 0;
                    continue block47;
                }
                case 8: {
                    float y2;
                    float x2;
                    float y1;
                    float x1;
                    int i = 0;
                    while (i < this.stackptr) {
                        x1 = pt.x + this.stack[i++];
                        y1 = pt.y + this.stack[i++];
                        x2 = x1 + this.stack[i++];
                        y2 = y1 + this.stack[i++];
                        pt.x = x2 + this.stack[i++];
                        pt.y = y2 + this.stack[i++];
                        gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    }
                    pt.open = true;
                    this.stackptr = 0;
                    continue block47;
                }
                case 10: {
                    hold = this.pos;
                    int i = (int)this.stack[--this.stackptr] + this.lsubrsoffset;
                    Range lsubr = this.getIndexEntry(this.lsubrbase, i);
                    this.parseGlyph(lsubr, gp, pt);
                    this.pos = hold;
                    continue block47;
                }
                case 11: {
                    return;
                }
                case 14: {
                    if (this.stackptr == 5) {
                        this.buildAccentChar(this.stack[1], this.stack[2], this.stack[3], this.stack[4], gp);
                    }
                    if (pt.open) {
                        gp.closePath();
                    }
                    pt.open = false;
                    this.stackptr = 0;
                    return;
                }
                case 18: {
                    if ((this.stackptr & 1) == 1) {
                        gp.setAdvance((float)this.nominalWidthX + this.stack[0]);
                    }
                    stemhints += this.stackptr / 2;
                    this.stackptr = 0;
                    continue block47;
                }
                case 19: 
                case 20: {
                    if ((this.stackptr & 1) == 1) {
                        gp.setAdvance((float)this.nominalWidthX + this.stack[0]);
                    }
                    System.out.println("Added " + this.stackptr + " extra bits;  skipping " + (((stemhints += this.stackptr / 2) - 1) / 8 + 1) + " from " + stemhints);
                    this.pos += (stemhints - 1) / 8 + 1;
                    this.stackptr = 0;
                    continue block47;
                }
                case 21: {
                    if (this.stackptr > 2) {
                        gp.setAdvance((float)this.nominalWidthX + this.stack[0]);
                        this.stack[0] = this.stack[1];
                        this.stack[1] = this.stack[2];
                    }
                    pt.x += this.stack[0];
                    pt.y += this.stack[1];
                    if (pt.open) {
                        gp.closePath();
                    }
                    gp.moveTo(pt.x, pt.y);
                    pt.open = false;
                    this.stackptr = 0;
                    continue block47;
                }
                case 22: {
                    if (this.stackptr > 1) {
                        gp.setAdvance((float)this.nominalWidthX + this.stack[0]);
                        this.stack[0] = this.stack[1];
                    }
                    pt.x += this.stack[0];
                    if (pt.open) {
                        gp.closePath();
                    }
                    gp.moveTo(pt.x, pt.y);
                    pt.open = false;
                    this.stackptr = 0;
                    continue block47;
                }
                case 23: {
                    if ((this.stackptr & 1) == 1) {
                        gp.setAdvance((float)this.nominalWidthX + this.stack[0]);
                    }
                    stemhints += this.stackptr / 2;
                    this.stackptr = 0;
                    continue block47;
                }
                case 24: {
                    float y2;
                    float x2;
                    float y1;
                    float x1;
                    int i = 0;
                    while (i < this.stackptr - 2) {
                        x1 = pt.x + this.stack[i++];
                        y1 = pt.y + this.stack[i++];
                        x2 = x1 + this.stack[i++];
                        y2 = y1 + this.stack[i++];
                        pt.x = x2 + this.stack[i++];
                        pt.y = y2 + this.stack[i++];
                        gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    }
                    pt.x += this.stack[i++];
                    pt.y += this.stack[i++];
                    gp.lineTo(pt.x, pt.y);
                    pt.open = true;
                    this.stackptr = 0;
                    continue block47;
                }
                case 25: {
                    int i = 0;
                    while (i < this.stackptr - 6) {
                        pt.x += this.stack[i++];
                        pt.y += this.stack[i++];
                        gp.lineTo(pt.x, pt.y);
                    }
                    float x1 = pt.x + this.stack[i++];
                    float y1 = pt.y + this.stack[i++];
                    float x2 = x1 + this.stack[i++];
                    float y2 = y1 + this.stack[i++];
                    pt.x = x2 + this.stack[i++];
                    pt.y = y2 + this.stack[i++];
                    gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    pt.open = true;
                    this.stackptr = 0;
                    continue block47;
                }
                case 26: {
                    float y2;
                    float x2;
                    float y1;
                    float x1;
                    int i = 0;
                    if ((this.stackptr & 1) == 1) {
                        pt.x += this.stack[i++];
                    }
                    while (i < this.stackptr) {
                        x1 = pt.x;
                        y1 = pt.y + this.stack[i++];
                        x2 = x1 + this.stack[i++];
                        y2 = y1 + this.stack[i++];
                        pt.x = x2;
                        pt.y = y2 + this.stack[i++];
                        gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    }
                    pt.open = true;
                    this.stackptr = 0;
                    continue block47;
                }
                case 27: {
                    float y2;
                    float x2;
                    float y1;
                    float x1;
                    int i = 0;
                    if ((this.stackptr & 1) == 1) {
                        pt.y += this.stack[i++];
                    }
                    while (i < this.stackptr) {
                        x1 = pt.x + this.stack[i++];
                        y1 = pt.y;
                        x2 = x1 + this.stack[i++];
                        y2 = y1 + this.stack[i++];
                        pt.x = x2 + this.stack[i++];
                        pt.y = y2;
                        gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    }
                    pt.open = true;
                    this.stackptr = 0;
                    continue block47;
                }
                case 29: {
                    hold = this.pos;
                    int i = (int)this.stack[--this.stackptr] + this.gsubrsoffset;
                    Range gsubr = this.getIndexEntry(this.gsubrbase, i);
                    this.parseGlyph(gsubr, gp, pt);
                    this.pos = hold;
                    continue block47;
                }
                case 30: {
                    hold = 4;
                }
                case 31: {
                    float y2;
                    float x2;
                    float y1;
                    float x1;
                    int i = 0;
                    while (i < this.stackptr) {
                        boolean hv = (i + hold & 4) == 0;
                        x1 = pt.x + (hv ? this.stack[i++] : 0.0f);
                        y1 = pt.y + (hv ? 0.0f : this.stack[i++]);
                        x2 = x1 + this.stack[i++];
                        y2 = y1 + this.stack[i++];
                        pt.x = x2 + (hv ? 0.0f : this.stack[i++]);
                        pt.y = y2 + (hv ? this.stack[i++] : 0.0f);
                        if (i == this.stackptr - 1) {
                            if (hv) {
                                pt.x += this.stack[i++];
                            } else {
                                pt.y += this.stack[i++];
                            }
                        }
                        gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    }
                    pt.open = true;
                    this.stackptr = 0;
                    continue block47;
                }
                case 1003: {
                    float x1 = this.stack[--this.stackptr];
                    float y1 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = x1 != 0.0f && y1 != 0.0f ? 1.0f : 0.0f;
                    continue block47;
                }
                case 1004: {
                    float x1 = this.stack[--this.stackptr];
                    float y1 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = x1 != 0.0f || y1 != 0.0f ? 1.0f : 0.0f;
                    continue block47;
                }
                case 1005: {
                    float x1 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = x1 == 0.0f ? 1.0f : 0.0f;
                    continue block47;
                }
                case 1009: {
                    this.stack[this.stackptr - 1] = Math.abs(this.stack[this.stackptr - 1]);
                    continue block47;
                }
                case 1010: {
                    float x1 = this.stack[--this.stackptr];
                    float y1 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = x1 + y1;
                    continue block47;
                }
                case 1011: {
                    float x1 = this.stack[--this.stackptr];
                    float y1 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = y1 - x1;
                    continue block47;
                }
                case 1012: {
                    float x1 = this.stack[--this.stackptr];
                    float y1 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = y1 / x1;
                    continue block47;
                }
                case 1014: {
                    this.stack[this.stackptr - 1] = -this.stack[this.stackptr - 1];
                    continue block47;
                }
                case 1015: {
                    float x1 = this.stack[--this.stackptr];
                    float y1 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = x1 == y1 ? 1.0f : 0.0f;
                    continue block47;
                }
                case 1018: {
                    --this.stackptr;
                    continue block47;
                }
                case 1020: {
                    float x1;
                    int i = (int)this.stack[--this.stackptr];
                    this.temps[i] = x1 = this.stack[--this.stackptr];
                    continue block47;
                }
                case 1021: {
                    int i = (int)this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = this.temps[i];
                    continue block47;
                }
                case 1022: {
                    if (this.stack[this.stackptr - 2] > this.stack[this.stackptr - 1]) {
                        this.stack[this.stackptr - 4] = this.stack[this.stackptr - 3];
                    }
                    this.stackptr -= 3;
                    continue block47;
                }
                case 1023: {
                    this.stack[this.stackptr++] = (float)Math.random();
                    continue block47;
                }
                case 1024: {
                    float x1 = this.stack[--this.stackptr];
                    float y1 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = y1 * x1;
                    continue block47;
                }
                case 1026: {
                    this.stack[this.stackptr - 1] = (float)Math.sqrt(this.stack[this.stackptr - 1]);
                    continue block47;
                }
                case 1027: {
                    float x1 = this.stack[this.stackptr - 1];
                    this.stack[this.stackptr++] = x1;
                    continue block47;
                }
                case 1028: {
                    float x1 = this.stack[this.stackptr - 1];
                    this.stack[this.stackptr - 1] = this.stack[this.stackptr - 2];
                    this.stack[this.stackptr - 2] = x1;
                    continue block47;
                }
                case 1029: {
                    int i = (int)this.stack[this.stackptr - 1];
                    if (i < 0) {
                        i = 0;
                    }
                    this.stack[this.stackptr - 1] = this.stack[this.stackptr - 2 - i];
                    continue block47;
                }
                case 1030: {
                    int i = (int)this.stack[--this.stackptr];
                    int n = (int)this.stack[--this.stackptr];
                    i = i > 0 ? (i %= n) : n - -i % n;
                    if (i <= 0) continue block47;
                    float[] roll = new float[n];
                    System.arraycopy(this.stack, this.stackptr - 1 - i, roll, 0, i);
                    System.arraycopy(this.stack, this.stackptr - 1 - n, roll, i, n - i);
                    System.arraycopy(roll, 0, this.stack, this.stackptr - 1 - n, n);
                    continue block47;
                }
                case 1034: {
                    float ybase;
                    float x1 = pt.x + this.stack[0];
                    float y1 = ybase = pt.y;
                    float x2 = x1 + this.stack[1];
                    float y2 = y1 + this.stack[2];
                    pt.x = x2 + this.stack[3];
                    pt.y = y2;
                    gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    x1 = pt.x + this.stack[4];
                    y1 = pt.y;
                    x2 = x1 + this.stack[5];
                    y2 = ybase;
                    pt.x = x2 + this.stack[6];
                    pt.y = y2;
                    gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    pt.open = true;
                    this.stackptr = 0;
                    continue block47;
                }
                case 1035: {
                    float x1 = pt.x + this.stack[0];
                    float y1 = pt.y + this.stack[1];
                    float x2 = x1 + this.stack[2];
                    float y2 = y1 + this.stack[3];
                    pt.x = x2 + this.stack[4];
                    pt.y = y2 + this.stack[5];
                    gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    x1 = pt.x + this.stack[6];
                    y1 = pt.y + this.stack[7];
                    x2 = x1 + this.stack[8];
                    y2 = y1 + this.stack[9];
                    pt.x = x2 + this.stack[10];
                    pt.y = y2 + this.stack[11];
                    gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    pt.open = true;
                    this.stackptr = 0;
                    continue block47;
                }
                case 1036: {
                    float ybase = pt.y;
                    float x1 = pt.x + this.stack[0];
                    float y1 = pt.y + this.stack[1];
                    float x2 = x1 + this.stack[2];
                    float y2 = y1 + this.stack[3];
                    pt.x = x2 + this.stack[4];
                    pt.y = y2;
                    gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    x1 = pt.x + this.stack[5];
                    y1 = pt.y;
                    x2 = x1 + this.stack[6];
                    y2 = y1 + this.stack[7];
                    pt.x = x2 + this.stack[8];
                    pt.y = ybase;
                    gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    pt.open = true;
                    this.stackptr = 0;
                    continue block47;
                }
                case 1037: {
                    float ybase = pt.y;
                    float xbase = pt.x;
                    float x1 = pt.x + this.stack[0];
                    float y1 = pt.y + this.stack[1];
                    float x2 = x1 + this.stack[2];
                    float y2 = y1 + this.stack[3];
                    pt.x = x2 + this.stack[4];
                    pt.y = y2 + this.stack[5];
                    gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    x1 = pt.x + this.stack[6];
                    y1 = pt.y + this.stack[7];
                    x2 = x1 + this.stack[8];
                    y2 = y1 + this.stack[9];
                    if (Math.abs(x2 - xbase) > Math.abs(y2 - ybase)) {
                        pt.x = x2 + this.stack[10];
                        pt.y = ybase;
                    } else {
                        pt.x = xbase;
                        pt.y = y2 + this.stack[10];
                    }
                    gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    pt.open = true;
                    this.stackptr = 0;
                    continue block47;
                }
            }
            System.out.println("ERROR! TYPE1C CHARSTRING CMD IS " + cmd);
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Need the name of a cff font.");
            System.exit(0);
        }
        JFrame jf = new JFrame("Font test: " + args[0]);
        try {
            FileInputStream fis = new FileInputStream(args[0]);
            TestType1CFont panel = new TestType1CFont(fis);
            jf.getContentPane().add(panel);
            jf.pack();
            jf.show();
            panel.requestFocus();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class GlyphData {
        GeneralPath gp = new GeneralPath();
        GeneralPath advp;
        ArrayList<GlyphPoint> points = new ArrayList();
        float x = 0.0f;
        float y = 0.0f;
        float advance;
        String name;

        public void setName(String name) {
            this.name = name;
        }

        public void lineTo(float x, float y) {
            this.gp.lineTo(x, y);
            this.x = x;
            this.y = y;
            this.points.add((Object)new GlyphPoint(x, y, false));
        }

        public void moveTo(float x, float y) {
            this.gp.moveTo(x, y);
            this.x = x;
            this.y = y;
            this.points.add((Object)new GlyphPoint(x, y, false));
        }

        public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
            this.gp.curveTo(x1, y1, x2, y2, x3, y3);
            this.x = x3;
            this.y = y3;
            this.points.add((Object)new GlyphPoint(x1, y1, true));
            this.points.add((Object)new GlyphPoint(x2, y2, true));
            this.points.add((Object)new GlyphPoint(x3, y3, false));
        }

        public void closePath() {
            this.gp.closePath();
        }

        public void addGlyph(GlyphData gv, float x, float y) {
            AffineTransform at = AffineTransform.getTranslateInstance(x, y);
            PathIterator pi = gv.gp.getPathIterator(at);
            float[] coords = new float[6];
            while (!pi.isDone()) {
                int type = pi.currentSegment(coords);
                switch (type) {
                    case 0: {
                        this.moveTo(coords[0], coords[1]);
                        break;
                    }
                    case 1: {
                        this.lineTo(coords[0], coords[1]);
                        break;
                    }
                    case 3: {
                        this.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                        break;
                    }
                    case 4: {
                        this.closePath();
                        break;
                    }
                    default: {
                        System.out.println("Unknown path type: " + type);
                    }
                }
                pi.next();
            }
        }

        public void setAdvance(float adv) {
            this.advance = adv;
            this.advp = new GeneralPath();
            this.advp.moveTo(-2.0f, -2.0f);
            this.advp.lineTo(2.0f, 2.0f);
            this.advp.moveTo(-2.0f, 2.0f);
            this.advp.lineTo(2.0f, -2.0f);
            this.advp.moveTo(adv - 2.0f, -2.0f);
            this.advp.lineTo(adv, 0.0f);
            this.advp.lineTo(adv + 2.0f, -2.0f);
            this.advp.moveTo(adv, 0.0f);
            this.advp.lineTo(adv, -8.0f);
        }

        public void draw(Graphics2D g) {
            g.setColor(TestType1CFont.this.fillColor);
            g.fill(this.gp);
            g.setColor(Color.black);
            g.draw(this.gp);
            for (int i = 0; i < this.points.size(); ++i) {
                GlyphPoint p = (GlyphPoint)this.points.get(i);
                g.setColor(Color.red);
                g.draw(p.gp);
                g.setColor(Color.blue);
                g.setFont(TestType1CFont.this.gfont);
                g.drawString(String.valueOf(i), p.x + 3.0f, p.y + 3.0f);
            }
            g.setColor(Color.black);
            g.draw(this.advp);
            if (this.name != null) {
                g.setFont(TestType1CFont.this.gfont);
                g.drawString(this.name, 0, -40);
            }
        }
    }

    class GlyphPoint {
        float x;
        float y;
        boolean curvecontrol;
        GeneralPath gp;

        public GlyphPoint(float x, float y, boolean curvectrl) {
            this.x = x;
            this.y = y;
            this.curvecontrol = curvectrl;
            this.gp = new GeneralPath();
            if (curvectrl) {
                this.gp.moveTo(x - 4.0f, y - 4.0f);
                this.gp.lineTo(x + 4.0f, y + 4.0f);
                this.gp.moveTo(x - 4.0f, y + 4.0f);
                this.gp.lineTo(x + 4.0f, y - 4.0f);
            } else {
                this.gp.moveTo(x - 4.0f, y - 4.0f);
                this.gp.lineTo(x - 4.0f, y + 4.0f);
                this.gp.lineTo(x + 4.0f, y + 4.0f);
                this.gp.lineTo(x + 4.0f, y - 4.0f);
                this.gp.closePath();
            }
        }
    }

    class Range {
        private int start;
        private int len;

        public Range(int start, int len) {
            this.start = start;
            this.len = len;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getLen() {
            return this.len;
        }

        public final int getEnd() {
            return this.start + this.len;
        }
    }
}

