/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swinghelper.layer.item;

import java.awt.Shape;
import javax.swing.event.EventListenerList;
import org.jdesktop.swinghelper.layer.item.LayerItem;
import org.jdesktop.swinghelper.layer.item.LayerItemEvent;
import org.jdesktop.swinghelper.layer.item.LayerItemListener;

public abstract class AbstractLayerItem
implements LayerItem {
    private EventListenerList listenerList = new EventListenerList();
    private boolean isEnabled;

    protected AbstractLayerItem() {
        this.setEnabled(true);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        this.fireLayerItemChanged();
    }

    public void addLayerItemListener(LayerItemListener l) {
        this.listenerList.add(LayerItemListener.class, l);
    }

    public void removeLayerItemListener(LayerItemListener l) {
        this.listenerList.remove(LayerItemListener.class, l);
    }

    public LayerItemListener[] getLayerItemListeners() {
        return (LayerItemListener[])this.listenerList.getListeners(LayerItemListener.class);
    }

    protected void fireLayerItemChanged() {
        this.fireLayerItemChanged((Shape)null);
    }

    protected void fireLayerItemChanged(Shape clip) {
        this.fireLayerItemChanged(new LayerItemEvent(this, clip));
    }

    private void fireLayerItemChanged(LayerItemEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != LayerItemListener.class) continue;
            ((LayerItemListener)listeners[i + 1]).layerItemChanged(event);
        }
    }
}

