/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.util.algorithm2D;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.geotools.geometry.iso.util.algorithm2D.AlgoPoint2D;

public class AlgoRectangle2D {
    public static Rectangle2D copyRectangle(Rectangle2D r) {
        return new Rectangle2D.Double(r.getMinX(), r.getMinY(), r.getWidth(), r.getHeight());
    }

    public static Rectangle2D createRectangle(Point2D p0, Point2D p1) {
        Rectangle2D.Double r = new Rectangle2D.Double();
        AlgoRectangle2D.setValues(r, p0.getX(), p0.getY(), p1.getX(), p1.getY());
        return r;
    }

    public static Rectangle2D createRectangle(Point2D p) {
        Rectangle2D.Double r = new Rectangle2D.Double();
        AlgoRectangle2D.setValues(r, p.getX(), p.getY(), p.getX(), p.getY());
        return r;
    }

    public static Rectangle2D createRectangle(Point2D[] p) {
        if (p.length == 0) {
            return null;
        }
        Rectangle2D.Double result = new Rectangle2D.Double(p[0].getX(), p[0].getY(), 0.0, 0.0);
        for (int i = 1; i < p.length; ++i) {
            if (p[i] == null) continue;
            result.add(p[i]);
        }
        return result;
    }

    public static Rectangle2D createRectangle(double xmin, double ymin, double xmax, double ymax) {
        Rectangle2D.Double r = new Rectangle2D.Double();
        AlgoRectangle2D.setValues(r, xmin, ymin, xmax, ymax);
        return r;
    }

    public static void setValues(Rectangle2D r, Point2D[] p) {
        if (p == null || p.length == 0) {
            return;
        }
        r.setRect(p[0].getX(), p[0].getY(), 0.0, 0.0);
        for (int i = 1; i < p.length; ++i) {
            r.add(p[i]);
        }
    }

    public static void setValues(Rectangle2D r, double xmin, double ymin, double xmax, double ymax) {
        double tmp;
        if (Double.isNaN(xmin) || Double.isNaN(ymin) || Double.isNaN(xmax) || Double.isNaN(ymax)) {
            throw new IllegalArgumentException("Error on AlgoRectangle::getValues");
        }
        if (xmin > xmax) {
            tmp = xmin;
            xmin = xmax;
            xmax = tmp;
        }
        if (ymin > ymax) {
            tmp = ymin;
            ymin = ymax;
            ymax = tmp;
        }
        r.setRect(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    public static Point2D getUpperCorner(Rectangle2D r) {
        return new Point2D.Double(r.getMaxX(), r.getMaxY());
    }

    public static Point2D getLowerCorner(Rectangle2D r) {
        return new Point2D.Double(r.getMinX(), r.getMinY());
    }

    public static Point2D[] getCorners(Rectangle2D r) {
        return new Point2D[]{AlgoRectangle2D.getLowerCorner(r), AlgoRectangle2D.getUpperCorner(r)};
    }

    public static Point2D getCenter(Rectangle2D r) {
        return new Point2D.Double(r.getCenterX(), r.getCenterY());
    }

    public static Rectangle2D createScale(Rectangle2D r, double factor) {
        if (factor <= 0.0 || factor == 1.0) {
            return AlgoRectangle2D.copyRectangle(r);
        }
        double cx = r.getCenterX();
        double cy = r.getCenterY();
        double w = r.getWidth() * 0.5 * factor;
        double h = r.getHeight() * 0.5 * factor;
        return AlgoRectangle2D.createRectangle(cx - w, cy - h, cx + w, cy + h);
    }

    public static void setScale(Rectangle2D r, double factor) {
        if (factor <= 0.0 || factor == 1.0) {
            return;
        }
        double w = r.getWidth() * factor;
        double h = r.getHeight() * factor;
        r.setRect(r.getCenterX() - w * 0.5, r.getCenterY() - h * 0.5, w, h);
    }

    public static void setMinSize(Rectangle2D r, double size) {
        if (size <= 0.0 || r.getWidth() >= size && r.getHeight() >= size) {
            return;
        }
        double w = r.getWidth();
        double h = r.getHeight();
        if (w < size && h < size) {
            r.setRect(r.getCenterX() - size * 0.5, r.getCenterY() - size * 0.5, size, size);
        } else if (w < size) {
            r.setRect(r.getCenterX() - size * 0.5, r.getMinY(), size, h);
        } else if (h < size) {
            r.setRect(r.getMinX(), r.getCenterY() - size * 0.5, w, size);
        }
    }

    public static void setMaxQuadrat(Rectangle2D r) {
        double cx = r.getCenterX();
        double cy = r.getCenterY();
        double w = r.getWidth() > r.getHeight() ? r.getWidth() : r.getHeight();
        r.setRect(cx - w, cy - w, cx + w, cy + w);
    }

    public static void setMinQuadrat(Rectangle2D r) {
        double cx = r.getCenterX();
        double cy = r.getCenterY();
        double w = r.getWidth() < r.getHeight() ? r.getWidth() : r.getHeight();
        r.setRect(cx - w, cy - w, cx + w, cy + w);
    }

    public static boolean intersects(Rectangle2D r0, Rectangle2D r1) {
        return AlgoRectangle2D.intersects(r0.getMinX(), r0.getMaxX(), r1.getMinX(), r1.getMaxX()) && AlgoRectangle2D.intersects(r0.getMinY(), r0.getMaxY(), r1.getMinY(), r1.getMaxY());
    }

    public static boolean intersects(Point2D p0, Point2D p1, Point2D p) {
        return (!(p0.getX() < p1.getX()) ? AlgoRectangle2D.intersects(p1.getX(), p0.getX(), p.getX()) : AlgoRectangle2D.intersects(p0.getX(), p1.getX(), p.getX())) || (p0.getY() < p1.getY() ? AlgoRectangle2D.intersects(p0.getY(), p1.getY(), p.getY()) : AlgoRectangle2D.intersects(p1.getY(), p0.getY(), p.getY()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean intersects(Point2D p0, Point2D p1, Point2D q0, Point2D q1) {
        double d = p0.getX() < p1.getX() ? p0.getX() : p1.getX();
        double d2 = q0.getX() > q1.getX() ? q0.getX() : q1.getX();
        if (d <= d2) {
            if ((p0.getX() > p1.getX() ? p0.getX() : p1.getX()) >= (q0.getX() < q1.getX() ? q0.getX() : q1.getX())) return true;
        }
        double d3 = p0.getY() < p1.getY() ? p0.getY() : p1.getY();
        double d4 = q0.getY() > q1.getY() ? q0.getY() : q1.getY();
        if (!(d3 <= d4)) return false;
        double d5 = p0.getY() > p1.getY() ? p0.getY() : p1.getY();
        double d6 = q0.getY() < q1.getY() ? q0.getY() : q1.getY();
        if (!(d5 >= d6)) return false;
        return true;
    }

    public static boolean intersects(double minx1, double miny1, double maxx1, double maxy1, double minx2, double miny2, double maxx2, double maxy2) {
        return !(minx2 > maxx1 || maxx2 < minx1 || miny2 > maxy1 || maxy2 < miny1);
    }

    private static boolean intersects(double min0, double max0, double min1, double max1) {
        return min0 <= max1 && max0 >= min1;
    }

    private static boolean intersects(double min0, double max0, double d) {
        return min0 <= d && max0 >= d;
    }

    public static Point2D[] intersectionRectangleLine(Rectangle2D rec, Line2D line) {
        double x1 = line.getX1();
        double x2 = line.getX2();
        double y1 = line.getY1();
        double y2 = line.getY2();
        double xmin = rec.getMinX();
        double xmax = rec.getMaxX();
        double ymin = rec.getMinY();
        double ymax = rec.getMaxY();
        Point2D p0 = null;
        Point2D p1 = null;
        if (x1 == x2 && xmin <= x1 && xmax >= x1 && (y1 <= ymin && y2 >= ymax || y2 <= ymin && y1 >= ymax)) {
            return new Point2D[]{new Point2D.Double(x1, ymin), new Point2D.Double(x1, ymax)};
        }
        if (y1 == y2 && ymin <= y1 && ymax >= y1 && (x1 <= xmin && x2 >= xmax || x2 <= xmin && x1 >= xmax)) {
            return new Point2D[]{new Point2D.Double(xmin, y1), new Point2D.Double(xmax, y1)};
        }
        double r = (xmin - x1) / (x2 - x1);
        p0 = AlgoPoint2D.evaluate(line.getP1(), line.getP2(), r);
        if (p0 != null && (p0.getX() < xmin || p0.getX() > xmax || p0.getY() < ymin || p0.getY() > ymax)) {
            p0 = null;
        }
        double s = (ymin - y1) / (y2 - y1);
        if (p0 == null) {
            p0 = AlgoPoint2D.evaluate(line.getP1(), line.getP2(), s);
        } else {
            p1 = AlgoPoint2D.evaluate(line.getP1(), line.getP2(), s);
        }
        if (p0 != null && (p0.getX() < xmin || p0.getX() > xmax || p0.getY() < ymin || p0.getY() > ymax)) {
            p0 = null;
        }
        if (p1 != null && (p1.getX() < xmin || p1.getX() > xmax || p1.getY() < ymin || p1.getY() > ymax)) {
            p1 = null;
        }
        if (p0 != null && p1 != null) {
            return new Point2D[]{p0, p1};
        }
        r = (xmax - x1) / (x2 - x1);
        if (p0 == null) {
            p0 = AlgoPoint2D.evaluate(line.getP1(), line.getP2(), r);
        } else {
            p1 = AlgoPoint2D.evaluate(line.getP1(), line.getP2(), r);
        }
        if (p0 != null && (p0.getX() < xmin || p0.getX() > xmax || p0.getY() < ymin || p0.getY() > ymax)) {
            p0 = null;
        }
        if (p1 != null && (p1.getX() < xmin || p1.getX() > xmax || p1.getY() < ymin || p1.getY() > ymax)) {
            p1 = null;
        }
        if (p0 != null && p1 != null) {
            return new Point2D[]{p0, p1};
        }
        s = (ymax - y1) / (y2 - y1);
        if (p0 == null) {
            p0 = AlgoPoint2D.evaluate(line.getP1(), line.getP2(), s);
        } else {
            p1 = AlgoPoint2D.evaluate(line.getP1(), line.getP2(), s);
        }
        if (p0 != null && (p0.getX() < xmin || p0.getX() > xmax || p0.getY() < ymin || p0.getY() > ymax)) {
            p0 = null;
        }
        if (p1 != null && (p1.getX() < xmin || p1.getX() > xmax || p1.getY() < ymin || p1.getY() > ymax)) {
            p1 = null;
        }
        if (p0 != null && p1 != null) {
            return new Point2D[]{p0, p1};
        }
        return null;
    }
}

