/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.primitive;

import java.util.Set;
import org.geotools.geometry.iso.coordinate.EnvelopeImpl;
import org.geotools.geometry.iso.primitive.PointImpl;
import org.geotools.geometry.iso.primitive.PrimitiveBoundaryImpl;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.TransfiniteSet;
import org.opengis.geometry.complex.Complex;
import org.opengis.geometry.primitive.CurveBoundary;
import org.opengis.geometry.primitive.Point;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CurveBoundaryImpl
extends PrimitiveBoundaryImpl
implements CurveBoundary {
    private static final long serialVersionUID = -3093563492516992268L;
    private Point startPoint = null;
    private Point endPoint = null;

    public CurveBoundaryImpl(CoordinateReferenceSystem crs, Point start, Point end) {
        super(crs);
        if (start.equals((TransfiniteSet)end)) {
            throw new IllegalArgumentException("Start- and Endpoint of the CurveBoundary cannot be equal");
        }
        this.startPoint = start;
        this.endPoint = end;
    }

    @Override
    public CurveBoundaryImpl clone() throws CloneNotSupportedException {
        return new CurveBoundaryImpl(this.getCoordinateReferenceSystem(), this.getStartPoint().clone(), this.getEndPoint().clone());
    }

    public PointImpl getStartPoint() {
        return (PointImpl)this.startPoint;
    }

    public PointImpl getEndPoint() {
        return (PointImpl)this.endPoint;
    }

    public String toString() {
        return "[CurveBoundary: StartPoint: " + this.startPoint + " EndPoint: " + this.endPoint + "]";
    }

    @Override
    public int getDimension(DirectPosition point) {
        return 0;
    }

    @Override
    public EnvelopeImpl getEnvelope() {
        EnvelopeImpl tmpEnv = new EnvelopeImpl(this.startPoint.getEnvelope());
        tmpEnv.expand(this.endPoint.getDirectPosition().getCoordinate());
        return tmpEnv;
    }

    @Override
    public Set<Complex> createBoundary() {
        return null;
    }

    public boolean isSimple() {
        return true;
    }

    @Override
    public DirectPosition getRepresentativePoint() {
        return this.startPoint.getDirectPosition();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.endPoint == null ? 0 : this.endPoint.hashCode());
        result = 31 * result + (this.startPoint == null ? 0 : this.startPoint.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CurveBoundaryImpl other = (CurveBoundaryImpl)obj;
        if (this.endPoint == null ? other.endPoint != null : !this.endPoint.equals((TransfiniteSet)other.endPoint)) {
            return false;
        }
        return !(this.startPoint == null ? other.startPoint != null : !this.startPoint.equals((TransfiniteSet)other.startPoint));
    }
}

