/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.io.wkt;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.geotools.geometry.iso.PositionFactoryImpl;
import org.geotools.geometry.iso.coordinate.LineStringImpl;
import org.geotools.geometry.iso.coordinate.PointArrayImpl;
import org.geotools.geometry.iso.io.wkt.Coordinate;
import org.geotools.geometry.iso.io.wkt.ParseException;
import org.geotools.geometry.iso.io.wkt.WKTConstants;
import org.geotools.geometry.iso.primitive.CurveImpl;
import org.geotools.geometry.iso.primitive.PointImpl;
import org.geotools.geometry.iso.primitive.RingImpl;
import org.geotools.geometry.iso.primitive.SurfaceBoundaryImpl;
import org.geotools.geometry.iso.primitive.SurfaceImpl;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.PositionFactory;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.Curve;
import org.opengis.geometry.primitive.OrientableCurve;
import org.opengis.geometry.primitive.Point;
import org.opengis.geometry.primitive.Ring;
import org.opengis.geometry.primitive.Surface;
import org.opengis.geometry.primitive.SurfaceBoundary;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WKTReader {
    private static final String EMPTY = "EMPTY";
    private static final String COMMA = ",";
    private static final String L_PAREN = "(";
    private static final String R_PAREN = ")";
    private PositionFactory positionFactory;
    private CoordinateReferenceSystem crs;
    private StreamTokenizer tokenizer;

    public WKTReader(CoordinateReferenceSystem crs) {
        this(crs, new PositionFactoryImpl(crs));
    }

    public WKTReader(CoordinateReferenceSystem crs, PositionFactory aPositionFactory) {
        this.crs = crs;
        this.positionFactory = aPositionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Geometry read(String wellKnownText) throws ParseException {
        try (StringReader reader = new StringReader(wellKnownText);){
            Geometry geometry = this.read(reader);
            return geometry;
        }
    }

    public Geometry read(Reader reader) throws ParseException {
        this.tokenizer = new StreamTokenizer(reader);
        this.tokenizer.resetSyntax();
        this.tokenizer.wordChars(97, 122);
        this.tokenizer.wordChars(65, 90);
        this.tokenizer.wordChars(160, 255);
        this.tokenizer.wordChars(48, 57);
        this.tokenizer.wordChars(45, 45);
        this.tokenizer.wordChars(43, 43);
        this.tokenizer.wordChars(46, 46);
        this.tokenizer.whitespaceChars(0, 32);
        this.tokenizer.commentChar(35);
        try {
            return this.readGeometryTaggedText();
        }
        catch (IOException e) {
            throw new ParseException(e.toString());
        }
    }

    private Coordinate[] getCoordinates() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return new Coordinate[0];
        }
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(this.getPreciseCoordinate());
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            coordinates.add(this.getPreciseCoordinate());
            nextToken = this.getNextCloserOrComma();
        }
        Coordinate[] array = new Coordinate[coordinates.size()];
        return coordinates.toArray(array);
    }

    private Coordinate getPreciseCoordinate() throws IOException, ParseException {
        Coordinate coord = new Coordinate();
        coord.x = this.getNextNumber();
        coord.y = this.getNextNumber();
        if (this.isNumberNext()) {
            coord.z = this.getNextNumber();
        }
        return coord;
    }

    private boolean isNumberNext() throws IOException {
        int type = this.tokenizer.nextToken();
        this.tokenizer.pushBack();
        return type == -3;
    }

    private double getNextNumber() throws IOException, ParseException {
        int type = this.tokenizer.nextToken();
        switch (type) {
            case -3: {
                try {
                    return Double.parseDouble(this.tokenizer.sval);
                }
                catch (NumberFormatException ex) {
                    throw new ParseException("Invalid number: " + this.tokenizer.sval);
                }
            }
        }
        this.parseError("number");
        return 0.0;
    }

    private String getNextEmptyOrOpener() throws IOException, ParseException {
        String nextWord = this.getNextWord();
        if (nextWord.equals(EMPTY) || nextWord.equals(L_PAREN)) {
            return nextWord;
        }
        this.parseError("EMPTY or (");
        return null;
    }

    private String getNextCloserOrComma() throws IOException, ParseException {
        String nextWord = this.getNextWord();
        if (nextWord.equals(COMMA) || nextWord.equals(R_PAREN)) {
            return nextWord;
        }
        this.parseError(", or )");
        return null;
    }

    private String getNextCloser() throws IOException, ParseException {
        String nextWord = this.getNextWord();
        if (nextWord.equals(R_PAREN)) {
            return nextWord;
        }
        this.parseError(R_PAREN);
        return null;
    }

    private String getNextWord() throws IOException, ParseException {
        int type = this.tokenizer.nextToken();
        switch (type) {
            case -3: {
                String word = this.tokenizer.sval;
                if (word.equalsIgnoreCase(EMPTY)) {
                    return EMPTY;
                }
                return word;
            }
            case 40: {
                return L_PAREN;
            }
            case 41: {
                return R_PAREN;
            }
            case 44: {
                return COMMA;
            }
        }
        this.parseError("word");
        return null;
    }

    private void parseError(String expected) throws ParseException {
        if (this.tokenizer.ttype == -2) {
            throw new ParseException("Unexpected NUMBER token");
        }
        if (this.tokenizer.ttype == 10) {
            throw new ParseException("Unexpected EOL token");
        }
        String tokenStr = this.tokenString();
        throw new ParseException("Expected " + expected + " but found " + tokenStr);
    }

    private String tokenString() {
        switch (this.tokenizer.ttype) {
            case -2: {
                return "<NUMBER>";
            }
            case 10: {
                return "End-of-Line";
            }
            case -1: {
                return "End-of-Stream";
            }
            case -3: {
                return "'" + this.tokenizer.sval + "'";
            }
        }
        return "'" + (char)this.tokenizer.ttype + "'";
    }

    private Geometry readGeometryTaggedText() throws IOException, ParseException {
        String type = this.getNextWord();
        if (type.equals(WKTConstants.WKT_POINT)) {
            return this.readPointText();
        }
        if (type.equalsIgnoreCase(WKTConstants.WKT_CURVE)) {
            return this.readLineStringText();
        }
        if (type.equalsIgnoreCase(WKTConstants.WKT_SURFACE) || type.equalsIgnoreCase(WKTConstants.WKT_POLYGON)) {
            return this.readPolygonText();
        }
        throw new ParseException("Unknown geometry type: " + type);
    }

    private Point readPointText() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return null;
        }
        PointImpl point = new PointImpl(this.positionFactory.createDirectPosition(this.getPreciseCoordinate().getCoordinates()));
        this.getNextCloser();
        return point;
    }

    private Curve readLineStringText() throws IOException, ParseException {
        return (Curve)this.createCurve(this.getCoordinates());
    }

    private Ring readLinearRingText() throws IOException, ParseException {
        ArrayList<OrientableCurve> curves = new ArrayList<OrientableCurve>();
        curves.add(this.createCurve(this.getCoordinates()));
        return new RingImpl((List<OrientableCurve>)curves);
    }

    private Surface readPolygonText() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return new SurfaceImpl((SurfaceBoundary)null);
        }
        ArrayList<Ring> holes = new ArrayList<Ring>();
        Ring shell = this.readLinearRingText();
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            Ring hole = this.readLinearRingText();
            holes.add(hole);
            nextToken = this.getNextCloserOrComma();
        }
        SurfaceBoundaryImpl sfb = new SurfaceBoundaryImpl(this.crs, shell, holes);
        return new SurfaceImpl(sfb);
    }

    private OrientableCurve createCurve(Coordinate[] aCoords) {
        ArrayList<Position> points = new ArrayList<Position>();
        for (int i = 0; i < aCoords.length; ++i) {
            points.add(this.positionFactory.createPosition((Position)this.positionFactory.createDirectPosition(aCoords[i].getCoordinates())));
        }
        LineStringImpl lineString = new LineStringImpl(new PointArrayImpl((List<Position>)points), 0.0);
        ArrayList<LineStringImpl> segments = new ArrayList<LineStringImpl>();
        segments.add(lineString);
        return new CurveImpl(this.crs, segments);
    }
}

