/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.coordinate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.geotools.geometry.iso.coordinate.CurveSegmentImpl;
import org.geotools.geometry.iso.coordinate.DirectPositionImpl;
import org.geotools.geometry.iso.coordinate.EnvelopeImpl;
import org.geotools.geometry.iso.coordinate.LineSegmentImpl;
import org.geotools.geometry.iso.coordinate.PointArrayImpl;
import org.geotools.geometry.iso.primitive.CurveImpl;
import org.geotools.geometry.iso.primitive.PointImpl;
import org.geotools.geometry.iso.util.DoubleOperation;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.coordinate.LineSegment;
import org.opengis.geometry.coordinate.LineString;
import org.opengis.geometry.coordinate.ParamForPoint;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.CurveInterpolation;

public class LineStringImpl
extends CurveSegmentImpl
implements LineString {
    private static final long serialVersionUID = -4463400288452707656L;
    private PointArrayImpl controlPoints;
    private EnvelopeImpl envelope = null;

    public LineStringImpl(List<Position> positions) {
        this(new PointArrayImpl(positions), 0.0);
    }

    public LineStringImpl(LineStringImpl lineString) {
        super(lineString);
        super.setInterpolation(CurveInterpolation.LINEAR);
        this.controlPoints = new PointArrayImpl(lineString.controlPoints);
        this.endParam = lineString.endParam;
        this.envelope = new EnvelopeImpl(lineString.getEnvelope());
    }

    public LineStringImpl(PointArrayImpl pointArray, double startPar) {
        super(startPar);
        super.setInterpolation(CurveInterpolation.LINEAR);
        if (pointArray.length() < 2) {
            throw new IllegalArgumentException("A LineString needs at least two control points.");
        }
        this.controlPoints = pointArray;
        this.setEndParam(DoubleOperation.add(startPar, this.controlPoints.getDistanceSum()));
        this.envelope = this.controlPoints.getEnvelope();
    }

    public LineStringImpl merge(LineStringImpl other) {
        LineStringImpl result;
        if (other.getEndPoint().equals((Object)this.getStartPoint())) {
            LinkedList<Position> posToAdd = new LinkedList<Position>((Collection<Position>)other.getControlPoints());
            posToAdd.removeLast();
            posToAdd.addAll((Collection<Position>)this.getControlPoints());
            result = new LineStringImpl(posToAdd);
        } else if (this.getEndPoint().equals((Object)other.getStartPoint())) {
            LinkedList<Position> posToAdd = new LinkedList<Position>((Collection<Position>)this.getControlPoints());
            posToAdd.removeLast();
            posToAdd.addAll((Collection<Position>)other.getControlPoints());
            result = new LineStringImpl(posToAdd);
        } else {
            throw new IllegalArgumentException("The LineString do not agree in a start and end point");
        }
        return result;
    }

    public PointArray getControlPoints() {
        return this.controlPoints;
    }

    public List<LineSegment> asLineSegments() {
        return this.controlPoints.getLineSegments(this.getCurve());
    }

    @Override
    public DirectPosition getStartPoint() {
        return this.controlPoints.getFirst().getDirectPosition();
    }

    @Override
    public DirectPosition getEndPoint() {
        return this.controlPoints.getLast().getDirectPosition();
    }

    @Override
    public Position getStartPosition() {
        return this.controlPoints.getFirst();
    }

    @Override
    public Position getEndPosition() {
        return this.controlPoints.getLast();
    }

    @Override
    public void split(double maxSpacing) {
        throw new UnsupportedOperationException("not implemented yet.");
    }

    public int getNumDerivativesAtStart() {
        return 0;
    }

    public int getNumDerivativesInterior() {
        return 0;
    }

    public int getNumDerivativesAtEnd() {
        return 0;
    }

    public PointArray getSamplePoints() {
        return this.controlPoints;
    }

    public CurveSegmentImpl reverse() {
        Collections.reverse(this.controlPoints);
        return this;
    }

    public double[] getTangent(double distance) {
        int i;
        if (distance < this.getStartParam() || distance > this.getEndParam()) {
            throw new IllegalArgumentException("Distance parameter not in parametrisation range.");
        }
        List<LineSegment> segments = this.asLineSegments();
        for (i = 0; segments.get(i).getEndParam() < distance && i < segments.size(); ++i) {
        }
        return ((LineSegmentImpl)segments.get(i)).getTangentInSegment(distance);
    }

    public DirectPosition forConstructiveParam(double cp) {
        double par = DoubleOperation.mult(cp, this.getCurve().length());
        return this.forParam(par);
    }

    @Override
    public EnvelopeImpl getEnvelope() {
        return this.envelope;
    }

    public DirectPosition forParam(double distance) {
        int i;
        if (distance < this.getStartParam() || distance > this.getEndParam()) {
            throw new IllegalArgumentException("Distance parameter not in parametrisation range.");
        }
        List<LineSegment> segments = this.asLineSegments();
        for (i = 0; ((LineSegmentImpl)segments.get((int)i)).endParam < distance && i < segments.size(); ++i) {
        }
        return ((LineSegmentImpl)segments.get(i)).forParamInSegment(distance);
    }

    public ParamForPoint getParamForPoint(DirectPosition p) {
        throw new UnsupportedOperationException("not implemented yet.");
    }

    public LineStringImpl asLineString(double maxSpacing, double maxOffset) {
        if (maxSpacing == 0.0 && maxOffset == 0.0) {
            return this;
        }
        ArrayList<Position> positions = new ArrayList<Position>();
        double actualParam = this.startParam;
        double newSpacing = maxSpacing;
        List<LineSegment> segments = this.asLineSegments();
        int firstSegment = 0;
        int lastSegment = 0;
        double maxDistance = 0.0;
        while (actualParam < this.endParam) {
            int i;
            if (actualParam + newSpacing > this.endParam) {
                newSpacing = this.endParam - actualParam;
            }
            maxDistance = 0.0;
            for (i = firstSegment; segments.get(i).getStartParam() < actualParam && i < segments.size() - 1; ++i) {
            }
            firstSegment = i;
            do {
                double EPSILON = 1.0E-5;
                if (segments.get(firstSegment).getStartParam() > actualParam && segments.get(firstSegment).getStartParam() + EPSILON < actualParam + newSpacing || segments.get(firstSegment).getEndParam() > actualParam && segments.get(firstSegment).getEndParam() + EPSILON < actualParam + newSpacing) {
                    for (i = firstSegment; i < segments.size() && segments.get(i).getEndParam() <= actualParam + newSpacing; ++i) {
                    }
                    lastSegment = i - 1;
                    DirectPosition p1 = this.forParam(actualParam);
                    DirectPositionImpl p2 = new DirectPositionImpl(this.forParam(actualParam + newSpacing));
                    LineSegmentImpl seg = new LineSegmentImpl(p1, p2, 0.0);
                    CurveImpl curve = new CurveImpl(seg);
                    maxDistance = curve.distance(new PointImpl(segments.get(firstSegment).getStartPoint()));
                    double actDistance = 0.0;
                    for (i = firstSegment; i < lastSegment; ++i) {
                        actDistance = curve.distance(new PointImpl(segments.get(i).getEndPoint()));
                        if (!(actDistance > maxDistance)) continue;
                        maxDistance = actDistance;
                    }
                    if (!(maxDistance > maxOffset)) continue;
                    newSpacing /= 2.0;
                    continue;
                }
                maxDistance = 0.0;
            } while (maxDistance > maxOffset);
            newSpacing = maxSpacing;
            positions.add((Position)new DirectPositionImpl(this.forParam(actualParam += newSpacing)));
        }
        LineStringImpl rLineString = new LineStringImpl(positions);
        rLineString.setEndParam(this.getEndParam());
        return rLineString;
    }

    public String toString() {
        return "[LineString: " + this.controlPoints + "]";
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.controlPoints == null ? 0 : this.controlPoints.hashCode());
        result = 31 * result + (this.envelope == null ? 0 : this.envelope.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineStringImpl)) {
            return false;
        }
        LineStringImpl other = (LineStringImpl)obj;
        if (this.controlPoints == null ? other.controlPoints != null : !this.controlPoints.equals(other.controlPoints)) {
            return false;
        }
        return !(this.envelope == null ? other.envelope != null : !this.envelope.equals(other.envelope));
    }
}

