/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.aggregate;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.geotools.geometry.iso.aggregate.AggregateImpl;
import org.geotools.geometry.iso.coordinate.DirectPositionImpl;
import org.geotools.geometry.iso.coordinate.EnvelopeImpl;
import org.geotools.geometry.iso.io.GeometryToString;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.aggregate.MultiPrimitive;
import org.opengis.geometry.complex.Complex;
import org.opengis.geometry.primitive.Primitive;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MultiPrimitiveImpl
extends AggregateImpl
implements MultiPrimitive {
    private static final long serialVersionUID = -8667095513075575773L;

    public MultiPrimitiveImpl(CoordinateReferenceSystem crs, Set<? extends Primitive> primitives) {
        super(crs, primitives);
    }

    @Override
    public Envelope getEnvelope() {
        EnvelopeImpl env = new EnvelopeImpl(new DirectPositionImpl(this.getCoordinateReferenceSystem(), new double[]{Double.NaN, Double.NaN}));
        Iterator elementIter = this.elements.iterator();
        while (elementIter.hasNext()) {
            env.add((EnvelopeImpl)((Primitive)elementIter.next()).getEnvelope());
        }
        return env;
    }

    public boolean isSimple() {
        return false;
    }

    public Set<Complex> getMaximalComplex() {
        return null;
    }

    @Override
    public DirectPosition getRepresentativePoint() {
        Iterator<? extends Primitive> elementIter = this.getElements().iterator();
        return ((Geometry)elementIter.next()).getRepresentativePoint();
    }

    public String toString() {
        return GeometryToString.getString(this);
    }

    public Set<? extends Primitive> getElements() {
        return Collections.checkedSet(this.elements, Primitive.class);
    }
}

