/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils.icon;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.plaf.UIResource;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.icon.TransitionAwareIcon;

public class MenuArrowIcon
implements Icon,
UIResource {
    private Icon ltrIcon;
    private Icon rtlIcon;

    public MenuArrowIcon(final JMenuItem menuItem) {
        this.ltrIcon = new TransitionAwareIcon(menuItem, new TransitionAwareIcon.Delegate(){

            public Icon getThemeIcon(SubstanceTheme theme) {
                int fontSize = SubstanceSizeUtils.getComponentFontSize(menuItem);
                return SubstanceImageCreator.getArrowIcon(fontSize, 3, theme);
            }
        });
        this.rtlIcon = new TransitionAwareIcon(menuItem, new TransitionAwareIcon.Delegate(){

            public Icon getThemeIcon(SubstanceTheme theme) {
                int fontSize = SubstanceSizeUtils.getComponentFontSize(menuItem);
                return SubstanceImageCreator.getArrowIcon(fontSize, 7, theme);
            }
        });
    }

    public int getIconHeight() {
        return this.ltrIcon.getIconHeight();
    }

    public int getIconWidth() {
        return this.ltrIcon.getIconWidth();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (c.getComponentOrientation().isLeftToRight()) {
            this.ltrIcon.paintIcon(c, g, x, y);
        } else {
            this.rtlIcon.paintIcon(c, g, x, y);
        }
    }
}

