/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.skin;

import java.awt.Color;
import org.jvnet.substance.border.ClassicInnerBorderPainter;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.color.EbonyColorScheme;
import org.jvnet.substance.color.TintColorScheme;
import org.jvnet.substance.color.ToneColorScheme;
import org.jvnet.substance.painter.AlphaControlBackgroundComposite;
import org.jvnet.substance.painter.SimplisticSoftBorderReverseGradientPainter;
import org.jvnet.substance.painter.decoration.FlatDecorationPainter;
import org.jvnet.substance.painter.highlight.ClassicHighlightPainter;
import org.jvnet.substance.skin.SubstanceAbstractSkin;
import org.jvnet.substance.theme.SubstanceComplexTheme;
import org.jvnet.substance.theme.SubstanceEbonyTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.watermark.SubstanceCrosshatchWatermark;

public class RavenGraphiteSkin
extends SubstanceAbstractSkin {
    public static String NAME = "Raven Graphite";

    public RavenGraphiteSkin() {
        TintColorScheme activeScheme = new TintColorScheme(new EbonyColorScheme(), 0.2){
            Color foreColor;
            {
                this.foreColor = new Color(200, 200, 200);
            }

            public Color getForegroundColor() {
                return this.foreColor;
            }
        };
        TintColorScheme selectedDisabledScheme = new TintColorScheme(new EbonyColorScheme(), 0.2){
            Color foreColor;
            {
                this.foreColor = new Color(32, 32, 32);
            }

            public Color getForegroundColor() {
                return this.foreColor;
            }
        };
        ToneColorScheme disabledScheme = new ToneColorScheme(new EbonyColorScheme(), 0.35){
            Color foreColor;
            {
                this.foreColor = new Color(32, 32, 32);
            }

            public Color getForegroundColor() {
                return this.foreColor;
            }
        };
        SubstanceTheme activeTheme = new SubstanceTheme(activeScheme, "Raven Graphite Active", SubstanceTheme.ThemeKind.DARK);
        SubstanceTheme defaultTheme = activeTheme.shade(0.2);
        SubstanceTheme disabledTheme = new SubstanceTheme(disabledScheme, "Raven Graphite Disabled", SubstanceTheme.ThemeKind.DARK);
        SubstanceTheme selectedDisabledTheme = new SubstanceTheme(selectedDisabledScheme, "Raven Graphite Selected Disabled", SubstanceTheme.ThemeKind.DARK);
        SubstanceTheme activeTitleTheme = defaultTheme;
        SubstanceComplexTheme theme = new SubstanceComplexTheme(NAME, SubstanceTheme.ThemeKind.DARK, activeTheme, defaultTheme, disabledTheme, activeTitleTheme);
        theme.setNonActivePainter(new SimplisticSoftBorderReverseGradientPainter());
        theme.setSelectedTabFadeStart(0.3);
        theme.setSelectedTabFadeEnd(0.6);
        theme.registerComponentHighlightStateTheme((SubstanceTheme)new SubstanceEbonyTheme(), 0.8f, new ComponentState[0]);
        theme.registerComponentStateTheme(disabledTheme, 0.5f, false, ComponentState.DISABLED_UNSELECTED);
        theme.registerComponentStateTheme(selectedDisabledTheme, 0.5f, false, ComponentState.DISABLED_SELECTED);
        this.theme = theme;
        this.buttonShaper = new ClassicButtonShaper();
        this.watermark = new SubstanceCrosshatchWatermark();
        this.gradientPainter = new SimplisticSoftBorderReverseGradientPainter(){

            public Color getBottomFillColor(ColorScheme interpolationScheme1, ColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
                return this.getMidFillColorBottom(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
            }
        };
        this.decorationPainter = new FlatDecorationPainter();
        this.highlightPainter = new ClassicHighlightPainter();
        this.tabBackgroundComposite = new AlphaControlBackgroundComposite(0.5f);
        this.borderPainter = new ClassicInnerBorderPainter(0.55f, SubstanceConstants.ColorShiftKind.TONE);
    }

    public String getDisplayName() {
        return NAME;
    }
}

