/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.border.InnerDelegateBorderPainter;
import org.jvnet.substance.border.SubstanceBorderPainter;
import org.jvnet.substance.button.BaseButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.SubstanceGradientPainter;
import org.jvnet.substance.painter.text.SubstanceTextPainter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceThemeUtilities;

public class SubstanceProgressBarUI
extends BasicProgressBarUI {
    protected Set lafWidgets;
    private static Map<String, BufferedImage> stripeMap = new HashMap<String, BufferedImage>();
    private float animationIndex;
    protected ChangeListener substanceValueChangeListener;
    protected float speed;
    public static final FadeKind PROGRESS_BAR_VALUE_CHANGED = new FadeKind("substancelaf.progressBarValueChanged");
    private static final String PROGRESS_BAR_FROM = "substancelaf.internal.from";
    private static final String PROGRESS_BAR_TO = "substancelaf.internal.to";

    public void __org__jvnet__substance__SubstanceProgressBarUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D);
        this.__org__jvnet__substance__SubstanceProgressBarUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstanceProgressBarUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceProgressBarUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__jvnet__substance__SubstanceProgressBarUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceProgressBarUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void installListeners() {
        this.__org__jvnet__substance__SubstanceProgressBarUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public void installDefaults() {
        this.__org__jvnet__substance__SubstanceProgressBarUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void uninstallListeners() {
        this.__org__jvnet__substance__SubstanceProgressBarUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void __org__jvnet__substance__SubstanceProgressBarUI__uninstallDefaults() {
        super.uninstallDefaults();
    }

    public void uninstallDefaults() {
        this.__org__jvnet__substance__SubstanceProgressBarUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public static synchronized void reset() {
        stripeMap.clear();
    }

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceProgressBarUI();
    }

    protected void __org__jvnet__substance__SubstanceProgressBarUI__installDefaults() {
        super.installDefaults();
        this.progressBar.putClientProperty(PROGRESS_BAR_TO, this.progressBar.getValue());
        LookAndFeel.installProperty(this.progressBar, "opaque", Boolean.FALSE);
        this.speed = 20.0f * (float)UIManager.getInt("ProgressBar.repaintInterval") / (float)UIManager.getInt("ProgressBar.cycleTime");
    }

    protected void __org__jvnet__substance__SubstanceProgressBarUI__installListeners() {
        super.installListeners();
        final BoundedRangeModel model = this.progressBar.getModel();
        if (model instanceof DefaultBoundedRangeModel) {
            this.substanceValueChangeListener = new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    int oldValue = (Integer)SubstanceProgressBarUI.this.progressBar.getClientProperty(SubstanceProgressBarUI.PROGRESS_BAR_TO);
                    int currValue = model.getValue();
                    int span = model.getMaximum() - model.getMinimum();
                    Insets b = SubstanceProgressBarUI.this.progressBar.getInsets();
                    int barRectWidth = SubstanceProgressBarUI.this.progressBar.getWidth() - (b.right + b.left);
                    int barRectHeight = SubstanceProgressBarUI.this.progressBar.getHeight() - (b.top + b.bottom);
                    int totalPixels = SubstanceProgressBarUI.this.progressBar.getOrientation() == 0 ? barRectWidth : barRectHeight;
                    int pixelDelta = span <= 0 ? 0 : (currValue - oldValue) * totalPixels / span;
                    FadeTracker fadeTracker = FadeTracker.getInstance();
                    if (!fadeTracker.isTracked(SubstanceProgressBarUI.this.progressBar, PROGRESS_BAR_VALUE_CHANGED)) {
                        SubstanceProgressBarUI.this.progressBar.putClientProperty(SubstanceProgressBarUI.PROGRESS_BAR_FROM, SubstanceProgressBarUI.this.progressBar.getClientProperty(SubstanceProgressBarUI.PROGRESS_BAR_TO));
                    }
                    SubstanceProgressBarUI.this.progressBar.putClientProperty(SubstanceProgressBarUI.PROGRESS_BAR_TO, SubstanceProgressBarUI.this.progressBar.getValue());
                    if (Math.abs(pixelDelta) > 5) {
                        FadeTracker.getInstance().trackFadeIn(PROGRESS_BAR_VALUE_CHANGED, SubstanceProgressBarUI.this.progressBar, false, null);
                    }
                }
            };
            ((DefaultBoundedRangeModel)model).addChangeListener(this.substanceValueChangeListener);
        }
    }

    protected void __org__jvnet__substance__SubstanceProgressBarUI__uninstallListeners() {
        BoundedRangeModel model = this.progressBar.getModel();
        if (model instanceof DefaultBoundedRangeModel) {
            ((DefaultBoundedRangeModel)model).removeChangeListener(this.substanceValueChangeListener);
        }
        super.uninstallListeners();
    }

    private static synchronized BufferedImage getStripe(int baseSize, boolean isRotated, ColorScheme colorScheme) {
        String key = "" + baseSize + ":" + isRotated + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme);
        BufferedImage result = stripeMap.get(key);
        if (result == null) {
            result = SubstanceImageCreator.getStripe(baseSize, colorScheme.getUltraLightColor());
            if (isRotated) {
                result = SubstanceImageCreator.getRotated(result, 1);
            }
            stripeMap.put(key, result);
        }
        return result;
    }

    public void paintDeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        final Insets insets = this.progressBar.getInsets();
        insets.top /= 2;
        insets.left /= 2;
        insets.bottom /= 2;
        insets.right /= 2;
        final int barRectWidth = this.progressBar.getWidth() - (insets.right + insets.left);
        final int barRectHeight = this.progressBar.getHeight() - (insets.top + insets.bottom);
        final int amountFull = this.getAmountFull(insets, barRectWidth, barRectHeight);
        SubstanceTextPainter.BackgroundPaintingCallback callback = new SubstanceTextPainter.BackgroundPaintingCallback(){

            public void paintBackground(Graphics g) {
                BufferedImage bg;
                GeneralPath contour;
                Graphics2D graphics = (Graphics2D)g.create();
                SubstanceTheme bgTheme = SubstanceThemeUtilities.getTheme(SubstanceProgressBarUI.this.progressBar);
                bgTheme = SubstanceProgressBarUI.this.progressBar.isEnabled() ? bgTheme.getDefaultTheme() : bgTheme.getDisabledTheme();
                SubstanceGradientPainter gp = SubstanceCoreUtilities.getGradientPainter(SubstanceProgressBarUI.this.progressBar);
                if (SubstanceProgressBarUI.this.progressBar.getOrientation() == 0) {
                    contour = BaseButtonShaper.getBaseOutline(barRectWidth + 1, barRectHeight + 1, 0.0f, null);
                    bg = gp.getContourBackground(barRectWidth + 1, barRectHeight + 1, contour, false, bgTheme.getColorScheme(), bgTheme.getColorScheme(), 0.0f, true, false);
                    graphics.drawImage((Image)bg, insets.left, insets.top, null);
                } else {
                    contour = BaseButtonShaper.getBaseOutline(barRectHeight + 1, barRectWidth + 1, 0.0f, null);
                    bg = gp.getContourBackground(barRectHeight + 1, barRectWidth + 1, contour, false, bgTheme.getColorScheme(), bgTheme.getColorScheme(), 0.0f, true, false);
                    graphics.drawImage((Image)SubstanceImageCreator.getRotated(bg, 3), insets.left, insets.top, null);
                }
                if (amountFull > 0) {
                    float borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(SubstanceProgressBarUI.this.progressBar));
                    SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(null);
                    int borderDelta = borderPainter instanceof InnerDelegateBorderPainter ? (int)Math.ceil(2.0 * (double)borderStrokeWidth) / 2 : (int)((double)borderStrokeWidth / 2.0);
                    ColorScheme fillColorScheme = SubstanceThemeUtilities.getTheme(SubstanceProgressBarUI.this.progressBar, SubstanceProgressBarUI.this.progressBar.isEnabled() ? ComponentState.SELECTED : ComponentState.DISABLED_UNSELECTED).getColorScheme();
                    if (SubstanceProgressBarUI.this.progressBar.getOrientation() == 0) {
                        int barWidth = amountFull - 2 * borderDelta;
                        int barHeight = barRectHeight - 2 * borderDelta;
                        if (barWidth > 0 && barHeight > 0) {
                            if (SubstanceProgressBarUI.this.progressBar.getComponentOrientation().isLeftToRight()) {
                                SubstanceImageCreator.paintRectangularBackground(g, insets.left + borderDelta, insets.top + borderDelta, barWidth, barHeight, fillColorScheme, 0.6f, false);
                            } else {
                                SubstanceImageCreator.paintRectangularBackground(g, insets.left + barRectWidth - amountFull - 2 * borderDelta, insets.top + borderDelta, barWidth, barHeight, fillColorScheme, 0.6f, false);
                            }
                        }
                    } else {
                        int barWidth = SubstanceProgressBarUI.this.progressBar.getHeight() - insets.bottom - amountFull - 2 * borderDelta;
                        int barHeight = barRectWidth - 2 * borderDelta;
                        if (barWidth > 0 && barHeight > 0) {
                            SubstanceImageCreator.paintRectangularBackground(g, insets.left + borderDelta, barWidth + borderDelta, barHeight, amountFull, fillColorScheme, 0.6f, true);
                        }
                    }
                }
                graphics.dispose();
            }
        };
        Graphics2D g2d = (Graphics2D)g.create();
        float themeAlpha = SubstanceThemeUtilities.getTheme(this.progressBar).getThemeAlpha(this.progressBar, this.progressBar.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED);
        g2d.setComposite(TransitionLayout.getAlphaComposite(this.progressBar, themeAlpha, g));
        SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
        textPainter.init(this.progressBar, null, true);
        textPainter.setBackgroundFill(this.progressBar, this.progressBar.getParent().getBackground(), true, 0, 0);
        if (textPainter.needsBackgroundImage()) {
            textPainter.attachCallback(callback);
        } else {
            callback.paintBackground(g2d);
        }
        if (this.progressBar.isStringPainted()) {
            this.paintString(g2d, insets.left, insets.top, barRectWidth, barRectHeight, amountFull, insets);
        }
        textPainter.renderSurface(g2d);
        g2d.dispose();
    }

    protected Color getSelectionBackground() {
        ComponentState state = this.progressBar.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED;
        SubstanceTheme theme = SubstanceThemeUtilities.getTheme(this.progressBar, state);
        return theme.getForegroundColor();
    }

    protected Color getSelectionForeground() {
        ComponentState state = this.progressBar.isEnabled() ? ComponentState.ACTIVE : ComponentState.DISABLED_UNSELECTED;
        SubstanceTheme theme = SubstanceThemeUtilities.getTheme(this.progressBar, state);
        return theme.getForegroundColor();
    }

    public void paintIndeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        final Insets b = this.progressBar.getInsets();
        final int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        final int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        final int valComplete = (int)this.animationIndex;
        SubstanceTextPainter.BackgroundPaintingCallback callback = new SubstanceTextPainter.BackgroundPaintingCallback(){

            public void paintBackground(Graphics g) {
                Graphics2D graphics = (Graphics2D)g.create();
                ColorScheme fillColorScheme = SubstanceThemeUtilities.getTheme(SubstanceProgressBarUI.this.progressBar, SubstanceProgressBarUI.this.progressBar.isEnabled() ? ComponentState.SELECTED : ComponentState.DISABLED_UNSELECTED).getColorScheme();
                if (SubstanceProgressBarUI.this.progressBar.getOrientation() == 0) {
                    SubstanceImageCreator.paintRectangularStripedBackground(graphics, b.left, b.top, barRectWidth, barRectHeight, fillColorScheme, SubstanceProgressBarUI.getStripe(barRectHeight, false, fillColorScheme), valComplete, 0.6f, false);
                } else {
                    SubstanceImageCreator.paintRectangularStripedBackground(graphics, b.left, b.top, barRectWidth, barRectHeight, fillColorScheme, SubstanceProgressBarUI.getStripe(barRectWidth, true, fillColorScheme), 2 * barRectWidth - valComplete, 0.6f, true);
                }
                graphics.dispose();
            }
        };
        Graphics2D g2d = (Graphics2D)g.create();
        float themeAlpha = SubstanceThemeUtilities.getTheme(this.progressBar).getThemeAlpha(this.progressBar, this.progressBar.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED);
        g2d.setComposite(TransitionLayout.getAlphaComposite(this.progressBar, themeAlpha, g));
        SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
        textPainter.init(this.progressBar, null, true);
        textPainter.setBackgroundFill(this.progressBar, this.progressBar.getParent().getBackground(), true, 0, 0);
        if (textPainter.needsBackgroundImage()) {
            textPainter.attachCallback(callback);
        } else {
            callback.paintBackground(g2d);
        }
        if (this.progressBar.isStringPainted()) {
            this.paintString(g2d, b.left, b.top, barRectWidth, barRectHeight, barRectWidth, b);
        }
        textPainter.renderSurface(g2d);
        g2d.dispose();
    }

    protected Rectangle getBox(Rectangle r) {
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        return new Rectangle(b.left, b.top, barRectWidth, barRectHeight);
    }

    protected void incrementAnimationIndex() {
        float newValue = this.animationIndex + this.speed;
        Insets b = this.progressBar.getInsets();
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int threshold = 0;
        threshold = this.progressBar.getOrientation() == 0 ? 2 * barRectHeight + 1 : 2 * barRectWidth + 1;
        this.animationIndex = newValue % (float)threshold;
        this.progressBar.repaint();
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceProgressBarUI: \n");
        sb.append("\t" + stripeMap.size() + " stripes");
        return sb.toString();
    }

    protected int getAmountFull(Insets b, int width, int height) {
        int amountFull = 0;
        BoundedRangeModel model = this.progressBar.getModel();
        long span = model.getMaximum() - model.getMinimum();
        double currentValue = model.getValue();
        FadeTracker fadeTracker = FadeTracker.getInstance();
        if (fadeTracker.isTracked(this.progressBar, PROGRESS_BAR_VALUE_CHANGED)) {
            double fade10 = fadeTracker.getFade10(this.progressBar, PROGRESS_BAR_VALUE_CHANGED);
            int from = (Integer)this.progressBar.getClientProperty(PROGRESS_BAR_FROM);
            int to = (Integer)this.progressBar.getClientProperty(PROGRESS_BAR_TO);
            currentValue = (double)from + fade10 * (double)(to - from) / 10.0;
        }
        double percentComplete = (currentValue - (double)model.getMinimum()) / (double)span;
        if (model.getMaximum() - model.getMinimum() != 0) {
            amountFull = this.progressBar.getOrientation() == 0 ? (int)Math.round((double)width * percentComplete) : (int)Math.round((double)height * percentComplete);
        }
        return amountFull;
    }

    protected Dimension getPreferredInnerHorizontal() {
        int size = SubstanceSizeUtils.getComponentFontSize(this.progressBar);
        size += 2 * SubstanceSizeUtils.getAdjustedSize(size, 1, 4, 1, false);
        return new Dimension(146 + SubstanceSizeUtils.getAdjustedSize(size, 0, 1, 10, false), size);
    }

    protected Dimension getPreferredInnerVertical() {
        int size = SubstanceSizeUtils.getComponentFontSize(this.progressBar);
        size += 2 * SubstanceSizeUtils.getAdjustedSize(size, 1, 4, 1, false);
        return new Dimension(size, 146 + SubstanceSizeUtils.getAdjustedSize(size, 0, 1, 10, false));
    }

    protected void paintString(Graphics g, int x, int y, int width, int height, int amountFull, Insets b) {
        if (this.progressBar.getOrientation() == 0) {
            if (this.progressBar.getComponentOrientation().isLeftToRight()) {
                if (this.progressBar.isIndeterminate()) {
                    this.boxRect = this.getBox(this.boxRect);
                    this.paintString(x, y, width, height, this.boxRect.x, this.boxRect.width, b);
                } else {
                    this.paintString(x, y, width, height, x, amountFull, b);
                }
            } else {
                this.paintString(x, y, width, height, x + width - amountFull, amountFull, b);
            }
        } else if (this.progressBar.isIndeterminate()) {
            this.boxRect = this.getBox(this.boxRect);
            this.paintString(x, y, width, height, this.boxRect.y, this.boxRect.height, b);
        } else {
            this.paintString(x, y, width, height, y + height - amountFull, amountFull, b);
        }
    }

    private void paintString(int x, int y, int width, int height, int fillStart, int amountFull, Insets b) {
        String progressString = this.progressBar.getString();
        Rectangle renderRectangle = this.getStringRectangle(progressString, x, y, width, height);
        SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
        if (this.progressBar.getOrientation() == 0) {
            textPainter.attachText(this.progressBar, renderRectangle, progressString, -1, this.progressBar.getFont(), this.getSelectionBackground(), new Rectangle(amountFull, y, this.progressBar.getWidth() - amountFull, height));
            textPainter.attachText(this.progressBar, renderRectangle, progressString, -1, this.progressBar.getFont(), this.getSelectionForeground(), new Rectangle(fillStart, y, amountFull, height));
        } else {
            textPainter.attachVerticalText(this.progressBar, renderRectangle, progressString, -1, this.progressBar.getFont(), this.getSelectionBackground(), new Rectangle(x, y, width, this.progressBar.getHeight() - amountFull), this.progressBar.getComponentOrientation().isLeftToRight());
            textPainter.attachVerticalText(this.progressBar, renderRectangle, progressString, -1, this.progressBar.getFont(), this.getSelectionForeground(), new Rectangle(x, fillStart, width, amountFull), this.progressBar.getComponentOrientation().isLeftToRight());
        }
    }

    protected Rectangle getStringRectangle(String progressString, int x, int y, int width, int height) {
        FontMetrics fontSizer = this.progressBar.getFontMetrics(this.progressBar.getFont());
        int stringWidth = fontSizer.stringWidth(progressString);
        if (this.progressBar.getOrientation() == 0) {
            return new Rectangle(x + Math.round(width / 2 - stringWidth / 2), y + (height - fontSizer.getHeight()) / 2, stringWidth, fontSizer.getHeight());
        }
        return new Rectangle(x + (width - fontSizer.getHeight()) / 2, y + Math.round(height / 2 - stringWidth / 2), fontSizer.getHeight(), stringWidth);
    }
}

