/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.GlyphList;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.Pfm2afm;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.fonts.FontsResourceAnchor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

class Type1Font
extends BaseFont {
    private static FontsResourceAnchor resourceAnchor;
    protected byte[] pfb;
    private String FontName;
    private String FullName;
    private String FamilyName;
    private String Weight = "";
    private float ItalicAngle = 0.0f;
    private boolean IsFixedPitch = false;
    private String CharacterSet;
    private int llx = -50;
    private int lly = -200;
    private int urx = 1000;
    private int ury = 900;
    private int UnderlinePosition = -100;
    private int UnderlineThickness = 50;
    private String EncodingScheme = "FontSpecific";
    private int CapHeight = 700;
    private int XHeight = 480;
    private int Ascender = 800;
    private int Descender = -200;
    private int StdHW;
    private int StdVW = 80;
    private Map<Object, Object[]> CharMetrics = new HashMap<Object, Object[]>();
    private Map<String, Object[]> KernPairs = new HashMap<String, Object[]>();
    private String fileName;
    private boolean builtinFont = false;
    private static final int[] PFB_TYPES;

    static {
        PFB_TYPES = new int[]{1, 2, 1};
    }

    Type1Font(String afmFile, String enc, boolean emb, byte[] ttfAfm, byte[] pfb, boolean forceRead) throws DocumentException, IOException {
        if (emb && ttfAfm != null && pfb == null) {
            throw new DocumentException(MessageLocalization.getComposedMessage("two.byte.arrays.are.needed.if.the.type1.font.is.embedded"));
        }
        if (emb && ttfAfm != null) {
            this.pfb = pfb;
        }
        this.encoding = enc;
        this.embedded = emb;
        this.fileName = afmFile;
        this.fontType = 0;
        RandomAccessFileOrArray rf = null;
        InputStream is = null;
        if (BuiltinFonts14.containsKey(afmFile)) {
            this.embedded = false;
            this.builtinFont = true;
            byte[] buf = new byte[1024];
            try {
                int size;
                if (resourceAnchor == null) {
                    resourceAnchor = new FontsResourceAnchor();
                }
                if ((is = Type1Font.getResourceStream("com/lowagie/text/pdf/fonts/" + afmFile + ".afm", resourceAnchor.getClass().getClassLoader())) == null) {
                    String msg = MessageLocalization.getComposedMessage("1.not.found.as.resource", afmFile);
                    System.err.println(msg);
                    throw new DocumentException(msg);
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while ((size = is.read(buf)) >= 0) {
                    out.write(buf, 0, size);
                }
                buf = out.toByteArray();
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
            try {
                rf = new RandomAccessFileOrArray(buf);
                this.process(rf);
            }
            finally {
                if (rf != null) {
                    try {
                        rf.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (afmFile.toLowerCase().endsWith(".afm")) {
            try {
                rf = ttfAfm == null ? new RandomAccessFileOrArray(afmFile, forceRead, Document.plainRandomAccess) : new RandomAccessFileOrArray(ttfAfm);
                this.process(rf);
            }
            finally {
                if (rf != null) {
                    try {
                        rf.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (afmFile.toLowerCase().endsWith(".pfm")) {
            try {
                ByteArrayOutputStream ba = new ByteArrayOutputStream();
                rf = ttfAfm == null ? new RandomAccessFileOrArray(afmFile, forceRead, Document.plainRandomAccess) : new RandomAccessFileOrArray(ttfAfm);
                Pfm2afm.convert(rf, ba);
                rf.close();
                rf = new RandomAccessFileOrArray(ba.toByteArray());
                this.process(rf);
            }
            finally {
                if (rf != null) {
                    try {
                        rf.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        throw new DocumentException(MessageLocalization.getComposedMessage("1.is.not.an.afm.or.pfm.font.file", afmFile));
        this.EncodingScheme = this.EncodingScheme.trim();
        if (this.EncodingScheme.equals("AdobeStandardEncoding") || this.EncodingScheme.equals("StandardEncoding")) {
            this.fontSpecific = false;
        }
        if (!this.encoding.startsWith("#")) {
            PdfEncodings.convertToBytes(" ", enc);
        }
        this.createEncoding();
    }

    @Override
    int getRawWidth(int c, String name) {
        Object[] metrics;
        if (name == null) {
            metrics = this.CharMetrics.get(c);
        } else {
            if (name.equals(".notdef")) {
                return 0;
            }
            metrics = this.CharMetrics.get(name);
        }
        if (metrics != null) {
            return (Integer)metrics[1];
        }
        return 0;
    }

    @Override
    public int getKerning(int char1, int char2) {
        String first = GlyphList.unicodeToName(char1);
        if (first == null) {
            return 0;
        }
        String second = GlyphList.unicodeToName(char2);
        if (second == null) {
            return 0;
        }
        Object[] obj = this.KernPairs.get(first);
        if (obj == null) {
            return 0;
        }
        int k = 0;
        while (k < obj.length) {
            if (second.equals(obj[k]) && obj.length > k + 1) {
                return (Integer)obj[k + 1];
            }
            k += 2;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    public void process(RandomAccessFileOrArray rf) throws DocumentException, IOException {
        isMetrics = false;
        block52: while ((line = rf.readLine()) != null) {
            tok = new StringTokenizer(line, " ,\n\r\t\f");
            if (!tok.hasMoreTokens()) continue;
            var6_6 = ident = tok.nextToken();
            tmp = -1;
            switch (var6_6.hashCode()) {
                case -2037328797: {
                    if (var6_6.equals("ItalicAngle")) {
                        tmp = 1;
                    }
                    break;
                }
                case -1707725160: {
                    if (var6_6.equals("Weight")) {
                        tmp = 2;
                    }
                    break;
                }
                case -1587834632: {
                    if (var6_6.equals("EncodingScheme")) {
                        tmp = 3;
                    }
                    break;
                }
                case -1502948305: {
                    if (var6_6.equals("FamilyName")) {
                        tmp = 4;
                    }
                    break;
                }
                case -1346249825: {
                    if (var6_6.equals("XHeight")) {
                        tmp = 5;
                    }
                    break;
                }
                case -1278893927: {
                    if (var6_6.equals("CharacterSet")) {
                        tmp = 6;
                    }
                    break;
                }
                case -812484743: {
                    if (var6_6.equals("CapHeight")) {
                        tmp = 7;
                    }
                    break;
                }
                case -802988361: {
                    if (var6_6.equals("Descender")) {
                        tmp = 8;
                    }
                    break;
                }
                case -766799081: {
                    if (var6_6.equals("Ascender")) {
                        tmp = 9;
                    }
                    break;
                }
                case -265632490: {
                    if (var6_6.equals("IsFixedPitch")) {
                        tmp = 10;
                    }
                    break;
                }
                case 80206418: {
                    if (var6_6.equals("StdHW")) {
                        tmp = 11;
                    }
                    break;
                }
                case 80206852: {
                    if (var6_6.equals("StdVW")) {
                        tmp = 12;
                    }
                    break;
                }
                case 425555957: {
                    if (var6_6.equals("UnderlinePosition")) {
                        tmp = 13;
                    }
                    break;
                }
                case 429700888: {
                    if (var6_6.equals("FontBBox")) {
                        tmp = 14;
                    }
                    break;
                }
                case 430088090: {
                    if (var6_6.equals("FontName")) {
                        tmp = 15;
                    }
                    break;
                }
                case 1395496410: {
                    if (var6_6.equals("FullName")) {
                        tmp = 16;
                    }
                    break;
                }
                case 1672376043: {
                    if (var6_6.equals("StartCharMetrics")) {
                        tmp = 17;
                    }
                    break;
                }
                case 1887629864: {
                    if (var6_6.equals("UnderlineThickness")) {
                        tmp = 18;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 15: {
                    this.FontName = tok.nextToken("\u00ff").substring(1);
                    ** GOTO lbl158
                }
                case 16: {
                    this.FullName = tok.nextToken("\u00ff").substring(1);
                    ** GOTO lbl158
                }
                case 4: {
                    this.FamilyName = tok.nextToken("\u00ff").substring(1);
                    ** GOTO lbl158
                }
                case 2: {
                    this.Weight = tok.nextToken("\u00ff").substring(1);
                    ** GOTO lbl158
                }
                case 1: {
                    this.ItalicAngle = Float.parseFloat(tok.nextToken());
                    ** GOTO lbl158
                }
                case 10: {
                    this.IsFixedPitch = tok.nextToken().equals("true");
                    ** GOTO lbl158
                }
                case 6: {
                    this.CharacterSet = tok.nextToken("\u00ff").substring(1);
                    ** GOTO lbl158
                }
                case 14: {
                    this.llx = (int)Float.parseFloat(tok.nextToken());
                    this.lly = (int)Float.parseFloat(tok.nextToken());
                    this.urx = (int)Float.parseFloat(tok.nextToken());
                    this.ury = (int)Float.parseFloat(tok.nextToken());
                    ** GOTO lbl158
                }
                case 13: {
                    this.UnderlinePosition = (int)Float.parseFloat(tok.nextToken());
                    ** GOTO lbl158
                }
                case 18: {
                    this.UnderlineThickness = (int)Float.parseFloat(tok.nextToken());
                    ** GOTO lbl158
                }
                case 3: {
                    this.EncodingScheme = tok.nextToken("\u00ff").substring(1);
                    ** GOTO lbl158
                }
                case 7: {
                    this.CapHeight = (int)Float.parseFloat(tok.nextToken());
                    ** GOTO lbl158
                }
                case 5: {
                    this.XHeight = (int)Float.parseFloat(tok.nextToken());
                    ** GOTO lbl158
                }
                case 9: {
                    this.Ascender = (int)Float.parseFloat(tok.nextToken());
                    ** GOTO lbl158
                }
                case 8: {
                    this.Descender = (int)Float.parseFloat(tok.nextToken());
                    ** GOTO lbl158
                }
                case 11: {
                    this.StdHW = (int)Float.parseFloat(tok.nextToken());
                    ** GOTO lbl158
                }
                case 12: {
                    this.StdVW = (int)Float.parseFloat(tok.nextToken());
                    ** GOTO lbl158
                }
                case 17: {
                    isMetrics = true;
                    break block52;
                }
lbl158:
                // 18 sources

                default: {
                    continue block52;
                }
            }
        }
        if (isMetrics) ** GOTO lbl220
        throw new DocumentException(MessageLocalization.getComposedMessage("missing.startcharmetrics.in.1", this.fileName));
lbl-1000:
        // 1 sources

        {
            tok = new StringTokenizer(line);
            if (!tok.hasMoreTokens()) continue;
            ident = tok.nextToken();
            if (ident.equals("EndCharMetrics")) {
                isMetrics = false;
                break;
            }
            C = -1;
            WX = 250;
            N = "";
            B = null;
            tok = new StringTokenizer(line, ";");
            while (tok.hasMoreTokens()) {
                tokc = new StringTokenizer(tok.nextToken());
                if (!tokc.hasMoreTokens()) continue;
                var11_17 = ident = tokc.nextToken();
                tmp = -1;
                switch (var11_17.hashCode()) {
                    case 66: {
                        if (var11_17.equals("B")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 67: {
                        if (var11_17.equals("C")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 78: {
                        if (var11_17.equals("N")) {
                            tmp = 3;
                        }
                        break;
                    }
                    case 2785: {
                        if (var11_17.equals("WX")) {
                            tmp = 4;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 2: {
                        C = Integer.valueOf(tokc.nextToken());
                        break;
                    }
                    case 4: {
                        WX = (int)Float.parseFloat(tokc.nextToken());
                        break;
                    }
                    case 3: {
                        N = tokc.nextToken();
                        break;
                    }
                    case 1: {
                        B = new int[]{Integer.parseInt(tokc.nextToken()), Integer.parseInt(tokc.nextToken()), Integer.parseInt(tokc.nextToken()), Integer.parseInt(tokc.nextToken())};
                    }
                }
            }
            metrics = new Object[]{C, WX, N, B};
            if (C >= 0) {
                this.CharMetrics.put(C, metrics);
            }
            this.CharMetrics.put(N, metrics);
lbl220:
            // 3 sources

            ** while ((line = rf.readLine()) != null)
        }
lbl221:
        // 2 sources

        if (isMetrics) {
            throw new DocumentException(MessageLocalization.getComposedMessage("missing.endcharmetrics.in.1", this.fileName));
        }
        if (!this.CharMetrics.containsKey("nonbreakingspace") && (space = this.CharMetrics.get("space")) != null) {
            this.CharMetrics.put("nonbreakingspace", space);
        }
        while ((line = rf.readLine()) != null) {
            tok = new StringTokenizer(line);
            if (!tok.hasMoreTokens()) continue;
            ident = tok.nextToken();
            if (ident.equals("EndFontMetrics")) {
                return;
            }
            if (!ident.equals("StartKernPairs")) continue;
            isMetrics = true;
            break;
        }
        if (isMetrics) ** GOTO lbl260
        throw new DocumentException(MessageLocalization.getComposedMessage("missing.endfontmetrics.in.1", this.fileName));
lbl-1000:
        // 1 sources

        {
            tok = new StringTokenizer(line);
            if (!tok.hasMoreTokens()) continue;
            ident = tok.nextToken();
            if (ident.equals("KPX")) {
                first = tok.nextToken();
                second = tok.nextToken();
                width = Integer.parseInt(tok.nextToken());
                relates = this.KernPairs.get(first);
                if (relates == null) {
                    this.KernPairs.put(first, new Object[]{second, width});
                    continue;
                }
                n = relates.length;
                relates2 = new Object[n + 2];
                System.arraycopy(relates, 0, relates2, 0, n);
                relates2[n] = second;
                relates2[n + 1] = width;
                this.KernPairs.put(first, relates2);
                continue;
            }
            if (!ident.equals("EndKernPairs")) continue;
            isMetrics = false;
            break;
lbl260:
            // 5 sources

            ** while ((line = rf.readLine()) != null)
        }
lbl261:
        // 2 sources

        if (isMetrics) {
            throw new DocumentException(MessageLocalization.getComposedMessage("missing.endkernpairs.in.1", this.fileName));
        }
        rf.close();
    }

    @Override
    public PdfStream getFullFontStream() throws DocumentException {
        if (this.builtinFont || !this.embedded) {
            return null;
        }
        RandomAccessFileOrArray rf = null;
        try {
            String filePfb = String.valueOf(this.fileName.substring(0, this.fileName.length() - 3)) + "pfb";
            rf = this.pfb == null ? new RandomAccessFileOrArray(filePfb, true, Document.plainRandomAccess) : new RandomAccessFileOrArray(this.pfb);
            int fileLength = rf.length();
            byte[] st = new byte[fileLength - 18];
            int[] lengths = new int[3];
            int bytePtr = 0;
            int k = 0;
            while (k < 3) {
                if (rf.read() != 128) {
                    throw new DocumentException(MessageLocalization.getComposedMessage("start.marker.missing.in.1", filePfb));
                }
                if (rf.read() != PFB_TYPES[k]) {
                    throw new DocumentException(MessageLocalization.getComposedMessage("incorrect.segment.type.in.1", filePfb));
                }
                int size = rf.read();
                size += rf.read() << 8;
                size += rf.read() << 16;
                lengths[k] = size += rf.read() << 24;
                while (size != 0) {
                    int got = rf.read(st, bytePtr, size);
                    if (got < 0) {
                        throw new DocumentException(MessageLocalization.getComposedMessage("premature.end.in.1", filePfb));
                    }
                    bytePtr += got;
                    size -= got;
                }
                ++k;
            }
            BaseFont.StreamFont streamFont = new BaseFont.StreamFont(st, lengths, this.compressionLevel);
            return streamFont;
        }
        catch (Exception e) {
            throw new DocumentException(e);
        }
        finally {
            if (rf != null) {
                try {
                    rf.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private PdfDictionary getFontDescriptor(PdfIndirectReference fontStream) {
        if (this.builtinFont) {
            return null;
        }
        PdfDictionary dic = new PdfDictionary(PdfName.FONTDESCRIPTOR);
        dic.put(PdfName.ASCENT, new PdfNumber(this.Ascender));
        dic.put(PdfName.CAPHEIGHT, new PdfNumber(this.CapHeight));
        dic.put(PdfName.DESCENT, new PdfNumber(this.Descender));
        dic.put(PdfName.FONTBBOX, new PdfRectangle(this.llx, this.lly, this.urx, this.ury));
        dic.put(PdfName.FONTNAME, new PdfName(this.FontName));
        dic.put(PdfName.ITALICANGLE, new PdfNumber(this.ItalicAngle));
        dic.put(PdfName.STEMV, new PdfNumber(this.StdVW));
        if (fontStream != null) {
            dic.put(PdfName.FONTFILE, fontStream);
        }
        int flags = 0;
        if (this.IsFixedPitch) {
            flags |= 1;
        }
        flags |= this.fontSpecific ? 4 : 32;
        if (this.ItalicAngle < 0.0f) {
            flags |= 0x40;
        }
        if (this.FontName.contains("Caps") || this.FontName.endsWith("SC")) {
            flags |= 0x20000;
        }
        if (this.Weight.equals("Bold")) {
            flags |= 0x40000;
        }
        dic.put(PdfName.FLAGS, new PdfNumber(flags));
        return dic;
    }

    private PdfDictionary getFontBaseType(PdfIndirectReference fontDescriptor, int firstChar, int lastChar, byte[] shortTag) {
        boolean stdEncoding;
        PdfDictionary dic = new PdfDictionary(PdfName.FONT);
        dic.put(PdfName.SUBTYPE, PdfName.TYPE1);
        dic.put(PdfName.BASEFONT, new PdfName(this.FontName));
        boolean bl = stdEncoding = this.encoding.equals("Cp1252") || this.encoding.equals("MacRoman");
        if (!this.fontSpecific || this.specialMap != null) {
            int k = firstChar;
            while (k <= lastChar) {
                if (!this.differences[k].equals(".notdef")) {
                    firstChar = k;
                    break;
                }
                ++k;
            }
            if (stdEncoding) {
                dic.put(PdfName.ENCODING, this.encoding.equals("Cp1252") ? PdfName.WIN_ANSI_ENCODING : PdfName.MAC_ROMAN_ENCODING);
            } else {
                PdfDictionary enc = new PdfDictionary(PdfName.ENCODING);
                PdfArray dif = new PdfArray();
                boolean gap = true;
                int k2 = firstChar;
                while (k2 <= lastChar) {
                    if (shortTag[k2] != 0) {
                        if (gap) {
                            dif.add(new PdfNumber(k2));
                            gap = false;
                        }
                        dif.add(new PdfName(this.differences[k2]));
                    } else {
                        gap = true;
                    }
                    ++k2;
                }
                enc.put(PdfName.DIFFERENCES, dif);
                dic.put(PdfName.ENCODING, enc);
            }
        }
        if (this.specialMap != null || this.forceWidthsOutput || !this.builtinFont || !this.fontSpecific && !stdEncoding) {
            dic.put(PdfName.FIRSTCHAR, new PdfNumber(firstChar));
            dic.put(PdfName.LASTCHAR, new PdfNumber(lastChar));
            PdfArray wd = new PdfArray();
            int k = firstChar;
            while (k <= lastChar) {
                if (shortTag[k] == 0) {
                    wd.add(new PdfNumber(0));
                } else {
                    wd.add(new PdfNumber(this.widths[k]));
                }
                ++k;
            }
            dic.put(PdfName.WIDTHS, wd);
        }
        if (!this.builtinFont && fontDescriptor != null) {
            dic.put(PdfName.FONTDESCRIPTOR, fontDescriptor);
        }
        return dic;
    }

    @Override
    void writeFont(PdfWriter writer, PdfIndirectReference ref, Object[] params) throws DocumentException, IOException {
        boolean subsetp;
        int firstChar = (Integer)params[0];
        int lastChar = (Integer)params[1];
        byte[] shortTag = (byte[])params[2];
        boolean bl = subsetp = (Boolean)params[3] != false && this.subset;
        if (!subsetp) {
            firstChar = 0;
            lastChar = shortTag.length - 1;
            int k = 0;
            while (k < shortTag.length) {
                shortTag[k] = 1;
                ++k;
            }
        }
        PdfIndirectReference ind_font = null;
        PdfDictionary pobj = null;
        PdfIndirectObject obj = null;
        pobj = this.getFullFontStream();
        if (pobj != null) {
            obj = writer.addToBody(pobj);
            ind_font = obj.getIndirectReference();
        }
        if ((pobj = this.getFontDescriptor(ind_font)) != null) {
            obj = writer.addToBody(pobj);
            ind_font = obj.getIndirectReference();
        }
        pobj = this.getFontBaseType(ind_font, firstChar, lastChar, shortTag);
        writer.addToBody((PdfObject)pobj, ref);
    }

    @Override
    public float getFontDescriptor(int key, float fontSize) {
        switch (key) {
            case 1: 
            case 9: {
                return (float)this.Ascender * fontSize / 1000.0f;
            }
            case 2: {
                return (float)this.CapHeight * fontSize / 1000.0f;
            }
            case 3: 
            case 10: {
                return (float)this.Descender * fontSize / 1000.0f;
            }
            case 4: {
                return this.ItalicAngle;
            }
            case 5: {
                return (float)this.llx * fontSize / 1000.0f;
            }
            case 6: {
                return (float)this.lly * fontSize / 1000.0f;
            }
            case 7: {
                return (float)this.urx * fontSize / 1000.0f;
            }
            case 8: {
                return (float)this.ury * fontSize / 1000.0f;
            }
            case 11: {
                return 0.0f;
            }
            case 12: {
                return (float)(this.urx - this.llx) * fontSize / 1000.0f;
            }
            case 13: {
                return (float)this.UnderlinePosition * fontSize / 1000.0f;
            }
            case 14: {
                return (float)this.UnderlineThickness * fontSize / 1000.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public String getPostscriptFontName() {
        return this.FontName;
    }

    @Override
    public String[][] getFullFontName() {
        return new String[][]{{"", "", "", this.FullName}};
    }

    @Override
    public String[][] getAllNameEntries() {
        return new String[][]{{"4", "", "", "", this.FullName}};
    }

    @Override
    public String[][] getFamilyFontName() {
        return new String[][]{{"", "", "", this.FamilyName}};
    }

    @Override
    public boolean hasKernPairs() {
        return !this.KernPairs.isEmpty();
    }

    @Override
    public void setPostscriptFontName(String name) {
        this.FontName = name;
    }

    @Override
    public boolean setKerning(int char1, int char2, int kern) {
        String first = GlyphList.unicodeToName(char1);
        if (first == null) {
            return false;
        }
        String second = GlyphList.unicodeToName(char2);
        if (second == null) {
            return false;
        }
        Object[] obj = this.KernPairs.get(first);
        if (obj == null) {
            obj = new Object[]{second, kern};
            this.KernPairs.put(first, obj);
            return true;
        }
        int k = 0;
        while (k < obj.length) {
            if (second.equals(obj[k]) && obj.length > k + 1) {
                obj[k + 1] = kern;
                return true;
            }
            k += 2;
        }
        int size = obj.length;
        Object[] obj2 = new Object[size + 2];
        System.arraycopy(obj, 0, obj2, 0, size);
        obj2[size] = second;
        obj2[size + 1] = kern;
        this.KernPairs.put(first, obj2);
        return true;
    }

    @Override
    protected int[] getRawCharBBox(int c, String name) {
        Object[] metrics;
        if (name == null) {
            metrics = this.CharMetrics.get(c);
        } else {
            if (name.equals(".notdef")) {
                return null;
            }
            metrics = this.CharMetrics.get(name);
        }
        if (metrics != null) {
            return (int[])metrics[3];
        }
        return null;
    }
}

