/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class BasicHyperlinkUI
extends BasicButtonUI {
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    private static MouseListener handCursorListener = new HandCursor();
    protected int dashedRectGapX;
    protected int dashedRectGapY;
    protected int dashedRectGapWidth;
    protected int dashedRectGapHeight;
    private Color focusColor;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicHyperlinkUI();
    }

    protected void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        abstractButton.setOpaque(false);
        abstractButton.setBorderPainted(false);
        abstractButton.setRolloverEnabled(true);
        abstractButton.setBorder(BorderFactory.createEmptyBorder());
        this.dashedRectGapX = UIManager.getInt("ButtonUI.dashedRectGapX");
        this.dashedRectGapY = UIManager.getInt("ButtonUI.dashedRectGapY");
        this.dashedRectGapWidth = UIManager.getInt("ButtonUI.dashedRectGapWidth");
        this.dashedRectGapHeight = UIManager.getInt("ButtonUI.dashedRectGapHeight");
        this.focusColor = UIManager.getColor("ButtonUI.focus");
        abstractButton.setHorizontalAlignment(10);
    }

    protected void installListeners(AbstractButton abstractButton) {
        super.installListeners(abstractButton);
        abstractButton.addMouseListener(handCursorListener);
    }

    protected void uninstallListeners(AbstractButton abstractButton) {
        super.uninstallListeners(abstractButton);
        abstractButton.removeMouseListener(handCursorListener);
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Insets insets = jComponent.getInsets();
        BasicHyperlinkUI.viewRect.x = insets.left;
        BasicHyperlinkUI.viewRect.y = insets.top;
        BasicHyperlinkUI.viewRect.width = abstractButton.getWidth() - (insets.right + BasicHyperlinkUI.viewRect.x);
        BasicHyperlinkUI.viewRect.height = abstractButton.getHeight() - (insets.bottom + BasicHyperlinkUI.viewRect.y);
        BasicHyperlinkUI.textRect.height = 0;
        BasicHyperlinkUI.textRect.width = 0;
        BasicHyperlinkUI.textRect.y = 0;
        BasicHyperlinkUI.textRect.x = 0;
        BasicHyperlinkUI.iconRect.height = 0;
        BasicHyperlinkUI.iconRect.width = 0;
        BasicHyperlinkUI.iconRect.y = 0;
        BasicHyperlinkUI.iconRect.x = 0;
        Font font = jComponent.getFont();
        graphics.setFont(font);
        String string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), viewRect, iconRect, textRect, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
        this.clearTextShiftOffset();
        if (buttonModel.isArmed() && buttonModel.isPressed()) {
            this.paintButtonPressed(graphics, abstractButton);
        }
        if (abstractButton.getIcon() != null) {
            this.paintIcon(graphics, jComponent, iconRect);
        }
        if (string != null && !string.equals("")) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                BasicHyperlinkUI.textRect.x += this.getTextShiftOffset();
                BasicHyperlinkUI.textRect.y += this.getTextShiftOffset();
                view.paint(graphics, textRect);
                BasicHyperlinkUI.textRect.x -= this.getTextShiftOffset();
                BasicHyperlinkUI.textRect.y -= this.getTextShiftOffset();
            } else {
                this.paintText(graphics, abstractButton, textRect, string);
            }
        }
        if (abstractButton.isFocusPainted() && abstractButton.hasFocus()) {
            this.paintFocus(graphics, abstractButton, viewRect, textRect, iconRect);
        }
    }

    protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        super.paintText(graphics, abstractButton, rectangle, string);
        if (abstractButton.getModel().isRollover()) {
            this.paintUnderline(graphics, abstractButton, rectangle, string);
        }
    }

    private void paintUnderline(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getDescent();
        graphics.drawLine(rectangle.x + this.getTextShiftOffset(), rectangle.y + rectangle.height - n + 1 + this.getTextShiftOffset(), rectangle.x + rectangle.width + this.getTextShiftOffset(), rectangle.y + rectangle.height - n + 1 + this.getTextShiftOffset());
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        if (abstractButton.getParent() instanceof JToolBar) {
            return;
        }
        int n = abstractButton.getWidth();
        int n2 = abstractButton.getHeight();
        graphics.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(graphics, this.dashedRectGapX, this.dashedRectGapY, n - this.dashedRectGapWidth, n2 - this.dashedRectGapHeight);
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
    }

    static class HandCursor
    extends MouseAdapter {
        HandCursor() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
        }

        public void mouseExited(MouseEvent mouseEvent) {
            mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
        }
    }
}

