/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JButton;
import org.jdesktop.swingx.plaf.JXHyperlinkAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class JXHyperlink
extends JButton {
    public static final String uiClassID = "HyperlinkUI";
    private boolean hasBeenVisited = false;
    private Color unclickedColor = new Color(0, 51, 255);
    private Color clickedColor = new Color(153, 0, 153);

    public JXHyperlink() {
    }

    public JXHyperlink(Action action) {
        super(action);
        this.init();
    }

    public Color getUnclickedColor() {
        return this.unclickedColor;
    }

    public void setClickedColor(Color color) {
        Color color2 = this.getClickedColor();
        this.clickedColor = color;
        if (this.isVisited()) {
            this.setForeground(this.getClickedColor());
        }
        this.firePropertyChange("clickedColor", color2, this.getClickedColor());
    }

    public Color getClickedColor() {
        return this.clickedColor;
    }

    public void setUnclickedColor(Color color) {
        Color color2 = this.getUnclickedColor();
        this.unclickedColor = color;
        if (!this.isVisited()) {
            this.setForeground(this.getUnclickedColor());
        }
        this.firePropertyChange("unclickedColor", color2, this.getUnclickedColor());
    }

    protected void setVisited(boolean bl) {
        boolean bl2 = this.isVisited();
        this.hasBeenVisited = bl;
        this.setForeground(this.isVisited() ? this.getClickedColor() : this.getUnclickedColor());
        this.firePropertyChange("visited", bl2, this.isVisited());
    }

    protected boolean isVisited() {
        return this.hasBeenVisited;
    }

    protected PropertyChangeListener createActionPropertyChangeListener(final Action action) {
        final PropertyChangeListener propertyChangeListener = super.createActionPropertyChangeListener(action);
        PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("visited".equals(propertyChangeEvent.getPropertyName())) {
                    JXHyperlink.this.setVisitedFromActionProperty(action);
                } else {
                    propertyChangeListener.propertyChange(propertyChangeEvent);
                }
            }
        };
        return propertyChangeListener2;
    }

    protected void configurePropertiesFromAction(Action action) {
        super.configurePropertiesFromAction(action);
        this.setVisitedFromActionProperty(action);
    }

    private void setVisitedFromActionProperty(Action action) {
        Boolean bl = (Boolean)action.getValue("visited");
        this.setVisited(bl != null ? bl : false);
    }

    private void init() {
        this.setForeground(this.isVisited() ? this.getClickedColor() : this.getUnclickedColor());
    }

    public String getUIClassID() {
        return uiClassID;
    }

    static {
        LookAndFeelAddons.contribute(new JXHyperlinkAddon());
    }
}

