/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import org.jdesktop.swingx.action.BoundAction;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class JXDialog
extends JDialog {
    public static final String EXECUTE_ACTION_COMMAND = "execute";
    public static final String CLOSE_ACTION_COMMAND = "close";
    public static final String UIPREFIX = "XDialog.";
    JComponent content;

    public JXDialog(Frame frame, JComponent jComponent) {
        super(frame);
        this.setContent(jComponent);
    }

    private void setContent(JComponent jComponent) {
        Action action;
        if (this.content != null) {
            throw new IllegalStateException("content must not be set more than once");
        }
        this.initActions();
        Action action2 = jComponent.getActionMap().get(CLOSE_ACTION_COMMAND);
        if (action2 != null) {
            this.putAction(CLOSE_ACTION_COMMAND, action2);
        }
        if ((action = jComponent.getActionMap().get(EXECUTE_ACTION_COMMAND)) != null) {
            this.putAction(EXECUTE_ACTION_COMMAND, action);
        }
        this.content = jComponent;
        this.build();
        this.setTitle(jComponent.getName());
    }

    private void build() {
        Box box = new Box(3);
        box.add(this.content);
        JComponent jComponent = this.createButtonPanel();
        box.add(jComponent);
        box.setBorder(BorderFactory.createEmptyBorder(14, 14, 14, 14));
        this.add(box);
    }

    public void setVisible(boolean bl) {
        if (this.content == null) {
            throw new IllegalStateException("content must be built before showing the dialog");
        }
        super.setVisible(bl);
    }

    public void doClose() {
        this.dispose();
    }

    private void initActions() {
        Action action = this.createCloseAction();
        this.putAction(CLOSE_ACTION_COMMAND, action);
        this.putAction(EXECUTE_ACTION_COMMAND, action);
    }

    private Action createCloseAction() {
        String string = this.getUIString(CLOSE_ACTION_COMMAND);
        BoundAction boundAction = new BoundAction(string, CLOSE_ACTION_COMMAND);
        boundAction.registerCallback(this, "doClose");
        return boundAction;
    }

    protected JComponent createButtonPanel() {
        JPanel jPanel = new JPanel(new BasicOptionPaneUI.ButtonAreaLayout(true, 6)){

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        jPanel.setBorder(BorderFactory.createEmptyBorder(9, 0, 0, 0));
        Action action = this.getAction(EXECUTE_ACTION_COMMAND);
        Action action2 = this.getAction(CLOSE_ACTION_COMMAND);
        JButton jButton = new JButton(action);
        jPanel.add(jButton);
        jPanel.add(new JButton(action2));
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0, false);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(27, 0, false);
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(keyStroke, EXECUTE_ACTION_COMMAND);
        inputMap.put(keyStroke2, CLOSE_ACTION_COMMAND);
        this.getRootPane().setDefaultButton(jButton);
        return jPanel;
    }

    private void putAction(Object object, Action action) {
        this.getRootPane().getActionMap().put(object, action);
    }

    private Action getAction(Object object) {
        return this.getRootPane().getActionMap().get(object);
    }

    private String getUIString(String string) {
        String string2 = UIManager.getString(UIPREFIX + string);
        return string2 != null ? string2 : string;
    }

    static {
        LookAndFeelAddons.getAddon();
    }
}

