/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils.menu;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.geom.Area;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.text.View;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceMenu;
import org.jvnet.substance.SubstanceMenuBackgroundDelegate;
import org.jvnet.substance.painter.text.SubstanceTextPainter;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class MenuUtilities {
    private static SubstanceMenuBackgroundDelegate backgroundDelegate = new SubstanceMenuBackgroundDelegate(0.4f);
    public static final String LAYOUT_METRICS = "substancelaf.internal.menus.layoutMetrics";
    public static final String GUTTER_X = "substancelaf.internal.menus.gutterX";

    public static MenuLayoutInfo getMenuLayoutInfo(JMenuItem menuItem, Font acceleratorFont, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        Insets i = menuItem.getInsets();
        Rectangle iconRect = new Rectangle(0, 0, 0, 0);
        Rectangle textRect = new Rectangle(0, 0, 0, 0);
        Rectangle acceleratorRect = new Rectangle(0, 0, 0, 0);
        Rectangle checkIconRect = new Rectangle(0, 0, 0, 0);
        Rectangle arrowIconRect = new Rectangle(0, 0, 0, 0);
        Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        if (menuWidth > 0 && menuHeight > 0) {
            viewRect.setBounds(0, 0, menuWidth, menuHeight);
        }
        viewRect.x += i.left;
        viewRect.y += i.top;
        viewRect.width -= i.right + viewRect.x;
        viewRect.height -= i.bottom + viewRect.y;
        FontMetrics fm = menuItem.getFontMetrics(menuItem.getFont());
        FontMetrics fmAccel = menuItem.getFontMetrics(acceleratorFont);
        KeyStroke accelerator = menuItem.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + UIManager.getString("MenuItem.acceleratorDelimiter");
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        }
        String text = MenuUtilities.layoutMenuItem(menuItem, fm, menuItem.getText(), fmAccel, acceleratorText, menuItem.getIcon(), checkIcon, arrowIcon, menuItem.getVerticalAlignment(), menuItem.getHorizontalAlignment(), menuItem.getVerticalTextPosition(), menuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, menuItem.getText() == null ? 0 : defaultTextIconGap, defaultTextIconGap);
        MenuLayoutInfo mlInfo = new MenuLayoutInfo();
        mlInfo.checkIconRect = checkIconRect;
        mlInfo.iconRect = iconRect;
        mlInfo.textRect = textRect;
        mlInfo.viewRect = viewRect;
        mlInfo.acceleratorRect = acceleratorRect;
        mlInfo.arrowIconRect = arrowIconRect;
        mlInfo.text = text;
        return mlInfo;
    }

    private static String layoutMenuItem(JMenuItem menuItem, FontMetrics fm, String text, FontMetrics fmAccel, String acceleratorText, Icon icon, Icon checkIcon, Icon arrowIcon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewRect, Rectangle iconRect, Rectangle textRect, Rectangle acceleratorRect, Rectangle checkIconRect, Rectangle arrowIconRect, int textIconGap, int menuItemGap) {
        SwingUtilities.layoutCompoundLabel(menuItem, fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewRect, iconRect, textRect, textIconGap);
        if (acceleratorText == null || acceleratorText.equals("")) {
            acceleratorRect.height = 0;
            acceleratorRect.width = 0;
            acceleratorText = "";
        } else {
            acceleratorRect.width = fmAccel.stringWidth(acceleratorText);
            acceleratorRect.height = fmAccel.getHeight();
        }
        if (MenuUtilities.useCheckAndArrow(menuItem)) {
            if (checkIcon != null) {
                checkIconRect.width = checkIcon.getIconWidth();
                checkIconRect.height = checkIcon.getIconHeight();
            } else {
                checkIconRect.height = 0;
                checkIconRect.width = 0;
            }
            if (arrowIcon != null) {
                arrowIconRect.width = arrowIcon.getIconWidth();
                arrowIconRect.height = arrowIcon.getIconHeight();
            } else {
                arrowIconRect.height = 0;
                arrowIconRect.width = 0;
            }
        }
        Rectangle labelRect = iconRect.union(textRect);
        if (menuItem.getComponentOrientation().isLeftToRight()) {
            textRect.x += menuItemGap;
            iconRect.x += menuItemGap;
            acceleratorRect.x = viewRect.x + viewRect.width - arrowIconRect.width - menuItemGap - acceleratorRect.width;
            if (MenuUtilities.useCheckAndArrow(menuItem)) {
                checkIconRect.x = viewRect.x + menuItemGap;
                textRect.x += menuItemGap + checkIconRect.width;
                iconRect.x += menuItemGap + checkIconRect.width;
                arrowIconRect.x = viewRect.x + viewRect.width - menuItemGap - arrowIconRect.width;
            }
        } else {
            textRect.x -= menuItemGap;
            iconRect.x -= menuItemGap;
            acceleratorRect.x = viewRect.x + arrowIconRect.width + menuItemGap;
            if (MenuUtilities.useCheckAndArrow(menuItem)) {
                checkIconRect.x = viewRect.x + viewRect.width - menuItemGap - checkIconRect.width;
                textRect.x -= menuItemGap + checkIconRect.width;
                iconRect.x -= menuItemGap + checkIconRect.width;
                arrowIconRect.x = viewRect.x + menuItemGap;
            }
        }
        acceleratorRect.y = labelRect.y + labelRect.height / 2 - acceleratorRect.height / 2;
        if (MenuUtilities.useCheckAndArrow(menuItem)) {
            arrowIconRect.y = labelRect.y + labelRect.height / 2 - arrowIconRect.height / 2;
            checkIconRect.y = labelRect.y + labelRect.height / 2 - checkIconRect.height / 2;
        }
        return text;
    }

    private static boolean useCheckAndArrow(JMenuItem menuItem) {
        boolean b = true;
        if (menuItem instanceof JMenu && ((JMenu)menuItem).isTopLevelMenu()) {
            b = false;
        }
        return b;
    }

    private static JComponent getMenuItemParent(JMenuItem mi) {
        Container parent = mi.getParent();
        if (!(!(parent instanceof JComponent) || mi instanceof JMenu && ((JMenu)mi).isTopLevelMenu())) {
            return (JComponent)parent;
        }
        return null;
    }

    public static void paintMenuItem(Graphics g, JMenuItem menuItem, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        Container parent;
        Component[] popups;
        JRootPane rootPane;
        Graphics2D g2d = (Graphics2D)g.create();
        if (Boolean.TRUE.equals(menuItem.getClientProperty("substancelaf.internal.paint.isCoveredByLightweightPopups")) && (rootPane = SwingUtilities.getRootPane(menuItem)) != null && (popups = rootPane.getLayeredPane().getComponentsInLayer(JLayeredPane.POPUP_LAYER)) != null) {
            int popupIndexToStartWith = SubstanceCoreUtilities.getPopupParentIndexOf(menuItem, popups) - 1;
            Area clip = new Area(g2d.getClip());
            for (int i = popupIndexToStartWith; i >= 0; --i) {
                Component popup = popups[i];
                Rectangle popupArea = SwingUtilities.convertRectangle(rootPane.getLayeredPane(), popup.getBounds(), menuItem);
                clip.subtract(new Area(popupArea));
            }
            g2d.setClip(clip);
        }
        ButtonModel model = menuItem.getModel();
        SubstanceMenu menuUi = (SubstanceMenu)((Object)menuItem.getUI());
        Font f = menuItem.getFont();
        g2d.setFont(f);
        KeyStroke accelerator = menuItem.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + UIManager.getString("MenuItem.acceleratorDelimiter");
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        }
        Icon icon = menuItem.getIcon();
        MenuLayoutInfo mli = MenuUtilities.getMenuLayoutInfo(menuItem, menuUi.getAcceleratorFont(), menuUi.getCheckIcon(), menuUi.getArrowIcon(), menuUi.getDefaultTextIconGap());
        MenuLayoutMetrics popupMetrics = MenuUtilities.getPopupLayoutMetrics(menuItem);
        Insets i = menuItem.getInsets();
        if (popupMetrics != null) {
            int currX;
            SubstanceConstants.MenuGutterFillKind gutterFillKind = SubstanceCoreUtilities.getMenuGutterFillKind();
            boolean needExtraIconTextGap = gutterFillKind != null && gutterFillKind != SubstanceConstants.MenuGutterFillKind.NONE;
            int gap = popupMetrics.maxGap;
            if (menuItem.getComponentOrientation().isLeftToRight()) {
                int bump;
                currX = i.left + gap / 2;
                if (checkIcon != null) {
                    mli.checkIconRect = new Rectangle(currX, i.top, checkIcon.getIconWidth(), checkIcon.getIconHeight());
                    bump = (popupMetrics.maxCheckIconWidth - checkIcon.getIconWidth()) / 2;
                    mli.checkIconRect.x += bump;
                }
                if (popupMetrics.maxCheckIconWidth > 0) {
                    currX += popupMetrics.maxCheckIconWidth + gap;
                }
                if (icon != null) {
                    mli.iconRect = new Rectangle(currX, i.top, icon.getIconWidth(), icon.getIconHeight());
                    bump = (popupMetrics.maxIconWidth - icon.getIconWidth()) / 2;
                    mli.iconRect.x += bump;
                }
                if (popupMetrics.maxIconWidth > 0) {
                    currX += popupMetrics.maxIconWidth + gap;
                }
                menuItem.putClientProperty(GUTTER_X, currX + gap / 2);
                if (needExtraIconTextGap) {
                    currX += gap;
                }
                if (menuItem.getText() != null) {
                    mli.textRect = new Rectangle(currX, mli.textRect.y, popupMetrics.maxTextWidth, mli.textRect.height);
                    mli.text = menuItem.getText();
                }
                currX += popupMetrics.maxTextWidth + gap;
                if (popupMetrics.maxAcceleratorWidth > 0) {
                    mli.acceleratorRect = new Rectangle((currX += 5 * gap) + popupMetrics.maxAcceleratorWidth - mli.acceleratorRect.width, mli.textRect.y, mli.acceleratorRect.width, mli.textRect.height);
                }
                if (popupMetrics.maxAcceleratorWidth > 0) {
                    currX += popupMetrics.maxAcceleratorWidth + gap;
                }
                if (arrowIcon != null) {
                    mli.arrowIconRect = new Rectangle(currX, i.top, popupMetrics.maxArrowIconWidth, arrowIcon.getIconHeight());
                }
                Rectangle labelRect = new Rectangle(0, 0, menuItem.getWidth(), menuItem.getHeight());
                if (mli.textRect != null) {
                    labelRect = mli.textRect;
                }
                if (mli.iconRect != null) {
                    mli.iconRect.y = labelRect.y + labelRect.height / 2 - mli.iconRect.height / 2;
                }
                if (mli.arrowIconRect != null) {
                    mli.arrowIconRect.y = labelRect.y + labelRect.height / 2 - mli.arrowIconRect.height / 2;
                }
                if (mli.checkIconRect != null) {
                    mli.checkIconRect.y = labelRect.y + labelRect.height / 2 - mli.checkIconRect.height / 2;
                }
            } else {
                int bump;
                currX = menuItem.getWidth() - i.right - gap / 2;
                if (checkIcon != null) {
                    mli.checkIconRect = new Rectangle(currX - popupMetrics.maxCheckIconWidth, i.top, checkIcon.getIconWidth(), checkIcon.getIconHeight());
                    bump = (popupMetrics.maxCheckIconWidth - checkIcon.getIconWidth()) / 2;
                    mli.checkIconRect.x += bump;
                }
                if (popupMetrics.maxCheckIconWidth > 0) {
                    currX -= popupMetrics.maxCheckIconWidth + gap;
                }
                if (icon != null) {
                    mli.iconRect = new Rectangle(currX - popupMetrics.maxIconWidth, i.top, icon.getIconWidth(), icon.getIconHeight());
                    bump = (popupMetrics.maxIconWidth - icon.getIconWidth()) / 2;
                    mli.iconRect.x += bump;
                }
                if (popupMetrics.maxIconWidth > 0) {
                    currX -= popupMetrics.maxIconWidth + gap;
                }
                menuItem.putClientProperty(GUTTER_X, currX + gap / 2);
                if (needExtraIconTextGap) {
                    currX -= gap;
                }
                if (menuItem.getText() != null) {
                    mli.textRect = new Rectangle(currX - mli.textRect.width, mli.textRect.y, popupMetrics.maxTextWidth, mli.textRect.height);
                    mli.text = menuItem.getText();
                }
                currX -= popupMetrics.maxTextWidth + gap;
                if (popupMetrics.maxAcceleratorWidth > 0) {
                    mli.acceleratorRect = new Rectangle((currX -= 5 * gap) - popupMetrics.maxAcceleratorWidth, mli.textRect.y, mli.acceleratorRect.width, mli.textRect.height);
                }
                if (popupMetrics.maxAcceleratorWidth > 0) {
                    currX -= popupMetrics.maxAcceleratorWidth + gap;
                }
                if (arrowIcon != null) {
                    mli.arrowIconRect = new Rectangle(currX - popupMetrics.maxArrowIconWidth, i.top, popupMetrics.maxArrowIconWidth, arrowIcon.getIconHeight());
                }
                Rectangle labelRect = new Rectangle(0, 0, menuItem.getWidth(), menuItem.getHeight());
                if (mli.textRect != null) {
                    labelRect = mli.textRect;
                }
                if (mli.iconRect != null) {
                    mli.iconRect.y = labelRect.y + labelRect.height / 2 - mli.iconRect.height / 2;
                }
                if (mli.arrowIconRect != null) {
                    mli.arrowIconRect.y = labelRect.y + labelRect.height / 2 - mli.arrowIconRect.height / 2;
                }
                if (mli.checkIconRect != null) {
                    mli.checkIconRect.y = labelRect.y + labelRect.height / 2 - mli.checkIconRect.height / 2;
                }
            }
        }
        if ((parent = menuItem.getParent()) instanceof JPopupMenu) {
            ((JPopupMenu)parent).putClientProperty(GUTTER_X, menuItem.getClientProperty(GUTTER_X));
        }
        SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
        textPainter.init(menuItem, null, true);
        if (textPainter.needsBackgroundImage()) {
            MenuUtilities.paintBackground(g2d, menuItem);
        }
        textPainter.renderSurface(g2d);
        textPainter.init(menuItem, null, true);
        MenuUtilities.paintBackground(g2d, menuItem);
        MenuUtilities.paintHighlights(g2d, menuItem);
        float textAlpha = 1.0f;
        if (mli.text != null) {
            View v = (View)menuItem.getClientProperty("html");
            if (v != null) {
                v.paint(g2d, mli.textRect);
            } else {
                textAlpha = SubstanceCoreUtilities.paintText(menuItem, mli.textRect, mli.text, menuItem.getDisplayedMnemonicIndex());
            }
        }
        if (acceleratorText != null && !acceleratorText.equals("")) {
            SubstanceCoreUtilities.paintText(menuItem, mli.acceleratorRect, acceleratorText, -1);
        }
        Graphics2D graphics = (Graphics2D)g2d.create();
        graphics.setComposite(TransitionLayout.getAlphaComposite(menuItem, textAlpha, g2d));
        textPainter.renderSurface(graphics);
        graphics.dispose();
        if (checkIcon != null && MenuUtilities.useCheckAndArrow(menuItem)) {
            checkIcon.paintIcon(menuItem, g2d, mli.checkIconRect.x, mli.checkIconRect.y);
        }
        if (icon != null) {
            if (!model.isEnabled()) {
                icon = menuItem.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                icon = menuItem.getPressedIcon();
                if (icon == null) {
                    icon = menuItem.getIcon();
                }
            } else {
                icon = menuItem.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(menuItem, g2d, mli.iconRect.x, mli.iconRect.y);
            }
        }
        if (arrowIcon != null && MenuUtilities.useCheckAndArrow(menuItem)) {
            arrowIcon.paintIcon(menuItem, g2d, mli.arrowIconRect.x, mli.arrowIconRect.y);
        }
        g2d.dispose();
    }

    protected static void paintBackground(Graphics g, final JMenuItem menuItem) {
        int textOffset = MenuUtilities.getTextOffset(menuItem, menuItem.getParent());
        SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
        final Color bgColor = SubstanceCoreUtilities.getBackgroundFillColor(menuItem);
        final int finalTextOffset = textOffset;
        SubstanceTextPainter.BackgroundPaintingCallback callback = new SubstanceTextPainter.BackgroundPaintingCallback(){

            public void paintBackground(Graphics g) {
                Graphics2D g2d = (Graphics2D)g.create();
                backgroundDelegate.paintBackground(g, menuItem, bgColor, 0.5f, finalTextOffset);
                g2d.dispose();
            }
        };
        if (textPainter.needsBackgroundImage()) {
            textPainter.setBackgroundFill(menuItem, bgColor, true, 0, 0);
            textPainter.attachCallback(callback);
        } else {
            callback.paintBackground(g);
        }
    }

    protected static void paintHighlights(Graphics g, final JMenuItem menuItem) {
        SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
        SubstanceTextPainter.BackgroundPaintingCallback callback = new SubstanceTextPainter.BackgroundPaintingCallback(){

            public void paintBackground(Graphics g) {
                Graphics2D g2d = (Graphics2D)g.create();
                SubstanceMenuBackgroundDelegate.paintHighlights(g, menuItem, 0.5f);
                g2d.dispose();
            }
        };
        if (textPainter.needsBackgroundImage()) {
            textPainter.attachCallback(callback);
        } else {
            callback.paintBackground(g);
        }
    }

    protected static MenuLayoutMetrics getMetrics(JPopupMenu popupMenu) {
        MenuLayoutMetrics metrics = new MenuLayoutMetrics();
        for (int i = 0; i < popupMenu.getComponentCount(); ++i) {
            JMenuItem childMenuItem;
            ButtonUI bui;
            Component comp = popupMenu.getComponent(i);
            if (!(comp instanceof JMenuItem) || !((bui = (childMenuItem = (JMenuItem)comp).getUI()) instanceof SubstanceMenu)) continue;
            SubstanceMenu ui = (SubstanceMenu)((Object)bui);
            MenuLayoutInfo mli = MenuUtilities.getMenuLayoutInfo(childMenuItem, ui.getAcceleratorFont(), ui.getCheckIcon(), ui.getArrowIcon(), ui.getDefaultTextIconGap());
            metrics.maxIconWidth = Math.max(metrics.maxIconWidth, mli.iconRect.width);
            metrics.maxCheckIconWidth = Math.max(metrics.maxCheckIconWidth, mli.checkIconRect.width);
            metrics.maxTextWidth = Math.max(metrics.maxTextWidth, mli.textRect.width);
            metrics.maxAcceleratorWidth = Math.max(metrics.maxAcceleratorWidth, mli.acceleratorRect.width);
            metrics.maxArrowIconWidth = Math.max(metrics.maxArrowIconWidth, mli.arrowIconRect.width);
            metrics.maxGap = Math.max(metrics.maxGap, ui.getDefaultTextIconGap());
        }
        return metrics;
    }

    public static MenuLayoutMetrics getPopupLayoutMetrics(JMenuItem menuItem) {
        ButtonUI bui;
        Container comp = menuItem.getParent();
        if (comp instanceof JPopupMenu) {
            JPopupMenu popupMenu = (JPopupMenu)comp;
            Object prop = popupMenu.getClientProperty(LAYOUT_METRICS);
            if (prop instanceof MenuLayoutMetrics) {
                return (MenuLayoutMetrics)prop;
            }
            MenuLayoutMetrics metrics = MenuUtilities.getMetrics(popupMenu);
            popupMenu.putClientProperty(LAYOUT_METRICS, metrics);
            return metrics;
        }
        if (!(comp instanceof JMenu) && (bui = menuItem.getUI()) instanceof SubstanceMenu) {
            SubstanceMenu ui = (SubstanceMenu)((Object)bui);
            MenuLayoutInfo mli = MenuUtilities.getMenuLayoutInfo(menuItem, ui.getAcceleratorFont(), ui.getCheckIcon(), ui.getArrowIcon(), ui.getDefaultTextIconGap());
            MenuLayoutMetrics metrics = new MenuLayoutMetrics();
            metrics.maxIconWidth = mli.iconRect.width;
            metrics.maxCheckIconWidth = mli.checkIconRect.width;
            metrics.maxTextWidth = mli.textRect.width;
            metrics.maxAcceleratorWidth = mli.acceleratorRect.width;
            metrics.maxArrowIconWidth = mli.arrowIconRect.width;
            metrics.maxGap = ui.getDefaultTextIconGap();
            return metrics;
        }
        return null;
    }

    public static void cleanPopupLayoutMetrics(JMenuItem menuItem) {
        Container comp = menuItem.getParent();
        if (comp instanceof JPopupMenu) {
            JPopupMenu popupMenu = (JPopupMenu)comp;
            MenuUtilities.cleanPopupLayoutMetrics(popupMenu);
        }
    }

    public static void cleanPopupLayoutMetrics(JPopupMenu popupMenu) {
        if (popupMenu != null) {
            popupMenu.putClientProperty(LAYOUT_METRICS, null);
        }
    }

    public static int getPreferredWidth(JMenuItem menuItem) {
        SubstanceConstants.MenuGutterFillKind gutterFillKind;
        boolean needExtraIconTextGap;
        Insets ins = menuItem.getInsets();
        MenuLayoutMetrics popupMetrics = MenuUtilities.getPopupLayoutMetrics(menuItem);
        int width = popupMetrics.maxCheckIconWidth + popupMetrics.maxIconWidth + popupMetrics.maxTextWidth + popupMetrics.maxAcceleratorWidth + popupMetrics.maxArrowIconWidth + ins.left + ins.right;
        int gapsToAdd = 0;
        if (popupMetrics.maxCheckIconWidth > 0) {
            ++gapsToAdd;
        }
        if (popupMetrics.maxIconWidth > 0) {
            ++gapsToAdd;
        }
        if (popupMetrics.maxAcceleratorWidth > 0) {
            ++gapsToAdd;
        }
        if (popupMetrics.maxArrowIconWidth > 0) {
            ++gapsToAdd;
        }
        int gap = popupMetrics.maxGap;
        width += (1 + gapsToAdd) * gap;
        if (popupMetrics.maxAcceleratorWidth > 0) {
            width += 5 * gap;
        }
        boolean bl = needExtraIconTextGap = (gutterFillKind = SubstanceCoreUtilities.getMenuGutterFillKind()) != null && gutterFillKind != SubstanceConstants.MenuGutterFillKind.NONE;
        if (needExtraIconTextGap) {
            width += gap;
        }
        return width;
    }

    public static int getTextOffset(JComponent menuItem, Component menuItemParent) {
        if (!(menuItemParent instanceof JPopupMenu)) {
            return 0;
        }
        Object itemProp = menuItem.getClientProperty(GUTTER_X);
        if (itemProp instanceof Integer) {
            return (Integer)itemProp;
        }
        JPopupMenu popupMenu = (JPopupMenu)menuItemParent;
        Object parentProp = popupMenu.getClientProperty(GUTTER_X);
        if (parentProp instanceof Integer) {
            return (Integer)parentProp;
        }
        return 0;
    }

    public static class MenuLayoutMetrics {
        public int maxIconWidth;
        public int maxCheckIconWidth;
        public int maxTextWidth;
        public int maxAcceleratorWidth;
        public int maxArrowIconWidth;
        public int maxGap;
    }

    public static class MenuLayoutInfo {
        public Rectangle viewRect;
        public Rectangle iconRect;
        public Rectangle checkIconRect;
        public Rectangle textRect;
        public Rectangle acceleratorRect;
        public Rectangle arrowIconRect;
        public String text;
    }

    public static class MenuPropertyListener
    implements PropertyChangeListener {
        protected JMenuItem menuItem;

        public MenuPropertyListener(JMenuItem menuItem) {
            this.menuItem = menuItem;
        }

        public void install() {
            this.menuItem.addPropertyChangeListener(this);
        }

        public void uninstall() {
            this.menuItem.removePropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getPropertyName().equals(MenuUtilities.LAYOUT_METRICS)) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MenuUtilities.cleanPopupLayoutMetrics(MenuPropertyListener.this.menuItem);
                    }
                });
            }
        }
    }
}

