/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils.icon;

import java.awt.Component;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.plaf.UIResource;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceThemeUtilities;

public class RadioButtonMenuItemIcon
implements Icon,
UIResource {
    private int size;
    private JMenuItem menuItem;
    private Map<String, Icon> iconMap;

    public RadioButtonMenuItemIcon(JMenuItem menuItem, int size) {
        this.menuItem = menuItem;
        this.size = size;
        this.iconMap = new HashMap<String, Icon>();
    }

    private synchronized Icon getIconToPaint() {
        String key;
        Icon result;
        if (this.menuItem == null) {
            return null;
        }
        ComponentState currState = ComponentState.getState(this.menuItem.getModel(), this.menuItem);
        ComponentState prevState = SubstanceCoreUtilities.getPrevSelComponentState(this.menuItem);
        float visibility = currState.isKindActive(FadeKind.SELECTION) ? 10.0f : 0.0f;
        SubstanceTheme theme = SubstanceThemeUtilities.getTheme(this.menuItem).getTheme(this.menuItem, currState, currState == ComponentState.SELECTED);
        SubstanceTheme theme2 = SubstanceThemeUtilities.getTheme(this.menuItem).getTheme(this.menuItem, prevState, prevState == ComponentState.SELECTED);
        float cyclePos = 0.0f;
        FadeState fadeState = SubstanceFadeUtilities.getFadeState((Component)this.menuItem, FadeKind.SELECTION, FadeKind.ROLLOVER, FadeKind.PRESS, FadeKind.ARM);
        if (fadeState != null) {
            cyclePos = fadeState.getFadePosition();
            if (fadeState.isFadingIn()) {
                cyclePos = 10.0f - cyclePos;
            }
            if (fadeState.fadeKind == FadeKind.SELECTION) {
                visibility = fadeState.getFadePosition();
            }
        }
        if ((result = this.iconMap.get(key = currState.name() + ":" + prevState.name() + ":" + theme.getDisplayName() + ":" + theme2.getDisplayName() + ":" + cyclePos + ":" + visibility)) != null) {
            return result;
        }
        result = new ImageIcon(SubstanceImageCreator.getRadioButton(this.menuItem, this.size, currState, 2, theme, theme2, cyclePos, visibility / 10.0f));
        this.iconMap.put(key, result);
        return result;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Icon iconToDraw = this.getIconToPaint();
        if (iconToDraw != null) {
            iconToDraw.paintIcon(c, g, x, y);
        }
    }

    public int getIconWidth() {
        return this.size + 2;
    }

    public int getIconHeight() {
        return this.size + 2;
    }
}

