/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.skin;

import java.awt.Color;
import org.jvnet.substance.border.ClassicInnerBorderPainter;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.color.AquaColorScheme;
import org.jvnet.substance.color.SaturatedColorScheme;
import org.jvnet.substance.color.ShiftColorScheme;
import org.jvnet.substance.painter.ClassicGradientPainter;
import org.jvnet.substance.painter.decoration.BrushedMetalDecorationPainter;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.highlight.ClassicHighlightPainter;
import org.jvnet.substance.skin.SubstanceAbstractSkin;
import org.jvnet.substance.theme.SubstanceComplexTheme;
import org.jvnet.substance.theme.SubstanceOrangeTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.watermark.SubstanceStripeWatermark;

public class OfficeBlue2007Skin
extends SubstanceAbstractSkin {
    public static final String NAME = "Office Blue 2007";

    public OfficeBlue2007Skin() {
        ShiftColorScheme shiftBlue = new ShiftColorScheme(new AquaColorScheme(), new Color(100, 150, 255), 0.3);
        SubstanceTheme activeTheme = new SubstanceOrangeTheme().saturate(0.4);
        SubstanceTheme defaultTheme = new SubstanceTheme(shiftBlue, "Aqua Blue", SubstanceTheme.ThemeKind.BRIGHT).saturate(-0.3);
        SaturatedColorScheme disabledScheme = new SaturatedColorScheme(new ShiftColorScheme(new AquaColorScheme(), new Color(100, 150, 255), 0.3), -0.1){
            Color foreColor;
            {
                this.foreColor = new Color(36, 95, 142);
            }

            public Color getForegroundColor() {
                return this.foreColor;
            }
        };
        SubstanceTheme disabledTheme = new SubstanceTheme(disabledScheme, "Disabled Office Blue 2007", SubstanceTheme.ThemeKind.COLD);
        SubstanceTheme activeTitleTheme = defaultTheme.saturate(-0.1);
        SubstanceComplexTheme theme = new SubstanceComplexTheme(NAME, SubstanceTheme.ThemeKind.BRIGHT, activeTheme, defaultTheme, disabledTheme, activeTitleTheme){

            public Color getLightBackgroundColor() {
                return this.disabledTheme.getColorScheme().getExtraLightColor();
            }
        };
        theme.setSelectedTabFadeStart(0.1);
        theme.setSelectedTabFadeEnd(0.3);
        theme.registerComponentStateTheme(disabledTheme, 0.5f, false, ComponentState.DISABLED_UNSELECTED);
        theme.registerComponentStateTheme(activeTheme, 0.5f, false, ComponentState.DISABLED_SELECTED);
        theme.registerDecorationAreaTheme(activeTitleTheme, false, DecorationAreaType.PRIMARY_TITLE_PANE, DecorationAreaType.SECONDARY_TITLE_PANE, DecorationAreaType.HEADER, DecorationAreaType.GENERAL, DecorationAreaType.TOOLBAR);
        this.theme = theme;
        this.buttonShaper = new ClassicButtonShaper();
        this.watermark = new SubstanceStripeWatermark();
        this.gradientPainter = new ClassicGradientPainter();
        BrushedMetalDecorationPainter decorationPainter = new BrushedMetalDecorationPainter();
        decorationPainter.setPaintingSeparators(true);
        decorationPainter.setTextureAlpha(0.3f);
        this.decorationPainter = decorationPainter;
        this.highlightPainter = new ClassicHighlightPainter();
        this.borderPainter = new ClassicInnerBorderPainter(0.8f, SubstanceConstants.ColorShiftKind.TINT);
    }

    public String getDisplayName() {
        return NAME;
    }
}

