/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.NumberFormat;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.TableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.substance.SubstanceBorder;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceTableUI;
import org.jvnet.substance.border.ClassicBorderPainter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceThemeUtilities;

public class SubstanceDefaultTableCellRenderer
extends DefaultTableCellRenderer {
    private boolean defaultOpacity;

    public SubstanceDefaultTableCellRenderer() {
        this(true);
    }

    @Deprecated
    public SubstanceDefaultTableCellRenderer(boolean defaultOpacity) {
        this.defaultOpacity = defaultOpacity;
        this.putClientProperty("substancelaf.borderPainter", new ClassicBorderPainter());
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (!(UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel)) {
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        TableUI tableUI = table.getUI();
        SubstanceTableUI ui = (SubstanceTableUI)tableUI;
        hasFocus = ui.isFocusedCell(row, column);
        SubstanceTableUI.TableCellId cellId = new SubstanceTableUI.TableCellId(row, column);
        Comparable<?> compId = ui.getId(row, column);
        ComponentState state = ui.getCellState(cellId);
        ComponentState prevState = ui.getPrevCellState(cellId);
        SubstanceTheme theme = SubstanceThemeUtilities.getTheme(table, state);
        Color color = SubstanceCoreUtilities.getInterpolatedForegroundColor(table, compId, theme, state, prevState, FadeKind.SELECTION, FadeKind.ROLLOVER);
        super.setForeground(color);
        SubstanceCoreUtilities.applyStripedBackground(table, row, this);
        this.setFont(table.getFont());
        SubstanceTableUI.TableCellId cellFocusId = new SubstanceTableUI.TableCellId(row, column);
        cellFocusId.setExactComparison(true);
        FadeState focusState = SubstanceFadeUtilities.getFadeState((Component)table, cellFocusId, FadeKind.FOCUS);
        Insets regInsets = SubstanceSizeUtils.getTableCellRendererInsets(SubstanceSizeUtils.getComponentFontSize(table));
        if (hasFocus || focusState != null) {
            SubstanceBorder border = new SubstanceBorder(regInsets);
            if (focusState != null) {
                border.setAlpha(focusState.getFadePosition() / 10.0f);
            }
            if (!table.getShowHorizontalLines() && !table.getShowVerticalLines()) {
                this.setBorder(new CompoundBorder(new EmptyBorder(table.getRowMargin() / 2, 0, table.getRowMargin() / 2, 0), border));
            } else {
                this.setBorder(border);
            }
        } else {
            this.setBorder(new EmptyBorder(regInsets.top, regInsets.left, regInsets.bottom, regInsets.right));
        }
        this.setValue(value);
        this.setOpaque(this.defaultOpacity && !SubstanceCoreUtilities.toBleedWatermark(table));
        this.setEnabled(table.isEnabled());
        return this;
    }

    public static class DateRenderer
    extends SubstanceDefaultTableCellRenderer {
        DateFormat formatter;

        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateInstance();
            }
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    public static class DoubleRenderer
    extends NumberRenderer {
        NumberFormat formatter;

        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = NumberFormat.getInstance();
            }
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    public static class NumberRenderer
    extends SubstanceDefaultTableCellRenderer {
        public NumberRenderer() {
            this.setHorizontalAlignment(4);
        }
    }

    public static class IconRenderer
    extends SubstanceDefaultTableCellRenderer {
        public IconRenderer() {
            this.setHorizontalAlignment(0);
        }

        public void setValue(Object value) {
            this.setIcon(value instanceof Icon ? (Icon)value : null);
            this.setText(null);
        }
    }

    public static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
            this.putClientProperty("substancelaf.borderPainter", new ClassicBorderPainter());
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setForeground(table.getForeground());
            }
            SubstanceCoreUtilities.applyStripedBackground(table, row, this);
            this.setSelected(value != null && (Boolean)value != false);
            this.setEnabled(table.isEnabled());
            TableUI tableUI = table.getUI();
            if (tableUI instanceof SubstanceTableUI) {
                SubstanceTableUI ui = (SubstanceTableUI)tableUI;
                hasFocus = ui.isFocusedCell(row, column);
                SubstanceTableUI.TableCellId cellFocusId = new SubstanceTableUI.TableCellId(row, column);
                cellFocusId.setExactComparison(true);
                FadeState focusState = SubstanceFadeUtilities.getFadeState((Component)table, cellFocusId, FadeKind.FOCUS);
                if (hasFocus || focusState != null) {
                    SubstanceBorder border = new SubstanceBorder();
                    if (focusState != null) {
                        border.setAlpha(focusState.getFadePosition() / 10.0f);
                    }
                    this.setBorder(border);
                } else {
                    this.setBorder(noFocusBorder);
                }
            } else if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            this.setOpaque(!SubstanceCoreUtilities.toBleedWatermark(table));
            return this;
        }
    }
}

