/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.coordinate;

import java.util.ArrayList;
import java.util.List;
import org.geotools.geometry.iso.coordinate.LineSegmentImpl;
import org.geotools.geometry.iso.coordinate.LineStringImpl;
import org.geotools.geometry.iso.coordinate.PositionImpl;
import org.geotools.geometry.iso.coordinate.TriangleImpl;
import org.geotools.geometry.iso.coordinate.TriangulatedSurfaceImpl;
import org.geotools.geometry.iso.primitive.SurfaceBoundaryImpl;
import org.opengis.geometry.primitive.SurfacePatch;

public class TinImpl
extends TriangulatedSurfaceImpl {
    private ArrayList<LineStringImpl> stopLines = null;
    private ArrayList<LineStringImpl> breakLines = null;
    private double maxLength = Double.NaN;
    private double minLength = Double.NaN;
    private ArrayList<PositionImpl> controlPoint = null;
    private ArrayList<LineSegmentImpl> front;

    public TinImpl(SurfaceBoundaryImpl surfBdry, ArrayList<PositionImpl> post, ArrayList<LineStringImpl> stopLines, ArrayList<LineStringImpl> breakLines, double maxLength, ArrayList<TriangleImpl> triangles) {
        super(surfBdry);
        this.controlPoint = post;
        this.breakLines = breakLines;
        this.stopLines = stopLines;
        this.maxLength = maxLength;
        super.setTriangles(triangles);
    }

    public TinImpl(PositionImpl[] post, LineStringImpl[] stopLines, LineStringImpl[] breakLines, double maxLength) {
        super((SurfaceBoundaryImpl)null);
        int i;
        this.controlPoint = new ArrayList();
        this.breakLines = new ArrayList();
        this.stopLines = new ArrayList();
        if (post.length >= 3) {
            for (i = 0; i < post.length; ++i) {
                this.controlPoint.add(post[i]);
            }
        } else {
            throw new IllegalArgumentException("At least three control points expected.");
        }
        for (i = 0; i < stopLines.length; ++i) {
            this.stopLines.add(stopLines[i]);
        }
        for (i = 0; i < breakLines.length; ++i) {
            this.breakLines.add(breakLines[i]);
        }
        this.maxLength = maxLength;
    }

    public List<LineStringImpl> getStopLines() {
        return this.stopLines;
    }

    public List<LineStringImpl> getBreakLines() {
        return this.breakLines;
    }

    public double getMaxLength() {
        return this.maxLength;
    }

    public List<TriangleImpl> getTriangles() {
        ArrayList<TriangleImpl> triangles = new ArrayList<TriangleImpl>();
        for (SurfacePatch surfacePatch : this.getPatches()) {
            triangles.add((TriangleImpl)surfacePatch);
        }
        return triangles;
    }

    public List<PositionImpl> getPosts() {
        return this.controlPoint;
    }
}

