/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.textfield;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class JTextFieldFilter
extends PlainDocument {
    private static final long serialVersionUID = 3256728389854181171L;
    public static final String LOWERCASE = "abcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df";
    public static final String UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc";
    public static final String ALPHA = "abcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00dfABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc";
    public static final String NUMERIC = "0123456789";
    public static final String FLOAT = "0123456789.";
    public static final String ALPHA_NUMERIC = "abcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00dfABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc0123456789";
    public static final String ALPHA_NUMERIC_SPACE = "abcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00dfABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc0123456789 ";
    public static final String SEARCH_ORTE = "abcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00dfABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc0123456789 /().-";
    public static final String UPPER_ALPHA_NUMERIC_SPACE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc0123456789 -";
    public static final String LOWER_ALPHA_NUMERIC_SPACE = "abcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df0123456789 -";
    public static final String NUMERIC_TELEFON = "0123456789 /-";
    public static final String ADDITION = " .,-():;_@+&";
    public static final String ADDITION_II = " .,-():;_@&";
    public static final String MAIL = " .,-_():!?\u00a7$%&=<>@\"\r\n";
    protected String acceptedChars = null;
    protected int maxLength = 0;
    protected boolean negativeAccepted = false;

    public JTextFieldFilter() {
        this(ALPHA_NUMERIC);
    }

    public JTextFieldFilter(String acceptedchars) {
        this.acceptedChars = acceptedchars;
    }

    public JTextFieldFilter(String acceptedchars, int value) {
        this.acceptedChars = acceptedchars;
        this.maxLength = value;
    }

    public void setNegativeAccepted(boolean negativeaccepted) {
        if (this.acceptedChars.equals(NUMERIC) || this.acceptedChars.equals(FLOAT) || this.acceptedChars.equals(ALPHA_NUMERIC) || this.acceptedChars.equals(ALPHA_NUMERIC_SPACE)) {
            this.negativeAccepted = negativeaccepted;
            this.acceptedChars = String.valueOf(this.acceptedChars) + "-";
        }
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (str == null) {
            return;
        }
        if (this.acceptedChars.indexOf(UPPERCASE) != -1 && this.acceptedChars.indexOf(LOWERCASE) == -1) {
            str = str.toUpperCase();
        } else if (this.acceptedChars.indexOf(LOWERCASE) != -1 && this.acceptedChars.indexOf(UPPERCASE) == -1) {
            str = str.toLowerCase();
        }
        int i = 0;
        while (i < str.length()) {
            if (this.acceptedChars.indexOf(String.valueOf(str.charAt(i))) == -1) {
                return;
            }
            ++i;
        }
        if ((this.acceptedChars.equals(FLOAT) || this.acceptedChars.equals("0123456789.-") && this.negativeAccepted) && str.indexOf(".") != -1 && this.getText(0, this.getLength()).indexOf(".") != -1) {
            return;
        }
        if (this.negativeAccepted && str.indexOf("-") != -1 && (this.acceptedChars.equals("0123456789.-") || this.acceptedChars.equals("0123456789-")) && (str.indexOf("-") != 0 || offset != 0)) {
            return;
        }
        if (this.maxLength > 0 && this.getLength() + str.length() > this.maxLength) {
            return;
        }
        super.insertString(offset, str, attr);
    }
}

