/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.printj2;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.StringTokenizer;
import prospektservice.PSAuftrag;
import prospektservice.PSEnvironment;
import prospektservice.printj2.PrintableObject;

public class PrintPaletteList
extends PrintableObject {
    private String pageData;
    private int numPages;

    public PrintPaletteList(String data) {
        this.pageData = data;
    }

    public void setNumPages(int pageCnt) {
        this.numPages = pageCnt;
    }

    @Override
    public int print(Graphics g, PageFormat pf, int actPage) throws PrinterException {
        int yOffSet = 19;
        int rowsPerPage = 39;
        boolean kgMode = false;
        g.translate(20, 20);
        g.setColor(Color.black);
        g.drawRect(20, 10, 500, 760);
        int startY = 10;
        int i = 0;
        while (i < rowsPerPage) {
            g.drawLine(20, startY += yOffSet, 520, startY);
            ++i;
        }
        String freitext = PSAuftrag.getActFreiTextPalette();
        if (freitext.length() > 0) {
            g.drawLine(20, 770 + yOffSet, 520, 770 + yOffSet);
            g.drawLine(20, 770, 20, 770 + yOffSet);
            g.drawLine(520, 770, 520, 770 + yOffSet);
        }
        g.drawLine(65, 10, 65, 770);
        g.drawLine(110, 10, 110, 770);
        g.drawLine(155, 10, 155, 770);
        g.drawLine(405, 10, 405, 770);
        g.drawLine(450, 10, 450, 770);
        StringTokenizer tMain = new StringTokenizer(this.pageData, "|");
        tMain.nextToken();
        kgMode = tMain.nextToken().equals("1");
        g.setFont(Arial8);
        g.drawString("PalZiel", 23, 23);
        g.drawString("PalNr", 68, 23);
        g.drawString("PLZ", 113, 23);
        g.drawString("ZSP", 158, 23);
        g.drawString(kgMode ? "Gewicht" : "Gebinde", 408, 23);
        g.drawString("Sendungen", 453, 23);
        g.setFont(Arial8n);
        int yPos = yOffSet + 23;
        while (tMain.hasMoreTokens()) {
            StringTokenizer tSub = new StringTokenizer(tMain.nextToken(), ";");
            g.drawString(tSub.nextToken(), 23, yPos);
            g.drawString(tSub.nextToken(), 68, yPos);
            g.drawString(tSub.nextToken(), 113, yPos);
            g.drawString(tSub.nextToken(), 158, yPos);
            String gebinde = tSub.nextToken();
            if (!kgMode) {
                g.drawString(gebinde, 408, yPos);
            }
            String sdg = tSub.nextToken();
            if (kgMode) {
                g.drawString(PSEnvironment.calcPalWeight(PSEnvironment.getIntValue(sdg)), 408, yPos);
            }
            g.drawString(sdg, 453, yPos);
            yPos += yOffSet;
        }
        if (freitext.length() > 0) {
            g.setFont(Arial7);
            freitext = this.cutText(freitext, g, 400);
            g.drawString("Freitext Palettenleitzettel: " + freitext, 25, 782);
        }
        g.setFont(Arial6);
        this.drawVersionAndCopyright(g, 22, 796);
        int pageCnt = this.numPages >= actPage ? this.numPages : actPage;
        g.drawString("\u00dcbersicht der Paletten Seite " + (actPage + 1) + " von " + pageCnt, 220, 796);
        this.drawImage(451, 791, 70, 15, "images/dpost256.bmp", g);
        g.dispose();
        return 0;
    }
}

