/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.printj2;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.StringTokenizer;
import org.krysalis.barcode4j.tools.UnitConv;
import prospektservice.PSAuftrag;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.PSUser;
import prospektservice.printj2.PrintAZ;

public class PrintLR
extends PrintAZ {
    private String pageData;
    private boolean isDruckOhneGrafik;
    private int numPages;

    public PrintLR(String data) {
        this.pageData = data;
    }

    @Override
    public void setPrintModus(int modus) {
        this.printModus = modus;
    }

    @Override
    public int print(Graphics g, PageFormat pf, int actPage) throws PrinterException {
        String tmpBez = " ";
        String tmpAnnahme = " ";
        g.translate(20, 20);
        bundleCnt = 4 * actPage;
        StringTokenizer t = new StringTokenizer(this.pageData, "|");
        int tmax = t.countTokens() - 2;
        if (t.hasMoreTokens()) {
            tmpAnnahme = t.nextToken();
        }
        if (t.hasMoreTokens()) {
            tmpBez = t.nextToken();
        }
        double tmpvalue = (double)tmax / 4.0;
        this.numPages = (tmpvalue -= (double)((int)tmpvalue)) > 0.0 ? tmax / 4 + 1 : tmax / 4;
        if (this.numPages < 1) {
            this.numPages = 1;
            tmax = 4;
        }
        String tmpTokenizer = " ";
        if (t.hasMoreTokens()) {
            tmpTokenizer = t.nextToken();
        }
        if (tmax > 0) {
            this.Formular_L(g, 0, String.valueOf(tmpAnnahme) + "|" + tmpBez + "|" + tmpTokenizer, this.printModus);
        }
        --tmax;
        if (t.hasMoreTokens()) {
            tmpTokenizer = t.nextToken();
        }
        if (tmax > 0) {
            this.Formular_L(g, 1, String.valueOf(tmpAnnahme) + "|" + tmpBez + "|" + tmpTokenizer, this.printModus);
        }
        --tmax;
        if (t.hasMoreTokens()) {
            tmpTokenizer = t.nextToken();
        }
        if (tmax > 0) {
            this.Formular_L(g, 2, String.valueOf(tmpAnnahme) + "|" + tmpBez + "|" + tmpTokenizer, this.printModus);
        }
        --tmax;
        if (t.hasMoreTokens()) {
            tmpTokenizer = t.nextToken();
        }
        if (tmax > 0) {
            this.Formular_L(g, 3, String.valueOf(tmpAnnahme) + "|" + tmpBez + "|" + tmpTokenizer, this.printModus);
        }
        --tmax;
        g.setFont(Arial6);
        if (actPage >= 0 && this.printModus == 0) {
            String tmp = "- " + String.valueOf(actPage + 1) + " -";
            int w = this.getFontWidth(tmp, g);
            g.drawString(tmp, 265 - w / 2, 786);
        }
        g.dispose();
        return 0;
    }

    private void Formular_L(Graphics g, int position, String value, int PModus) {
        int OffSetY;
        int OffSetX;
        String einlieferer = "";
        String e_strasse = "";
        String absender = "";
        String a_strasse = "";
        String e_annahme = "";
        String e_bezeichnung = "";
        String[] Leitregion = new String[]{"", "", "", ""};
        String zustell_termin = "";
        if (PModus == 5 || PModus == 0) {
            if (PSAuftrag.cbformulare.cb_abs_einl) {
                einlieferer = PSAuftrag.absender.KDNR;
                e_strasse = "/" + PSAuftrag.absender.Name + ", " + PSAuftrag.absender.PLZ + " " + PSAuftrag.absender.Ort;
                absender = einlieferer;
                a_strasse = e_strasse;
            } else {
                einlieferer = PSAuftrag.einlieferer.KDNR;
                e_strasse = "/" + PSAuftrag.einlieferer.Name + ", " + PSAuftrag.einlieferer.PLZ + " " + PSAuftrag.einlieferer.Ort;
                absender = PSAuftrag.absender.KDNR;
                a_strasse = "/" + PSAuftrag.absender.Name + ", " + PSAuftrag.absender.PLZ + " " + PSAuftrag.absender.Ort;
            }
        }
        if (position == 0) {
            OffSetX = 0;
            OffSetY = 0;
        } else if (position == 1) {
            OffSetX = 275;
            OffSetY = 0;
        } else if (position == 2) {
            OffSetX = 0;
            OffSetY = 394;
        } else {
            OffSetX = 275;
            OffSetY = 394;
        }
        Color fill = new Color(210, 210, 210);
        StringTokenizer t = new StringTokenizer(value, "|");
        int tmax = t.countTokens();
        if (tmax >= 2) {
            if (t.hasMoreTokens()) {
                e_annahme = t.nextToken();
            }
            if (t.hasMoreTokens()) {
                e_bezeichnung = t.nextToken();
            }
        }
        if (position == 0 || position == 2) {
            this.drawCuttingHelpers(g, OffSetX, OffSetY, position);
        }
        Leitregion[0] = "";
        Leitregion[1] = "";
        Leitregion[2] = "";
        Leitregion[3] = "";
        if (PModus < 4) {
            if (position == 0) {
                Leitregion[0] = t.nextToken();
            }
            if (position == 1) {
                Leitregion[1] = t.nextToken();
            }
            if (position == 2) {
                Leitregion[2] = t.nextToken();
            }
            if (position == 3) {
                Leitregion[3] = t.nextToken();
            }
        }
        if (t.hasMoreTokens()) {
            zustell_termin = t.nextToken();
        }
        g.setColor(fill);
        if (!PrintLR.isFlgDruckOhneGrafik()) {
            g.fillRect(OffSetX + 5, OffSetY + 160, 250, 45);
        }
        this.drawAZDefaults(g, OffSetX, OffSetY);
        g.setColor(Color.black);
        g.setFont(Arial18);
        g.drawString("Postwurfsendungen", OffSetX + 5, OffSetY + 97);
        g.drawString("an alle Briefabholer", OffSetX + 5, OffSetY + 127);
        g.drawString("f\u00fcr die Leitregion", OffSetX + 5, OffSetY + 147);
        g.setFont(Arial8);
        g.drawString("Diese Verpackungseinheit enth\u00e4lt versandfertige Gebinde", OffSetX + 5, OffSetY + 110);
        g.setFont(Arial9);
        String tmp = einlieferer;
        g.drawString(tmp, OffSetX + 97, OffSetY + 30);
        g.setFont(Arial9);
        tmp = e_strasse;
        tmp = this.setRightFontSize(g, tmp, 102, 0);
        g.drawString(tmp, OffSetX + 150, OffSetY + 30);
        g.setFont(Arial9);
        tmp = absender;
        g.drawString(tmp, OffSetX + 97, OffSetY + 45);
        g.setFont(Arial9);
        tmp = a_strasse;
        tmp = this.setRightFontSize(g, tmp, 102, 0);
        g.drawString(tmp, OffSetX + 150, OffSetY + 45);
        g.setFont(Arial9);
        tmp = e_annahme;
        tmp = this.setRightFontSize(g, tmp, 175, 0);
        g.drawString(tmp, OffSetX + 97, OffSetY + 60);
        g.setFont(Arial9);
        tmp = e_bezeichnung;
        tmp = this.setRightFontSize(g, tmp, 175, 0);
        g.drawString(tmp, OffSetX + 97, OffSetY + 75);
        g.setFont(Arial48);
        tmp = Leitregion[position];
        int w = this.getFontWidth(tmp, g);
        g.drawString(tmp, OffSetX + 135 - w / 2, OffSetY + 200);
        if (PModus < 4) {
            this.barCodeGenerator.setPLZ(e_annahme);
            this.barCodeGenerator.setDate(zustell_termin);
            this.barCodeGenerator.setCustomerID(PSAuftrag.getCurrentJobID());
            this.barCodeGenerator.setIdSubmitter(String.valueOf(++bundleCnt));
            this.barCodeGenerator.setSubmitter(PSUser.getsubmitterEKP());
            BufferedImage img = this.barCodeGenerator.CreateAZBarcode(this.barCodeGenerator.getBarcodeMessage());
            this.printBarcode(g, img, zustell_termin, PSAuftrag.getAMNummer(), OffSetX, OffSetY - 10);
            if (PSO.mainpanel.AE.isUseAM()) {
                g.drawString("Gebinde-ID: " + PSEnvironment.Format(bundleCnt, "###,##0"), 145 + OffSetX, 332 + (int)UnitConv.mm2pt((double)15.0) + OffSetY + 20 - 10);
            }
        }
    }
}

