/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.dialog;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import prospektservice.Feedback;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.PSUser;
import prospektservice.base.PSJCheckBox;
import prospektservice.base.PSJRadioButton;
import prospektservice.base.PamDialog;
import prospektservice.textfield.JTextFieldFilter;

public class OptionenForm
extends PamDialog {
    private static final long serialVersionUID = 3545799879432811570L;
    private static final int WIDTH = 260;
    private static final int HEIGHT = PSUser.getLanguage() == Locale.GERMAN ? 360 : 380;
    private static final int HH_ZWISCHEN = 0;
    private static final int HH_AUFSTEIGEND = 1;
    private static final int HH_ABSTEIGEND = 2;
    private static ResourceBundle localProperty;
    private PSO pso;
    private boolean exitstatus = false;
    private boolean Auswahl_BL = false;
    private boolean Auswahl_TZ = false;
    private boolean Auswahl_HH = false;
    private boolean[] SelBL = new boolean[16];
    private String Value_BL = "";
    private String Value_TZ = "0";
    private String Value_HH = "";
    private PSJCheckBox[] chkBundesland = new PSJCheckBox[16];
    private PSJCheckBox[] chkTarifgebiet = new PSJCheckBox[3];
    private PSJRadioButton[] optGroesse = new PSJRadioButton[3];
    private ButtonGroup groupAuswahlOrtgrosse = new ButtonGroup();
    private ButtonGroup groupTarifgebiete = new ButtonGroup();
    private PSJRadioButton optVoll;
    private PSJRadioButton optAuswahl;
    private PSJCheckBox chkOrtgrosse;
    private PSJCheckBox chkTarifgebiete;
    private JTextField txtGrosser;
    private JTextField txtKleiner;
    private JButton cmdOK;
    private JButton cmdAbbruch;
    private JLabel lblHH;

    public OptionenForm(PSO mainpanel, JFrame mainform) {
        super(mainform, "", true);
        this.pso = mainpanel;
        this.setDefaultCloseOperation(1);
        localProperty = ResourceBundle.getBundle("properties.OptionenForm", PSUser.getLanguage());
        this.getContentPane().setLayout(new BorderLayout());
        this.setTitle(localProperty.getString("Title"));
        this.setSize(260, HEIGHT);
        this.setResizable(false);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d.width - 260) / 2, (d.height - HEIGHT) / 2);
        JPanel optionenpanel = new JPanel();
        optionenpanel.setBorder(new CompoundBorder(BorderFactory.createEtchedBorder(), new EmptyBorder(10, 10, 10, 10)));
        optionenpanel.setLayout(new FlowLayout(0, 1, 1));
        ItemListener BundeslandListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (OptionenForm.this.optVoll.isSelected()) {
                    int i = 0;
                    while (i < 16) {
                        OptionenForm.this.chkBundesland[i].setEnabled(false);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < 16) {
                        OptionenForm.this.chkBundesland[i].setEnabled(true);
                        ++i;
                    }
                }
            }
        };
        ItemListener TarifgebieteListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (OptionenForm.this.chkTarifgebiete.isSelected()) {
                    OptionenForm.this.chkTarifgebiet[0].setEnabled(true);
                    OptionenForm.this.chkTarifgebiet[1].setEnabled(true);
                    OptionenForm.this.chkTarifgebiet[2].setEnabled(true);
                } else {
                    OptionenForm.this.chkTarifgebiet[0].setEnabled(false);
                    OptionenForm.this.chkTarifgebiet[0].setSelected(false);
                    OptionenForm.this.chkTarifgebiet[1].setEnabled(false);
                    OptionenForm.this.chkTarifgebiet[1].setSelected(false);
                    OptionenForm.this.chkTarifgebiet[2].setEnabled(false);
                    OptionenForm.this.chkTarifgebiet[2].setSelected(false);
                }
            }
        };
        ItemListener OrtsgroessenListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OptionenForm.this.txtGrosser.setEnabled(OptionenForm.this.chkOrtgrosse.isSelected());
                OptionenForm.this.txtKleiner.setEnabled(OptionenForm.this.chkOrtgrosse.isSelected());
            }
        };
        ItemListener GroessenListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (OptionenForm.this.optGroesse[0].isSelected()) {
                    OptionenForm.this.txtGrosser.setEnabled(true);
                    OptionenForm.this.txtKleiner.setEnabled(true);
                } else {
                    OptionenForm.this.txtGrosser.setEnabled(false);
                    OptionenForm.this.txtKleiner.setEnabled(false);
                    OptionenForm.this.txtGrosser.setEnabled(false);
                    OptionenForm.this.txtKleiner.setEnabled(false);
                }
            }
        };
        ItemListener GroessenAuswahlListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int wert = 0;
                wert = PSEnvironment.getIntValue(((JRadioButton)e.getSource()).getActionCommand());
                switch (wert) {
                    case 0: {
                        OptionenForm.this.txtGrosser.setEnabled(true);
                        OptionenForm.this.txtKleiner.setEnabled(true);
                        break;
                    }
                    case 1: {
                        OptionenForm.this.txtGrosser.setEnabled(false);
                        OptionenForm.this.txtKleiner.setEnabled(false);
                        break;
                    }
                    case 2: {
                        OptionenForm.this.txtGrosser.setEnabled(false);
                        OptionenForm.this.txtKleiner.setEnabled(false);
                    }
                }
            }
        };
        this.optVoll = new PSJRadioButton(localProperty.getString("RadioButton1"));
        this.optVoll.setActionCommand("Voll");
        this.optVoll.addItemListener(BundeslandListener);
        optionenpanel.add(this.optVoll);
        this.optAuswahl = new PSJRadioButton(localProperty.getString("RadioButton2"));
        this.optAuswahl.setPreferredSize(new Dimension(200, 20));
        this.optAuswahl.setActionCommand("Auswahl");
        this.optAuswahl.addItemListener(BundeslandListener);
        optionenpanel.add(this.optAuswahl);
        ButtonGroup groupAuswahlBundeslander = new ButtonGroup();
        groupAuswahlBundeslander.add(this.optVoll);
        groupAuswahlBundeslander.add(this.optAuswahl);
        this.chkBundesland[0] = new PSJCheckBox("Baden-W\u00fcrttemberg");
        this.chkBundesland[0].putClientProperty("Bundesland", "8");
        this.chkBundesland[1] = new PSJCheckBox("Bayern");
        this.chkBundesland[1].putClientProperty("Bundesland", "9");
        this.chkBundesland[2] = new PSJCheckBox("Berlin");
        this.chkBundesland[2].putClientProperty("Bundesland", "11");
        this.chkBundesland[3] = new PSJCheckBox("Brandenburg");
        this.chkBundesland[3].putClientProperty("Bundesland", "12");
        this.chkBundesland[4] = new PSJCheckBox("Bremen");
        this.chkBundesland[4].putClientProperty("Bundesland", "4");
        this.chkBundesland[5] = new PSJCheckBox("Hamburg");
        this.chkBundesland[5].putClientProperty("Bundesland", "2");
        this.chkBundesland[6] = new PSJCheckBox("Hessen");
        this.chkBundesland[6].putClientProperty("Bundesland", "6");
        this.chkBundesland[7] = new PSJCheckBox("Mecklenburg-Vorpommern");
        this.chkBundesland[7].putClientProperty("Bundesland", "13");
        this.chkBundesland[8] = new PSJCheckBox("Niedersachsen");
        this.chkBundesland[8].putClientProperty("Bundesland", "3");
        this.chkBundesland[9] = new PSJCheckBox("Nordrhein-Westfalen");
        this.chkBundesland[9].putClientProperty("Bundesland", "5");
        this.chkBundesland[10] = new PSJCheckBox("Rheinland-Pfalz");
        this.chkBundesland[10].putClientProperty("Bundesland", "7");
        this.chkBundesland[11] = new PSJCheckBox("Saarland");
        this.chkBundesland[11].putClientProperty("Bundesland", "10");
        this.chkBundesland[12] = new PSJCheckBox("Sachsen");
        this.chkBundesland[12].putClientProperty("Bundesland", "14");
        this.chkBundesland[13] = new PSJCheckBox("Sachsen-Anhalt");
        this.chkBundesland[13].putClientProperty("Bundesland", "15");
        this.chkBundesland[14] = new PSJCheckBox("Schleswig-Holstein");
        this.chkBundesland[14].putClientProperty("Bundesland", "1");
        this.chkBundesland[15] = new PSJCheckBox("Th\u00fcringen");
        this.chkBundesland[15].putClientProperty("Bundesland", "16");
        JPanel AuswahlBL = new JPanel();
        AuswahlBL.setBorder(new EmptyBorder(0, 10, 0, 0));
        AuswahlBL.setLayout(new BoxLayout(AuswahlBL, 1));
        JScrollPane scrPane = new JScrollPane(AuswahlBL);
        scrPane.getVerticalScrollBar().setUnitIncrement(10);
        scrPane.setPreferredSize(new Dimension(220, 115));
        scrPane.setBorder(new CompoundBorder(new EmptyBorder(0, 20, 0, 0), scrPane.getBorder()));
        int i = 0;
        while (i < 16) {
            this.chkBundesland[i].setEnabled(false);
            AuswahlBL.add(this.chkBundesland[i]);
            ++i;
        }
        optionenpanel.add(scrPane);
        optionenpanel.add(Box.createRigidArea(new Dimension(200, 10)));
        this.chkOrtgrosse = new PSJCheckBox(localProperty.getString(PSO.Modus == 4 ? "CheckBox1_BFAH" : "CheckBox1"));
        this.chkOrtgrosse.setActionCommand("Ortgrosse");
        this.chkOrtgrosse.addItemListener(OrtsgroessenListener);
        optionenpanel.add(this.chkOrtgrosse);
        this.lblHH = new JLabel(PSO.Modus == 4 ? "" : localProperty.getString("Label1"));
        this.lblHH.setForeground(this.chkOrtgrosse.getForeground());
        optionenpanel.add(this.lblHH);
        JPanel bla = new JPanel();
        bla.setLayout(new FlowLayout(0));
        bla.setBorder(new EmptyBorder(0, 10, 0, 0));
        this.optGroesse[0] = new PSJRadioButton(">");
        this.optGroesse[0].setActionCommand("0");
        this.optGroesse[0].addItemListener(GroessenAuswahlListener);
        JLabel lbl = new JLabel(" >");
        lbl.setForeground(this.chkOrtgrosse.getForeground());
        bla.add(lbl);
        this.txtKleiner = new JTextField();
        this.txtKleiner.setDocument(new JTextFieldFilter("0123456789"));
        this.txtKleiner.setPreferredSize(new Dimension(70, 20));
        bla.add(this.txtKleiner);
        this.txtKleiner.setEnabled(false);
        lbl = new JLabel("<");
        lbl.setForeground(this.chkOrtgrosse.getForeground());
        bla.add(lbl);
        this.txtGrosser = new JTextField();
        this.txtGrosser.setDocument(new JTextFieldFilter("0123456789"));
        this.txtGrosser.setPreferredSize(new Dimension(70, 20));
        bla.add(this.txtGrosser);
        this.txtGrosser.setEnabled(false);
        this.optGroesse[1] = new PSJRadioButton(localProperty.getString("RadioButton3"));
        this.optGroesse[1].setActionCommand("1");
        this.optGroesse[1].setPreferredSize(new Dimension(210, 20));
        this.optGroesse[1].addItemListener(GroessenAuswahlListener);
        this.optGroesse[2] = new PSJRadioButton(localProperty.getString("RadioButton4"));
        this.optGroesse[2].setActionCommand("2");
        this.optGroesse[2].addItemListener(GroessenAuswahlListener);
        int j = 0;
        while (j < 3) {
            this.optGroesse[j].setEnabled(false);
            this.groupAuswahlOrtgrosse.add(this.optGroesse[j]);
            ++j;
        }
        optionenpanel.add(bla);
        this.chkTarifgebiete = new PSJCheckBox(localProperty.getString("CheckBox2"));
        this.chkTarifgebiete.setActionCommand("Tarifgebiete");
        this.chkTarifgebiete.addItemListener(TarifgebieteListener);
        optionenpanel.add(this.chkTarifgebiete);
        if (PSO.Modus == 4) {
            this.chkTarifgebiete.setEnabled(false);
            this.chkTarifgebiete.setSelected(false);
        }
        JPanel bla1 = new JPanel();
        bla1.setLayout(new FlowLayout(0));
        bla1.setBorder(new EmptyBorder(0, 10, 0, 0));
        this.chkTarifgebiet[0] = new PSJCheckBox("A");
        this.chkTarifgebiet[0].setActionCommand("1");
        bla1.add(this.chkTarifgebiet[0]);
        this.chkTarifgebiet[1] = new PSJCheckBox("B");
        this.chkTarifgebiet[1].setActionCommand("2");
        bla1.add(this.chkTarifgebiet[1]);
        this.chkTarifgebiet[2] = new PSJCheckBox("C");
        this.chkTarifgebiet[2].setActionCommand("3");
        optionenpanel.add(bla1);
        this.chkTarifgebiet[0].setEnabled(false);
        this.chkTarifgebiet[1].setEnabled(false);
        this.chkTarifgebiet[2].setEnabled(false);
        JPanel bla2 = new JPanel();
        bla2.setLayout(new FlowLayout(1));
        bla2.setPreferredSize(new Dimension(230, 40));
        this.cmdOK = new JButton(localProperty.getString("Button1"));
        bla2.add(this.cmdOK);
        this.cmdOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionenForm.this.exitstatus = true;
                if (OptionenForm.this.processSelection()) {
                    OptionenForm.this.setVisible(false);
                }
            }
        });
        this.cmdOK.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    OptionenForm.this.exitstatus = true;
                    if (OptionenForm.this.processSelection()) {
                        OptionenForm.this.setVisible(false);
                    }
                } else {
                    e.consume();
                }
            }
        });
        this.cmdAbbruch = new JButton(localProperty.getString("Button2"));
        bla2.add(this.cmdAbbruch);
        this.cmdAbbruch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionenForm.this.exitstatus = false;
                OptionenForm.this.setVisible(false);
            }
        });
        optionenpanel.add(bla2);
        this.getContentPane().add(optionenpanel);
        this.requestFocus();
        optionenpanel.requestFocus();
        this.optVoll.requestFocus();
        this.optVoll.setSelected(true);
    }

    public String getSelectedBundeslaender() {
        if (this.Auswahl_BL) {
            return this.Value_BL;
        }
        return " ";
    }

    public String getSelectedOrtsgroessen() {
        return this.Value_HH;
    }

    public String getSelectedTarifzonen() {
        return this.Value_TZ;
    }

    public boolean getExitStatus() {
        return this.exitstatus;
    }

    private boolean processSelection() {
        int i;
        boolean errorflag = true;
        if (this.optAuswahl.isSelected()) {
            i = 0;
            while (i < 16) {
                if (this.chkBundesland[i].isSelected()) {
                    errorflag = false;
                }
                ++i;
            }
            if (errorflag) {
                Feedback.showMessage(this.getParent(), 7);
                return false;
            }
        }
        if (this.chkOrtgrosse.isSelected() && this.txtKleiner.getText().length() > 0 && this.txtGrosser.getText().length() > 0 && PSEnvironment.getIntValue(this.txtKleiner.getText()) > PSEnvironment.getIntValue(this.txtGrosser.getText())) {
            Feedback.showMessage(this.getParent(), 10);
            return false;
        }
        if (this.chkTarifgebiete.isSelected()) {
            errorflag = true;
            i = 0;
            while (i < 3) {
                if (this.chkTarifgebiet[i].isSelected()) {
                    errorflag = false;
                }
                ++i;
            }
            if (errorflag) {
                Feedback.showMessage(this.getParent(), 8);
                return false;
            }
        }
        this.Value_BL = "";
        this.Auswahl_BL = this.optAuswahl.isSelected();
        if (this.Auswahl_BL) {
            i = 0;
            while (i < 16) {
                this.SelBL[i] = this.chkBundesland[i].isSelected();
                if (this.SelBL[i]) {
                    this.Value_BL = String.valueOf(this.Value_BL) + (String)this.chkBundesland[i].getClientProperty("Bundesland") + "|";
                }
                ++i;
            }
        }
        this.Value_HH = " ";
        this.Auswahl_HH = this.chkOrtgrosse.isSelected();
        if (this.Auswahl_HH) {
            if (this.txtKleiner.getText().length() == 0 && this.txtGrosser.getText().length() == 0) {
                Feedback.showMessage(this.getParent(), 10);
                return false;
            }
            if (this.txtKleiner.getText().length() == 0 && this.txtGrosser.getText().length() != 0) {
                this.Value_HH = "0|" + this.txtGrosser.getText() + "|0";
            } else if (this.txtGrosser.getText().length() == 0 && this.txtKleiner.getText().length() != 0) {
                this.Value_HH = "0|0|" + this.txtKleiner.getText();
            } else if (this.txtGrosser.getText().length() != 0 && this.txtKleiner.getText().length() != 0) {
                this.Value_HH = "0|" + this.txtGrosser.getText() + "|" + this.txtKleiner.getText();
            }
        }
        this.Value_TZ = "0";
        this.Auswahl_TZ = this.chkTarifgebiete.isSelected();
        if (this.Auswahl_TZ) {
            int selCount = 0;
            int adder = 0;
            int j = 0;
            while (j < this.chkTarifgebiet.length) {
                if (this.chkTarifgebiet[j].isSelected()) {
                    adder += PSEnvironment.getIntValue(this.chkTarifgebiet[j].getActionCommand());
                    ++selCount;
                }
                ++j;
            }
            if (selCount == 2) {
                ++adder;
            }
            if (selCount < 3) {
                this.Value_TZ = String.valueOf(adder);
            }
        }
        return true;
    }

    public void recoverSelection() {
        if (this.Auswahl_BL) {
            this.optAuswahl.setSelected(true);
            int i = 0;
            while (i < 16) {
                this.chkBundesland[i].setSelected(this.SelBL[i]);
                ++i;
            }
        } else {
            this.optVoll.setSelected(true);
        }
        if (this.Auswahl_HH) {
            StringTokenizer tmp1 = new StringTokenizer(this.Value_HH, "|");
            int auswahl = PSEnvironment.getIntValue(tmp1.nextToken());
            if (auswahl == 0) {
                String grosser = tmp1.nextToken();
                String kleiner = tmp1.nextToken();
                if (PSEnvironment.getIntValue(kleiner) > PSEnvironment.getIntValue(grosser) && grosser.equals("0")) {
                    this.txtGrosser.setText("");
                    this.txtKleiner.setText(kleiner);
                } else {
                    this.txtGrosser.setText(grosser);
                    this.txtKleiner.setText(kleiner);
                }
            }
            this.optGroesse[auswahl].setSelected(true);
        } else {
            this.chkOrtgrosse.setSelected(false);
        }
        if (this.Auswahl_TZ) {
            this.chkTarifgebiete.setSelected(true);
            if (this.Value_TZ.equals("1")) {
                this.chkTarifgebiet[0].setSelected(true);
            } else if (this.Value_TZ.equals("2")) {
                this.chkTarifgebiet[1].setSelected(true);
            } else {
                this.chkTarifgebiet[2].setSelected(true);
            }
        } else {
            this.chkTarifgebiete.setSelected(false);
        }
    }

    public void resetSelection(int Modus) {
        this.Auswahl_BL = false;
        this.Auswahl_TZ = false;
        this.Auswahl_HH = false;
        int i = 0;
        while (i < 16) {
            this.SelBL[i] = false;
            this.chkBundesland[i].setSelected(false);
            ++i;
        }
        this.Value_BL = "";
        this.Value_TZ = "0";
        this.Value_HH = "";
        PSO.cc.SendMessage(60, this.Value_TZ);
        PSO.cc.SendMessage(61, this.Value_HH);
        PSO.cc.SendMessage(62, this.Value_BL);
        this.chkOrtgrosse.setText(localProperty.getString(Modus == 4 ? "CheckBox1_BFAH" : "CheckBox1"));
        this.lblHH.setText(Modus == 4 ? "" : localProperty.getString("Label1"));
        this.chkTarifgebiete.setEnabled(Modus != 4);
        this.optGroesse[0].setSelected(true);
    }

    @Override
    public void setVisible(boolean flag) {
        if (flag && PSO.Modus == 4) {
            this.chkTarifgebiete.setEnabled(false);
            this.chkTarifgebiete.setSelected(false);
        }
        super.setVisible(flag);
    }
}

