/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import prospektservice.Feedback;
import prospektservice.PSAuftrag;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.PSUser;
import prospektservice.base.PSFileFilter;
import prospektservice.base.zbnimport.ZbnDataHandler;

public class DlgZBNImportStats
extends JDialog {
    private static final long serialVersionUID = 3258689888567441208L;
    private static final int WIDTH = 600;
    private static final int HEIGHT = 480;
    private PSO pso;
    private static ResourceBundle localProperty;
    private JPanel mainPanel;
    private JButton cmdOK;
    private JButton cmdExport;
    private JButton cmdExportLog;
    private JLabel lblLogFileInfo;
    private JLabel lblHouseHolds;
    private JTree importTree;
    private LogTreeNode failNode = null;
    private LogTreeNode successNode = null;
    private boolean entryID = false;
    private boolean showEntgelt = false;
    private boolean fileExportAllowed = false;
    private boolean isVectorStats = false;

    public DlgZBNImportStats(PSO mainpanel, final String logFile, boolean containsID) {
        super(mainpanel, "", false);
        this.pso = mainpanel;
        this.entryID = containsID;
        this.showEntgelt = ZbnDataHandler.getInstance(false).getSettings().isLogEntgelt();
        localProperty = ResourceBundle.getBundle("properties.dlgZBNImportStats", PSUser.getLanguage());
        this.setSize(600, 480);
        this.setTitle(localProperty.getString("Title"));
        this.setResizable(false);
        this.setLocationRelativeTo(this.pso);
        this.getContentPane().setLayout(new BorderLayout());
        this.mainPanel = new JPanel();
        this.mainPanel.setBorder(BorderFactory.createEtchedBorder());
        this.mainPanel.setLayout(new FlowLayout(1));
        this.mainPanel.setPreferredSize(new Dimension(588, 370));
        LogTreeNode top = new LogTreeNode(localProperty.getString("RootNode"));
        try {
            this.createTreeNodes(top, logFile);
        }
        catch (FileNotFoundException fnfEx) {
            fnfEx.printStackTrace();
        }
        this.importTree = new JTree(top);
        ToolTipManager.sharedInstance().registerComponent(this.importTree);
        Object[] nodePath = new Object[]{top, this.successNode};
        this.importTree.expandPath(new TreePath(nodePath));
        nodePath[1] = this.failNode;
        this.importTree.expandPath(new TreePath(nodePath));
        this.importTree.setCellRenderer(new MyNodeRenderer());
        this.importTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getNewLeadSelectionPath();
                if (path != null) {
                    String hhMode = "";
                    switch (((DlgZBNImportStats)DlgZBNImportStats.this).pso.AE.postwurfan) {
                        case 3: {
                            hhMode = localProperty.getString("HHAllSum");
                            break;
                        }
                        case 1: {
                            hhMode = localProperty.getString("HHTpSum");
                            break;
                        }
                        default: {
                            hhMode = localProperty.getString("HHSum");
                        }
                    }
                    LogTreeNode actNode = (LogTreeNode)path.getLastPathComponent();
                    DlgZBNImportStats.this.lblHouseHolds.setText(String.valueOf(hhMode) + actNode.getHHData());
                    DlgZBNImportStats.this.importTree.invalidate();
                }
            }
        });
        JScrollPane treeView = new JScrollPane();
        treeView.setPreferredSize(new Dimension(575, 355));
        treeView.getViewport().add(this.importTree);
        this.mainPanel.add((Component)treeView, "North");
        this.getContentPane().add((Component)this.mainPanel, "North");
        JPanel txtPanel = new JPanel();
        txtPanel.setLayout(new FlowLayout(0));
        txtPanel.setPreferredSize(new Dimension(588, 45));
        String hhTxt = "";
        switch (this.pso.AE.postwurfan) {
            case 0: {
                hhTxt = localProperty.getString("HHSum");
                break;
            }
            case 1: {
                hhTxt = localProperty.getString("HHTpSum");
                break;
            }
            case 3: {
                hhTxt = localProperty.getString("HHAllSum");
            }
        }
        this.lblHouseHolds = new JLabel(hhTxt);
        this.lblHouseHolds.setBorder(BorderFactory.createEtchedBorder());
        this.lblHouseHolds.setPreferredSize(new Dimension(580, 20));
        String logInfoMsg = String.valueOf(localProperty.getString("LogFileMsgPt1")) + " " + PSEnvironment.getPSPath() + "data" + System.getProperty("file.separator", "/") + PSUser.getUserID() + System.getProperty("file.separator", "/") + localProperty.getString("LogFileMsgPt2");
        this.lblLogFileInfo = new JLabel(logInfoMsg);
        txtPanel.add(this.lblHouseHolds);
        this.getContentPane().add((Component)txtPanel, "Center");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout(2));
        this.cmdOK = new JButton(localProperty.getString("cmdOK"));
        this.cmdOK.setMnemonic(this.cmdOK.getText().charAt(0));
        this.cmdOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgZBNImportStats.this.dispose();
            }
        });
        bottomPanel.add(this.cmdOK);
        this.cmdExportLog = new JButton(localProperty.getString("SaveLogfile"));
        this.cmdExportLog.setMnemonic(this.cmdExportLog.getText().charAt(0));
        this.cmdExportLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean loopDlg;
                String fileFormat = "txt";
                String fileName = "";
                JFileChooser chooser = new JFileChooser();
                chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
                PSFileFilter filter = new PSFileFilter(String.valueOf(fileFormat) + " Dateien" + "|" + fileFormat);
                chooser.addChoosableFileFilter(filter);
                chooser.setFileFilter(filter);
                File file = new File(PSEnvironment.getPSPath());
                chooser.setCurrentDirectory(file);
                do {
                    loopDlg = false;
                    if (chooser.showSaveDialog(PSO.mainpanel) == 0) {
                        int fb;
                        file = chooser.getSelectedFile();
                        fileName = file.getAbsolutePath();
                        if (!fileName.endsWith("." + fileFormat)) {
                            File tmp;
                            fileName = String.valueOf(fileName) + "." + fileFormat;
                            file = tmp = new File(fileName);
                        }
                        if (!file.exists() || (fb = Feedback.showQuestion((Component)PSO.mainpanel, 13)) != 1) continue;
                        loopDlg = true;
                        continue;
                    }
                    return;
                } while (loopDlg);
                try {
                    FileInputStream fisLog = new FileInputStream(String.valueOf(PSEnvironment.getPSPath()) + logFile);
                    FileChannel fcLog = fisLog.getChannel();
                    FileOutputStream fosNewLog = new FileOutputStream(fileName);
                    FileChannel fcNewLog = fosNewLog.getChannel();
                    fcLog.transferTo(0L, fisLog.available(), fcNewLog);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        bottomPanel.add(this.cmdExportLog);
        if (this.failNode.getChildCount() > 0) {
            this.cmdExport = new JButton(localProperty.getString("cmdExport"));
            this.cmdExport.setToolTipText(localProperty.getString("cmdExportTT"));
            this.cmdExport.setMnemonic(this.cmdExport.getText().charAt(0));
            this.cmdExport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgZBNImportStats.this.exportUnresolvedData();
                }
            });
            bottomPanel.add(this.cmdExport);
        }
        this.getContentPane().add((Component)bottomPanel, "South");
        this.setVisible(true);
    }

    public DlgZBNImportStats(PSO mainpanel, Vector zbezStats) {
        super(mainpanel, "", false);
        this.pso = mainpanel;
        this.isVectorStats = true;
        this.showEntgelt = ZbnDataHandler.getInstance(false).getSettings().isLogEntgelt();
        localProperty = ResourceBundle.getBundle("properties.dlgZBNImportStats", PSUser.getLanguage());
        this.setSize(600, 480);
        this.setTitle(localProperty.getString("Title"));
        this.setResizable(false);
        this.setLocationRelativeTo(this.pso);
        this.getContentPane().setLayout(new BorderLayout());
        this.mainPanel = new JPanel();
        this.mainPanel.setBorder(BorderFactory.createEtchedBorder());
        this.mainPanel.setLayout(new FlowLayout(1));
        this.mainPanel.setPreferredSize(new Dimension(588, 370));
        LogTreeNode top = new LogTreeNode(localProperty.getString("RootNode"));
        this.createVectorTreeNodes(top, zbezStats);
        this.importTree = new JTree(top);
        ToolTipManager.sharedInstance().registerComponent(this.importTree);
        Object[] nodePath = new Object[]{top, this.successNode};
        this.importTree.expandPath(new TreePath(nodePath));
        nodePath[1] = this.failNode;
        this.importTree.expandPath(new TreePath(nodePath));
        this.importTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getNewLeadSelectionPath();
                if (path != null) {
                    String hhMode = "";
                    switch (((DlgZBNImportStats)DlgZBNImportStats.this).pso.AE.postwurfan) {
                        case 3: {
                            hhMode = localProperty.getString("HHAllSum");
                            break;
                        }
                        case 1: {
                            hhMode = localProperty.getString("HHTpSum");
                            break;
                        }
                        default: {
                            hhMode = localProperty.getString("HHSum");
                        }
                    }
                    LogTreeNode actNode = (LogTreeNode)path.getLastPathComponent();
                    DlgZBNImportStats.this.lblHouseHolds.setText(String.valueOf(hhMode) + actNode.getHHData());
                    DlgZBNImportStats.this.importTree.invalidate();
                }
            }
        });
        JScrollPane treeView = new JScrollPane();
        treeView.setPreferredSize(new Dimension(575, 355));
        treeView.getViewport().add(this.importTree);
        this.mainPanel.add((Component)treeView, "North");
        this.getContentPane().add((Component)this.mainPanel, "North");
        JPanel txtPanel = new JPanel();
        txtPanel.setLayout(new FlowLayout(0));
        txtPanel.setPreferredSize(new Dimension(588, 45));
        String hhTxt = "";
        switch (this.pso.AE.postwurfan) {
            case 0: {
                hhTxt = localProperty.getString("HHSum");
                break;
            }
            case 1: {
                hhTxt = localProperty.getString("HHTpSum");
                break;
            }
            case 3: {
                hhTxt = localProperty.getString("HHAllSum");
            }
        }
        this.lblHouseHolds = new JLabel(hhTxt);
        this.lblHouseHolds.setBorder(BorderFactory.createEtchedBorder());
        this.lblHouseHolds.setPreferredSize(new Dimension(580, 20));
        String logInfoMsg = String.valueOf(localProperty.getString("LogFileMsgPt1")) + " " + PSEnvironment.getPSPath() + "data" + System.getProperty("file.separator", "/") + PSUser.getUserID() + System.getProperty("file.separator", "/") + localProperty.getString("LogFileMsgPt2");
        this.lblLogFileInfo = new JLabel(logInfoMsg);
        txtPanel.add(this.lblHouseHolds);
        this.getContentPane().add((Component)txtPanel, "Center");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout(2));
        this.cmdOK = new JButton(localProperty.getString("cmdOK"));
        this.cmdOK.setMnemonic(this.cmdOK.getText().charAt(0));
        this.cmdOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgZBNImportStats.this.dispose();
            }
        });
        bottomPanel.add(this.cmdOK);
        this.cmdExportLog = new JButton(localProperty.getString("SaveLogfile"));
        this.cmdExportLog.setMnemonic(this.cmdExportLog.getText().charAt(0));
        this.cmdExportLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean loopDlg;
                String fileFormat = "txt";
                String fileName = "";
                JFileChooser chooser = new JFileChooser();
                chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
                PSFileFilter filter = new PSFileFilter(String.valueOf(fileFormat) + " Dateien" + "|" + fileFormat);
                chooser.addChoosableFileFilter(filter);
                chooser.setFileFilter(filter);
                File file = new File(PSEnvironment.getPSPath());
                chooser.setCurrentDirectory(file);
                do {
                    loopDlg = false;
                    if (chooser.showSaveDialog(PSO.mainpanel) == 0) {
                        int fb;
                        file = chooser.getSelectedFile();
                        fileName = file.getAbsolutePath();
                        if (!fileName.endsWith("." + fileFormat)) {
                            File tmp;
                            fileName = String.valueOf(fileName) + "." + fileFormat;
                            file = tmp = new File(fileName);
                        }
                        if (!file.exists() || (fb = Feedback.showQuestion((Component)PSO.mainpanel, 13)) != 1) continue;
                        loopDlg = true;
                        continue;
                    }
                    return;
                } while (loopDlg);
                try {
                    String entry;
                    LogTreeNode node;
                    BufferedWriter bw = new BufferedWriter(new FileWriter(fileName));
                    String header = "Zustellbezirk;Erfolgreich Importiert;Haushalte";
                    if (DlgZBNImportStats.this.showEntgelt) {
                        header = String.valueOf(header) + ";Entgelt";
                    }
                    bw.write(String.valueOf(header) + "\r\n");
                    int i = 0;
                    while (i < DlgZBNImportStats.this.successNode.getChildCount()) {
                        node = (LogTreeNode)DlgZBNImportStats.this.successNode.getChildAt(i);
                        entry = node.getUserObject() + ";1" + ";" + node.hhData;
                        if (DlgZBNImportStats.this.showEntgelt) {
                            entry = String.valueOf(entry) + ";" + node.entgelt;
                        }
                        bw.write(String.valueOf(entry) + "\r\n");
                        ++i;
                    }
                    i = 0;
                    while (i < DlgZBNImportStats.this.failNode.getChildCount()) {
                        node = (LogTreeNode)DlgZBNImportStats.this.failNode.getChildAt(i);
                        entry = node.getUserObject() + ";0" + ";" + 0;
                        if (DlgZBNImportStats.this.showEntgelt) {
                            entry = String.valueOf(entry) + ";0,00";
                        }
                        bw.write(String.valueOf(entry) + "\r\n");
                        ++i;
                    }
                    bw.flush();
                    bw.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        bottomPanel.add(this.cmdExportLog);
        if (this.failNode.getChildCount() > 0) {
            this.cmdExport = new JButton(localProperty.getString("cmdExport"));
            this.cmdExport.setToolTipText(localProperty.getString("cmdExportTT"));
            this.cmdExport.setMnemonic(this.cmdExport.getText().charAt(0));
            this.cmdExport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgZBNImportStats.this.exportUnresolvedData();
                }
            });
            bottomPanel.add(this.cmdExport);
        }
        this.getContentPane().add((Component)bottomPanel, "South");
        this.setVisible(true);
    }

    private void createTreeNodes(LogTreeNode root, String logFile) throws FileNotFoundException {
        try {
            PSEnvironment.printDebugMessage("dlgZBNImportStats", "in createTreeNodes()");
            this.successNode = new LogTreeNode(localProperty.getString("ImportSuccess"));
            this.failNode = new LogTreeNode(localProperty.getString("NotFound"));
            root.add(this.successNode);
            root.add(this.failNode);
            FileInputStream fisLog = new FileInputStream(String.valueOf(PSEnvironment.getPSPath()) + logFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(fisLog));
            String line = "";
            try {
                while (br.ready()) {
                    LogTreeNode orgData;
                    line = br.readLine();
                    if ((line = line.replace('\t', ';')).indexOf(ZbnDataHandler.IMPORT_SUCCESS) != -1) {
                        PSEnvironment.printDebugMessage("dlgZBNImportStats", "Adding Succesful Childnodes...");
                        orgData = new LogTreeNode(line.substring(this.entryID ? line.indexOf(";") + 1 : 0, line.indexOf(ZbnDataHandler.IMPORT_SUCCESS)));
                        this.successNode.add(orgData);
                        int hhStartPos = line.indexOf(ZbnDataHandler.IMPORT_SUCCESS) + ZbnDataHandler.IMPORT_SUCCESS.length() + 1;
                        int hhEndPos = line.indexOf(";", hhStartPos);
                        String hh = line.substring(hhStartPos, hhEndPos);
                        orgData.setHHData(hh);
                        if (this.showEntgelt) {
                            hhStartPos = hhEndPos + 1;
                            hhEndPos = line.indexOf(";", hhStartPos);
                            String entgeltValue = line.substring(hhStartPos, hhEndPos);
                            orgData.setEntgelt(entgeltValue);
                        }
                        int zbnStartPos = ++hhEndPos;
                        int zbnEndPos = line.indexOf(ZbnDataHandler.periphery) == -1 ? line.length() : line.indexOf(ZbnDataHandler.periphery) - 1;
                        String zbn = line.substring(zbnStartPos, zbnEndPos);
                        LogTreeNode orgZB = new LogTreeNode(zbn);
                        orgData.add(orgZB);
                        if (line.indexOf(ZbnDataHandler.periphery) != -1) {
                            zbn = line.substring(line.indexOf(ZbnDataHandler.periphery) + ZbnDataHandler.periphery.length(), line.length());
                            StringTokenizer t = new StringTokenizer(zbn, ";");
                            int tCnt = t.countTokens();
                            int i = 0;
                            while (t.hasMoreTokens()) {
                                LogTreeNode perZB = new LogTreeNode(t.nextToken().trim());
                                orgZB.add(perZB);
                                ++i;
                            }
                        }
                    }
                    if (line.indexOf(ZbnDataHandler.IMPORT_FAILED) != -1) {
                        orgData = new LogTreeNode(line.substring(this.entryID ? line.indexOf(";") + 1 : 0, line.indexOf(ZbnDataHandler.IMPORT_FAILED)));
                        this.failNode.add(orgData);
                    }
                    if (line.indexOf(localProperty.getString("HHSum")) == -1 && line.indexOf(localProperty.getString("HHTpSum")) == -1 && line.indexOf(localProperty.getString("HHAllSum")) == -1) continue;
                    this.successNode.setHHData(line.substring(line.indexOf(":") + 1, line.length()));
                }
                br.close();
                fisLog.close();
            }
            catch (IOException ioEx) {
                PSEnvironment.printExceptionMessage(ioEx);
            }
        }
        catch (Exception ex) {
            PSEnvironment.printExceptionMessage(ex);
            ex.printStackTrace();
        }
    }

    private void createVectorTreeNodes(LogTreeNode root, Vector stats) {
        long hhSum = 0L;
        double entgeltSum = 0.0;
        try {
            PSEnvironment.printDebugMessage("dlgZBNImportStats", "in createTreeNodes()");
            this.successNode = new LogTreeNode(localProperty.getString("ImportSuccess"));
            this.successNode.setHHData(PSAuftrag.getSumSdg());
            this.failNode = new LogTreeNode(localProperty.getString("NotFound"));
            root.add(this.successNode);
            root.add(this.failNode);
            int i = 0;
            while (i < stats.size()) {
                String[] tokens = ((String)stats.elementAt(i)).split(";");
                int j = 0;
                while (j < tokens.length) {
                    String entry = tokens[j];
                    String[] actNode = entry.split("\\|");
                    LogTreeNode orgData = new LogTreeNode(actNode[0]);
                    if (actNode[1].equals("1")) {
                        orgData.setHHData(actNode[2]);
                        String tmpConv = actNode[2].replaceAll("\\.", "");
                        hhSum += Long.parseLong(tmpConv);
                        if (this.showEntgelt) {
                            orgData.setEntgelt(actNode[3]);
                            tmpConv = actNode[3].replaceAll(",", ".");
                            entgeltSum += Double.parseDouble(tmpConv);
                        }
                        this.successNode.add(orgData);
                    } else {
                        this.failNode.add(orgData);
                    }
                    ++j;
                }
                ++i;
            }
            if (hhSum > 0L) {
                String hhData = PSEnvironment.Format(hhSum, "#,###,##0");
                if (this.showEntgelt) {
                    hhData = String.valueOf(hhData) + ", Entgelt: " + PSEnvironment.Format(entgeltSum, "#,###,##0.00");
                }
                this.successNode.setHHData(hhData);
            }
        }
        catch (Exception ex) {
            PSEnvironment.printExceptionMessage(ex);
            ex.printStackTrace();
        }
    }

    private void exportUnresolvedData() {
        String filename = "";
        try {
            JFileChooser chooser = new JFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            PSFileFilter filter = new PSFileFilter(String.valueOf(localProperty.getString("fcDescr")) + "|csv");
            chooser.addChoosableFileFilter(filter);
            chooser.setFileFilter(filter);
            File f = new File(PSEnvironment.getPSPath());
            chooser.setCurrentDirectory(f);
            if (chooser.showSaveDialog(this) == 0) {
                File file = chooser.getSelectedFile();
                filename = file.getAbsolutePath();
                if (filename.indexOf(".csv") == -1) {
                    filename = String.valueOf(filename) + ".csv";
                    file = new File(filename);
                }
                BufferedWriter br = new BufferedWriter(new FileWriter(file));
                if (this.failNode != null) {
                    if (!this.isVectorStats) {
                        br.write(localProperty.getString("exportHeader"));
                    }
                    int i = 0;
                    while (i < this.failNode.getChildCount()) {
                        LogTreeNode actChild = (LogTreeNode)this.failNode.getChildAt(i);
                        String entry = (String)actChild.getUserObject();
                        br.write(String.valueOf(entry) + "\n");
                        ++i;
                    }
                }
                br.close();
            }
        }
        catch (IOException ioEx) {
            Feedback.showMessage((Component)this.pso, 41, filename);
        }
    }

    class LogTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 3258413919604455730L;
        String hhData;
        String entgelt;

        public LogTreeNode(Object userObject) {
            super(userObject);
            this.hhData = "";
            this.entgelt = "";
        }

        public void setHHData(String data) {
            this.hhData = data;
        }

        public void setEntgelt(String data) {
            this.entgelt = data;
        }

        public String getHHData() {
            String result = "";
            if (this.getLevel() == 2) {
                LogTreeNode parentNode = (LogTreeNode)this.getParent();
                if (parentNode.getUserObject().equals(localProperty.getString("ImportSuccess"))) {
                    result = " " + this.hhData;
                    if (DlgZBNImportStats.this.showEntgelt) {
                        result = String.valueOf(result) + ", Entgelt: " + this.entgelt;
                    }
                }
            } else if (this.equals(DlgZBNImportStats.this.successNode)) {
                result = " " + this.hhData;
            }
            return result;
        }
    }

    private class MyNodeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 3762531213537063984L;

        private MyNodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String toolTipText = null;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            LogTreeNode actNode = (LogTreeNode)value;
            if (actNode.equals(DlgZBNImportStats.this.successNode)) {
                toolTipText = String.valueOf(ZbnDataHandler.IMPORT_SUCCESS.substring(3, ZbnDataHandler.IMPORT_SUCCESS.length())) + ": " + DlgZBNImportStats.this.successNode.getChildCount();
            }
            if (actNode.equals(DlgZBNImportStats.this.failNode)) {
                toolTipText = String.valueOf(ZbnDataHandler.IMPORT_FAILED.substring(3, ZbnDataHandler.IMPORT_FAILED.length())) + ": " + DlgZBNImportStats.this.failNode.getChildCount();
            }
            if (actNode.equals(DlgZBNImportStats.this.failNode.getParent())) {
                toolTipText = String.valueOf(localProperty.getString("RowCount")) + (DlgZBNImportStats.this.successNode.getChildCount() + DlgZBNImportStats.this.failNode.getChildCount());
            }
            if (actNode.getLevel() == 2 && actNode.getParent() == DlgZBNImportStats.this.successNode) {
                toolTipText = String.valueOf(localProperty.getString("FoundZbn")) + actNode.getFirstChild().toString().length() / 8;
            }
            if (actNode.getLevel() == 3) {
                toolTipText = String.valueOf(localProperty.getString("AddedPeripherals")) + actNode.getChildCount();
            }
            this.setToolTipText(toolTipText);
            return this;
        }
    }
}

