/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import prospektservice.PSEnvironment;
import prospektservice.base.BrowserLauncher;
import prospektservice.mdbimport.PSJobImporterFactory;

public class DlgShowJobInfo
extends JDialog {
    private static final long serialVersionUID = 4048794554729837875L;
    private static final int WIDTH = 380;
    private static final int HEIGHT = 320;
    private JButton btnOk;
    private JButton btnCancel;
    private ResourceBundle localProperty = ResourceBundle.getBundle("properties.DlgShowJobInfo", PSEnvironment.getEnvironmentLanguage());
    private JScrollPane scroller;
    private JEditorPane textArea;

    public DlgShowJobInfo(JFrame pso, boolean modal) {
        super((Frame)pso, modal);
        this.setBackground(SystemColor.menu);
        this.getContentPane().setLayout(new BorderLayout());
        this.setTitle(this.localProperty.getString("Title"));
        this.setSize(380, 320);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d.width - 380) / 2, (d.height - 320) / 2);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setAlignmentX(0.0f);
        panel.setBounds(12, 20, 350, 300);
        this.textArea = new JEditorPane();
        this.textArea.setFont(PSEnvironment.Arial11);
        this.textArea.setContentType("text/html");
        this.textArea.setEditable(false);
        HyperlinkListener hpl = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                try {
                    if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                        DlgShowJobInfo.this.setCursor(Cursor.getPredefinedCursor(12));
                    }
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        BrowserLauncher.openURL(e.getURL().toString());
                    }
                    if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                        DlgShowJobInfo.this.setCursor(Cursor.getDefaultCursor());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        this.textArea.addHyperlinkListener(hpl);
        this.scroller = new JScrollPane();
        this.scroller.setBounds(0, 0, 350, 300);
        this.scroller.getViewport().add(this.textArea);
        panel.add((Component)this.scroller, "Center");
        this.getContentPane().add((Component)panel, "North");
        JPanel btnPanel = new JPanel(new FlowLayout(1));
        this.btnCancel = new JButton(this.localProperty.getString("btnCancel"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PSJobImporterFactory.cancelImport();
                DlgShowJobInfo.this.dispose();
            }
        });
        btnPanel.add(this.btnCancel);
        this.btnOk = new JButton(this.localProperty.getString("btnOk"));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgShowJobInfo.this.dispose();
            }
        });
        btnPanel.add(this.btnOk);
        this.getContentPane().add((Component)btnPanel, "South");
    }

    public void setData(Vector<String> values, int jobMode) {
        int gebMode;
        int i = 0;
        String msg = "<table><tr><td>" + this.localProperty.getString("jobName");
        msg = String.valueOf(msg) + "</td><td align=\"right\">" + values.elementAt(i++) + "</td></tr>";
        msg = String.valueOf(msg) + "<tr><td>" + this.localProperty.getString("jobPwAn");
        msg = String.valueOf(msg) + "</td><td align=\"right\">" + values.elementAt(i++) + "</td></tr>";
        msg = String.valueOf(msg) + "<tr><td>" + this.localProperty.getString("jobMode");
        msg = String.valueOf(msg) + "</td><td align=\"right\">" + values.elementAt(i++) + "</tr></td>";
        msg = String.valueOf(msg) + "<tr><td>" + this.localProperty.getString("jobItemWeight");
        msg = String.valueOf(msg) + "</td><td align=\"right\">" + values.elementAt(i++) + "</tr></td>";
        msg = String.valueOf(msg) + "<tr><td>" + this.localProperty.getString("jobSdgVE");
        msg = String.valueOf(msg) + "</td><td align=\"right\">" + values.elementAt(i++) + "</tr></td>";
        if ((gebMode = PSEnvironment.getIntValue(values.elementAt(i++), 0)) == 0) {
            msg = String.valueOf(msg) + "<tr><td>" + this.localProperty.getString("jobToleranz");
            msg = String.valueOf(msg) + "</td><td align=\"right\">" + values.elementAt(i++) + "</tr></td>";
            msg = String.valueOf(msg) + "<tr><td>" + this.localProperty.getString("jobRundung");
            msg = String.valueOf(msg) + "</td><td align=\"right\">0</tr></td>";
        } else {
            msg = String.valueOf(msg) + "<tr><td>" + this.localProperty.getString("jobToleranz");
            msg = String.valueOf(msg) + "</td><td align=\"right\">0</tr></td>";
            msg = String.valueOf(msg) + "<tr><td>" + this.localProperty.getString("jobRundung");
            msg = String.valueOf(msg) + "</td><td align=\"right\">" + values.elementAt(i++) + "</tr></td>";
        }
        switch (jobMode) {
            case 3: {
                msg = String.valueOf(msg) + "<tr><td>" + this.localProperty.getString("jobZSPCnt");
                msg = String.valueOf(msg) + "</td><td align=\"right\">" + values.elementAt(i++) + "</tr></td>";
                break;
            }
            case 4: {
                msg = String.valueOf(msg) + "<tr><td>" + this.localProperty.getString("jobBFAHCnt");
                msg = String.valueOf(msg) + "</td><td align=\"right\">" + values.elementAt(i++) + "</tr></td>";
                break;
            }
            default: {
                msg = String.valueOf(msg) + "<tr><td>" + this.localProperty.getString("jobOrteCnt");
                msg = String.valueOf(msg) + "</td><td align=\"right\">" + values.elementAt(i++) + "</tr></td>";
                msg = String.valueOf(msg) + "<tr><td>" + this.localProperty.getString("jobOrtsteileCnt");
                msg = String.valueOf(msg) + "</td><td align=\"right\">" + values.elementAt(i++) + "</tr></td>";
            }
        }
        this.setData(msg);
    }

    public void setData(String msg) {
        this.textArea.setText("<html><div style=\"font-family:Arial,sans-serif; font-size:9px\">" + msg + "</div></html>");
    }
}

