/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.dialog;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.PSUser;

public class DlgProgressKarte
extends JDialog {
    private static final long serialVersionUID = 3256438092998062646L;
    private static final int WIDTH = 300;
    private static final int HEIGHT = 100;
    private static ResourceBundle localProperty;
    private static JProgressBar Progress;
    private static JLabel Label;

    public DlgProgressKarte(PSO refpso) {
        super((Frame)refpso, false);
        localProperty = ResourceBundle.getBundle("properties.dlgProgressKarte", PSUser.getLanguage());
        this.getContentPane().setLayout(new FlowLayout(1));
        this.setTitle(localProperty.getString("Title"));
        this.setSize(300, 100);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setLocationRelativeTo(refpso);
        this.setCursor(Cursor.getPredefinedCursor(3));
        Label = new JLabel(localProperty.getString("Label1"));
        Label.setHorizontalAlignment(0);
        Label.setPreferredSize(new Dimension(180, 20));
        Progress = new JProgressBar();
        Progress.setPreferredSize(new Dimension(180, 20));
        this.getContentPane().add(Label);
        this.getContentPane().add(Progress);
    }

    public int getProgressMaximum() {
        return Progress.getMaximum();
    }

    public int getProgressValue() {
        return Progress.getValue();
    }

    public void setProgressValue(int value) {
        PSEnvironment.printDebugMessage(String.valueOf(this.getClass().getName()) + ".setProgressValue()", "" + value);
        Progress.setValue(value);
        Progress.repaint();
        this.repaint();
    }

    public void setProgressMaximum(int value) {
        Progress.setMaximum(value);
    }

    public void setProgressTitle(String newTitle) {
        if (PSEnvironment.DEBUG) {
            System.out.println(" Neue Titel =" + newTitle);
        }
        this.setTitle(newTitle);
        this.repaint();
    }

    public void setLabelContent(String newContent) {
        Label.setText(newContent);
        this.repaint();
    }

    public String getLabelContent() {
        return Label.getText();
    }

    public JProgressBar getProgressBar() {
        return Progress;
    }
}

